//*-*REV 18.04.00 Jacak: Fixed Bug 218357 - edit boxes in Gear dialog box moved
//*-*REV 03.04.2000 Kaleja: added label for dilaog gefsh_hatchcut
//*-*REV 07.02.2000 Kaleja: removed one row from GEFSHWE dialog
//*-*REV 08.12.99 Kaleja: changes acc. to PD spec
//*-*REV 01.12.99 Jacak: added shortcuts
//*-*REV 30.11.99 Kaleja: added new option to gefsh_hatchparam
//*-*REV 07.08.99 GrafR: added Mnemonics
//*-*REV 23.07.99 Jacak: alignment in ge3sh_gear changed
//*-*REV 11.06.99 Kaleja: bugfix in gefsh_gear
//*-*REV 07.06.99 Kaleja: Descriptions for edit boxes in gefsh_gear from mld-file
//*-*REV 25.03.99 Jacak: In dialogbox gefsh_gear more place for units
//*-*REV 20.07.98 Jacak: Fixed Bug No D5837 DIN/ANSI Standard
//*-*REV 13.05.98 Jacak: Starting state for 14.1

@include "genius.dcl"

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//                    DIALOG-BOX  Wellengenerator
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

// dcl_settings: default_dcl_settings { audit_level = 2; }

  card_left : image {
    key = "card_left";
    // fixed_width = true;
    width = 1;
    horizontal_margin = none;
    vertical_margin = none;
    color  = -15;
  }

  card_right : image {
    key = "card_right";
    // fixed_width = true;
    width = 1;
    horizontal_margin = none;
    vertical_margin = none;
    color  = -15;
  }

  card_bottom : image {
    key = "card_bottom";
    height = 0.5;
    fixed_height = true;
    horizontal_margin = none;
    vertical_margin = none;
    color  = -15;
  }

  card_topleft : image {
    key = "card_topleft";
    horizontal_margin = none;
    vertical_margin = none;
    color  = -15;
    width = 0.5;
    height = 1;
  }

  card_topright : image {
    key = "card_topright";
    horizontal_margin = none;
    vertical_margin = none;
    color  = -15;
    width = 0.5;
    height = 1;
  }

  card_butleft : image {
    width = 1;
    horizontal_margin = none;
    vertical_margin = none;
    color  = -15;
  }

  card_butright : image {
    width = 1;
    horizontal_margin = none;
    vertical_margin = none;
    color  = -15;
  }

  card_buttop : image {
    height = 0.4;
    fixed_height = true;
    horizontal_margin = none;
    vertical_margin = none;
    color  = -15;
  }

  card_butbot : image {
    height = 0.5;
    fixed_height = true;
    horizontal_margin = none;
    vertical_margin = none;
    color  = -15;
  }

  card_button : radio_button {
    height = 1;
    fixed_height = true;
    horizontal_margin = none;
    vertical_margin = none;
  }

  gefsh_imgb : image_button {
          color   = -15;
          allow_accept = true;
          fixed_width = true;
          aspect_ratio = 0.7;
  }

  gefsh_imgb_nm : gefsh_imgb {
          horizontal_margin = none;
          vertical_margin = none;
  }


  gefsh_imgbm : image_button {
          color   = -15;
          allow_accept = true;
          fixed_width = true;
          aspect_ratio = 0.7;
          horizontal_margin = none;
          vertical_margin = none;
          width = 11;
  }

  gefsh_button : button {
          fixed_width = true;
          width = 12;
  }


  gefsh_img : image {
    color = -15;
    fixed_width = true;
    fixed_height = true;
    aspect_ratio = 0.7;
    width = 30;
  }

  gefsh_img_text : text {
    vertical_margin = none;
    horizontal_margin = none;
    fixed_width = true;
   	alignment = centered;
    width = 10;
  }

  gefsh_imgsel_button : image_button {
	   color   = -15;
	   allow_accept = true;
	   fixed_width = true;
	   aspect_ratio = 0.7;
	   width = 25;
  }

  gefsh_imgsel_text : text {
    fixed_width = true;
	   alignment = centered;
    vertical_margin = none;
    width = 25;
  }

  gefsh_anwahlen : genretirement_button {
    label = /*t-gefsh0*/"<";   // "<"
    fixed_width = true;
    width = 3;
//    vertical_margin = none;
    alignment = centered;
  }

  gefsh_txt : text {
    fixed_width = true;
    alignment = centered;
  }  

  gefsh_txt1 : text {
    fixed_width = true;
    width = 37;
  }  

  gefsh_text1           // used in 1.dialogue box - Modified design
    : text {
      width = 20;
      fixed_width = true;
    }

  gefsh_edit_box1
    : edit_box {
  //    is_enabled = false;
      edit_width = 7;
      width = 15.7;
      fixed_width = true;
    }


  gefsh_sond_oneline_prev :row {
    vertical_margin = none;
    horizontal_margin = none;
    fixed_height = true;
    fixed_width = false;
    children_alignment = bottom;
    :geniusdia {height=2;}
    :row {
      vertical_margin = none;
      fixed_width = true;
      children_fixed_width = true;
      alignement = left;
      :column {
        :button {
          label = /*t-gefsh1*/"&Modified Design";   // "Sonderanfertigung"
          key = "sond";
          fixed_width = false;
        }
        :row {
          okbutton;            //KEY accept
          cancelbutton;
        }
      }

      :column {
        :button {
          label = /*t-gefsh113*/"&Standard..."; // "Norm"
          key = "norm";
          fixed_width = false;
        }
        :helpbutton { fixed_width = false; }
      }
    }
  }


  gefsh_norm_oneline_prev :row {
    vertical_margin = none;
    horizontal_margin = none;
    fixed_height = true;
    fixed_width = false;
    children_alignement = bottom;
    :geniusdia {height=2;}
    :row {
      vertical_margin = none;
      fixed_width = true;
      children_fixed_width = true;
      alignement = left;
      okbutton;            //KEY accept
      :button {
        label = /*t-gefsh2*/"Standard Si&zes";   // "Normliste"
        key = "norm";
      }
      cancelbutton;
      helpbutton;
    }
  }


  gefsh_normp_oneline_prev :row {
    vertical_margin = none;
    horizontal_margin = none;
    fixed_height = true;
    fixed_width = false;
    children_alignement = bottom;
    :geniusdia {height=2;}
    :row {
      vertical_margin = none;
      fixed_width = true;
      children_fixed_width = true;
      alignement = left;
      okbutton;            //KEY accept
      :button {
        label = /*t-gefsh113*/"&Standard...";   // "Normteil"
        key = "norm";
      }
      cancelbutton;
      helpbutton;
    }
  }


  gefsh_rb1: radio_button {     
     fixed_width = true;
     width = 20;
  }

  gefsh_rb2: radio_button {
     fixed_width = true;
     width = 15;
  }

  gefsh_rb_question : radio_button { 
     label = /*t-gefsh75*/"Prompt";  // "Fragen"
		mnemonic = /*t-gefsh7500*/"P";
     // fixed_width = true;
  }



//---------------------------------------------------------gefsh_box0
gefsh_box0: dialog {
  label = /*t-gefsh3*/"Shaft Generator";  // "Wellengenerator"
  key = "text";

  : column {
    : row {
      // fixed_width = true;
      card_topleft;

      : card_butleft { key = "cardl0"; }
      : column {
        : card_buttop { key = "cardt0"; }
        : card_button {
           key = "card0";
           label = /*t-gefsh123*/"Left Inner Contour"; // "Left inner contour"
		mnemonic = /*t-gefsh12300*/"L";
        }
        : card_butbot { key = "cardb0"; }
      }
      : card_butright { key = "cardr0"; }

      : card_butleft  { key = "cardl1"; }
      : column {
        : card_buttop { key = "cardt1"; }
        : card_button {
           key = "card1";
           label = /*t-gefsh124*/"Outer Contour"; // "Outer contour"
		mnemonic = /*t-gefsh12400*/"O";
        }
        : card_butbot { key = "cardb1"; }
      }
      : card_butright { key = "cardr1"; }

      : card_butleft  { key = "cardl2"; }
      : column {
        : card_buttop { key = "cardt2"; }
        : card_button {
           key = "card2";
           label = /*t-gefsh125*/"Right Inner Contour"; // "Right inner contour"
		mnemonic = /*t-gefsh12500*/"R";
        }
        : card_butbot { key = "cardb2"; }
      }
      : card_butright { key = "cardr2"; }

      card_topright;
    } // row

    : row {
      card_left;
      : column {
        :row {
          children_fixed_height = true;
          children_alignment = top;
          :column {
            /*----------------------- Naechste Ecke --------------*/
            :gefsh_imgbm { key = "necke"; }
            :gefsh_img_text { key = "tnecke"; }
            /*----------------------- Zylinder -------------------*/
            :gefsh_imgbm { key = "zyl"; }
            :gefsh_img_text { key = "tzyl"; }
          }

          :column {
            /*----------------------- Konus Ecke -----------------*/
            :gefsh_imgbm { key = "kecke"; }
            :gefsh_img_text { key = "tkecke"; }
            /*----------------------- Konus ----------------------*/
            :gefsh_imgbm { key = "konus"; }
            :gefsh_img_text { key = "tkonus"; }
          }

          :column {
            /*----------------------- Gewinde --------------------*/
            :gefsh_imgbm { key = "gew"; }
            :gefsh_img_text { key = "tgew"; }
            /*----------------------- Schluesselweite ------------*/
            :gefsh_imgbm { key = "schl";  }
            :gefsh_img_text { key = "tschl"; }
          }

          :column {
            /*----------------------- Profile ---------------------*/
            :gefsh_imgbm { key = "prof";  }
            :gefsh_img_text { key = "tprof"; }
            /*----------------------- Zahnrad --------------------*/
            :gefsh_imgbm { key = "zahn";  }
            :gefsh_img_text { key = "tzahn"; }
          }

          :column {
            /*----------------------- Nut ------------------------*/
            :gefsh_imgbm { key = "nut";  }
            :gefsh_img_text { key = "tnut"; }
            /*----------------------- Aufbruch -------------------*/
            :gefsh_imgbm { key = "aufbr"; }
            :gefsh_img_text { key = "taufbr"; }
          }

          :column {
            /*----------------------- Fase -----------------------*/
            :gefsh_imgbm { key = "fase"; }
            :gefsh_img_text { key = "tfase"; }
            /*----------------------- Radius ---------------------*/
            :gefsh_imgbm { key = "rad"; }
            :gefsh_img_text { key = "trad"; }
          }

          :column {
            /*----------------------- seed point for hatch -------*/
            :gefsh_imgbm { key = "hpoint";  }
            :gefsh_img_text { key = "thpoint"; }
            /*-------------------- boundary line for hatch -------*/
            :gefsh_imgbm { key = "bline"; }
            :gefsh_img_text { key = "tbline"; }
          }

          :spacer { width = 0.2; }

          :column {
            /*----------------------- Schnitt  -------------------*/
            :gefsh_imgbm { key = "cut"; }
            :gefsh_img_text { key = "tcut"; }
            /*----------------------- Seitenansicht  -------------*/
            :gefsh_imgbm { key = "ansicht";  }
            :gefsh_img_text { key = "tansicht"; }
          }
        } //row

        :row {
          alignment = centered;

          :button {
                label = /*t-gefsh15*/"&Std.Parts...";  // "Normteile"
                key = "vario";
                fixed_width = false;
          }

          :button {
                label = /*t-gefsh16*/"&Insert";  // "Neuer Start"
                key = "start";
                fixed_width = false;
          }

          :button {
                label = /*t-gefsh18*/"&Edit";  // "Edit"
                key = "editi";
                fixed_width = false;
          }

          :button {
                label = /*t-gefsh19*/"&Delete";  // "Lschen"
                key = "loschen";
                fixed_width = false;
          }

          :button {
                label = /*t-gefsh143*/"Co&py";  // "Kopieren"
                key = "copy";
                fixed_width = false;
          }

          :button {
                label = /*t-gefsh107*/"&Note";  // "Text"
                key = "text1";
                fixed_width = false;
          }


          :button {
                label = /*t-gefsh22*/"&Undo";  // "Zurck"
                key = "zur";
                fixed_width = false;
          }
        } // row
      } // column
      card_right;
    } // row
    card_bottom;      
  } // column


  :spacer { height = 0.2; }

  :row {
    vertical_margin = none;
    horizontal_margin = none;
    fixed_height = true;
    fixed_width = false;
    children_alignement = bottom;
    :geniusdia {height=2;}
    :row {
      vertical_margin = none;
      fixed_width = true;
      children_fixed_width = true;
      alignement = left;
      :button {
          label = /*t-gefsh24*/">>>";  // ">>>"
          fixed_width = true;
          key = "view";
          width = 8;
      }
      :button {
          label = /*t-gefsh23*/"Con&fig...";  // "Konfig"
          key = "konfig";
          width = 12;
      }
      :button {
            label = /*t-gefsh17*/"Co&mmand Line";  // "Man.Eingabe"
            width = 13;
            key = "maneing";
      }
      :button { 
            is_cancel = true;
            label = /*t-gefsh95*/"&Close";     //"Close"
            key = "abort";
      }
      helpbutton;
    } // row
  }
} //dialog


//---------------------------------------------------------gefsh_cone
// Konus

gefsh_cone: dialog {
  label = /*t-gefsh25*/"Shaft Generator - Cone";  // "Wellengenerator - Konus"
  key = "text";

  :row {
    children_alignment = top;
    children_fixed_height = true;
    :column {
       children_alignment = left;
       children_fixed_width = true;

       :spacer { height = 0.3; }
       :row {
         children_fixed_width = true;
        :gefsh_text1 { 
           key = "d1_text"; 
           label = /*t-gefsh26*/"Diameter";  // "Durchmesser"
           width = 15;
		mnemonic = /*t-gefsh2600*/"D";
         }

         :gefsh_edit_box1 {
           label = /*t-gefsh27*/"d1 =";   // "d1 ="
           key = "d1";
           width = 16.5;
         }

         :gefsh_anwahlen {
           key = "d1_anw";
         }

         :text {
           key = "d1_unit";
           width = 6;
         }   
       }//row


       :row {
         children_fixed_width = true;
        :gefsh_text1 { 
           key = "x_text"; 
           label = /*t-gefsh29*/"Cone";  // "Konus"
           width = 15;
		mnemonic = /*t-gefsh2900*/"C";
         }

         :gefsh_edit_box1 {
           label = /*t-gefsh30*/"1 :";   // "1 :"
           key = "x";
           width = 16.5;
         }
       }//row


       :row {
         children_fixed_width = true;
         :gefsh_text1 { 
           key = "ang_text"; 
           label = /*t-gefsh117*/"Angle";  // "Winkel"
           width = 15;
		mnemonic = /*t-gefsh11700*/"A";
         }
         :gefsh_edit_box1 {
           label = /*t-gefsh118*/"alpha";   // "Alpha"  
           key = "ang";
           width = 16.5;
         }
         
         :gefsh_anwahlen {
           key = "ang_anw";
         }

         :text {
           key = "ang_unit";
           width = 6;
         }   

       }//row


       :row {
         children_fixed_width = true;
         :gefsh_text1 { 
           key = "d2_text";  
           label = /*t-gefsh26*/"Diameter";  // "Durchmesser"
           width = 15;
		mnemonic = /*t-gefsh2601*/"m";
         }
         :gefsh_edit_box1 {
           label = /*t-gefsh32*/"d2 =";   // "d2 ="
           key = "d2";
           width = 16.5;
         }

         :gefsh_anwahlen {
           key = "d2_anw";
         }

         :text {
           key = "d2_unit";
           width = 6;
         }   
       }//row

       :row {
         children_fixed_width = true;
         :gefsh_text1 { 
           label = /*t-gefsh33*/"Length";  // "Lnge"
           width = 15;
		mnemonic = /*t-gefsh3300*/"L";
         }
         :gefsh_edit_box1 {
           label = /*t-gefsh34*/"l =";   // "l ="
           key = "l";
           width = 16.5;
         }

         :gefsh_anwahlen {
           key = "l_anw";
         }

         :text {
           key = "l_unit";
           width = 6;
         }   
       }//row
     }//column

    :column {
      :row {
        children_alignment = top;
        children_fixed_height = true;

        :column {
          :gefsh_img {
             key = "icon";
             alignment = centered;
          }
          :radio_row {
            :spacer { width = 0.5; }
            :radio_button {        
              label = /*t-gefsh35*/"d1<d2";  // "d1<d2"
              key = "d1_small";
              value = "1";
		mnemonic = /*t-gefsh3500*/"1";
            }
            :radio_button { 
              label = /*t-gefsh36*/"d1>d2";  // "d1>d2"
              key = "d2_small";
              value = "0";
		mnemonic = /*t-gefsh3600*/"2";
            }
          }//radio_row
        }//column
      }//row  
    }//column
  }//row

  :spacer { height = 0.5; }

  :row {
    vertical_margin = none;
    horizontal_margin = none;
    fixed_height = true;
    fixed_width = false;
    children_alignement = bottom;
    :geniusdia {height=2;}
    :row {
      vertical_margin = none;
      fixed_width = true;
      children_fixed_width = true;
      alignement = left;
      okbutton;            //KEY accept
      cancelbutton;        //KEY abort
      helpbutton;          
    }
  }
} //dialog




//---------------------------------------------------------gefsh_wrench2
// Schluesselweite fuer 2 Ecke mit d

gefsh_wrench2: dialog {
  key = "text";

  children_alignment = left;
  children_fixed_width = true;


  :text {
    key = "s_text";
    width = 25;
  }
 
  :row {
    children_alignment = top;
    children_fixed_height = true;
    :column {
       children_alignment = left;
       children_fixed_width = true;

       :list_box {
         key = "sn";
         multiple_select = false;
         width = 25;
         height = 10;
       }
    }

    :spacer { width = 5; }
    :column {
      :row {
        children_alignment = top;
        children_fixed_height = true;

        :column {
          :gefsh_img {
             key = "icon";
             alignment = centered;
          }
          :toggle {
             key = "drehen";
             label = /*t-gefsh37*/"Rotate";  // "Drehen"
             value = "0";
             width = 12;
             fixed_width = true;
		mnemonic = /*t-gefsh3700*/"R";
          }


        }//column
      }//row
    }//column
  }//row

  :row {
    children_fixed_width = true;
    width = 28;
    :edit_box {
      label = /*t-gefsh141*/"Find s =";  // "Suchen s ="
		mnemonic = /*t-gefsh14100*/"F";
      edit_width = 7;
      key = "s_find";
    }
    :gefsh_anwahlen {
      key = "s_anw";
    }
    :text {
      key = "s_unit";
      width = 6;
    }   
  }
  :row {
    children_fixed_width = true;
    width = 28;
    :edit_box {
      label = /*t-gefsh142*/"Find d =";  // "Suchen d ="
      edit_width = 7;
      key = "d_find";
		mnemonic = /*t-gefsh14200*/"d";
    }
    :gefsh_anwahlen {
      key = "df_anw";
    }
    :text {
      key = "df_unit";
      width = 6;
    }   
  }


  :spacer { height = 1; }

  :row {
    children_fixed_width = true;
    :gefsh_text1 {
      label = /*t-gefsh39*/"Nominal Diameter";  // "Nenndurchmesser"
      key = "d_text1";
		mnemonic = /*t-gefsh3900*/"N";
    }
    :gefsh_edit_box1 {
      label = /*t-gefsh40*/"d =";   // "d ="
      key = "d";
    }

    :gefsh_anwahlen { key = "d_anw"; }
    :text {  key = "d_unit"; width = 6; }   
  }//row

  :row {
    children_fixed_width = true;
    :gefsh_text1 { 
      label = /*t-gefsh33*/"Length";  // "Lnge"
		mnemonic = /*t-gefsh3300*/"L";
    }
    :gefsh_edit_box1 {
      label = /*t-gefsh34*/"l =";   // "l ="
      key = "l";
    }

    :gefsh_anwahlen {
      key = "l_anw";
    }

    :text {
      key = "l_unit";
      width = 6;
    }   
  }//row

  :spacer { height = 0.5; }

  gefsh_normp_oneline_prev;
} //dialog


//---------------------------------------------------------gefsh_wrench46
// Schluesselweite fuer 4,6 Ecke ohne d

gefsh_wrench46: dialog {
  key = "text";


  children_alignment = left;
  children_fixed_width = true;


  :text {
    key = "s_text";
    width = 25;
  }
 
 :row {
    children_alignment = top;
    children_fixed_height = true;
    :column {
       children_alignment = left;
       children_fixed_width = true;


       :list_box {
         key = "sn";
         multiple_select = false;
         width = 25;
         height = 10;
       }
    }

    :spacer { width = 5; }
    :column {
      :row {
        children_alignment = top;
        children_fixed_height = true;

        :column {
          :gefsh_img {
             key = "icon";
             alignment = centered;
          }
          :toggle {
             key = "drehen";
             label = /*t-gefsh37*/"Rotate";  // "Drehen"
             value = "0";
             width = 12;
             fixed_width = true;
		mnemonic = /*t-gefsh3700*/"R";
          }


        }//column
      }//row
    }//column
  }//row


  :row {
    children_fixed_width = true;
    :gefsh_text1 {  
      label = /*t-gefsh41*/"Find";  // "Suchen"
      width = 10;
		mnemonic = /*t-gefsh4100*/"F";
    }
    :gefsh_edit_box1 {
      label = /*t-gefsh42*/"s =";   // "s ="
      key = "s_find";
      width = 14;
    }

    :gefsh_anwahlen {
      key = "s_anw";
    }

    :text {
      key = "s_unit";
      width = 6;
    }   
  }//row


  //:spacer { height = 0.3; }

  :row {
    children_fixed_width = true;
    :gefsh_text1 { 
      label = /*t-gefsh33*/"Length";  // "Lnge"
      width = 10;
		mnemonic = /*t-gefsh3300*/"L";
    }
    :gefsh_edit_box1 {
      label = /*t-gefsh34*/"l =";   // "l ="
      key = "l";
      width = 14;
    }

    :gefsh_anwahlen {
      key = "l_anw";
    }

    :text {
      key = "l_unit";
      width = 6;
    }   
  }//row

  :spacer { height = 0.5; }

  gefsh_normp_oneline_prev;
} //dialog




//---------------------------------------------------------gefsh_threadd
// Gewinde DIN

gefsh_threadd: dialog {
  key = "text";


  children_alignment = left;
  children_fixed_width = true;


  :text {
    key = "d_text";
    width = 25;
  }
 
  :row {
    children_alignment = top;
    children_fixed_height = true;
    :column {
      children_alignment = left;
      children_fixed_width = true;


      :list_box {
        key = "dn";
        multiple_select = false;
        width = 28;
        height = 10;
      }
     
      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 14.5;   
          :text { label = /*t-gefsh41*/"Find";  // "Suchen"
		mnemonic = /*t-gefsh4100*/"F";
                }
          :text { label = /*t-gefsh40*/"d =";   // "d ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "d_find";
          width = 7.5;
        }
        :gefsh_anwahlen {
          key = "d_anw";
        }
        :text {
          key = "d_unit";
          width = 6;
        }
      }

      //:spacer { height = 0.3; }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 14.5;   

          :text { label = /*t-gefsh33*/"Length";  // "Lnge"
		mnemonic = /*t-gefsh3300*/"L";
                }
          :text { label = /*t-gefsh34*/"l =";   // "l ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "l";
          width = 7.5;
        }

        :gefsh_anwahlen {
          key = "l_anw";
        }

        :text {
          key = "l_unit";
          width = 6;
        }   
      }//row
    }

    :spacer { width = 1; }
    :column {
      :row {
        children_alignment = top;
        children_fixed_height = true;

        :column {
          :gefsh_img {
             key = "icon";
             alignment = centered;
          }
          :toggle {
             key = "freist";
             label = /*t-gefsh43*/"Undercut";  // "Gewindefreistich"
             value = "0";
		mnemonic = /*t-gefsh4300*/"U";
          }

          :spacer { height = 0.3; }

          :radio_row {
            :radio_button {         
              label = /*t-gefsh44*/"Standard ";  // "Regelfall"
              key = "reg";
              value = "1";
		mnemonic = /*t-gefsh4400*/"S";
            }
            :radio_button {         
              label = /*t-gefsh45*/"Short";  // "kurz"
              key = "short";
              value = "0";
		mnemonic = /*t-gefsh4500*/"h";
            }
            :radio_button {         
              label = /*t-gefsh46*/"Long";  // "lang"
              key = "long";
              value = "0";
		mnemonic = /*t-gefsh4600*/"o";
            }
          }

          :spacer { height = 0.3; }

          :radio_row {
            :text {         
              label = /*t-gefsh47*/"Start from";  // "Anfang von"
            }
            :radio_button {         
              label = /*t-gefsh48*/"Left";  // "links"
              key = "left";
              value = "0";
		mnemonic = /*t-gefsh4800*/"e";
            }
            :radio_button {         
              label = /*t-gefsh49*/"Right";  // "rechts"
              key = "right";
              value = "1";
		mnemonic = /*t-gefsh4900*/"R";
            }
          }

        }//column
      }//row
    }//column
  }//row

  :spacer { height = 0.5; }

  gefsh_normp_oneline_prev;
} //dialog


//---------------------------------------------------------gefsh_threada
// Gewinde ANSI

gefsh_threada: dialog {
  key = "text";


  children_alignment = left;
  children_fixed_width = true;


  :text {
    key = "d_text";
    width = 30;
  }
 
 :row {
    children_alignment = top;
    children_fixed_height = true;
    :column {
      children_alignment = left;
      children_fixed_width = true;

      :list_box {
        key = "dn";
        multiple_select = false;
        width = 28;
        height = 10;
      }
      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 14.5;   
          :text { label = /*t-gefsh41*/"Find";  // "Suchen"
		mnemonic = /*t-gefsh4100*/"F";
                }
          :text { label = /*t-gefsh40*/"d =";   // "d ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "d_find";
          width = 7.5;
        }
        :gefsh_anwahlen {
          key = "d_anw";
        }
        :text {
          key = "d_unit";
          width = 6;
        }
      }

      //:spacer { height = 0.3; }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 14.5;   

          :text { label = /*t-gefsh33*/"Length";  // "Lnge"
		mnemonic = /*t-gefsh3300*/"L";
                }
          :text { label = /*t-gefsh34*/"l =";   // "l ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "l";
          width = 7.5;
        }

        :gefsh_anwahlen {
          key = "l_anw";
        }

        :text {
          key = "l_unit";
          width = 6;
        }   
      }//row
    }

    :spacer { width = 1; }
    :column {
      :row {
        children_alignment = top;
        children_fixed_height = true;

        :column {
          :gefsh_img {
             key = "icon";
             alignment = centered;
          }
          :toggle {
             key = "freist";
             label = /*t-gefsh43*/"Undercut";  // "Gewindefreistich"
             value = "0";
		mnemonic = /*t-gefsh4300*/"U";
          }
          :column {
            fixed_width = true;
            children_alignment = right;
            children_fixed_width = true;
            :row {
              children_fixed_width = true;
     
              :edit_box {
                 key = "dg";
                 label = /*t-gefsh99*/"dg =";  // "dg ="
                 edit_width = 6;
		mnemonic = /*t-gefsh9900*/"d";
              }

              :edit_box {
                 key = "g1";
                 label = /*t-gefsh100*/"&g1 =";  // "g1 ="
                 edit_width = 6;
              }
              :text {
                key = "g1_unit";
                width = 6;
              }   
            }
            :row {
              children_fixed_width = true;
              :edit_box {
                 key = "r";
                 label = /*t-gefsh108*/"&r =";  // "r ="
                 edit_width = 6;
              }
              :edit_box {
                 key = "g2";
                 label = /*t-gefsh101*/"&g2 =";  // "g2 ="
                 edit_width = 6;
              }

              :text {
                key = "g2_unit";
                width = 6;
              }   
            }
          }
          :spacer { height = 0.3; }

          :radio_row {
            fixed_width = true; 
            :text {         
              label = /*t-gefsh47*/"Start from";  // "Anfang von"
            }
            :radio_button {         
              label = /*t-gefsh48*/"Left";  // "links"
              key = "left";
              value = "0";
		mnemonic = /*t-gefsh4800*/"e";
            }
            :radio_button {         
              label = /*t-gefsh49*/"Right";  // "rechts"
              key = "right";
              value = "1";
		mnemonic = /*t-gefsh4900*/"i";
            }
          }

        }//column
      }//row
    }//column
  }//row

  :spacer { height = 0.5; }

  gefsh_normp_oneline_prev;
} //dialog




//---------------------------------------------------------gefsh_spltr
// Keilwelle mit Toleranzen und Reihe

gefsh_spltr: dialog {
  key = "text";

  children_alignment = left;
  children_fixed_width = true;

  :text {
    key = "d_text";
    width = 40;
  }
 
 :row {
    children_alignment = top;
    children_fixed_height = true;
    :column {
      children_alignment = left;
      children_fixed_width = true;

      :list_box {
        key = "dn";
        multiple_select = false;
        width = 28;
        height = 10;
      }
    
      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 14.5;   
          :text { label = /*t-gefsh41*/"Find";  // "Suchen"
		mnemonic = /*t-gefsh4100*/"F";
                }
          :text { key = "d1_text1"; 
                  label = /*t-gefsh40*/"d =";   // "d ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "d_find";
          width = 7.5;
        }
        :gefsh_anwahlen {
          key = "d_anw";
        }
        :text {
          key = "d_unit";
          width = 6;
        }
      }

      //:spacer { height = 0.3; }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 14.5;   

          :text { label = /*t-gefsh33*/"Length";  // "Lnge"
		mnemonic = /*t-gefsh3300*/"L";
                }
          :text { label = /*t-gefsh34*/"l =";   // "l ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "l";
          width = 7.5;
        }

        :gefsh_anwahlen {
          key = "l_anw";
        }

        :text {
          key = "l_unit";
          width = 6;
        }   
      }//row
    }

    :spacer { width = 1; }
    :column {
      :row {
        children_alignment = top;
        children_fixed_height = true;

        :column {
          :gefsh_img {
             key = "icon";
             alignment = centered;
          }
          :radio_row {
            :text {
              label = /*t-gefsh50*/"Set";  // "Reihe"
            }
            :radio_button {         
              label = /*t-gefsh51*/"Light";  // "leichte"
              key = "leichte";
              value = "1";
		mnemonic = /*t-gefsh5100*/"i";
            }
            :radio_button {         
              label = /*t-gefsh52*/"Middle";  // "mittlere"
              key = "mittlere";
              value = "0";
		mnemonic = /*t-gefsh5200*/"M";
            }
          }

          :spacer { height = 0.2; }
          :text {         
            label = /*t-gefsh53*/"Tolerance for";  // "Toleranzen fr"
		mnemonic = /*t-gefsh5300*/"T";
          }
          :row {
            children_fixed_width = true;
            :text {
              key = "d1_text";
              width = 1.5;
            }
            :edit_box {
              key = "d1_tol";
              edit_width = 6;
              width = 6.5;
            }
            :spacer { width = 1.5; }
            :text {
              key = "d2_text";
              width = 1.5;
            }
            :edit_box {
              key = "d2_tol";
              edit_width = 6;
              width = 6.5;
            }
          }
        }//column
      }//row
    }//column
  }//row

  :spacer { height = 0.5; }

  gefsh_sond_oneline_prev;
} //dialog



//---------------------------------------------------------gefsh_splt
// Keilwelle mit Toleranzen

gefsh_splt: dialog {
  key = "text";


  children_alignment = left;
  children_fixed_width = true;


  :text {
    key = "d_text";
    width = 40;
  }
 
 :row {
    children_alignment = top;
    children_fixed_height = true;
    :column {
       children_alignment = left;
       children_fixed_width = true;


       :list_box {
         key = "dn";
         multiple_select = false;
         width = 28;
         height = 10;
       }
     
      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 14.5;   
          :text { label = /*t-gefsh41*/"Find";  // "Suchen"
		mnemonic = /*t-gefsh4100*/"F";
                }
          :text { key = "d1_text1"; 
                  label = /*t-gefsh40*/"d =";   // "d ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "d_find";
          width = 7.5;
        }
        :gefsh_anwahlen {
          key = "d_anw";
        }
        :text {
          key = "d_unit";
          width = 6;
        }
      }

      //:spacer { height = 0.3; }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 14.5;   

          :text { label = /*t-gefsh33*/"Length";  // "Lnge"
		mnemonic = /*t-gefsh3300*/"L";
                }
          :text { label = /*t-gefsh34*/"l =";   // "l ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "l";
          width = 7.5;
        }

        :gefsh_anwahlen {
          key = "l_anw";
        }

        :text {
          key = "l_unit";
          width = 6;
        }   
      }//row
    }

    :spacer { width = 1; }
    :column {
      :row {
        children_alignment = top;
        children_fixed_height = true;

        :column {
          :gefsh_img {
             key = "icon";
             alignment = centered;
          }
          :text {         
            label = /*t-gefsh53*/"Tolerance for";  // "Toleranzen fr"
		mnemonic = /*t-gefsh5300*/"T";
          }
          :row {
            children_fixed_width = true;
            :text {
              key = "d1_text";
              width = 1.5;
            }
            :edit_box {
              key = "d1_tol";
              edit_width = 6;
              width = 6.5;
            }
            :spacer { width = 1.5; }
            :text {
              key = "d2_text";
              width = 1.5;
            }
            :edit_box {
              key = "d2_tol";
              edit_width = 6;
              width = 6.5;
            }
          }
        }//column
      }//row
    }//column
  }//row

  :spacer { height = 0.5; }

  gefsh_sond_oneline_prev;
} //dialog


//---------------------------------------------------------gefsh_spl
// Keilwelle fuer ANSI 

gefsh_spl: dialog {
  key = "text";


  children_alignment = left;
  children_fixed_width = true;


  :text {
    key = "d_text";
    width = 40;
  }
 
 :row {
    children_alignment = top;
    children_fixed_height = true;
    :column {
      children_alignment = left;
      children_fixed_width = true;

      :list_box {
        key = "dn";
        multiple_select = false;
        width = 28;
        height = 10;
      }
     
      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 14.5;   
          :text { label = /*t-gefsh41*/"Find";  // "Suchen"
		mnemonic = /*t-gefsh4100*/"F";
                }
          :text { key = "d1_text1"; 
                  label = /*t-gefsh40*/"d =";   // "d ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "d_find";
          width = 7.5;
        }
        :gefsh_anwahlen {
          key = "d_anw";
        }
        :text {
          key = "d_unit";
          width = 6;
        }
      }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 14.5;   

          :text { label = /*t-gefsh33*/"Length";  // "Lnge"
		mnemonic = /*t-gefsh3300*/"L";
                }
          :text { label = /*t-gefsh34*/"l =";   // "l ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "l";
          width = 7.5;
        }

        :gefsh_anwahlen {
          key = "l_anw";
        }

        :text {
          key = "l_unit";
          width = 6;
        }   
      }//row
    }

    :spacer { width = 1; }
    :column {
      :row {
        children_alignment = top;
        children_fixed_height = true;

        :column {
          :gefsh_img {
             key = "icon";
             alignment = centered;
          }
        }//column
      }//row
    }//column
  }//row

  :spacer { height = 0.5; }

  gefsh_sond_oneline_prev;
} //dialog




//---------------------------------------------------------gefsh_splsond
// Sonderanfertigung Keilwelle 

gefsh_splsond: dialog {
  key = "text";

  children_alignment = left;
  children_fixed_width = true;

 :row {
    children_alignment = top;
    children_fixed_height = true;
    :column {
       children_alignment = left;
       children_fixed_width = true;

      :edit_box {
        label = /*t-gefsh114*/"Description";   // "Beschreibung"
        key = "nm1";
        edit_width = 35;
		mnemonic = /*t-gefsh11400*/"D";
      }

      :row {
        fixed_width = true;
        :text {
          label = "&Number of Splines";                
          key = "n_text";
          width = 20;
        }

        :text { key = "n_bez";
                width = 1.5; }
        :text { label = /*t-gefsh28*/"=";   // "="
                width = 1.2; }

        :edit_box {
          edit_width = 7;
          key = "n";
          width = 7.5;
        }
      }

      :row {
        fixed_width = true;
        :text {
          label = "&Internal Diameter";
          key = "d1_text";
          width = 20;
        }

        :text { key = "d1_bez";
                width = 1.5; }
        :text { label = /*t-gefsh28*/"=";   // "="
                width = 1.2; }

        :edit_box {
          edit_width = 7;
          key = "d1";
          width = 7.5;
        }

        :row {
          fixed_width = true;
          children_fixed_width = true;
          width = 13.5;
          :gefsh_anwahlen {
            key = "d1_anw";
          }
          :text {
            key = "d1_unit";
            width = 6;
          }
        }
      }

      :row {
        fixed_width = true;
        :text {
          label = "&External Diameter";
          key = "d2_text";
          width = 20;
        }

       :text { key = "d2_bez";
               width = 1.5; }
       :text { label = /*t-gefsh28*/"=";   // "="
               width = 1.2; }

        :edit_box {
          edit_width = 7;
          key = "d2";
          width = 7.5;
        }

        :row {
          fixed_width = true;
          children_fixed_width = true;
          width = 13.5;
          :gefsh_anwahlen {
            key = "d2_anw";
          }
          :text {
            key = "d2_unit";
            width = 6;
          }
        }
      }


      :row {
        fixed_width = true;
        :text {
          label = /*t-gefsh54*/"Width of Spline";  // "Keilbreite"
          width = 20;
		mnemonic = /*t-gefsh5400*/"W";
        }

       :text { key = "b_bez";
               width = 1.5; }
       :text { label = /*t-gefsh28*/"=";   // "="
               width = 1.2; }

        :edit_box {
          edit_width = 7;
          key = "b";
          width = 7.5;
        }

        :row {
          fixed_width = true;
          children_fixed_width = true;
          width = 13.5;

          :spacer { width = 1; }
          :text {
            key = "b_unit";
            width = 6;
          }
        }
      }


      :spacer { height = 1; }
      :row {
        fixed_width = true;
        :text {
          label = /*t-gefsh33*/"Length";  // "Lnge"
          width = 20;
		mnemonic = /*t-gefsh3300*/"L";
        }

       :text { label = /*t-gefsh102*/"l";   // "l"
               width = 1.5; }
       :text { label = /*t-gefsh28*/"=";   // "="
               width = 1.2; }

        :edit_box {
          edit_width = 7;
          key = "l";
          width = 7.5;
        }

        :row {
          fixed_width = true;
          children_fixed_width = true;
          width = 13.5;
          :gefsh_anwahlen {
            key = "l_anw";
          }
          :text {
            key = "l_unit";
            width = 6;
          }
        }
      }
    }

    :spacer { width = 1; }
    :column {
      :row {
        children_alignment = top;
        children_fixed_height = true;

        :column {
          :gefsh_img {
             key = "icon";
             alignment = centered;
          }
        }//column
      }//row
    }//column
  }//row

  :spacer { height = 0.5; }

  gefsh_norm_oneline_prev;
} //dialog


//---------------------------------------------------------gefsh_ser
// Kerbverzahnung Normliste

gefsh_ser: dialog {
  key = "text";


  children_alignment = left;
  children_fixed_width = true;


  :text {
    key = "d_text";
    width = 40;
  }
 
 :row {
    children_alignment = top;
    children_fixed_height = true;
    :column {
      children_alignment = left;
      children_fixed_width = true;

      :list_box {
        key = "dn";
        multiple_select = false;
        width = 28;
        height = 10;
      }

      :row {
        children_fixed_width = true;
        :row {
           children_fixed_width = true;
           width = 14.5;
           :text { label = /*t-gefsh41*/"Find";  // "Suchen"
		mnemonic = /*t-gefsh4100*/"F";
                 }
           :text { label = /*t-gefsh40*/"d =";   // "d ="
                 }
        }

        :edit_box {
          edit_width = 7;
          key = "d_find";
          width = 7.5;
        }
        :gefsh_anwahlen {
          key = "d_anw";
        }
        :text {
          key = "d_unit";
          width = 6;
        }
      }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 14.5;   

          :text { label = /*t-gefsh33*/"Length";  // "Lnge"
		mnemonic = /*t-gefsh3300*/"L";
                }
          :text { label = /*t-gefsh34*/"l =";   // "l ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "l";
          width = 7.5;
        }

        :gefsh_anwahlen {
          key = "l_anw";
        }

        :text {
          key = "l_unit";
          width = 6;
        }   
      }//row
    }

    :spacer { width = 1; }
    :column {
      :row {
        children_alignment = top;
        children_fixed_height = true;

        :column {
          :gefsh_img {
             key = "icon";
             alignment = centered;
          }
        }//column
      }//row
    }//column
  }//row

  :spacer { height = 0.5; }

  gefsh_sond_oneline_prev;
} //dialog



//---------------------------------------------------------gefsh_sersond
// Sonderanfertigung Kerbverzahnung

gefsh_sersond: dialog {
  key = "text";

  children_alignment = left;
  children_fixed_width = true;

 :row {
    children_alignment = top;
    children_fixed_height = true;
    :column {
       children_alignment = left;
       children_fixed_width = true;

      :edit_box {
        label = /*t-gefsh114*/"Description";   // "Beschreibung"
        key = "nm1";
        edit_width = 35;
		mnemonic = /*t-gefsh11400*/"D";
      }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 31;
          :text {  label = "&Number of Teeth"; 
                   key = "n_text";  width = 21;  }
          :text {  label = /*t-gefsh103*/"n =";   // "n ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "n";
          width = 7.5;
        }
      }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 31;
          :text {  label = "Included &Angle";
                   key = "a_text";  width = 18; }
          :text { label = /*t-gefsh65*/"alpha =";   // "alpha ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "a";
          width = 7.5;
        }

        :row {
          fixed_width = true;
          children_fixed_width = true;
          width = 13.5;
          :spacer { width = 1; }
          :text {
            label = /*t-gefsh55*/"[deg]";  // "[deg]"
            width = 6;
          }
        }
      }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 31;
          :text {  label = "&Internal Diameter";
                   key = "d4_text";  width = 20;  }
          :text { label = /*t-gefsh105*/"di =";   // "di ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "d4";
          width = 7.5;
        }

        :row {
          fixed_width = true;
          children_fixed_width = true;
          width = 13.5;

          :gefsh_anwahlen {
            key = "d4_anw";
          }
          :text {
            key = "d4_unit";
            width = 6;
          }
        }
      }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 31;
          :text {  label = "&External Diameter";
                   key = "d3_text";  width = 20; }
          :text { label = /*t-gefsh104*/"da =";   // "da ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "d3";
          width = 7.5;
        }

        :row {
          fixed_width = true;
          children_fixed_width = true;
          width = 13.5;

          :gefsh_anwahlen {
            key = "d3_anw";
          }
          :text {
            key = "d3_unit";
            width = 6;
          }
        }
      }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 31;
          :text { label = "&Pitch Diameter";
                  key = "d5_text";  width = 20; }
          :text { label = /*t-gefsh106*/"dt =";   // "dt ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "d5";
          width = 7.5;
        }

        :row {
          fixed_width = true;
          children_fixed_width = true;
          width = 13.5;

          :gefsh_anwahlen {
            key = "d5_anw";
          }
          :text {
            key = "d5_unit";
            width = 6;
          }
        }
      }


      :spacer { height = 0.5; }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 31;
          :text {  label = /*t-gefsh33*/"Length";  // "Lnge"
		mnemonic = /*t-gefsh3300*/"L";
                }
          :text { label = /*t-gefsh34*/"l =";   // "l"
                }
        }

        :edit_box {
          edit_width = 7;
          key = "l";
          width = 7.5;
        }

        :row {
          fixed_width = true;
          children_fixed_width = true;
          width = 13.5;

          :gefsh_anwahlen {
            key = "l_anw";
          }
          :text {
            key = "l_unit";
            width = 6;
          }
        }
      }
    }

    :spacer { width = 1; }
    :column {
      :row {
        children_alignment = top;
        children_fixed_height = true;

        :column {
          :gefsh_img {
             key = "icon";
             alignment = centered;
          }
        }//column
      }//row
    }//column
  }//row

  :spacer { height = 0.5; }

  gefsh_norm_oneline_prev;
} //dialog



//---------------------------------------------------------gefsh_pol
// Polygonprofil Normliste

gefsh_pol: dialog {
  key = "text";


  children_alignment = left;
  children_fixed_width = true;


  :text {
    key = "d_text";
    width = 40;
  }
 
 :row {
    children_alignment = top;
    children_fixed_height = true;
    :column {
      children_alignment = left;
      children_fixed_width = true;

      :list_box {
        key = "dn";
        multiple_select = false;
        width = 28;
        height = 10;
      }
      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 14.5;   
          :text { label = /*t-gefsh41*/"Find";  // "Suchen"
		mnemonic = /*t-gefsh4100*/"F";
                }
          :text { key = "d1_text1"; 
                  label = /*t-gefsh40*/"d =";   // "d ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "d_find";
          width = 7.5;
        }
        :gefsh_anwahlen {
          key = "d_anw";
        }
        :text {
          key = "d_unit";
          width = 6;
        }
      }

      //:spacer { height = 0.3; }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 14.5;   

          :text { label = /*t-gefsh33*/"Length";  // "Lnge"
		mnemonic = /*t-gefsh3300*/"L";
                }
          :text { label = /*t-gefsh34*/"l =";   // "l ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "l";
          width = 7.5;
        }

        :gefsh_anwahlen {
          key = "l_anw";
        }

        :text {
          key = "l_unit";
          width = 6;
        }   
      }//row
    }

    :column {
      :row {
        children_alignment = top;
        children_fixed_height = true;

        :column {
          children_alignment = left; 
          :gefsh_img {
             key = "icon";
             alignment = centered;
          }
          :toggle {
             key = "drehen";
             label = /*t-gefsh37*/"Rotate";  // "Drehen"
             value = "0";
             width = 12;
             fixed_width = true;
		mnemonic = /*t-gefsh3700*/"R";
          }

          :spacer { height = 0.3; }
          :row {
            children_fixed_width = true;
            :text {         
              label = /*t-gefsh56*/"Tolerance for d";  // "Toleranz fr d"
		mnemonic = /*t-gefsh5600*/"T";
            }
          
            :edit_box {
              key = "d1_tol";
              edit_width = 6;
              width = 6.5;
            }
          }
        }//column
      }//row
    }//column
  }//row

  :spacer { height = 0.5; }

  gefsh_sond_oneline_prev;
} //dialog



//---------------------------------------------------------gefsh_polsond3
// Sonderanfertigung Polygonprofil P3

gefsh_polsond3: dialog {
  key = "text";

  children_alignment = left;
  children_fixed_width = true;

 :row {
    children_alignment = top;
    children_fixed_height = true;
    :column {
       children_alignment = left;
       children_fixed_width = true;

      :edit_box {
        label = /*t-gefsh114*/"Description";   // "Beschreibung"
        key = "nm1";
        edit_width = 35;
		mnemonic = /*t-gefsh11400*/"D";
      }

      :row {
        fixed_width = true;
        :text {
          label = "&Nominal Diameter";
          key = "d1_text";
          width = 20;
        }

       :text { key = "d1_bez";
               width = 1.5; }
       :text { label = /*t-gefsh28*/"=";   // "="
               width = 1.2; }

        :edit_box {
          edit_width = 7;
          key = "d1";
          width = 7.5;
        }

        :row {
          fixed_width = true;
          children_fixed_width = true;
          width = 13.5;

          :gefsh_anwahlen {
            key = "d1_anw";
          }
          :text {
            key = "d1_unit";
            width = 6;
          }
        }
      }

      :row {
        fixed_width = true;
        :text {
          label = "&External Diameter";
          key = "d2_text";
          width = 20;
        }

       :text { key = "d2_bez";
               width = 1.5; }
       :text { label = /*t-gefsh28*/"=";   // "="
               width = 1.2; }

        :edit_box {
          edit_width = 7;
          key = "d2";
          width = 7.5;
        }

        :row {
          fixed_width = true;
          children_fixed_width = true;
          width = 13.5;

          :gefsh_anwahlen {
            key = "d2_anw";
          }
          :text {
            key = "d2_unit";
            width = 6;
          }
        }
      }

      :row {
        fixed_width = true;
        :text {
          label = "Di&fference";
          key = "e_text";
          width = 20;
        }

       :text { key = "e_bez";
               width = 1.5; }
       :text { label = /*t-gefsh28*/"=";   // "="
               width = 1.2; }

        :edit_box {
          edit_width = 7;
          key = "e";
          width = 7.5;
        }

        :row {
          fixed_width = true;
          children_fixed_width = true;
          width = 13.5;

          :spacer { width = 1; }
          :text {
            key = "e_unit";
            width = 6;
          }
        }
      }


      :spacer { height = 0.5; }
      :row {
        fixed_width = true;
        :text {
          label = /*t-gefsh33*/"Length";  // "Lnge"
          width = 20;
		mnemonic = /*t-gefsh3300*/"L";
        }

       :text { label = /*t-gefsh102*/"l";   // "l"
               width = 1.5; }
       :text { label = /*t-gefsh28*/"=";   // "="
               width = 1.2; }

        :edit_box {
          edit_width = 7;
          key = "l";
          width = 7.5;
        }

        :row {
          fixed_width = true;
          children_fixed_width = true;
          width = 13.5;

          :gefsh_anwahlen {
            key = "l_anw";
          }
          :text {
            key = "l_unit";
            width = 6;
          }
        }
      }
    }

    :spacer { width = 1; }
    :column {
      :row {
        children_alignment = top;
        children_fixed_height = true;

        :column {
          :gefsh_img {
             key = "icon";
             alignment = centered;
          }
          :toggle {
             key = "drehen";
             label = /*t-gefsh37*/"Rotate";  // "Drehen"
             value = "0";
             width = 12;
             fixed_width = true;
		mnemonic = /*t-gefsh3700*/"R";
          }
        }//column
      }//row
    }//column
  }//row

  :spacer { height = 0.5; }

  gefsh_norm_oneline_prev;
} //dialog



//---------------------------------------------------------gefsh_polsond4
// Sonderanfertigung Polygonprofil P4

gefsh_polsond4: dialog {
  key = "text";

  children_alignment = left;
  children_fixed_width = true;

 :row {
    children_alignment = top;
    children_fixed_height = true;
    :column {
       children_alignment = left;
       children_fixed_width = true;

      :edit_box {
        label = /*t-gefsh114*/"Description";   // "Beschreibung"
        key = "nm1";
        edit_width = 35;
		mnemonic = /*t-gefsh11400*/"D";
      }

      :row {
        fixed_width = true;
        :text {
          label = "&External Diameter";
          key = "d1_text";
          width = 20;
        }

       :text { key = "d1_bez";
               width = 1.5; }
       :text { label = /*t-gefsh28*/"=";   // "="
               width = 1.2; }

        :edit_box {
          edit_width = 7;
          key = "d1";
          width = 7.5;
        }

        :row {
          fixed_width = true;
          children_fixed_width = true;
          width = 13.5;

          :gefsh_anwahlen {
            key = "d1_anw";
          }
          :text {
            key = "d1_unit";
            width = 6;
          }
        }
      }

      :row {
        fixed_width = true;
        :text {
          label = "&Internal Diameter";
          key = "d2_text";
          width = 20;
        }

       :text { key = "d2_bez";
               width = 1.5; }
       :text { label = /*t-gefsh28*/"=";   // "="
               width = 1.2; }

        :edit_box {
          edit_width = 7;
          key = "d2";
          width = 7.5;
        }

        :row {
          fixed_width = true;
          children_fixed_width = true;
          width = 13.5;

          :gefsh_anwahlen {
            key = "d2_anw";
          }
          :text {
            key = "d2_unit";
            width = 6;
          }
        }
      }

      :row {
        fixed_width = true;
        :text {
          label = "Di&fference";
          key = "e_text";
          width = 20;
        }

       :text { key = "e_bez";
               width = 1.5; }
       :text { label = /*t-gefsh28*/"=";   // "="
               width = 1.2; }

        :edit_box {
          edit_width = 7;
          key = "e";
          width = 7.5;
        }

        :row {
          fixed_width = true;
          children_fixed_width = true;
          width = 13.5;

          :spacer { width = 1; }
          :text {
            key = "e_unit";
            width = 6;
          }
        }
      }


      :spacer { height = 0.5; }
      :row {
        fixed_width = true;
        :text {
          label = /*t-gefsh33*/"Length";  // "Lnge"
          width = 20;
		mnemonic = /*t-gefsh3300*/"L";
        }

       :text { label = /*t-gefsh102*/"l";   // "l"
               width = 1.5; }
       :text { label = /*t-gefsh28*/"=";   // "="
               width = 1.2; }

        :edit_box {
          edit_width = 7;
          key = "l";
          width = 7.5;
        }

        :row {
          fixed_width = true;
          children_fixed_width = true;
          width = 13.5;

          :gefsh_anwahlen {
            key = "l_anw";
          }
          :text {
            key = "l_unit";
            width = 6;
          }
        }
      }
    }

    :spacer { width = 1; }
    :column {
      :row {
        children_alignment = top;
        children_fixed_height = true;

        :column {
          :gefsh_img {
             key = "icon";
             alignment = centered;
          }
          :toggle {
             key = "drehen";
             label = /*t-gefsh37*/"Rotate";  // "Drehen"
             value = "0";
             width = 12;
             fixed_width = true;
		mnemonic = /*t-gefsh3700*/"R";
          }
        }//column
      }//row
    }//column
  }//row

  :spacer { height = 0.5; }

  gefsh_norm_oneline_prev;
} //dialog





//---------------------------------------------------------gefsh_invd
// Evolventenverzahnung DIN

gefsh_invd: dialog {
  key = "text";


  children_alignment = left;
  children_fixed_width = true;


  :text {
    key = "d_text";
    width = 40;
  }
 
 :row {
    children_alignment = top;
    children_fixed_height = true;
    :column {
      children_alignment = left;
      children_fixed_width = true;

      :list_box {
        key = "dn";
        multiple_select = false;
        width = 32;
        height = 10;
      }

      :row {
        children_fixed_width = true;
        :row {
           children_fixed_width = true;
           width = 14.5;
           :text { label = /*t-gefsh41*/"Find";  // "Suchen"
		mnemonic = /*t-gefsh4100*/"F";
                 }
           :text { label = /*t-gefsh40*/"d =";   // "d ="
                 }
        }

        :edit_box {
          edit_width = 7;
          key = "d_find";
          width = 7.5;
        }
        :gefsh_anwahlen {
          key = "d_anw";
        }
        :text {
          key = "d_unit";
          width = 6;
        }
      }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 14.5;   

          :text { label = /*t-gefsh33*/"Length";  // "Lnge"
		mnemonic = /*t-gefsh3300*/"L";
                }
          :text { label = /*t-gefsh34*/"l =";   // "l ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "l";
          width = 7.5;
        }

        :gefsh_anwahlen {
          key = "l_anw";
        }

        :text {
          key = "l_unit";
          width = 6;
        }   
      }//row
     
      :spacer { height = 0.3; }
      :text {
        label = "";
        key = "wait";
        fixed_width = false;
        alignment = centered;
      }
    }

    :spacer { width = 1; }

    :column {
      :row {
        children_alignment = top;
        children_fixed_height = true;

        :column {
          children_fixed_width = true;
          children_alignment = left;
          :gefsh_img {
             key = "icon";
             alignment = centered;
          }

          :row {
            width = 29;
            :text {
              label = "&Pressure Angle";
              key = "a_text";
              width = 20;
            }
            :popup_list {
              label = ""; 
              width = 9;
              key = "an";
            }
          }

          :row {
            width = 29;
            :text {
              label = "&Module";
              key = "m_text";
              width = 20;
            }

            :popup_list {
              label = ""; 
              width = 9;
              key = "mn";
            }
          }

          :spacer { height = 0.5; }

          :text {         
            label = /*t-gefsh53*/"Tolerance for";  // "Toleranzen fr"
          }
          :row {
            children_fixed_width = true;
            :text {
              label = /*t-gefsh59*/"da";  // "da"
              width = 2.2;
		mnemonic = /*t-gefsh5900*/"a";
            }
            :edit_box {
              key = "da_tol";
              edit_width = 6;
              width = 6.5;
            }
            :spacer { width = 1.5; }
            :text {
              label = /*t-gefsh90*/"di";  // "di"
              width = 2.2;
		mnemonic = /*t-gefsh9000*/"i";
            }
            :edit_box {
              key = "df_tol";
              edit_width = 6;
              width = 6.5;
            }
          }
        }//column
      }//row
    }//column
  }//row

  :spacer { height = 0.5; }

  gefsh_sond_oneline_prev;
} //dialog



//---------------------------------------------------------gefsh_inva
// Evolventenverzahnung ANSI

gefsh_inva: dialog {
  key = "text";


  children_alignment = left;
  children_fixed_width = true;


  :text {
    key = "d_text";
    width = 40;
  }
 
 :row {
    children_alignment = top;
    children_fixed_height = true;
    :column {
      children_alignment = left;
      children_fixed_width = true;

      :list_box {
        key = "dn";
        multiple_select = false;
        width = 28;
        height = 10;
      }
     
      :row {
        children_fixed_width = true;
        :row {
           children_fixed_width = true;
           width = 14.5;
           :text { label = /*t-gefsh41*/"Find";  // "Suchen"
		mnemonic = /*t-gefsh4100*/"F";
                 }
           :text { label = /*t-gefsh40*/"d =";   // "d ="
                 }
        }

        :edit_box {
          edit_width = 7;
          key = "d_find";
          width = 7.5;
        }
        :gefsh_anwahlen {
          key = "d_anw";
        }
        :text {
          key = "d_unit";
          width = 6;
        }
      }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 14.5;   

          :text { label = /*t-gefsh33*/"Length";  // "Lnge"
		mnemonic = /*t-gefsh3300*/"L";
                }
          :text { label = /*t-gefsh34*/"l =";   // "l ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "l";
          width = 7.5;
        }

        :gefsh_anwahlen {
          key = "l_anw";
        }

        :text {
          key = "l_unit";
          width = 6;
        }   
      }//row

      :spacer { height = 1; }
      :text {
        label = "";
        key = "wait";
        fixed_width = false;
        alignment = centered;
      }
    }

    :spacer { width = 1; }

    :column {
      :row {
        children_alignment = top;
        children_fixed_height = true;

        :column {
          children_fixed_width = true;
          children_alignment = left;
          :gefsh_img {
             key = "icon";
             alignment = centered;
          }
          :row {
            width = 24;
            :text {
              label = "&Pressure Angle";
              key = "a_text";
              width = 15;
            }
            :popup_list {
              label = ""; 
              width = 9;
              key = "an";
            }
          }

          :row {
            width = 24;
            :text {
              label = "&Diametral Pitch";
              key = "m_text";
              width = 15;
            }

            :popup_list {
              label = ""; 
              width = 9;
              key = "mn";
            }
          }

          :spacer { height = 0.1; }

          
          :radio_column {
            children_fixed_width = true;
            :radio_button {         
              label = /*t-gefsh61*/"Flat Root, Side Fit";  // "Fulinie, Flankenzentr."
              key = "form1";
              value = "1";
		mnemonic = /*t-gefsh6100*/"R";
            }
            :radio_button {         
              label = /*t-gefsh62*/"Flat Root, Major Diameter Fit";  // "Fulinie, Auenzentr."
              key = "form2";
              value = "0";
		mnemonic = /*t-gefsh6200*/"M";
            }
            :radio_button {         
              label = /*t-gefsh63*/"Fillet Root, Side Fit";  // "Furundung, Flankenzentr."
              key = "form3";
              value = "0";
		mnemonic = /*t-gefsh6300*/"o";
            }
          }
        }//column
      }//row
    }//column
  }//row

  :spacer { height = 0.1; }

  gefsh_sond_oneline_prev;
} //dialog



//---------------------------------------------------------gefsh_invsondd
// Sonderanfertigung Evolventenverzahnung DIN

gefsh_invsondd: dialog {
  key = "text";

  children_alignment = left;
  children_fixed_width = true;

 :row {
    children_alignment = top;
    children_fixed_height = true;
    :column {
       children_alignment = left;
       children_fixed_width = true;


      :edit_box {
        label = /*t-gefsh114*/"Description";   // "Beschreibung"
        key = "nm1";
        edit_width = 35;
		mnemonic = /*t-gefsh11400*/"D";
      }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 36;
          :text {  label = "&Module";
                   key = "m_text";  width = 21; }
          :text { 
            fixed_width = true; 
            label = /*t-gefsh69*/"m ="; 
            key = "m_bez"; 
          }
        }

        :edit_box {
          edit_width = 7;
          key = "m";
          width = 7.5;
        }
        :text {
          key = "m_unit";
          width = 8;
        }
      }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 36;
          :text {  label = "&Number of Teeth";
                   key = "z_text";  width = 21;  }
          :text { label = /*t-gefsh64*/"z =";   // "z ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "z";
          width = 7.5;
        }
      }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 36;
          :text {  label = "Pressure &Angle";
                   key = "a_text";   width = 23;  }
          :text { label = /*t-gefsh65*/"alpha =";   // "alpha ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "a";
          width = 7.5;
        }

        :text {
          label = /*t-gefsh55*/"[deg]";  // "[deg]"
          width = 6;
        }
      }


      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 36;
          :text { label = "Addendum &Circle Coeff."; 
                  key = "hap_text";  width = 25; }
          :text { label = /*t-gefsh66*/"hap =";   // "hap"
                }
        }

        :edit_box {
          edit_width = 7;
          key = "hap";
          width = 7.5;
        }
      }


      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 36;
          :text { label = "&Root Circle Coeff.";
                  key = "hfp_text";  width = 25; }
          :text { label = /*t-gefsh67*/"hfp =";   // "hfp"
                }
        }

        :edit_box {
          edit_width = 7;
          key = "hfp";
          width = 7.5;
        }
      }


      :spacer { height = 0.5; }
      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 36;
          :text { label = /*t-gefsh33*/"Length";  // "Lnge"
		mnemonic = /*t-gefsh3300*/"L";
                }
          :text { label = /*t-gefsh34*/"l =";   // "l ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "l";
          width = 7.5;
        }
        :gefsh_anwahlen {
          key = "l_anw";
        }
        :text {
          key = "l_unit";
          width = 6;
        }
      }
    }

    :column {
      :row {
        children_alignment = top;
        children_fixed_height = true;

        :column {
          :gefsh_img {
             key = "icon";
             alignment = centered;
          }
        }//column
      }//row
    }//column
  }//row

  :spacer { height = 0.5; }

  gefsh_norm_oneline_prev;
} //dialog



//---------------------------------------------------------gefsh_invsonda
// Sonderanfertigung Evolventenverzahnung ANSI

gefsh_invsonda: dialog {
  key = "text";

  children_alignment = left;
  children_fixed_width = true;

 :row {
    children_alignment = top;
    children_fixed_height = true;
    :column {
       children_alignment = left;
       children_fixed_width = true;

      :edit_box {
        label = /*t-gefsh114*/"Description";   // "Beschreibung"
        key = "nm1";
        edit_width = 35;
		mnemonic = /*t-gefsh11400*/"D";
      }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 36;
          :text { label = "Diametral &Pitch"; 
                  key = "m_text";  width = 21; }
          :text { 
            fixed_width = true; 
            label = /*t-gefsh69*/"m ="; 
            key = "m_bez"; 
          }
        }

        :edit_box {
          edit_width = 7;
          key = "m";
          width = 7.5;
        }
        :text {
          key = "m_unit";
          width = 8;
        }
      }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 36;
          :text {  label = "&Number of Teeth";
                   key = "z_text";  width = 21;  }
          :text { label = /*t-gefsh64*/"z =";   // "z ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "z";
          width = 7.5;
        }
      }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 36;
          :text { label = "Pressure &Angle"; 
                  key = "a_text";   width = 23;  }
          :text { label = /*t-gefsh65*/"alpha =";   // "alpha ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "a";
          width = 7.5;
        }

        :text {
          label = /*t-gefsh55*/"[deg]";  // "[deg]"
          width = 6;
        }
      }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 36;
          :text { label = "Addendum &Circle Coeff.";  
                  key = "hap_text";  width = 23; }
          :text { label = /*t-gefsh66*/"hap =";   // "hap"
                }
        }

        :edit_box {
          edit_width = 7;
          key = "hap";
          width = 7.5;
        }
      }

      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 36;
          :text { label = "&Root Circle Coeff.";
                  key = "hfp_text";  width = 23; }
          :text { label = /*t-gefsh67*/"hfp =";   // "hfp"
                }
        }

        :edit_box {
          edit_width = 7;
          key = "hfp";
          width = 7.5;
        }
      }


      :spacer { height = 0.5; }
      :row {
        children_fixed_width = true;
        :row {
          children_fixed_width = true;
          width = 36;
          :text { label = /*t-gefsh33*/"Length";  // "Lnge"
		mnemonic = /*t-gefsh3300*/"L";
                }
          :text { label = /*t-gefsh34*/"l =";   // "l ="
                }
        }

        :edit_box {
          edit_width = 7;
          key = "l";
          width = 7.5;
        }
        :gefsh_anwahlen {
          key = "l_anw";
        }
        :text {
          key = "l_unit";
          width = 6;
        }
      }
    }

    :column {
      :row {
        children_alignment = top;
        children_fixed_height = true;

        :column {
          :gefsh_img {
             key = "icon";
             alignment = centered;
          }
        }//column
      }//row
    }//column
  }//row

  :spacer { height = 0.5; }

  gefsh_norm_oneline_prev;
} //dialog



//---------------------------------------------------------gefsh_gear
// Zahnrad

gefsh_gear: dialog {
  key = "text";

  children_alignment = left;
  children_fixed_width = true;

 :row {
    children_alignment = top;
    children_fixed_height = true;
    :column {
      children_alignment = left;
      children_fixed_width = true;

      :radio_row {
        children_fixed_width = true;
        :spacer { width = 3; }
        :radio_button {        
          label = /*t-gefsh145*/"DIN";  // "DIN"
          key = "din";
          value = "1";
		mnemonic = /*t-gefsh14500*/"D";
        }
        :spacer { width = 3; }
        :radio_button { 
          label = /*t-gefsh146*/"ANSI";  // "ANSI"
          key = "ansi";
          value = "0";
		mnemonic = /*t-gefsh14600*/"A";
        }
      }//radio_row

      :spacer { height = 0.5; }

      :row {
        children_fixed_height = true;
        children_alignment = centered;
        :row {           
          width = 36;
          children_fixed_height = true;
          children_alignment = centered;
          :column {
            :text { alignment = left; width = 21; key = "m_text"; }
          }
          :column {
            :text { 
              label = /*t-gefsh69*/"m ="; 
              key = "m_bez"; 
              alignment = right; 
            }
          }
        }

        :row {
          children_fixed_width = true;
          width = 16;
          :edit_box {
            edit_width = 7;
            key = "m";
            width = 7.5;
          }
          :text {
            key = "m_unit";
            width = 8;
          }
        }
      }

      :row {
        children_fixed_height = true;
        children_alignment = centered;
        :row {           
          width = 36;
          children_fixed_height = true;
          children_alignment = centered;
          :column {
            :text { label = "&Number of Teeth";
                    alignment = left; width = 21; key = "z_text"; }
          }
          :column {
            :text { label = /*t-gefsh64*/"z ="; 
                    key = "z_bez"; 
                    alignment = right; 
                  }   // "z ="
          }
        }

        :row {
          children_fixed_width = true;
          width = 16;
          :edit_box {
            edit_width = 7;
            key = "z";
            width = 7.5;
          }
        }
      }

      :row {
         children_fixed_height = true;
         children_alignment = centered;
        :row {           
           width = 36;
           children_fixed_height = true;
           children_alignment = centered;
           :column {
             :text { label = "&Pressure Angle";
                     alignment = left; width = 18; key = "a_text"; }
           }
           :column {
             :text { label = /*t-gefsh65*/"alpha =";  
                     alignment = right;
                     width = 1;
                     key = "alpha_bez"; 
                   }  // "alpha ="
           }
        }

        :row {
          children_fixed_width = true;
          width = 16;

          :edit_box {
            edit_width = 7;
            key = "a";
            width = 7.5;
          }

          :text {
            label = /*t-gefsh55*/"[deg]";  // "[deg]"
            width = 6;
          }
        }
      }

      :row {
        children_fixed_height = true;
        children_alignment = centered;
        :row {           
          width = 36;
          children_fixed_height = true;
          children_alignment = centered;
          :column {
            :text { label = "&Helix Angle"; 
                    alignment = left; width = 19; key = "b_text"; }
          }
          :column {
            :text {  label = /*t-gefsh68*/"beta =";   // "beta ="
                     key = "beta_bez"; 
                     alignment = right; 
                  }
          }
        }

        :row {
          children_fixed_width = true;
          width = 16;
          :edit_box {
            edit_width = 7;
            key = "b";
            width = 7.5;
          }

          :text {
            label = /*t-gefsh55*/"[deg]";  // "[deg]"
            width = 6;
          }
        }
      }

      :row {
        children_fixed_height = true;
        children_alignment = centered;
        :row {           
          width = 36;
          children_fixed_height = true;
          children_alignment = centered;
          :column {
            :text { label = "Profile &Offset";
                    alignment = left; width = 21; key = "x_text"; }
          }
          :column {
            :text {  label = /*t-gefsh70*/"x =";   // "x ="
                     key = "x_bez"; 
                     alignment = right; 
                  }
          }
        }

        :row {
          children_fixed_width = true;
          width = 16;

          :edit_box {
            edit_width = 7;
            key = "x";
            width = 7.5;
          }
        }
      }




      :row {
        children_fixed_height = true;
        children_alignment = centered;
        :row {           
          width = 36;
          children_fixed_height = true;
          children_alignment = centered;
          :column {
            :text { label = "Addendum &Circle Coeff.";
                    alignment = left; width = 21; key = "hap_text"; }
          }
          :column {
            :text { label = /*t-gefsh66*/"hap =";   // "hap ="
                    key = "hap_bez"; 
                    alignment = right;
                  }
           }
         }
         :row {
           children_fixed_width = true;
           width = 16;

          :edit_box {
            edit_width = 7;
            key = "hap";
            width = 7.5;
          }
        }
      }


      :row {
        children_fixed_height = true;
        children_alignment = centered;
        :row {           
          width = 36;
          children_fixed_height = true;
          children_alignment = centered;
          :column {
            :text { label = "&Root Circle Coeff.";
                    alignment = left; width = 20; key = "hfp_text"; }
          }
          :column {
            :text { label = /*t-gefsh67*/"hfp =";   // "hfp"
                    key = "hfp_bez"; 
                    alignment = right; 
                  }
          }
        }

        :row {
          children_fixed_width = true;
          width = 16;

          :edit_box {
            edit_width = 7;
            key = "hfp";
            width = 7.5;
          }
        }
      }
    }

    :spacer { width = 3; }

    :column {
      children_alignment = left;
      children_fixed_width = true;

      :gefsh_img {
        key = "icon";
        alignment = centered;
      }
 
      :row {
        fixed_width = true;
        :spacer { width = 1; }
        :text { label = /*t-gefsh59*/"da";   // "da"
                width = 2.2; 
                key = "da_bez";
              }
        :text { label = /*t-gefsh28*/"=";   // "="
                width = 1.2; }
        :text { key = "da"; 
                width = 12; }
        :text { key = "da_unit";
                width = 8;  }
      }//row

      :row {
        fixed_width = true;
        :spacer { width = 1; }
        :text { label = /*t-gefsh59*/"d&a";   // "da"
                width = 2.2; 
                key = "da_edit_bez";
		            }
        :text { label = /*t-gefsh28*/"=";   // "="
                width = 1.2; }
        :edit_box {
          edit_width = 7;
          key = "da_eing";
          width = 7.5;
        }
        :gefsh_anwahlen {
          key = "da_anw";
        }
      }//row

      :spacer { height = 0.2; }

      :row {
        fixed_width = true;
        :spacer { width = 1; }
        :text { label = /*t-gefsh91*/"dt";   // "dt"
                width = 3.0; 
                key = "dt_bez";
              }
        :text { label = /*t-gefsh28*/"=";   // "="
                width = 1.2; }
        :text { key = "d"; 
                width = 12; }
        :text { key = "d_unit";
                width = 8;  }
      }//row

      :row {
        fixed_width = true;
        :spacer { width = 1; }
        :text { label = /*t-gefsh60*/"df";   // "df"
                width = 3.0; 
                key = "df_bez";
              }
        :text { label = /*t-gefsh28*/"=";   // "="
                width = 1.2; }
        :text { key = "df"; 
                width = 12; }
        :text { key = "df_unit";
                width = 8;  }
      }//row
    }//column
  }//row

  :row {
    :column {
      children_alignment = left;
      :row {
        children_fixed_height = true;
        children_alignment = centered;
        :row {           
          width = 36;
          children_fixed_height = true;
          children_alignment = centered;
          :column {
            :text { 
              label = /*t-gefsh33*/"Length"; 
              fixed_width = true;  // "Lnge"
              width = 21;
              alignment = left;
		mnemonic = /*t-gefsh3300*/"L";
            }
          }
          :column {
            :text { fixed_width = true;  
                    label = /*t-gefsh34*/"l =";   // "l ="
                    alignment = right;
                  }
          }
        }
        :edit_box {
          edit_width = 7;
          key = "l";
          width = 7.5;
        }
        :gefsh_anwahlen {
          key = "l_anw";
        }
        :text {
          key = "l_unit";
          width = 8;
        }
      }
    }
  }

  :spacer { height = 0.5; }

  :row {
    vertical_margin = none;
    horizontal_margin = none;
    fixed_height = true;
    fixed_width = false;
    children_alignement = bottom;
    :geniusdia {height=2;}
    :row {
      vertical_margin = none;
      fixed_width = true;
      children_fixed_width = true;
      alignement = left;
      okbutton;            //KEY accept
//      :button {
//        label = t-gefsh113~;   // "Norm"
//        key = "norm";
//      }
      cancelbutton;        //KEY abort
      helpbutton;          
    }
  }
} //dialog




//---------------------------------------------------------gefsh_config
// Konfiguration

gefsh_config: dialog {
  key = "text";
  label = /*t-gefsh71*/"Shaft Generator - Configuration";  // "Wellengenerator - Konfiguration"

  :boxed_column {
    label = /*t-gefsh109*/"Settings";     // "Modes"
    :row {
      fixed_width = true; //false;
      :gefsh_txt1 {
        label = /*t-gefsh72*/"For Segment Inserted:";  // "Alter Abschnitt mit Neuem"
      }

      :radio_row {
        fixed_width = true;
        key = "insmode";
        :gefsh_rb1 {         
          label = /*t-gefsh73*/"Overdraw";  // "berzeichnen"
          key = "insmode0";
        }
        :gefsh_rb2 {         
          label = /*t-gefsh74*/"Insert";  // "Verschieben"
          key = "insmode1";
        }
        :gefsh_rb_question { key = "insmode2"; }
      }
    }//row

    :row {
      fixed_width = true; //false;
      :gefsh_txt1 {
        label = /*t-gefsh76*/"Stationary Shaft End:";  // "Feste Ende beim Lschen, Edit"
      }

      :radio_row {
        fixed_width = true;
        key = "fixend";
       :gefsh_rb1 {         
          label = /*t-gefsh77*/"Left";  // "Linke"
          key = "fixend0";
        }
        :gefsh_rb2 {         
          label = /*t-gefsh78*/"Right";  // "Rechte"
          key = "fixend1";
        }
        :gefsh_rb_question { key = "fixend2"; }
      } //row
    } // row

    :row {
      fixed_width = true;
      :gefsh_txt1 {
        label = /*t-gefsh82*/"Initial State:";  // "Am Anfang Start von"
      }

      :radio_row {
        fixed_width = true;
        key = "dclmode";
        :gefsh_rb1 {         
          label = /*t-gefsh83*/"Command Line";  // "Befehlzeile"
          key = "dclmode0";
        }  
        :gefsh_rb2 {         
          label = /*t-gefsh84*/"Dialog Box";  // "Icon"
          key = "dclmode1";
        }        
        // spacer_0; //1 { width = 6; }
      } // row
    } // row

    :row {
      fixed_width = true;
      :gefsh_txt1 {
        label = /*t-gefsh119*/"Side for Side View:";  // "Seite fuer Seitenansicht:"
      }

      :radio_row {
        fixed_width = true;
        key = "side";
        :gefsh_rb1 {         
          label = /*t-gefsh120*/"European";  // "DIN"
          key = "side0";
        }  
        :gefsh_rb2 {         
          label = /*t-gefsh121*/"ANSI Projection";  // "ANSI"
          key = "side1";
        }        
        // spacer_0; //1 { width = 6; }
      } // row
    } // row
  } // column

  :row {
    :column {
      :boxed_column {
        label = /*t-gefsh110*/"Front View"; // "Front view"
        :toggle {
           label = /*t-gefsh85*/"Draw as 2 Halves"; // "Doppeltlinie ber, unter Achse"
           key = "doubleline";
        }
        :toggle {
          label = /*t-gefsh86*/"Radius Reflection Line";  // "Lichtlinie beim Radius"
          key = "lightline";
        }
        :toggle {
          label = /*t-gefsh144*/"Check Contour";  // "check contour"
          key = "checkcontour";
        }
      }

      :boxed_radio_row {
        label = /*t-gefsh79*/"Adjust Centerline";  // "Am Ende Mittellinie verlngern"
        key = "centerline";
        :radio_button {
          label = /*t-gefsh80*/"Yes";  // "Ja"
          key = "centerline1";        
        }
        :radio_button {
          label = /*t-gefsh81*/"No";  // "Nein"
          key = "centerline0";
        }
        :gefsh_rb_question { key = "centerline2"; }
      } // boxed_radio_row
    } // column

    :boxed_column {
      label = /*t-gefsh111*/"Side and Sectional Views";   // "Seite Ansichten und Schnitten"
      :toggle {
         label = /*t-gefsh87*/"Complete View"; // "Vollstndige Darstellung"
         key = "fullsideview";
      }
      :toggle {
        label = /*t-gefsh86*/"Radius Reflection Line";  // "Lichtlinie beim Radius"
        key = "lightlineview";
      }
      :toggle {
        label = /*t-gefsh92*/"Sectional with Background";   // "Schnitt mit Hintergrund"
        key = "cutview";
      }
      :toggle {
        label = /*t-gefsh97*/"Always Update";   //  "Aktualisieren immer"
        key = "updateview";
      }
      :toggle {
        label = /*t-gefsh122*/"Hidden Lines";  //  "Verdeckte Linien"
        key = "hidden";
      }
      :toggle {
        label = /*t-gefsh127*/"Move Side View";  // "Move of Side View"
        key = "moveside";
      }
    }

    :boxed_column {
      label = /*t-gefsh128*/"View of";
      children_alignment = centered;
      :row {
        children_alignment = centered;
        :column {
          : gefsh_imgb {
            key = "interrupt";
            width = 15;        
          }
          :gefsh_img_text { label = /*t-gefsh129*/"Interrupt"; width = 14; }
        }
        :column {
          : gefsh_imgb {
            key = "dmode";
            width = 15;        
          }
          :gefsh_img_text { label = /*t-gefsh130*/"Std.Parts"; width = 14; }
        }
      }
    }
  }

  :spacer { height = 0.5; }

  :row {
    vertical_margin = none;
    horizontal_margin = none;
    fixed_height = true;
    fixed_width = false;
    children_alignement = bottom;
    :geniusdia {height=2;}
    :row {
       vertical_margin = none;
       fixed_width = true;
       children_fixed_width = true;
       alignement = left;

       okbutton;           // KEY accept
       :genretirement_button {
         key = "save";
         label = /*t-gefsh98*/"&Use as Default"; //"Speichern"
       }
       cancelbutton;       // KEY cancel
       helpbutton;         // KEY help
    }
  }
} //dialog


//---------------------------------------------------------gefsh_config
// Following dialog box is used in Genius GEF Setup Configuration.
// Dialog box is same as gefsh_config, but does't contains image_button
// "dmode"

gefsh_setup: dialog {
  key = "text";
  label = /*t-gefsh71*/"Shaft Generator - Configuration";  // "Wellengenerator - Konfiguration"

  :boxed_column {
    label = /*t-gefsh109*/"Settings";     // "Modes"
    :row {
      fixed_width = true; //false;
      :gefsh_txt1 {
        label = /*t-gefsh72*/"For Segment Inserted:";  // "Alter Abschnitt mit Neuem"
      }

      :radio_row {
        fixed_width = true;
        key = "insmode";
        :gefsh_rb1 {         
          label = /*t-gefsh73*/"Overdraw";  // "berzeichnen"
          key = "insmode0";
        }
        :gefsh_rb2 {         
          label = /*t-gefsh74*/"Insert";  // "Verschieben"
          key = "insmode1";
        }
        :gefsh_rb_question { key = "insmode2"; }
      }
    }//row

    :row {
      fixed_width = true; //false;
      :gefsh_txt1 {
        label = /*t-gefsh76*/"Stationary Shaft End:";  // "Feste Ende beim Lschen, Edit"
      }

      :radio_row {
        fixed_width = true;
        key = "fixend";
       :gefsh_rb1 {         
          label = /*t-gefsh77*/"Left";  // "Linke"
          key = "fixend0";
        }
        :gefsh_rb2 {         
          label = /*t-gefsh78*/"Right";  // "Rechte"
          key = "fixend1";
        }
        :gefsh_rb_question { key = "fixend2"; }
      } //row
    } // row

    :row {
      fixed_width = true;
      :gefsh_txt1 {
        label = /*t-gefsh82*/"Initial State:";  // "Am Anfang Start von"
      }

      :radio_row {
        fixed_width = true;
        key = "dclmode";
        :gefsh_rb1 {         
          label = /*t-gefsh83*/"Command Line";  // "Befehlzeile"
          key = "dclmode0";
        }  
        :gefsh_rb2 {         
          label = /*t-gefsh84*/"Dialog Box";  // "Icon"
          key = "dclmode1";
        }        
        // spacer_0; //1 { width = 6; }
      } // row
    } // row

    :row {
      fixed_width = true;
      :gefsh_txt1 {
        label = /*t-gefsh119*/"Side for Side View:";  // "Seite fuer Seitenansicht:"
      }

      :radio_row {
        fixed_width = true;
        key = "side";
        :gefsh_rb1 {         
          label = /*t-gefsh120*/"European";  // "DIN"
          key = "side0";
        }  
        :gefsh_rb2 {         
          label = /*t-gefsh121*/"ANSI Projection";  // "ANSI"
          key = "side1";
        }        
        // spacer_0; //1 { width = 6; }
      } // row
    } // row
  } // column

  :row {
    :column {
      :boxed_column {
        label = /*t-gefsh110*/"Front View"; // "Front view"
        :toggle {
           label = /*t-gefsh85*/"Draw as 2 Halves"; // "Doppeltlinie ber, unter Achse"
           key = "doubleline";
        }
        :toggle {
          label = /*t-gefsh86*/"Radius Reflection Line";  // "Lichtlinie beim Radius"
          key = "lightline";
        }
        :toggle {
          label = /*t-gefsh144*/"Check Contour";  // "check contour"
          key = "checkcontour";
        }
      }

      :boxed_radio_row {
        label = /*t-gefsh79*/"Adjust Centerline";  // "Am Ende Mittellinie verlngern"
        key = "centerline";
        :radio_button {
          label = /*t-gefsh80*/"Yes";  // "Ja"
          key = "centerline1";        
        }
        :radio_button {
          label = /*t-gefsh81*/"No";  // "Nein"
          key = "centerline0";
        }
        :gefsh_rb_question { key = "centerline2"; }
      } // boxed_radio_row
    } // column

    :boxed_column {
      label = /*t-gefsh111*/"Side and Sectional Views";   // "Seite Ansichten und Schnitten"
      :toggle {
         label = /*t-gefsh87*/"Complete View"; // "Vollstndige Darstellung"
         key = "fullsideview";
      }
      :toggle {
        label = /*t-gefsh86*/"Radius Reflection Line";  // "Lichtlinie beim Radius"
        key = "lightlineview";
      }
      :toggle {
        label = /*t-gefsh92*/"Sectional with Background";   // "Schnitt mit Hintergrund"
        key = "cutview";
      }
      :toggle {
        label = /*t-gefsh97*/"Always Update";   //  "Aktualisieren immer"
        key = "updateview";
      }
      :toggle {
        label = /*t-gefsh122*/"Hidden Lines";  //  "Verdeckte Linien"
        key = "hidden";
      }
      :toggle {
        label = /*t-gefsh127*/"Move Side View";  // "Move of Side View"
        key = "moveside";
      }
    }

    :boxed_column {
      label = /*t-gefsh128*/"View of";
      children_alignment = centered;
      :row {
        children_alignment = centered;
        :column {
          : gefsh_imgb {
            key = "interrupt";
            width = 15;        
          }
          :gefsh_img_text { label = /*t-gefsh129*/"Interrupt"; width = 14; }
        }
      }
    }
  }

  :spacer { height = 0.5; }

  :row {
    vertical_margin = none;
    horizontal_margin = none;
    fixed_height = true;
    fixed_width = false;
    children_alignement = bottom;
    :geniusdia {height=2;}
    :row {
       vertical_margin = none;
       fixed_width = true;
       children_fixed_width = true;
       alignement = left;

       okbutton;           // KEY accept
       :genretirement_button {
         key = "save";
         label = /*t-gefsh98*/"&Use as Default"; //"Speichern"
       }
       cancelbutton;       // KEY cancel
       helpbutton;         // KEY help
    }
  }
} //dialog


gefsh_edittext : dialog {
  label = /*t-gefsh93*/"Shaft Generator - Note";  // "Wellengenerator - Hinweis"
  initial_focus = "text_edit";  
  : edit_box {
      label = /*t-gefsh94*/"Text";  // "Text"
      key = "text_edit";
      edit_width = 40;
      edit_limit = 1024;
      allow_accept = true;
  }

  :spacer_1 { height = 0.5; }
  genius_okcancel_noh;
}


// Wellenende
gefshwe : dialog {
  label = /*t-gefsh140*/"Select a Shaft Break";  // "Wellenende"

  :spacer_1 { height = 0.5; }
  :column {
    :row {
      :gefsh_imgb_nm { 
        key = "zzlp";
        width = 12;
      }
      :gefsh_imgb_nm { 
        key = "fhlp";
        width = 12;
      }
      :gefsh_imgb_nm { 
        key = "halp";
        width = 12;
      }
    }
  }

  :spacer_1 { height = 0.5; }
  :row {
    vertical_margin = none;
    horizontal_margin = none;
    fixed_height = true;
    fixed_width = false;
    children_alignment = bottom;
    :geniusdia {height=2;}
    :row {
      vertical_margin = none;
      fixed_width = true;
      children_fixed_width = true;
      alignement = left;
      cancelbutton;
      :helpbutton { fixed_width = false; }
    }
  }
}


//---------------------------------------------------------gefsh_sel
// 
gefsh_sel : dialog {
  key = "title";

  children_alignment = centered;

  :row {
    :column {
	     : gefsh_imgsel_button { key = "0img"; }
	     : gefsh_imgsel_text   { key = "0txt"; }
    } //column

    :column {
	     : gefsh_imgsel_button { key = "1img"; }
	     : gefsh_imgsel_text   { key = "1txt"; }
    } //column

  } //row

  :spacer { height = 0.5; }

  genius_oneline;
} //dialog



//------------------------------------------------- hatch parameters
//
gefsh_hatchparam:column {

  children_fixed_width = true;
  children_alignment = left;
  

  :radio_row {
    fixed_width = true;

    :radio_button {         
      label = /*t-gefsh132*/"&Automatic";  //"automatisch"
      key = "autom";
      value = "1";
    }

    :radio_button {         
      label = /*t-gefsh133*/"&Manual";  //"manuell"
      key = "man";
      value = "0";
    }
  }

  :row {
    :spacer { width = 8; }

    :column {
      //fixed_width = true;
      //children_fixed_width = true;
      //children_alignment = left;

      :row {
        : row {
          fixed_width = true;
          width = 32;
          :edit_box {                
            label = /*t-gefsh117*/"A&ngle:";  //"Angle:"
            edit_width = 10;
            key = "angle";
          }

          :text {
            key = "ang_unit";
            width = 6;
            fixed_width = true;
          }   
        }
      }//row

      :row {
        fixed_width = true;
        width = 32;
        horizontal_margin = none;
        : text {
           key = "spaclabel";
           label = "&Spacing:";
        }
        :edit_box {                
          edit_width = 10;
          key = "spacing";
        }

        :text {
          key = "sp_unit";
          width = 6;
          fixed_width = true;
        }   
      }//row

      :row {
        : row {
          fixed_width = true;
          : text { 
            label = /*t-gefsh117*/"Pattern:"; 
            width = 10;
            fixed_width = true;
          }

          : text { 
            key = "pattern";
            width = 18;
            fixed_width = true;
          }
        }

        :button {
          key = "chgpattern";
          label = "...";
          width = 3;
        }   
      }//row
    }//column
  }//row

  :spacer { height = 0.3; }
}//column



//----------------------------------------------------gefsh_hatchpoint
// 
gefsh_hatchpoint : dialog {
  key = "title";

  :row {
    alignment = centered;
    :column {
	     : gefsh_imgsel_button { key = "img0"; }
	     : gefsh_imgsel_text   { key = "txt0"; }
    } //column

    :column {
	     : gefsh_imgsel_button { key = "img1"; }
	     : gefsh_imgsel_text   { key = "txt1"; }
    } //column

  } //row

  :spacer { height = 0.5; }

  :text {
    alignment = left;
    label = /*t-gefsh131*/"Hatch Parameters:";   //"Schraffuerparametern:"
  }

  gefsh_hatchparam;

  genius_oneline;
} //dialog




//----------------------------------------------------gefsh_hatchcut
// 
gefsh_hatchcut : dialog {
  key = "title";
  label = /*MSG*/"Section Line Style";

  :gefsh_imgsel_button { key = "img"; width = 60; alignment = centered; }

  :spacer { height = 0.5; }

  :text {
    alignment = left;
    label = /*t-gefsh131*/"Hatch Parameters:";   //"Schraffuerparametern:"
  }

  gefsh_hatchparam;

  genius_oneline;
} //dialog


//----------------------------------------------------gefsh_hatchpardcl
// 
gefsh_hatchpardcl : dialog {
  label = /*t-gefsh131*/"Hatch Parameters:";   //"Schraffuerparametern:"

  children_alignment = left;

  :spacer { height = 0.5; }

  gefsh_hatchparam;

  genius_oneline;
} //dialog
