
//    SEC.DCL      Version 1.0
//
//    Copyright (C) 1991-1996 by Autodesk, Inc.
//
//    Permission to use, copy, modify, and distribute this software
//    for any purpose and without fee is hereby granted, provided
//    that the above copyright notice appears in all copies and that
//    both that copyright notice and this permission notice appear in
//    all supporting documentation.
//
//    THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED
//    WARRANTY.  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR
//    PURPOSE AND OF MERCHANTABILITY ARE HEREBY DISCLAIMED.

// AutoCAD DCL (Dialog Control Language)
// Define AutoCAD dialogs

// This file contains the dialog boxes used for the 
// security file sec.arx

dcl_settings : default_dcl_settings { audit_level = 0;}

alertBox1 : dialog {
    key = /*MSG0*/"alert_dlg_name";
    spacer;
    text1;
    spacer_1;
    ok_only;
    spacer;
}

alertBox1andRestart1 : dialog {
    key = /*MSG0*/"alert_dlg_name";
    spacer;
    text1;
    restartText1;
    spacer_1;
    ok_only;
    spacer;
}

alertBox1andRestart2 : dialog {
    key = /*MSG0*/"alert_dlg_name";
    spacer;
    text1;
    restartText2;
    spacer_1;
    ok_only;
    spacer;
}

alertBox2 : dialog {
    key = /*MSG0*/"alert_dlg_name";
    spacer;
    text1;
    text2;
    spacer_1;
    ok_only;
    spacer;
}

alertBox2andRestart1 : dialog {
    key = /*MSG0*/"alert_dlg_name";
    spacer;
    text1;
    text2;
    restartText1;
    spacer_1;
    ok_only;
    spacer;
}

alertBox2andRestart2 : dialog {
    key = /*MSG0*/"alert_dlg_name";
    spacer;
    text1;
    text2;
    restartText2;
    spacer_1;
    ok_only;
    spacer;
}

text1 : text {
    key       = /*MSG0*/"alert_text_1";
    alignment = centered;
    width     = /*SEC_DCL_1*/55;
}

text2 : text {
    key       = /*MSG0*/"alert_text_2";
    alignment = centered;
    width     = /*SEC_DCL_2*/55;
}

restartText1 : column {
    spacer_1;
    : text {
        key       = /*MSG0*/"alert_text_3";
        alignment = centered;
        width     = /*SEC_DCL_3*/55;
    }
}

restartText2 : column {
    spacer_1;
    : text {
        key       = /*MSG0*/"alert_text_4";
        alignment = centered;
        width     = /*SEC_DCL_3*/55;
    }
    : text {
        key       = /*MSG0*/"alert_text_5";
        alignment = centered;
        width     = /*SEC_DCL_4*/55;
    }
}

sec_auth_button : retirement_button {
        label           = /*SEC_DCL_10*/"&Authorize";
        key             = /*MSG0*/"accept";
        is_default      = true;
}

sec_defer_button : retirement_button {
        label           = /*SEC_DCL_11*/"&Defer";
        key             = /*MSG0*/"defer";
}

sec_nodefer_button : retirement_button {
        label           = /*SEC_DCL_11*/"&Defer";
        key             = /*MSG0*/"nodefer";
        is_enabled      = false;
}

sec_cancel_button : retirement_button {
        label           = /*SEC_DCL_12*/"&Cancel";
        key             = /*MSG0*/"cancel";
        is_cancel       = true;
}

sec_errtile : text {
        label           = /*MSG0*/"";
        key             = /*MSG0*/"error";
        width           = 35;
        is_error_tile   = true;
}

sec_auth_defer_cancel : column {
    : row {
        fixed_width = true;
        alignment = centered;
        sec_auth_button;
        : spacer { width = 2; }
        sec_defer_button;
        : spacer { width = 2; }
        sec_cancel_button;
    }
}

sec_auth_nodefer_cancel : column {
    : row {
        fixed_width = true;
        alignment = centered;
        sec_auth_button;
        : spacer { width = 2; }
        sec_nodefer_button;
        : spacer { width = 2; }
        sec_cancel_button;
    }
}
sec_auth_defer_cancel_err : column {
    sec_auth_defer_cancel;
    sec_errtile;
}

sec_auth_nodefer_cancel_err : column {
    sec_auth_nodefer_cancel;
    sec_errtile;
}

authCodeBox1 : dialog {
    key = /*MSG0*/"dlg_name";
    spacer;
    : text {
         key         = /*MSG0*/"serial_key";
         alignment   = centered;
         width       = /*SEC_DCL_5*/40;
         fixed_width = true;
    }
    : boxed_column {
        label = /*MSG0*/"";
        : text {
             key         = /*MSG0*/"grace_text_key";
             justification = left;
             width       = /*SEC_DCL_6*/50;
        }
        spacer;
        spacer;
        : text {
             key         = /*MSG0*/"auth_info_key";
             justification = left;
             height      = 2;
             width       = /*SEC_DCL_18*/64;
        }
        spacer;
        : row {
            : text {
                key   = /*MSG0*/"auth_code_text_key";
                width = /*SEC_DCL_7*/42;
            }
            : edit_box {
                label        = /*MSG0*/"";
                key          = /*MSG0*/"auth_code_key";
                edit_width   = /*SEC_DCL_13*/18;
                edit_limit   = /*SEC_DCL_14*/18;
                allow_accept = true;
            }
        }
        spacer;
        spacer;
    }
    spacer;
    sec_auth_defer_cancel_err;
}

authCodeBox2 : dialog {
    key = /*MSG0*/"dlg_name";
    spacer;
    : text {
         key         = /*MSG0*/"serial_key";
         alignment   = centered;
         width       = /*SEC_DCL_5*/40;
         fixed_width = true;
    }
    spacer;
    : text {
         key         = /*MSG0*/"application_key";
         alignment   = centered;
         width       = /*SEC_DCL_5*/40;
         fixed_width = true;
    }
    : boxed_column {
        label = /*MSG0*/"";
        : text {
             key         = /*MSG0*/"grace_text_key";
             justification = left;
             width       = /*SEC_DCL_6*/50;
        }
        spacer;
        spacer;
        : text {
             key         = /*MSG0*/"auth_info_key";
             justification = left;
             height      = 2;
             width       = /*SEC_DCL_18*/64;
        }
        spacer;
        : row {
            : text {
                key   = /*MSG0*/"auth_code_text_key";
                width = /*SEC_DCL_7*/42;
            }
            : edit_box {
                label        = /*MSG0*/"";
                key          = /*MSG0*/"auth_code_key";
                edit_width   = /*SEC_DCL_13*/18;
                edit_limit   = /*SEC_DCL_14*/18;
                allow_accept = true;
            }
        }
        spacer;
        spacer;
    }
    spacer;
    sec_auth_defer_cancel_err;
}

authCodeBox3 : dialog {
    key = /*MSG0*/"dlg_name";
    spacer;
    : text {
         key         = /*MSG0*/"serial_key";
         alignment   = centered;
         width       = /*SEC_DCL_8*/40;
         fixed_width = true;
    }
    : boxed_column {
        label = /*MSG0*/"";
        : text {
             key         = /*MSG0*/"auth_info_key";
             justification = left;
             height      = 2;
             width       = /*SEC_DCL_18*/64;
        }
        spacer;
        : row {
            : text {
                key   = /*MSG0*/"auth_code_text_key";
                width = /*SEC_DCL_9*/42;
            }
            : edit_box {
                label        = /*MSG0*/"";
                key          = /*MSG0*/"auth_code_key";
                edit_width   = /*SEC_DCL_13*/18;
                edit_limit   = /*SEC_DCL_14*/18;
                allow_accept = true;
            }
        }
        spacer;
        spacer;
    }
    spacer;
    sec_auth_nodefer_cancel_err;
}

authCodeBox4 : dialog {
    key = /*MSG0*/"dlg_name";
    spacer;
    : text {
         key         = /*MSG0*/"serial_key";
         alignment   = centered;
         width       = /*SEC_DCL_8*/40;
         fixed_width = true;
    }
    spacer;
    : text {
         key         = /*MSG0*/"application_key";
         alignment   = centered;
         width       = /*SEC_DCL_5*/40;
         fixed_width = true;
    }
    : boxed_column {
        label = /*MSG0*/"";
        : text {
             key         = /*MSG0*/"auth_info_key";
             justification = left;
             height      = 2;
             width       = /*SEC_DCL_18*/64;
        }
        spacer;
        : row {
            : text {
                key   = /*MSG0*/"auth_code_text_key";
                width = /*SEC_DCL_9*/42;
            }
            : edit_box {
                label        = /*MSG0*/"";
                key          = /*MSG0*/"auth_code_key";
                edit_width   = /*SEC_DCL_13*/18;
                edit_limit   = /*SEC_DCL_14*/18;
                allow_accept = true;
            }
        }
        spacer;
        spacer;
    }
    spacer;
    sec_auth_nodefer_cancel_err;
}

trialBox : dialog {
    key = /*MSG0*/"dlg_name";
    spacer_1;
    : text {
         key         = /*MSG0*/"grace_text_key";
         justification = left;
         width       = 64;
        }
    spacer_1;
    ok_only;
}

trialDoneBox : dialog {
    key = /*MSG0*/"dlg_name";
    spacer_1;
    : text {
         key         = /*MSG0*/"expiration_key";
         justification = left;
         width       = 64;
        }
    spacer_1;
    : text {
         key         = /*MSG0*/"contact_key";
         justification = left;
         width       = 64;
        }
    spacer_1;
    ok_only;
}
