;;;*-*DAT genzvi.ll
;;;*-*ENV Lisp
;;;*-*TXT Ausfuehrende GENIUS-Funktionen der Zeichnungsverwaltung
;;;*-*HES
;;;*-*REV 25.02.00 Eckardt: GENZVITIT, genzvititle removed; geninloc in genzvi12to13
;;;                         replaced with (genyesno)
;;;*-*REV 28.01.00 Krimmer: genpmscet was moved to gencvt.lsp - changed genlade
;;;*-*REV 18.01.00 Lippold: removed genzviupdate, GENZVIUPD, GENZVIDEL, genzvidelete,
;;;                         genzvimovecmd, genzvirotcmd, genzvirot3d.
;;;*-*REV 11.06.99 Eckardt: genzvi12to13 adapted to new type of result list of
;;;                         genentbox
;;;*-*REV 22.04.99 Eckardt: load of genppo1 commented out
;;;*-*REV 12.04.99 Eckardt: general update stuff removed; registering
;;;                         for callbacks of redefined commands removed
;;;*-*REV 01.02.99 MF: genzvicrm moved to genbas2.ll
;;;*-*REV 01.02.99 MF: gendre -> amcopyrm (CopyRotateMove)
;;;       genzvidre -> genzvicrm
;;;*-*REV 30.01.99 MF: "GENSCALE" -> "SCALE"
;;;*-*REV 20.01.99 BaumS: Removed functions genzvierase, genzvimirrcmd, 
;;;       genzviarray, genzvinew, genzviopen, genzviend, genzvisave,
;;;       genzviqsave, genzvisaveas, GENZVIsaveasr12, genzviquit, 
;;;       genzviwblock, genzviplot, genzviblock, genzvicopys, genzvicopym,
;;;       genzvicopy, genzviexplode, genzvifileopen
;;;*-*REV 20.01.99 BaumS: Removed genzviexport
;;;*-*REV 07.12.98 Hummel: added argument to error functions
;;;*-*REV 28.10.98 MF: replaced gencfgget "gen@drawing@genplotscale"
;;;       with gengetdwgsetting("SCALE")                                  
;;;*-*REV 07.05.98 Schlosser: 14_0/14_1 merged
;;;*-*REV 25.02.98 Eckardt: special help callback for desktop version
;;;                         in the general update dialog 
;;;*-*REV 12.02 98 Eckardt: bugfix in general update (catalog restore)
;;;*-*REV 04.02.98 Eckardt: ge3cataupd built in into gengeneralupd 
;;;*-*REV 12.12.97 Eckardt: behavior of fits list update adjusted in
;;;                         general update
;;;*-*REV 27.11.97 Eckardt: switch off local update toggle if empty selection
;;;                         in general update
;;;*-*REV 26.11.97 Eckardt: check selected entity for SDF AND TIT object,
;;;                         when picking a genius border in genupdborder 
;;;*-*REV 26.11.97 Eckardt: New behavior for forced update of parts lists
;;;                         in the general update dialog
;;;*-*REV 21.11.97 Eckardt: we wait for RETURN on commandline, when highlighting
;;;                         borders/selection sets in gengeneralupd
;;;*-*REV 07.10.97 Eckardt:  better method to to pass users own locoption
;;;                          parameters to the result (plus results of
;;;                          geninsert) of genzviinsert
;;;*-*REV 07.10.97 Eckardt: genzviinsert adapted for the new geninsert
;;;                         interface
;;;*-*REV 10.07.97 Eckardt: filename corrected genzviexport
;;;*-*REV 09.07.97 Eckardt: handle new button "No Update" in gengeneralupd
;;;*-*REV 27.06.97 Eckardt: bugfix for fits list update
;;;*-*REV 24.06.97 Eckardt: set "newlist" lisp variable for
;;;                         update parts list in general update
;;;*-*REV 24.06.97 Eckardt: general update dialog changed for force
;;;                update partlist and fitslist even if nothing
;;;                to update is detected
;;;*-*REV 18.06.97 Eckardt: built in fitslist support in general update
;;;*-*REV 12.06.97 Eckardt: comment header corrected
;;;*-*REV 29.01.97 Eckardt: gengeneralupd changed; ZVI-functions for
;;;                         redefined commands: END, QUIT, SAVE...
;;;                         chaged for handling new result of general callback
;;;*-*REV 28.05.97 Schwingl: changed file header, added END after HEE
;;;*-*REV 28.05.97 Eckardt: qsave does not us own callback (genzviqsave)
;;;*-*REV 26.05.97 Eckardt: general update dialog implemented 
;;;*-*REV 25.05.97 Eckardt: function header corrected
;;;*-*REV 22.04.97 Eckardt genzviqsave new
;;;*-*REV 24.03.97 Eckardt genzviarray new
;;;*-*REV 25.10.96 Eckardt: genzvimirror3d new
;;;*-*REV 16.09.96 Eckardt: genzvirot3d new
;;;*-*REV 26.08.96 BaumS: entget -> genentget
;;;*-*REV 06.08.96 BaumS: genzvierase: bugfix implied sset
;;;*-*REV 13.06.96 Eckardt: "highlight" vor move, mirror und rot disabled
;;;*-*REV 08.03.96 Eckardt: global variable gendbmod used in genzviasksv
;;;*-*REV 16.02.96 Eckardt: genzviexport new
;;;*-*REV 04.02.96 Eckardt: genzvimirrcmd new
;;;*-*REV 29.01.96 Eckardt: changes in genzvzvifileopen: special workaround,
;;;                         because AUTODESK has changed the interface
;;;*-*REV 17.12.95 Pudor: entget with appid changed to genentget
;;;*-*REV 29.09.95 Eckardt: Schlagwort ZV eingefuehrt
;;;*-*REV 12.09.95 Hummel: 1. Changed prompt for scale from fixed string
;;;                           to genmsg call in genzvi12to13 (!!)
;;;                        2. Scale can also be passed in genzvo12to13 as
;;;                           argument, no prompt in this case (Bosch wish).
;;;*-*REV 11.09.95 Hummel: Fixed bug in genzvi12to13:
;;;                        Block name can be also specified in 
;;;                        small letters now
;;;*-*REV 28.06.95 Lippold: changed usage of implied ss
;;;*-*REV 19.05.95 Eckardt: neu genzvifileopen
;;;*-*REV 18.05.95 Eckardt: neu genzvidre
;;;*-*REV 18.05.95 Baum: neu genzviblock
;;;*-*REV 16.05.95 Eckardt: Kommentar gepflegt
;;;*-*REV 16.05.95 Eckardt: Aufruf von genrotcmd, genmovecmd
;;;                         auf locoption geaendert
;;;*-*REV 11.05.95 Lippold: Faster detection of group creation
;;;*-*REV 10.05.95 Eckardt: genzvimovecmd und genzvirotcmd neu
;;;*-*REV 09.05.95 Baum: (gensv)/(genun) in genzviwblock entfernt
;;;*-*REV 08.05.95 Herbst: ssget changed into genssget
;;;*-*REV 08.05.95 Baum: genzviinsert angepasst
;;;*-*REV 10.04.95 Baum: Aederung in genzviwblock
;;;*-*REV 07.04.95 Baum: Anederung in genzviinsert
;;;*-*REV 04.04.95 Lippold: genzvicopy(/s/m) neu/erweitert 
;;;                         fuer COPY-Multiple
;;;*-*REV 30.03.95 Baum: genzvierase, genzviexplode neu
;;;*-*REV 28.03.95 Lippold: genzvicopy neu
;;;*-*REV 20.03.95 Baum: genzvierase entfernt
;;;*-*REV 06.03.95 Hummel: added fit update calls
;;;*-*REV 20.02.95 Eckardt: Kommentar gepflegt
;;;*-*REV 01.02.95 Baum: genzvierase neu
;;;*-*REV 04.11.94 Eckardt: Kommentare ergaenzt
;;;*-*HEE
;;;*-*END
;;;([{
;(genlade "gen" "genppo1" genpponew)

;------------------------------------ updaten der tag-wert-flag-liste
;;;*-*STA
;;;*-*IMP PRIVATE
;;;*-*FUK genzviappold(plnew, plold)
;;;*-*SHO ~ZV~, ergaenzen der tag-wert-flag-liste
;;;*-*TXT Items aus plold, die nicht in plnew sind
;;;       werden zu plnew ergaenzt fall ihr Wert in
;;;       pold nicht NIL war.
;;;*-*PAR -> plnew (LIST): zu ergaenzende Liste im PLIST-FORMAT
;;;       -> plold (LIST): Liste im PLIST-FORMAT, die ggf.
;;;                       fuer plnew zu ergaenzende Items ent-
;;;                       haelt.
;;;*-*RES (LIST): ergaenzte Liste in PLIST-Format
;;;*-*END
(defun genzviappold (plnew plold / sub )
  (foreach sub plold
    (if (and (not (assoc (car sub) plnew)))
      (setq plnew (append plnew (list sub)))
    )
  )
  plnew  
)
;;;--------------------------------------------- genzviupdunchg
;;;*-*STA
;;;*-*IMP PRIVATE
;;;*-*SHO ~ZV~, String-Liste der "ungchangeable" erstellen
;;;*-*FUK genzviupdunchg(oldunchg, inplist)
;;;*-*TXT Die Funktion aktualisiert die Liste der nicht ver-
;;;       aenderbaren Attribute anhand der angegebenen Liste
;;;       im PLIST Format. Neue Tags werden entsprechend der in
;;;       inplist gesetzten Flags dazugefuegt. Es werden Tags aus
;;;       der Liste entfernt, wenn deren Kenner in inplist gefunden
;;;       werden und das Flag auf "changeable" gesetzt ist.
;;;       plist in die Attribute des Schriftkopfblockes ein
;;;*-*PAR -> oldunchg (List): Liste von Strings, die die Tags
;;;                           der nicht aenderbaren Attribute
;;;                           enthaelt
;;;       -> inplist (List): Liste im PLIST-Format
;;;                          ((<tag> <value> <flag>)(..)  ..)
;;;*-*REV 18.08.95 Eckardt neu
;;;*-*GLO - locf_st
;;;       - locs_st
;;;       - locf_st_pfad
;;;       - loc_taglis
;;;*-*FUN - genalexchg
;;;       - gencdrlese
;;;*-*RES (LIST): neue String-Liste der "unchangeable"
;;;*-*END
(defun genzviupdunchg( oldunchg inplist / item unchg newunchg)
  ; remove "changeable" from the "unchangeable" list
  (foreach unchg oldunchg
    (if (setq item (gencdrlese unchg inplist))
      (if (= 0 (cadr item))
        (setq newunchg (append newunchg (list unchg)))
      )
      (setq newunchg (append newunchg (list unchg)))
    )
  )
  ; add new unchangeable from inplist to "unchangeable" list
  (foreach item inplist
    (if (= 0 (cadr (cdr item)))
      (if (not (member (car item) newunchg))
        (setq newunchg (append newunchg (list (car item))))
      )
    )
  )
  newunchg
)

;------------------------------------------------------genzvi12to13
;;;*-*STA
;;;*-*IMP GENERAL
;;;*-*FUK genzvi12to13 ( asli )
;;;*-*SHO ~ZV~, Converting into GENIUS ~block~/border title object V13
;;;*-*TXT This function is intended to create a Genius13 drawing border/title
;;;       block object out of a Genius12 title block and border block.
;;;       The function scans the drawing for insertion of blocks with given
;;;       names. 
;;;       If there are none, nil will be returned. If there is only one of
;;;       each, genzvi12to13 creates a Genius13 title border block/object by
;;;       prompting the user for affirmation of the scale found by the
;;;       insertion scale factor of the blocks (command line) and trying to
;;;       get the corners of the scale definition area. The function also
;;;       checks whether the title block is located inside the area of
;;;       the border. if not, the function is prompting the user for
;;;       affirmation for creation of title border block/object from the
;;;       given blocks.
;;;       No rescale is done, no setting of views, limites, base scale etc.
;;;       If no names are given or more title blocks / border blocks are found,
;;;       the user is prompted to select the appropriate inserts. Afterwards
;;;       the function proceeds as if only one of each has been found.
;;;       If an object could be made, plist is returned. If not, nil is
;;;       returned.
;;;       The scale may either be predetermined by specifying a corres-
;;;       ponding argument or will be taken from the block insertion
;;;       factors.
;;;       CAUTION: In the first case the calling programme is respon-
;;;                sible to supply the correct value. In order to prevent
;;;                accidents, the user will be prompted nevertheless
;;;                if the insertion factor of the chosen block does not
;;;                match the given scale. This value will be used for 
;;;                scaling the symbols inside, so a wrong value not
;;;                suitable for the given border would lead to messing
;;;                up scaling!
;;;       In the latter case the user will be prompted for
;;;       affirmation anyway.
;;;
;;;*-*PAR -> asli (ASSOC-List)
;;;         > BORDER assoc (STR): name of border block searching for in the
;;;                               the drawing
;;;         > TITLE assoc (STR): name of title block searching for in the
;;;                              the drawing
;;;         (>) SCALE assoc (STR): scale to be used. If not specified or 
;;;                                nil, the scale will be determined by 
;;;                                the block insertion factor and the user
;;;                                will be prompted for affirmation/change.
;;;                                If specified, the user will only be 
;;;                                involved if the given scale is not the
;;;                                same as the insertion factor of the
;;;                                border block.
;;;         if missing Border OR missing title, function proceeds as no
;;;         parameter is given.
;;;
;;;*-*RES (LIST,NIL): Complete list of data of GENIUS block/border title
;;;                    object in PLIST format if object has been created.
;;;                    NIL otherwise.
;;;
;;;
;;;          < GENIUSID item (STR): string represents the handle of
;;;                                 the changed title block/border object.
;;;
;;;          <  SCALE item (STR): Scale of the title block/border object.
;;;          <  BORDER item (STR): name of border block
;;;          <  TITLE item (STR): name of title block.
;;;          <  HRA item (STR): handle of border block
;;;          <  HTIT item (STR): handle of title block
;;;
;;;         (<) ZVID item (STR): The unique handle (not an AutoCAD handle)
;;;                              of the drawing manager.
;;;
;;;         (<) ZV item (STR): Name of ZV
;;;         (<) EED item (LIST): EED of ZV. The format is AutoCAD EED list
;;;         (<) PINS item (POINT): Insertion point of the border block
;;;                                (3D point in wcs)
;;;          <  (Tags of attributes) items (STR): Values of all attributes
;;;                                               in title block
;;;          <  (Tag) item (STR): any item given in PLIST and not used/chanched
;;;                         
;;;*-*REV 11.06.99 Eckardt: adapted to new type of result list of genentbox
;;;*-*REV 12.09.95 Hummel: 1. Changed prompt for scale from fixed string
;;;                           to genmsg call (!!)
;;;                        2. Scale can also be passed as
;;;                           argument, no prompt in this case (Bosch wish).
;;;*-*REV 11.09.95 Hummel: Block name can be also specified in small 
;;;                        letters now
;;;*-*REV 08.09.95 Eckardt: added all results to comment
;;;*-*REV 27.08.95 Eckardt: implemented
;;;*-*GLO
;;;*-*FUN - genssget
;;;       - gensel
;;;       - genssadd
;;;       - gencdrlese
;;;       - geninloc
;;;       - genmsg
;;;       - genprompt
;;;       - genobjedit
;;;       - genobjcollect
;;;       - genzviinquire
;;;       - gentitgetdata
;;;       - genpmscreal
;;;       - genpmscunru
;;;       - genpmscset
;;;       - genal-entipkt
;;;       - genbasoli
;;;*-*END
(defun genzvi12to13( asli / title border scale next entli ent enb unchg
 ss ssobj obj pins ll ru dum result anzra anztit boxt boxb )

  (gen1sv)
  (setq border (gencdrlese "BORDER" asli)
    title (gencdrlese "TITLE" asli)
    scale (gencdrlese "SCALE" asli)
    anzra 0
    anztit 0
    next 0
  )
  (if (and border title)
    (progn
      ; scan for given blocks
      (setq ss
        (genssget
          (list
            (list "STR" "_X")
            (list "FILTER" 
              (list
                (cons -4 "<and")
                (cons 0 "INSERT")
                (cons -4 "<or")
                (cons 2 border)
                (cons 2 title)
                (cons -4 "or>")
                (cons -4 "and>")
              )
            )
          ) ; list
        ) ; genssget
      ) ; setq
      (if (and ss (/= 0 (setq dum (sslength ss))))
        (while (< next dum)
          (setq entli (genentget (ssname ss next)))
;;;Hummel: Inserted strcase here
;;;Eckardt: removed strcase for V15
;          (if (= (cdr (assoc 2 entli)) (strcase title))
          (if (= (cdr (assoc 2 entli)) title)
            (setq ent (cdr (assoc -1 entli))
              anztit (+ 1 anztit)
            ) 
          )
;;;Hummel: Inserted strcase here
;;;Eckardt: removed strcase for V15
;          (if (= (cdr (assoc 2 entli)) (strcase border))
          (if (= (cdr (assoc 2 entli)) border)
            (setq enb (cdr (assoc -1 entli))
              anzra (+ 1 anzra)
            ) 
          )
          (setq next (1+ next))
        ) ; while
      ) ; if
    ) ; progn
  ) ; if border and title
  (if (or (not title) (not border)
          (and title border ent enb (or (> anzra 1) (> anztit 1))))
    (progn
      (if (or (> anzra 1) (= 0 anzra ))
        (setq enb (car
          (gensel
            (list
              (list "PROMPT" (genmsg "genzvo" 14))
              (list "FLAG" "e")
              (list "EMPTY" 2)
              (list "OBJ1" '("INSERT"))
            )
          )) ; gensel
        ) ; steq
      ) ; if
      (if (or (> anztit 1) (= 0 anztit))
        (setq ent (car
          (gensel
            (list
              (list "PROMPT" (genmsg "genzvo" 15))
              (list "FLAG" "e")
              (list "EMPTY" 2)
              (list "OBJ1" '("INSERT"))
            )
          )) ; gensel
        ) ; setq
      ) ; if
    ) ; progn
  )
  (if (and ent enb)
    (progn
      (setq boxb (genentbox (genbasoli "ELE" enb "TRANS" 1))
         boxt (genentbox (genbasoli "ELE" ent "TRANS" 1))
      )
      (if (and (car boxb) (car boxt))
        (progn
          ; check whether title block is located in border area
          (setq boxb (nth 1 boxb) boxt (nth 1 boxt))
          (if (or (< (caar boxt) (caar boxb))
                  (< (cadar boxt) (cadar boxb))
                  (> (caadr boxt) (caadr boxb))
                  (> (cadadr boxt) (cadadr boxb)))
            (progn
              (genprompt (genmsg "genzvo" 16))
              (if (not (genyesno (genmsg "genzvo" 17) nil))
                (setq enb nil ent nil)
              ) ; if gennein
            ) ; progn
          ) ; if in box
        ) ; progn
      ) ; if good results from genentbox
    ) ; progn
  ) ; if ent and entb

  ; now creating title border block/object
  (if (and ent enb)
    (progn
;;;Krimmer 28.01.00: This function is now registered in C...
;      (genlade "gen" "genpm" genpmscunru)
      (setq ssobj (genssadd ent))
      (genssadd ssobj enb)
;;;Hummel: scale can also be given.
      (if
        (if scale
;;;if given scale does not match 
          (/= (genpmscreal scale)
            (cdr (assoc 41 (genentget enb)))
          );/= 
          T
        )     
;;;in cases of prompts always take insertion facor of blocks
;;;(probably more save)
        (setq 
          scale (cdr (assoc 41 (genentget enb)))
          scale (cadr (genpmscunru scale))
          scale
          (geninloc
            (LIST
              (LIST "PR" (strcat "\n" (genmsg "gentitle" 101)))
              (LIST "ST" scale)
              (list "D" scale)
            )
          );geninloc
        );setq
      );if
      (setq
        border (cdr (assoc 2 (genentget enb)))
        title (cdr (assoc 2 (genentget ent)))
        pins (cdr (assoc 10 (genentget enb)))
        unchg (list "GEN-TITLE-SCA" "GEN-TITLE-SIZ")
        xdata
        (genbasoli
          "SCALE" scale
          "BORDER" border
          "TITLE"  title
          "UNCHG" unchg
        ) ; genbasoli
        obj
        (genobjcollect
          (list
            (list "SS" ssobj)
            (list "REACTOR" nil)
            (list "SORT" (list "TIT"))
            (list "OWNER" "GEN")
            (list "XAPPL" "GENTITLE")
            (list "XVER" "13")
            (list "XART" T)
            (list "XDATA" xdata)
          )
        ) ; genobjcollect
      ) ; setq
      (genobjedit
        (list
          (list "OBJ" obj)
          (list "XAPPL" "GENTITLE")
          (list "XVER"  "13")
          (list "XFLAG" 2)
          (list "XART" T)
          (list "XDATA"
            (list
              (list "HRA" enb)
              (list "HTIT" ent)
              (list "GENIUSID" obj)
            )
          )
        )
      ) ; genobjedit
      (setq scale (genpmscreal scale)
        ll (genal-entipkt enb "LL" scale nil)            
        ru (genal-entipkt enb "RU" scale nil)
      )
      (if ll
        (setq ll (list (+ (car ll) (car pins)) (+ (cadr ll) (cadr pins))))
        (setq ll (car boxb)) 
      )
      (if ru
        (setq ru (list (+ (car ru) (car pins)) (+ (cadr ru) (cadr pins))))
        (setq ru (cadr boxb)) 
      )
;Krimmer 28.01.00: genpmscset was moved to gencvt.lsp
      (genlade "gen" "gencvt" genpmscset)
      (genpmscset
        (list
          (list "ENAME" enb)
          (list "PLOTFACTOR" scale)
          (list "CORNERS" ll ru)
          (list "LIMITS" 0)
          (list "VIEWS" 0)
          (list "BASIC" nil)
        ) ;; list
      )
      (setq dum (gentitgetdata obj)
        dum (gencdrlese "XDATA" dum)
        result
        (genzviinquire (list (list "GENIUSID" (gencdrlese "GENIUSID" dum))))
      )

    ) ; progn
  )
  (gen1un)
  result
)

;----------------------------------------------------genzviplotregfunc
;;;*-*STA
;;;*-*IMP GENERAL
;;;*-*FUK genzviplotregfunc (locoption)
;;;*-*SHO ~STARTDOWN~ ~DWG~ Registers callback function for plot command
;;;*-*TXT genzviplotregfunc lets you register dynamically
;;;       a callback function to be called when the user launches
;;;       a PLOT command. The callback will be called BEFORE any plotting
;;;       is done.
;;;*-*PAR -> locoption (ASSO):
;;;          > FUNC assoc (LIST):
;;;                       LISP function that shall be called.
;;;                       The function MUST have the following
;;;                       interface:
;;;                       Parameter is a locoption list with following
;;;                       items:
;;;                       CMD (STR) = "PLOT"
;;;
;;;                       Result (SYM) must be 
;;;*-*RES                 = T: continue command execution
;;;                         nil: stop command execution
;;;*-*REV 06.05.95 Hummel: Checked if function already registered
;;;*-*REV 01.05.95 Hummel: new
;;;*-*GLO - genzviplotcblis
;;;*-*FUN - gencopt
;;;*-*END
(defun genzviplotregfunc (locoption / func)
  (if 
    (not 
      (member
        (setq func (gencopt "FUNC"))
        genzviplotcblis
      )
    )
    (setq genzviplotcblis (cons func genzviplotcblis))
  );if
);defun

(genlade "gen" "genzvidf" nil)

; )]}

;;;-----BEGIN-SIGNATURE-----
;;; 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEE+U0vr78xSzq0vXnmuWytEw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMjAwNjE1MDAwMDAwWhcNMjEwODEyMjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBAMt3bX7WxfbqKZpcgiX4jvJBSg6MCucqh4aDRHA8
;;; Hny4Fc2vKP+Xgn3mY4qtHoeNZ/j4d669d5+guDfOpD7jZX/JyR81wLE22GwswGLN
;;; M6n3N6Vudo0PcdCNXRxccGdPmJMIiEZNp84RjWN7Gy0JfgChxNiNEWS+Dezr5cYK
;;; B7UlGjGivbUdK6/HP0JlO3t3QxXYERASgPWj6YXmHGdvYHPBNit1MJTLRUj7uXyk
;;; bWzpaQEnXdey73yxg+FV2us0BicMIChoDXdTY/uAWbhkThET8GffQd08miZDNWMv
;;; IUIfFEkKjGZX6VkfkK/ShlVtjcdYlknpatvAtkFuYnQm6mECAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBACiY
;;; IcU6uh5Lz5MGiUDT3w+daDMfYW44/ak/wMK1SgkL+iHzsgHaY8plDqZ4oaxT3U45
;;; /L5BdedSZWIvR738xpjcJNKZVILKTMg3mzl0bjO/t91dj5TFlTSpCbQgBh+jbBpJ
;;; R0il59VeZ9LQTvK/2E41TK89VHXZa+8MaTrsVOyTsBuAnNdYdzzExmAqp1BZdirH
;;; JH35aOAnZz3nkcGS4knKOAc7EX8pLkhAl4UDoS2V+2MKw5IXpYO3tU5TwM7y8uGZ
;;; gj/XpMlzWXtVQvOVpwgmT0XCymP5174BFyTP1SLNhlUWUfwFCypOY6tRHd6U9uqc
;;; BATajxbYoRpvjWl9Nu8xggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQT5TS+vvzFLOrS9eea5bK0TANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQAf1qn2Zcf3JBz+XYbh8FlDr9w18Mg63kOc
;;; ovenhv2l5SpLnXafKqpR2/55HNg2rwqurozfPXUKJHKJ8d7ao1dW2doj2zcTxxwq
;;; UUlk7HmjxtU9s9o30R2DHGXrbKZG4uWeffZUAZ22utn94EtiaIMZ8vX8Dmy2Szq+
;;; A8lykk6RRH3v3vjKXxjaASugIysSvilW06T3i0PWejcKry+hZTSWpDgQ1ktoH0aS
;;; Z3xiw/mdWmnMZdCr7yjYeZaFcHazprhuiuuIBTm81VOMAwHiMSlWFSljncKlad4V
;;; F2T+47VEfGv8uYJb6Y6GwRI0sNKv892u2IDbjmke6WRQQ/UYTG27
;;; -----END-SIGNATURE-----