;///////////////////////////////////////////////////////////////////////////
;/////////////////////////// T R A N S L . L S P ////////////////////////////
;///////////////////////////////////////////////////////////////////////////
;// 
;// Translating of drawings accordingly to configuration settings. 
;// The drawings are saved in a subdirectory created.
;// 
;//*-*REV 20.01.99 BaumS: getdefaults: UPRESERVE: use genset/getdwgsetting
;///////////////////////////////////////////////////////////////////////////


;== START OF SCRIPT ROUTINE SECTION =======================================

;///////////////////////////////////////////////////////////////////////////
;// 
;// Called before the script opens the first drawing. 
;// Informs about the configuration settings for genius configuration 
;// values of 
;// Asks user whether script shall go on with this settings. 
;// Aborts the script, if not.
;// 
(defun transl-start( / 
;//    ===========
                     defaults file
                     projectpath projectname usermsgpath
                     on off attprompt upreserve control warn ignorecase
                     textnorm files nodeffile srclang dstlang protfile
                   )
  (setq defaults      (getdefaults))
  (setq 
        on            (genmsg "genbasc" 129)
        off           (genmsg "genbasc" 130)

        ; The following three values are just for information 
        ; where the message files are searched
        ; They are no batchcall arguments, but inderectly used
        projectpath   (genmsg "genbasc" 149) 

        projectname   (genmsg "genbasc" 149) 

        usermsgpath   (if (gencfgget "gen@tools@trans@userpath")
                          (gencfgget "gen@tools@trans@userpath")
                          (genworkingdir)
                      )

        ; The following 11 values can directly be set for batch
        ; call - to change them for the script, edit function
        ; "(getdefaults)" at the end of the file
        ; do not change the values here, because this is only
        ; a user information function and not called while 
        ; translating the drawings

        ; The following 8 values can be found in configuration
        ; If they are not defined there, defaults exist
        ; But they can be overwritten temporarly in function
        ; "(getdefaults)"
        attprompt     (cadr (assoc "ATTPROMPT"  defaults))
        upreserve     (genmsg "genbasc" 149) 
        control       (cadr (assoc "CONTROL"    defaults))
        warn          (cadr (assoc "WARN"       defaults))
        ignorecase    (cadr (assoc "IGNORECASE" defaults))
        textnorm      (cadr (assoc "TEXTNORM"   defaults))
        srclang       (genmsg "genbasc" 149) 
        dstlang       (cadr (assoc "DSTLANG"    defaults))

        ; The following 3 values are just settings for batchcall
        ; they can not be set in configuration
        protfile      (cadr (assoc "PROTFILE"   defaults))
        files         ""
        files         (if(cadr (assoc "FILES"      defaults))
                         (foreach file (cadr (assoc "FILES" defaults))
                            (setq files (strcat files file " "))
                         )
                         "nil"
                      )
        nodeffile     (cadr (assoc "NODEFFILE"  defaults))
  )

   (if  (gendcl_yesno 
            nil
            T
            (strcat 
               (genmsg "genbasc" 120)
               "\n"
               (strcat "\n" (genmsg "genbasc" 126) projectpath)
               (strcat "\n" (genmsg "genbasc" 127) projectname)
               (strcat "\n" (genmsg "genbasc" 128) usermsgpath)
               (strcat "\n" (genmsg "genbasc" 131) (if attprompt on off))
               (strcat "\n" (genmsg "genbasc" 132) upreserve)
               (strcat "\n" (genmsg "genbasc" 133) (if control on off))
               (strcat "\n" (genmsg "genbasc" 134) (if warn on off))
               (strcat "\n" (genmsg "genbasc" 135) (if ignorecase on off))
               (strcat "\n" (genmsg "genbasc" 136) (if textnorm on off))
               (strcat "\n" (genmsg "genbasc" 137) (if nodeffile on off))
               (strcat "\n" (genmsg "genbasc" 138) files  )
               (strcat "\n" (genmsg "genbasc" 139) srclang    )
               (strcat "\n" (genmsg "genbasc" 140) dstlang    )
               (strcat "\n" (genmsg "genbasc" 141) protfile   )
               "\n"
               "\n"
               (strcat (genmsg "genbasc" 121)
                       dstlang
                       (genmsg "genbasc" 122)
               )
               "\n"
               "\n"
               (genmsg "genbasc" 145)
               "\n"
               (genmsg "genbasc" 146)
               "\n"
               "\n"
               (genmsg "genbasc" 123)
            );Strcat
        );Gendcl_yesno
      T
      (progn
         ; This WAY a running script quits!
         (command "_.SCRIPT") 
         (command)
         (quit)                   ; To quit even for just ONE drawing
      )
   );If
   (princ)
);Defun -Start


;///////////////////////////////////////////////////////////////////////////
;// 
;// translate drawing, using the settings made or found in "(getdefaults)"
;// 
(defun transl ( / defaults subdir newfile)
;//    ======
  (gentra (setq defaults (getdefaults)))
  (setq subdir (cadr (assoc "DSTLANG" defaults)))
  (if (genosmd (setq subdir (strcat(getvar "dwgprefix") subdir))) (progn
    (setq newfile (strcat subdir(genosbsl)(getvar "dwgname") ))        
    (genosdel newfile)
    (command "_.save" newfile)
  )(progn
     (princ (strcat (genmsg "genbasc" 147)
                    subdir
                    (genmsg "genbasc" 148)
     )       )

     (command "_.SCRIPT") 
     (command)
  ));If Progn
   (princ)
);Defun Main routine


;== START OF SUBROUTINE SECTION ============================================

;///////////////////////////////////////////////////////////////////////////
;// 
;// Gets default settings for batch routine
;// 
;// 
;
;
;(gentra (list
;              (list "ATTPROMPT"  T)
;              (list "UPRESERVE"  T)
;              (list "CONTROL"    nil)
;              (list "WARN"       T)
;              (list "IGNORECASE" T)
;              (list "TEXTNORM"  T)
;              (list "FILES"     "c:\\work\\mein.mld" "c:\\firma.mld")
;              (list "NODEFFILE" "")
;              (list "SRCLANG"   "gb")
;              (list "DSTLANG"   "d")
;              (list "PROTFILE"  "@temppath/gentrans.prt")
;        )
;)

;
;//*-*REV 20.01.99 BaumS: UPRESERVE: use genset/getdwgsetting
;
(defun getdefaults ( / 
;//    ===========
;                     defaults attprompt upreserve control warn 
;                     ignorecase textnorm srclang dstlang temppath
                   )
  (setq 
        attprompt     (if(gencfgset "gen@tools@trans@attprompts"
                            (gencfgget "gen@tools@trans@attprompts"))
                         (gencfgget "gen@tools@trans@attprompts")
                         T
                      ) 
        ignorecase    (if (gencfgset "gen@tools@trans@ignorecase"
                              (gencfgget "gen@tools@trans@ignorecase"))
                          (gencfgget "gen@tools@trans@ignorecase")
                          T
                      )
        upreserve    (if (gensetdwgsetting "upreserve"
                              (gengetdwgsetting "upreserve"))
                          (gengetdwgsetting "upreserve")
                          T
                      )
        textnorm      (if (gencfgset "gen@tools@trans@textnorm"
                              (gencfgget "gen@tools@trans@textnorm"))
                          (gencfgget "gen@tools@trans@textnorm")
                          T
                      )
        srclang       (if (gencfgget "gen@tools@trans@sourcelang")
                          (gencfgget "gen@tools@trans@sourcelang")
                          (if (and (gencfgget "gen@system@altlang") 
                                   (not (= 
                                   (strlen (gencfgget "gen@system@altlang"))
                                   ))
                                           
                              )
                              (gencfgget "gen@system@altlang")
                              (gencfgget "gen@system@language")
                          )
                      )
        dstlang       (if (and (gencfgget "gen@system@altlang") 
                               (not (= 
                               (strlen (gencfgget "gen@system@altlang"))
                               ))
                                       
                          )
                          (gencfgget "gen@system@altlang")
                          (gencfgget "gen@system@language")
                      )
        temppath      (gencfgget "gen@paths@temppath")
  )
  (setq defaults (list 
                   (list "ATTPROMPT"  attprompt)
                   ; UPRESERVE is drawing dependent 
                   ; To set a common behaviour for all files, enter T or 
                   ; nil instead of 'upreserve'
                   (list "UPRESERVE"  upreserve)
                   (list "CONTROL"    nil)
                   (list "WARN"       T)
                   (list "IGNORECASE" ignorecase)
                   (list "TEXTNORM"   textnorm)
                   ; SRCLANG is drawing dependent 
                   ; To set a common sourcelanguage for all files, enter
                   ; a language short cut instead of 'srclang', 
                   ; e.g. "GB" or "I"
                   (list "SRCLANG"    srclang)
                   (list "DSTLANG"    dstlang)
                   ; As PROJECTPATH and PROJECTNAME are drawing dependent
                   ; you can ensure that some files are used, by 
                   ; changing the following ASSOC
                   ;(list "FILES"  (list "c:\\work\\my.mld c:\\comp.mld"))
                   (list "FILES"    nil)
                   (list "NODEFFILE" nil)
                   (list "PROTFILE"  (strcat temppath "gentrans.prt"))
  )              );Setq
);Defun Getdefaults


;;;-----BEGIN-SIGNATURE-----
;;; 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEE+U0vr78xSzq0vXnmuWytEw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMjAwNjE1MDAwMDAwWhcNMjEwODEyMjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBAMt3bX7WxfbqKZpcgiX4jvJBSg6MCucqh4aDRHA8
;;; Hny4Fc2vKP+Xgn3mY4qtHoeNZ/j4d669d5+guDfOpD7jZX/JyR81wLE22GwswGLN
;;; M6n3N6Vudo0PcdCNXRxccGdPmJMIiEZNp84RjWN7Gy0JfgChxNiNEWS+Dezr5cYK
;;; B7UlGjGivbUdK6/HP0JlO3t3QxXYERASgPWj6YXmHGdvYHPBNit1MJTLRUj7uXyk
;;; bWzpaQEnXdey73yxg+FV2us0BicMIChoDXdTY/uAWbhkThET8GffQd08miZDNWMv
;;; IUIfFEkKjGZX6VkfkK/ShlVtjcdYlknpatvAtkFuYnQm6mECAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBACiY
;;; IcU6uh5Lz5MGiUDT3w+daDMfYW44/ak/wMK1SgkL+iHzsgHaY8plDqZ4oaxT3U45
;;; /L5BdedSZWIvR738xpjcJNKZVILKTMg3mzl0bjO/t91dj5TFlTSpCbQgBh+jbBpJ
;;; R0il59VeZ9LQTvK/2E41TK89VHXZa+8MaTrsVOyTsBuAnNdYdzzExmAqp1BZdirH
;;; JH35aOAnZz3nkcGS4knKOAc7EX8pLkhAl4UDoS2V+2MKw5IXpYO3tU5TwM7y8uGZ
;;; gj/XpMlzWXtVQvOVpwgmT0XCymP5174BFyTP1SLNhlUWUfwFCypOY6tRHd6U9uqc
;;; BATajxbYoRpvjWl9Nu8xggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQT5TS+vvzFLOrS9eea5bK0TANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQBcq2ftVH0BLl4jY0X4ecVPZmyweCjnVJBM
;;; NpCkiNYHPlmsMXeDwfikT3yLlZxGNaZDYQV4eqfdQotACg98aJTau3x5401s4t+U
;;; kwxmxlQULcv8+/OSY6N1up8Pi56jFEA2IH0eujMt/B39lkoXlQ5Nsmh5K7BrXNa/
;;; iB1UauwHb7Caa9y+DGJQK+QbFDfuY3tVefetuAWYsY3yIXyFB2lXYolOQgO2VPvP
;;; bkn8Yp80y9miiQa5BS3/UJrSCPQtzYrL4CHKXqpRuc6MfZRAkwGno2Q6WLVaJjrU
;;; BPLxbnnx4RosCMAYQZeCDsWMsXL2a/UEbqbjFZkJ+5jcrGMab+4P
;;; -----END-SIGNATURE-----