;programm to exchange titleblocks
;;;*-*REV 28.02.00 Eckardt: new used title block name stored in xdata 
;;;                (using genobjedit)
;;;*-*REV 26.06.97 bau: bugfix for swap id
;;;*-*REV 20.04.97 bau: bugfix for last call
;;;*-*REV 09.02.96 bau: bugfix
;;;*-*REV 10.06.98 Schlosser: load genalblock before it is used

;this function will be called only once when the script starts
(defun titleexg-first ( /
 BLONEW EXIST 
)
 ;startfunction to set the variables
 (gen1sv)
 (setq blonew (gencfgget "gen@user@blonew"))
 (prompt (genmsg "genscr" 81))
 ;read new blockname from the configuration
 (if (not blonew)(progn
   (gencfgnew "gen@user@blonew" '(("TYPE""GenCfgString")("dwg" nil)("cfg" nil))
   (setq blonew "")
 )))
 (setq exist nil)
 ;new block must exist
 (while (not exist)
   (setq blonew(getfiled (genmsg "genscr" 74) "" "dwg" 2))
   (setq blonew (strcat(gendwgohne blonew) ".dwg"))
   (setq exist(findfile blonew))
   (if (not exist)(prompt (strcat (genmsg "genscr" 63) blonew (genmsg "genscr" 64))))
 )
 ;store blocknames in configuration
 (gencfgset "gen@user@blonew" blonew)
 ;now exchange block
 (titleexg)
 (gen1un)
)

;this is the function for each dwg from the script
(defun titleexg ( / 
 ATTLIS BLONEW BLONEWCFG ENTLIS LIS OBJ OBJLIS OK OLDENAME XDATA
)
 (gen1sv)
 ;read from configuration
 ;why is it made so complicated ?
 ;because the title is included inside an object
 (setq
   blonewcfg (gencfgget "gen@user@blonew")
   ;blonew is the pure blockname (no path, no .dwg)
   blonew (gendwgohne(gendwgfilter blonewcfg))
 )
 ;makes sense only if the old block is there
  ;make selectionsset
  (setq objlis (genobjssgetx '(("SORT" ("TIT"))))  )
  ;read attributes
  (foreach obj objlis
    ;data of object
    (setq xdata(gencdrlese"xdata"(gentitgetdata obj)))
    (print xdata)
    ;when the first dwg is touched again entget=nil
    (if(and
      xdata
      (setq oldename(gencdrlese "htit" xdata))
      (setq oldename(handent oldename))
      (setq xdata (genlistexchg "htit" xdata oldename))
      (setq bename(gencdrlese "hra" xdata))
      (setq bename(handent bename))
      (setq xdata (genlistexchg "hra" xdata bename))
      (genentget oldename)
      )
    (progn
    ;change entity list
    (setq entlis (entget oldename '("*")))
    ;reenter the attributes
    (setq attlis (genal-al oldename))
    (command "_.ucs" "_w")
    (setvar "attdia" 0)(setvar "attreq" 0)
    ;insert the block with the old data from the block
    ;genalblock also activates the translator
    ;this is the genius function to exchange attributes
    (genlade "gen" "genbas7" genalblock)
    (setq ok (genalblock (list
       (list "BLOCK" blonewcfg)
       (list "INS" (cdr(assoc 10 entlis)))
       (list "SIZE"
         (cdr(assoc 41 entlis))
         (cdr(assoc 42 entlis))
         (cdr(assoc 43 entlis))
       )
       (list "ANGR" (cdr(assoc 50 entlis)))
       (list "TRANS" 2)
       (list "CHECK" 1)
    )))
    (if ok (progn
      (setq xdata (genlistexchg "TITLE" xdata blonewcfg))
      (genobjedit (list 
                    (list "OBJ" obj)
                    (list "XAPPL" "GENTITLE")
                    (list "XVER"  "13")
                    (list "XDATA" xdata)
                    (list "XFLAG" 1)
                    (list "XART" T)
                  )
      )
      ;attribute 
      ;set attributes of new title
      (genalexchg(list(list"ENAME"(entlast))(list"ATTRI"attlis)))
      ;the new titleblock gets the ename from the old
      (genswapid oldename (entlast) 1 1)
      ;the old one has now the new ename
      (entdel (entlast))
      (command "_.save" "")
    ));if ok
  ));if progn
 );foreach
 (gen1un)
)




;;;-----BEGIN-SIGNATURE-----
;;; 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEE+U0vr78xSzq0vXnmuWytEw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMjAwNjE1MDAwMDAwWhcNMjEwODEyMjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBAMt3bX7WxfbqKZpcgiX4jvJBSg6MCucqh4aDRHA8
;;; Hny4Fc2vKP+Xgn3mY4qtHoeNZ/j4d669d5+guDfOpD7jZX/JyR81wLE22GwswGLN
;;; M6n3N6Vudo0PcdCNXRxccGdPmJMIiEZNp84RjWN7Gy0JfgChxNiNEWS+Dezr5cYK
;;; B7UlGjGivbUdK6/HP0JlO3t3QxXYERASgPWj6YXmHGdvYHPBNit1MJTLRUj7uXyk
;;; bWzpaQEnXdey73yxg+FV2us0BicMIChoDXdTY/uAWbhkThET8GffQd08miZDNWMv
;;; IUIfFEkKjGZX6VkfkK/ShlVtjcdYlknpatvAtkFuYnQm6mECAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBACiY
;;; IcU6uh5Lz5MGiUDT3w+daDMfYW44/ak/wMK1SgkL+iHzsgHaY8plDqZ4oaxT3U45
;;; /L5BdedSZWIvR738xpjcJNKZVILKTMg3mzl0bjO/t91dj5TFlTSpCbQgBh+jbBpJ
;;; R0il59VeZ9LQTvK/2E41TK89VHXZa+8MaTrsVOyTsBuAnNdYdzzExmAqp1BZdirH
;;; JH35aOAnZz3nkcGS4knKOAc7EX8pLkhAl4UDoS2V+2MKw5IXpYO3tU5TwM7y8uGZ
;;; gj/XpMlzWXtVQvOVpwgmT0XCymP5174BFyTP1SLNhlUWUfwFCypOY6tRHd6U9uqc
;;; BATajxbYoRpvjWl9Nu8xggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQT5TS+vvzFLOrS9eea5bK0TANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQBE1X/RgR0NWDfkQgpzXczq4qfeKCG41Ab0
;;; PXYqHOipd4ZHN0TPMt/lkl06VBRcKRLW+2dKnsukNqeMG6NbM5WUgm1QqUl3YlXA
;;; y9quU2u8OXDoC2CAUHDLExr8/cCflzUJysiVpqlWQMqYxKiLgQ/j2vNsapag4yZN
;;; LIQ6C16otCxt7D5EW2VxTlxxZ5IqNehoDQpmq+z5jHrzmmTU4eXP3zwSjw1NnZH1
;;; 3aLA3gvlN8KY+gzyvaKr+G/bDkI+O9+3poMU412cGA4/sYgfVTCXp5jSOIrlSmHy
;;; 2pLGJvzOGxC0SIKf2zRiJMg5NYo9rG4LTsW5dI5A8WP2LlN7ieNE
;;; -----END-SIGNATURE-----