;///////////////////////////////////////////////////////////////////////////
;/////////////////////////// D U M M Y . L S P /////////////////////////////
;///////////////////////////////////////////////////////////////////////////
;// 
;// The script generator writes a script for a couple of selected drawings.
;// The routines, which work on this drawings are defined in a lisp file.
;// This routines defined in this lisp file have to be in accordance with 
;// the following description.
;//
;// The routines called by the generated script have to correspond to the
;// name of the lisp file. Let's suppose that the filename is "dummy.lsp"
;// (as it is for this file) The following routines are callable routines:
;// (dummy-start)
;// (dummy-first)
;// (dummy)          
;// (dummy-last)
;// None of these routines can have arguments. Other routines are not 
;// called by the generated script. Of course you can define subroutines,
;// which you call in the main routines.
;//
;// Only the routine (dummy) has to be defined. If it is the only one 
;// defined, it is called for each drawing chosen.
;// If the routine (dummy-first) is defined, it is called for the 
;// first drawing in script. For this drawing (dummy) is not called.
;// If the routine (dummy-last) is defined, it is called for the 
;// last drawing in script. For this drawing (dummy) is not called.
;// If the routine (dummy-start) is defined, it is called before the first
;// chosen drawing is opened by the script.
;// 
;// The generated script does never contain any command sequences to save 
;// the chosen drawings. If you want your drawings to be saved, you have 
;// to call the save command in your routines:
;//   (command "_.save" "")
;// 
;// If you want to rename the file and use it for your own routines, 
;// replace "dummy" by "newname" all over the file.
;// 
;///////////////////////////////////////////////////////////////////////////


;== START OF SCRIPT ROUTINE SECTION =======================================

;///////////////////////////////////////////////////////////////////////////
;// 
;// Called before the script opens the first drawing. 
;// Has not to be defined.
;// - You can make sure that caller wants drawings to be changed and abort
;//   if not.
;// - You can change genius configuration settings - this of course makes
;//   no sense for configuration values saved in drawing.
;// - You can question some information you need, for example name of a
;//   protocolfile. (To remeber the information, load lisp persistent or 
;//   save value in genius configuration)
;//  
(defun dummy-start( / answer)
;//    ===========
  (setq answer (dialoginput 
                  "dummy-start" 
                  "Return \"ABORT\" and Script will abort."
  )             );Setq Dialoginput
  (if (= answer "ABORT") (progn
      ; This WAY a running script quits!
      (command "_.SCRIPT") 
      (command)
  ));If Progn
  (princ)
);Defun -Start


;///////////////////////////////////////////////////////////////////////////
;// 
;// Called for the first drawing.
;// Has not to be defined.
;// If not defined (dummy) is called for the first drawing.
;// If defined and you want changes in the first drawing to be saved you 
;// have to do it here.
;// - You can change genius configuration settings - this of course makes
;//   no sense for configuration values saved in drawing.
;// 
;// 
(defun dummy-first( / answer)
;//    ===========
  (setq answer (dialoginput "dummy-first" "FIRST"))
  (princ answer)
  (command "PAUSE" 3000)
  ;(command "_.save" "")
  (princ)
);Defun -First


;///////////////////////////////////////////////////////////////////////////
;// 
;// Called for every drawing.
;// Has to be defined.
;// Not called for first drawing, if (dummy-first) is defined. 
;// Not called for last drawing, if (dummy-last) is defined. 
;// If want changes in the drawings to be saved you have to do it here.
;// 
(defun dummy ( / answer)
;//    =====
  (setq answer (dialoginput "dummy MAIN" "MAIN"))
  (princ answer)
  (command "PAUSE" 3000)
  ;(command "_.save" "")
  (princ)
);Defun Main routine


;///////////////////////////////////////////////////////////////////////////
;// 
;// Called for the last drawing.
;// Has not to be defined.
;// If not defined (dummy) is called for the last drawing.
;// If defined and you want changes in the last drawing to be saved you 
;// have to do it here.
;// - You can display a finished message or the protocoll file
;// - You can quit AutoCAD after this last drawing.
;// 
(defun dummy-last( / answer)
;//    ==========
  (setq answer (dialoginput 
                  "dummy-last" 
                  "Return \"QUIT\" - AutoCAD will go down"
  )             );Setq Dialoginput
  ;(command "_.save" "")
  (if (= answer "QUIT") (progn
      ; Ensures that the "quit" command asks for "loose changes"
      (command "_.POINT" (getvar "LIMMIN"))
      (command "_.ERASE" (entlast)  "")
      ; End Genius and AutoCAD
      (command "_.QUIT" "_Y") 
      (command)
  ));If Progn
  (princ)
);Defun -Last


;== START OF SUBROUTINE SECTION ============================================

;///////////////////////////////////////////////////////////////////////////
;// 
;// Gets text input with genius dialog functions.
;// During a running script the (get...) function do not work. But dialogs
;// can be started. If one needs input from a script, one can use this
;// little routine.
;// If the "cancel" button of the dialog is pressed, the script aborts.
;// 
;// 
(defun dialoginput (head valold)
;//    ===========
    (gendclload "gen" "gendcl")
    (gendclnew "gendcl" "input")
    (set_tile "kopf"  head)
    (set_tile "text" valold)
    (mode_tile "text" 2)
    (gendclaction "gendcl" "input" "text" "(setq value $value)")
    (gendclaction "gendcl" "input" "accept" "(gendcldone)")
    (gendclaction "gendcl" "input" "cancel" "(setq value nil)(gendcldone)")
    (gendcleck)
    (gendclstart)
    (if (not value) (getpoint ""))
value
);Defun Dialoginput

;;;-----BEGIN-SIGNATURE-----
;;; 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEE+U0vr78xSzq0vXnmuWytEw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMjAwNjE1MDAwMDAwWhcNMjEwODEyMjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBAMt3bX7WxfbqKZpcgiX4jvJBSg6MCucqh4aDRHA8
;;; Hny4Fc2vKP+Xgn3mY4qtHoeNZ/j4d669d5+guDfOpD7jZX/JyR81wLE22GwswGLN
;;; M6n3N6Vudo0PcdCNXRxccGdPmJMIiEZNp84RjWN7Gy0JfgChxNiNEWS+Dezr5cYK
;;; B7UlGjGivbUdK6/HP0JlO3t3QxXYERASgPWj6YXmHGdvYHPBNit1MJTLRUj7uXyk
;;; bWzpaQEnXdey73yxg+FV2us0BicMIChoDXdTY/uAWbhkThET8GffQd08miZDNWMv
;;; IUIfFEkKjGZX6VkfkK/ShlVtjcdYlknpatvAtkFuYnQm6mECAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBACiY
;;; IcU6uh5Lz5MGiUDT3w+daDMfYW44/ak/wMK1SgkL+iHzsgHaY8plDqZ4oaxT3U45
;;; /L5BdedSZWIvR738xpjcJNKZVILKTMg3mzl0bjO/t91dj5TFlTSpCbQgBh+jbBpJ
;;; R0il59VeZ9LQTvK/2E41TK89VHXZa+8MaTrsVOyTsBuAnNdYdzzExmAqp1BZdirH
;;; JH35aOAnZz3nkcGS4knKOAc7EX8pLkhAl4UDoS2V+2MKw5IXpYO3tU5TwM7y8uGZ
;;; gj/XpMlzWXtVQvOVpwgmT0XCymP5174BFyTP1SLNhlUWUfwFCypOY6tRHd6U9uqc
;;; BATajxbYoRpvjWl9Nu8xggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQT5TS+vvzFLOrS9eea5bK0TANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQCrITZSQLA7q0bnDjx/ZBNfZUrFqCEHWiA9
;;; GRn3eAuN+kVVDBMy6ixFCcPuOdPBcqisW0IAqif0fNm4pWG99pOeSDL4M9lLiJqo
;;; 9BbLW4Nvs24MRSQ2ghhKI85Q5erm1+XSNRZXHKZsljIsJvQHI421pD/8x8HS2PNP
;;; 4KTLaKXzJOfR9N+S2f2VqB7O6AfmW/lv65XVh53YWeuCHMLV9U199wbLqck62cr1
;;; KXd30GdssBDY95Pqws8Yd32vwgIq0QKb9BqMk/4qWiCHFRmpOysZRMY7RPVwDmbW
;;; bCxIGzMs/JyOo6mKqTQHGjnbRFjlUxbKYa2NXXKMvqV1oM6XLHqJ
;;; -----END-SIGNATURE-----