; Next available MSG number is  6 
; MODULE_ID SHEET_LSP_
;;;---------------------------------------------------------------------------;
;;;
;;;   SHEET.LSP   Version 1.0
;;;
;;;   Copyright (C) 1992, 1993 by Autodesk, Inc.
;;;  
;;;   Permission to use, copy, modify, and distribute this software and its
;;;   documentation for any purpose and without fee is hereby granted.  
;;;
;;;   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. 
;;;   ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR PURPOSE AND OF 
;;;   MERCHANTABILITY ARE HEREBY DISCLAIMED.
;;;   
;;;---------------------------------------------------------------------------;
;;;   SHEET
;;;
;;;   This program creates paper space VIEWPORT entities corresponding to
;;;   a specified VPORT configuration.   It uses the MVIEW command and the
;;;   RESTORE subcommand to convert a specified VPORT configuration into
;;;   paper space VIEWPORT entities which are placed in a space from
;;;   (0,0) to (x,y), where x and y are the specified extents of the drawing.
;;;
;;;---------------------------------------------------------------------------;


;;;---------------------------------------------------------------------------;
;;; Internal error handling.
;;;---------------------------------------------------------------------------;
(defun sheet_error(s)
  (if (/= s ;|MSG1|;"Function cancelled")
    (princ (strcat ;|MSG2|;"\nSHEET Error: " s))
  )
  (setq *error* olderr)
  (princ)
)


;;;---------------------------------------------------------------------------;
;;;  SHEET
;;;---------------------------------------------------------------------------;
(defun C:SHEET (/ olderr echo tilemode vport extents)

  (setq olderr *error*                ; Redefine error handler.
        *error* sheet_error)

  ;; Save cmdecho and tilemode sysvars.
  (setq 
    echo (getvar ;|MSG0|;"cmdecho")
    tilemode (getvar ;|MSG0|;"tilemode")
  )
   
  ;; Disable command echo 
  (setvar ;|MSG0|;"cmdecho" 0)

  ;; Switch to tilemode on, if necessary 
  (if (= 0 tilemode)
     (setvar ;|MSG0|;"tilemode" 1)
  )

  ;; Get vport configuration to restore 
  (setq vport 
        (getstring ;|MSG3|;"\nViewport configuration to be mapped <*ACTIVE>: "))
  (if (= vport "?")
    (progn
      ;; List VPORT configurations 
      (command ;|MSG0|;"_VPORTS" "_?" ;|MSG0|;"*") 
      (setq vport (getstring ;|MSG4|;"\nViewport configuration to be mapped <*ACTIVE>: "))
    )
  )

  ;; Handle default case
  (if (= vport ;|MSG0|;"")
    (setq vport ;|MSG0|;"*ACTIVE")
  )

  ;; Prompt for size of drawing 
  (setq extents (getpoint ;|MSG5|;"Drawing extents (x,y): "))

  ;; Switch to tilemode off
  (if (= 1 (getvar ;|MSG0|;"tilemode"))(setvar ;|MSG0|;"tilemode" 0))

  ;; Switch to paperspace, if necessary 
  (if (/= 1 (getvar ;|MSG0|;"cvport"))(command ;|MSG0|;"_pspace"))

  ;; Start to restore a VPORT configuration as VIEWPORT entities
  (command ;|MSG0|;"_MVIEW" ;|MSG0|;"_Restore" vport ;|MSG0|;"0,0" extents)
 
  ;; Restore cmdecho sysvar
  (setvar ;|MSG0|;"cmdecho" echo)

  (setq *error* olderr)               ; Reset the error function.
  (princ)
)

;;;-----BEGIN-SIGNATURE-----
;;; 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEE+U0vr78xSzq0vXnmuWytEw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMjAwNjE1MDAwMDAwWhcNMjEwODEyMjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBAMt3bX7WxfbqKZpcgiX4jvJBSg6MCucqh4aDRHA8
;;; Hny4Fc2vKP+Xgn3mY4qtHoeNZ/j4d669d5+guDfOpD7jZX/JyR81wLE22GwswGLN
;;; M6n3N6Vudo0PcdCNXRxccGdPmJMIiEZNp84RjWN7Gy0JfgChxNiNEWS+Dezr5cYK
;;; B7UlGjGivbUdK6/HP0JlO3t3QxXYERASgPWj6YXmHGdvYHPBNit1MJTLRUj7uXyk
;;; bWzpaQEnXdey73yxg+FV2us0BicMIChoDXdTY/uAWbhkThET8GffQd08miZDNWMv
;;; IUIfFEkKjGZX6VkfkK/ShlVtjcdYlknpatvAtkFuYnQm6mECAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBACiY
;;; IcU6uh5Lz5MGiUDT3w+daDMfYW44/ak/wMK1SgkL+iHzsgHaY8plDqZ4oaxT3U45
;;; /L5BdedSZWIvR738xpjcJNKZVILKTMg3mzl0bjO/t91dj5TFlTSpCbQgBh+jbBpJ
;;; R0il59VeZ9LQTvK/2E41TK89VHXZa+8MaTrsVOyTsBuAnNdYdzzExmAqp1BZdirH
;;; JH35aOAnZz3nkcGS4knKOAc7EX8pLkhAl4UDoS2V+2MKw5IXpYO3tU5TwM7y8uGZ
;;; gj/XpMlzWXtVQvOVpwgmT0XCymP5174BFyTP1SLNhlUWUfwFCypOY6tRHd6U9uqc
;;; BATajxbYoRpvjWl9Nu8xggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQT5TS+vvzFLOrS9eea5bK0TANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQCWUCabLBwgqK9bzpnvDipxLWYtn045BOGV
;;; cD7elMola23r94LS60Dz1fTAfI1XELTnEtediwqVD69t2N0fmywsoe3OdRcQBNWe
;;; 8oy5iqzR1XVyN1tchfm36IrUuJxxKZM0SbL71tuxs0DoGm3O/Gfe874/nmDFFBI/
;;; 71/I81A8HMlPzSSOt7pwWvFyH1f0IqBUe5BeiRsR0N63DnJLG6FmNR7Yi+wYEWzN
;;; AFaJT68wSHZTNe6ODYOZanBOmfrC4DLSi3NFNkDr41S/ph5WCQUoPfokVtoQy5a3
;;; RIGlOB9AHbLOkFMXvEn9s1seeKgfgLecGaTyNh21S4WjMBxL2nSo
;;; -----END-SIGNATURE-----