; Next available MSG number is  6 
; MODULE_ID OSHIFT_LSP_
;;;---------------------------------------------------------------------------;
;;;
;;;   OSHIFT.LSP   Version 1.0
;;;
;;;   Copyright (C) 1992, 1993 by Autodesk, Inc.
;;;  
;;;   Permission to use, copy, modify, and distribute this software and its
;;;   documentation for any purpose and without fee is hereby granted.  
;;;
;;;   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. 
;;;   ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR PURPOSE AND OF 
;;;   MERCHANTABILITY ARE HEREBY DISCLAIMED.
;;;   
;;;---------------------------------------------------------------------------;
;;;   OSHIFT
;;;
;;;   This program shifts paper space entities so that they are all 
;;;   in positive paper space.  This tool is useful for making 
;;;   the paper space of a drawing compatible with IGES drawing space which
;;;   defines the lower left corner as the origin (0,0).
;;;
;;;---------------------------------------------------------------------------;


;;;---------------------------------------------------------------------------;
;;; Internal error handling.
;;;---------------------------------------------------------------------------;
(defun oshift_error(s)
  (if (/= s ;|MSG1|;"Function cancelled")
    (princ (strcat ;|MSG2|;"\nOSHIFT Error: " s))
  )
  (setq *error* olderr)
  (princ)
)


;;;---------------------------------------------------------------------------;
;;;  OSHIFT
;;;---------------------------------------------------------------------------;
(defun C:OSHIFT (/ echo emin emax )
  (setq olderr *error*                ; Redefine error handler.
        *error* oshift_error)

  ;; Switch to tilemode off, if necessary 
  (setq echo (getvar ;|MSG0|;"cmdecho"))      ; save CMDECHO sysvar
  (setvar ;|MSG0|;"cmdecho" 0)

  ;; Switch to tilemode off, if necessary 
  (if (= 1 (getvar ;|MSG0|;"tilemode"))(setvar ;|MSG0|;"tilemode" 0))

  ;; Switch to paperspace, if necessary 
  (if (/= 1 (getvar ;|MSG0|;"cvport"))(command ;|MSG0|;"_pspace"))

  ;; Get min and max extents
  (setq emin (getvar ;|MSG0|;"extmin")
        emax (getvar ;|MSG0|;"extmax")
  ) 

  ;; Shift to origin, if necessary (i.e. emin < (0,0))
  (if (or (< (car emin) 0.0) (< (cadr emin) 0.0)) 
    (progn
      ;; Shift to the origin
      (command ;|MSG0|;"_MOVE" 
               ;|MSG0|;"_W" 
               emin emax 
               ;|MSG0|;""
               emin (quote (0.0 0.0)))
      (command ;|MSG0|;"_ZOOM" ;|MSG0|;"_EXTENT")
      (princ ;|MSG3|;"Paper space entities shifted from ")
      (princ emin)
      (princ ;|MSG4|;" to (0.0 0.0).")
    )
    (princ ;|MSG5|;"No shifting necessary")
  )

  (setvar ;|MSG0|;"cmdecho" echo)     ; restore CMDECHO sysvar
  (setq *error* olderr)               ; Reset the error function.
  (princ)
)

;;;-----BEGIN-SIGNATURE-----
;;; 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEE+U0vr78xSzq0vXnmuWytEw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMjAwNjE1MDAwMDAwWhcNMjEwODEyMjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBAMt3bX7WxfbqKZpcgiX4jvJBSg6MCucqh4aDRHA8
;;; Hny4Fc2vKP+Xgn3mY4qtHoeNZ/j4d669d5+guDfOpD7jZX/JyR81wLE22GwswGLN
;;; M6n3N6Vudo0PcdCNXRxccGdPmJMIiEZNp84RjWN7Gy0JfgChxNiNEWS+Dezr5cYK
;;; B7UlGjGivbUdK6/HP0JlO3t3QxXYERASgPWj6YXmHGdvYHPBNit1MJTLRUj7uXyk
;;; bWzpaQEnXdey73yxg+FV2us0BicMIChoDXdTY/uAWbhkThET8GffQd08miZDNWMv
;;; IUIfFEkKjGZX6VkfkK/ShlVtjcdYlknpatvAtkFuYnQm6mECAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBACiY
;;; IcU6uh5Lz5MGiUDT3w+daDMfYW44/ak/wMK1SgkL+iHzsgHaY8plDqZ4oaxT3U45
;;; /L5BdedSZWIvR738xpjcJNKZVILKTMg3mzl0bjO/t91dj5TFlTSpCbQgBh+jbBpJ
;;; R0il59VeZ9LQTvK/2E41TK89VHXZa+8MaTrsVOyTsBuAnNdYdzzExmAqp1BZdirH
;;; JH35aOAnZz3nkcGS4knKOAc7EX8pLkhAl4UDoS2V+2MKw5IXpYO3tU5TwM7y8uGZ
;;; gj/XpMlzWXtVQvOVpwgmT0XCymP5174BFyTP1SLNhlUWUfwFCypOY6tRHd6U9uqc
;;; BATajxbYoRpvjWl9Nu8xggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQT5TS+vvzFLOrS9eea5bK0TANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQBoXP1IEjHe/J2hKnpeeuFOW09PuM+nqLTm
;;; 1ZuHiMQgFww73pS2klgST6fJSaDMTsJdfK4HQLhPuwnrC8eb0yhNXx6WJG3G3WT0
;;; LybF0Sil+ECwizoGSZoy5wQGjO0RJ9sTSoyGeZJW22zEnJt6vw5zgThN7lMb2RXO
;;; 2AYOYC6h24HBWdDBneosHelXkrxUw+In9+3JDbxVum7ffS2prS3dOkVBrAcZhoZT
;;; 10McCnaAnRCXqOWCtTDlYCx31rRNjUVvOh9bnjgxoiSkkCx+QX3MnRJSziFDze84
;;; Vs6wTyKYC/8avtW96yAMQdtgldCnlXd1NLqa6marOOIC8atz0Wr2
;;; -----END-SIGNATURE-----