; Next available MSG number is  7 
; MODULE_ID LISTDE_LSP_
;;;---------------------------------------------------------------------------;
;;;
;;;   LISTDE.LSP   Version 1.0
;;;
;;;   Copyright (C) 1992, 1993 by Autodesk, Inc.
;;;  
;;;   Permission to use, copy, modify, and distribute this software and its
;;;   documentation for any purpose and without fee is hereby granted.  
;;;
;;;   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. 
;;;   ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR PURPOSE AND OF 
;;;   MERCHANTABILITY ARE HEREBY DISCLAIMED.
;;;   
;;;---------------------------------------------------------------------------;
;;;   LISTDE
;;;
;;;   This program lists the IGES DE data for an AutoCAD entity created by
;;;   the AutoCAD IGES Translator.
;;;
;;;---------------------------------------------------------------------------;


;;;---------------------------------------------------------------------------;
;;; Internal error handling.
;;;---------------------------------------------------------------------------;

(defun listdeerr(s)
  (if (/= s ;|MSG1|;"Function cancelled")
    (princ (strcat ;|MSG2|;"\nError: " s))
  )
  (setq *error* olderr) 
  (if ename (redraw ename 4))         ; de-highlight entity
  (princ)
)

 
;;;---------------------------------------------------------------------------;
;;;  LISTDE
;;;---------------------------------------------------------------------------;
(defun C:LISTDE (/ olderr esel ename elist xd_list app_list app_sub_list xd_code
                   xd_data)

  ; Redefine error handler.
  (setq 
     olderr *error* 
     *error* listdeerr)
 
  (if (not (tblsearch ;|MSG0|;"APPID" ;|MSG0|;"ACADIGES"))
     (progn
        (princ ;|MSG3|;"\nNo AutoCAD IGES extended entity data found.\n")
        (princ ;|MSG4|;"Retranslate IGES data with the XED option.")
     ) 
     (progn         
       ;; Have user select the entity to be examined 
       (while (not (setq esel (entsel ;|MSG5|;"Select entity to be checked: "))))
            
       ;; Get user input. 
       (setq ename (car esel))        ; Get entity info
       (redraw ename 3)               ; ...highlight entity  
       (setq elist (entget ename (list ;|MSG0|;"ACADIGES"))) 
     
       ;; Get XED from the list.
       (if (setq xd_list (assoc -3 elist))
         (princ (cdr (assoc 1000 (cdadr xd_list))))
         ;; otherwise
         (princ ;|MSG6|;"ACADIGES extended entity data was not found on the selected entity.")
       )  

;;     (redraw ename 4)               ; De-highlight entity.

     )
  )

  (setq *error* olderr)               ; Reset the error function.
  (princ)                             ; Quiet exit.
)

;;;-----BEGIN-SIGNATURE-----
;;; 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEE+U0vr78xSzq0vXnmuWytEw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMjAwNjE1MDAwMDAwWhcNMjEwODEyMjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBAMt3bX7WxfbqKZpcgiX4jvJBSg6MCucqh4aDRHA8
;;; Hny4Fc2vKP+Xgn3mY4qtHoeNZ/j4d669d5+guDfOpD7jZX/JyR81wLE22GwswGLN
;;; M6n3N6Vudo0PcdCNXRxccGdPmJMIiEZNp84RjWN7Gy0JfgChxNiNEWS+Dezr5cYK
;;; B7UlGjGivbUdK6/HP0JlO3t3QxXYERASgPWj6YXmHGdvYHPBNit1MJTLRUj7uXyk
;;; bWzpaQEnXdey73yxg+FV2us0BicMIChoDXdTY/uAWbhkThET8GffQd08miZDNWMv
;;; IUIfFEkKjGZX6VkfkK/ShlVtjcdYlknpatvAtkFuYnQm6mECAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBACiY
;;; IcU6uh5Lz5MGiUDT3w+daDMfYW44/ak/wMK1SgkL+iHzsgHaY8plDqZ4oaxT3U45
;;; /L5BdedSZWIvR738xpjcJNKZVILKTMg3mzl0bjO/t91dj5TFlTSpCbQgBh+jbBpJ
;;; R0il59VeZ9LQTvK/2E41TK89VHXZa+8MaTrsVOyTsBuAnNdYdzzExmAqp1BZdirH
;;; JH35aOAnZz3nkcGS4knKOAc7EX8pLkhAl4UDoS2V+2MKw5IXpYO3tU5TwM7y8uGZ
;;; gj/XpMlzWXtVQvOVpwgmT0XCymP5174BFyTP1SLNhlUWUfwFCypOY6tRHd6U9uqc
;;; BATajxbYoRpvjWl9Nu8xggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQT5TS+vvzFLOrS9eea5bK0TANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQBmWv6KAfFQskhrpeobFqAeBk0XqhGgn7rY
;;; orH7KAPSpObuvw2gxIVblYH+AKaTsmaZDkgOoLkH3gHVP9ElQ6JhcdYhg+v29toC
;;; pbF7V+8kAqBNqn/TyVGlZ7kNcUEUmDjnuEVCIkDsJqgDCTaosYeZThs8QhWWB/sE
;;; j6RCjc3Aj2EvHkCBJ5Fkh+2pgTBsgtD7i63MFQnYVlBvdNsV6HgBALkRXQ3g/1/n
;;; 2pAtnH8zh0La0LuI9r/e8SktUskCx4e3HIIG1aEgbQwNpDgxuVbKZpo55pAc/xrL
;;; UCak/Z4wcr+v7B0Likb7LuPRtxlvWhur+p45vp0fQyW1xnW3CQK+
;;; -----END-SIGNATURE-----