; Next available MSG number is 33 MODULE_ID IGESIN_LSP_
;;;----------------------------------------------------------------------------
;;;
;;;   IGESIN.LSP
;;;   Copyright (C) 1991-1997 by Autodesk, Inc.
;;;
;;;   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED
;;;   WARRANTY.  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR
;;;   PURPOSE AND OF MERCHANTABILITY ARE HEREBY DISCLAIMED.
;;;
;;;----------------------------------------------------------------------------
;;;
;;; Check to see if AI_UTILS is loaded, If not, try to find it,
;;; and then try to load it.
;;;
;;; If it can't be found or it can't be loaded, then abort the
;;; loading of this file immediately, preserving the (autoload)
;;; stub function.
  (cond
    ((and ai_dcl (listp ai_dcl)) )            ; it's already loaded.
    ((not (findfile ;|MSG0|;"ai_utils.lsp"))  ; find it
      (ait_abort ;|MSG0|;"IGESIN" 
         (strcat ;|MSG1|;"Can't locate file ai_utils.lsp."
             ;|MSG2|;"\n Check support directory.")
         ;|MSG0|;"igesin"
         igesin))
    ((eq ;|MSG0|;"failed" (load ;|MSG0|;"ai_utils" ;|MSG0|;"failed")) ; load it
      (ait_abort ;|MSG0|;"IGESIN" 
         ;|MSG3|;"Can't load file ai_utils.lsp"
         ;|MSG0|;"igesin"
         igesin))
  )
  (if (not (ai_acadapp))     ; defined in ai_utils.lsp
    (ait_abort ;|MSG0|;"IGESIN" nil
         ;|MSG0|;"igesin"
         igesin))    ; a Nil <msg> supresses
                 ; ait_abort's alert box dialog.

  (setq arxlist (arx))
  (if (member "asrf.arx" arxlist)
	(setq asrf_loaded T)
	(setq asrf_loaded nil) ;; disable AutoSurf option usage
  )

;;;---------------------------------------------------------------------------
;;; The main IGESIN function.
;;;----------------------------------------------------------------------------
(defun c:igesin ( / old_cmd)

  ;; Set up error function.
  (setq old_cmd (getvar ;|MSG0|;"CMDECHO")    ; save current setting of cmdecho
    old_error  *error*                    ; save current error function
    *error* ai_error                      ; new error function
  )
  (setvar ;|MSG0|;"CMDECHO" 0)
  (ait_rxunload ;|MSG0|;"igesin" igesin)
  (cond
    ((not (ait_cmdactive (+ 1 2 8))))         ; transparent/dialog box not OK
    ((not (ai_acadapp)) )                     ; ACADAPP.EXP rxloaded?
    ((or (= 0 (getvar ;|MSG0|;"CMDDIA"))      ; Command line version
     (= 4 (logand (getvar ;|MSG0|;"CMDACTIVE") 4)) ; also do if script running
     )
      (if (ait_rxload ;|MSG0|;"igesin" igesin)
    (igesin)
      )
      (ait_rxunload ;|MSG0|;"igesin" igesin)
    )
    (T                                        ; Proteus version
      (ddigesin)
    )
  )
  (princ)
)
;;
;;;---------------------------------------------------------------------------
;;; The alternative -IGESIN function.
;;;----------------------------------------------------------------------------
(defun c:-igesin ( / old_cmd)

  ;; Set up error function.
  (setq old_cmd (getvar ;|MSG0|;"CMDECHO")    ; save current setting of cmdecho
    old_error  *error*                    ; save current error function
    *error* ai_error                      ; new error function
  )
  (setvar ;|MSG0|;"CMDECHO" 0)
  (ait_rxunload ;|MSG0|;"igesin" igesin)
  (cond 
    ((not (ait_cmdactive (+ 1 2 8))))    ; transparent/dialog box not OK
    ((not (ai_acadapp)))                 ; ACADAPP loaded?
    (if (ait_rxload ;|MSG0|;"igesin" igesin)
      (igesin)
    )
  )
  (ait_rxunload ;|MSG0|;"igesin" igesin)
  (princ)
)
;;
;;
(defun ddigesin (/
    a pickf pickdwgf dcl_id optname desctxt what_next1 dname fname tmode
    lfiles sfp_list mfp_list dwg_list lmode tmp_list soptname moptname
    optfile modflag wasmod canflag canopts str_opts geo_opts anno_opts
    demap_opts misc_opts allopts f f1 proceed defopts curoptdesc scrpath
    asurf_geo_opts pnttolval nextfn
    curr defs invdir posrn intrng saving
        )

  (ait_rxload ;|MSG0|;"igesgui" ISXOGI)

;; Setup messages
  (setq
     curr   ;|MSG4|;"*Current*"
     defs   ;|MSG5|;"*Defaults*"
     invdir ;|MSG6|;"Invalid directory."
     posrn  ;|MSG7|;"Must be a positive real number."
     intrng ;|MSG8|;"Must be an integer between 2 and 32767."
     saving ;|MSG9|;"Saving... Please Wait"
  )

;; Function to grey out modify list item and delete list item.
;; If the list item is not selected, then the buttons are greyed out
;; otherwise they are pickable. Valid only for multiple translations.
;; In single translation, they are automatically greyed out.
;;
(defun greylists()
  (if (read (get_tile ;|MSG0|;"fp_list"))
    (mode_tile ;|MSG0|;"del_cur_out" 0)
    (progn
      (mode_tile ;|MSG0|;"clr_all" 1)
      (mode_tile ;|MSG0|;"del_cur_out" 1)
    )
  )
  (if (= tmode ;|MSG0|;"1")
    (progn
      (if fp_list  (mode_tile ;|MSG0|;"clr_all" 0))
      (if (read (get_tile ;|MSG0|;"dwg_list"))
    (mode_tile ;|MSG0|;"out_file" 0)
    (mode_tile ;|MSG0|;"out_file" 1)
      )
    )
    (mode_tile ;|MSG0|;"out_file" 1)
  )
)
;;
;;
(defun greydir (path_on)
  (if (and (= (get_tile ;|MSG0|;"dwg_path") ;|MSG0|;"spec_path") path_on)
    (mode_tile ;|MSG0|;"outdir" 0)
    (mode_tile ;|MSG0|;"outdir" 1)
  )
)
;;
;;
(defun grey_modes ()
  (if (= tmode ;|MSG0|;"0")
    (progn
      (mode_tile ;|MSG0|;"dwg_path" 1)
      (greydir nil)
    )
    (progn
      (mode_tile ;|MSG0|;"dwg_path" 0)
      (greydir T)
    )
  )
  (greylists)
)
;;
;; Resets the error tile to display null message.
;;
(defun rs_err ()
  (set_tile ;|MSG0|;"error" ;|MSG0|;"")
)
;;
;; Reads the GUI config file where all the information is stored. The
;; routine stores information in igesin.cfg and retrieves them next time
;; when GUI is invoked. This file is created the first time when GUI is
;; invoked.
;;
(defun read_fls ()
  (setq noerr
    (cond
      ((not (setq f (open ;|MSG0|;"igesin.cfg" ;|MSG0|;"r"))) nil)
      ((not (or (= ;|MSG0|;"0" (setq tmode (read-line f))) (= ;|MSG0|;"1" tmode)))
    (setq tmode ;|MSG0|;"0") nil)
      ((/= ;|MSG0|;"single" (read-line f))   ; single mode header
    nil)
      ((not (or (findfile (setq soptname (read-line f)))
        (= soptname defs)))  ; single opt filename
    (setq soptname defs) nil)
      ((not
     (progn
       (if (setq validf (setq a (read-line f))) ; if not end of file
         (if (setq validf (or (findfile a) (= a ;|MSG0|;"")))  ; if file exists
           (if (not(= a ;|MSG0|;""))(setq sfp_list (list a)))
         )
       )
       validf
     )
       )  ; last single translation file
    (setq sfp_list nil)
      )
      ((/= ;|MSG0|;"multiple" (read-line f))   ; multiple mode header
    nil)
      ((not (chkdir (setq dname (read-line f))))         ; out directory
    (setq dname nil))
      ((not (or (= defs (setq moptname (read-line f)))
        (findfile moptname)))                    ; multi opt filename
    (setq moptname defs) nil)
      ((not (is_posint (itoa (setq lfiles (atoi (read-line f)))))) ;file count
    (if (= 0 lfiles) T nil))
      ((not
     (progn
       (setq fcnt lfiles validf T)
       (while (and (> fcnt 0) validf)
         (if (setq validf (setq a (read-line f))) ; if not end of file
           (if (setq validf (findfile a))         ; if file exists
         (setq mfp_list (cons a mfp_list))
           )
         )
         (setq fcnt (1- fcnt))
       )
       (if validf (setq mfp_list (reverse mfp_list)))
     )
       )
    (setq mfp_list nil)
      )
      ((not
     (progn
       (setq fcnt lfiles)
       (while (and (> fcnt 0) validf)
         (if (setq validf (setq a (read-line f))) ; if not end of file
           (if (setq validf (chkdir (strpfn a)))  ; if valid directory
         (setq dwg_list (cons a dwg_list))
           )
         )
         (setq fcnt (1- fcnt))
       )
       (if validf (setq dwg_list (reverse dwg_list)))
     )
       )
    (setq dwg_list nil mfp_list nil)
      )
      ((not (read-line f)) T)
      (t (setq mfp_list nil dwg_list  nil))
    )
  )
  (if f
    (close f)
    (setq noerr T)
  )
  noerr
)
;;
;; Checks whether the drawing exist and if it exist alerts the user
;; to input another file name.
;;
(defun checkdwglist (/ n)
  (setq canflag 0)
  (if (= tmode ;|MSG0|;"1")
  (if dwg_list
    (foreach n dwg_list
      (if (findfile (strcat n ;|MSG0|;".dwg"))(alertusr n)
    (set_tile ;|MSG0|;"error" ;|MSG10|;"Please Wait..."))
      )
    )
  )
  (rs_err)
)
;;
;; Alerts the user of the duplicate drawing name.
;;
(defun alertusr (dupname)
  (if (= canflag 0)
    (progn
      (if (not (new_dialog ;|MSG0|;"dupfile" dcl_id))(exit))
      (set_tile ;|MSG0|;"dupfilename" dupname)
      (action_tile ;|MSG0|;"accept" ;|MSG0|;"(setq canflag 0)(done_dialog 40)")
      (action_tile ;|MSG0|;"cancel" ;|MSG0|;"(setq canflag 1)(done_dialog 41)")
      (setq what_next1 (start_dialog))
    )
  )
)
;;
;; Writes out the GUI configuration to igesin.cfg 
;;
(defun save_list ()
  (setq f (open ;|MSG0|;"igesin.cfg" ;|MSG0|;"w"))
  (write-line tmode f) ;; the last mode in the GUI
  (write-line ;|MSG0|;"single" f) ;; write the string single
  (if (= soptname curr) ;; write the single mode option filename
    (write-line defs f)
    (write-line soptname f)
  )
  (if sfp_list            ;; write the single translation filename
      (write-line (car sfp_list) f)
      (write-line ;|MSG0|;"" f)   ;; if nil write an empty string
  )
  (write-line ;|MSG0|;"multiple" f) ;; write the string multiple
  (write-line dname f)      ;; write the output dwg directory name
  (if (= moptname curr)     ;; write the multiple option filename
    (write-line defs f)
    (write-line moptname f)
  )
  (write-line (itoa lfiles) f) ;; write the files count
  (if mfp_list                 ;; write the multiple translation filenames
    (foreach n mfp_list (write-line n f))
  )
  (if dwg_list                ;; write the multiple output dwg filenames
    (foreach n dwg_list (write-line n f))
  )
  (close f)
)
;;
;; Add a file to the selection list
;;
(defun addfile ()
  (setq fname ;|MSG0|;"")
  (if (/= ;|MSG0|;"" pickf)
    (if (not (wcmatch pickf ;|MSG0|;"* *")) ; test for multiple select
      (setq fname (strpfn (nth (read pickf) fp_list)))
    )
  )
  (if (setq fname (getfiled ;|MSG11|;"IGESIN - Select IGES File" fname ;|MSG0|;"igs" 4))
    (cond
      ((= tmode ;|MSG0|;"0")  ;; for single mode
        (setq sfp_list (list fname))
        (setq fp_list sfp_list)
        (setlist fp_list ;|MSG0|;"fp_list")
        (greylists)
      )
      ((= tmode ;|MSG0|;"1") ;; for multiple mode
        (add2lists fname)
        (setq lfiles (length mfp_list))
      )
      (t nil)
    )
  )
  (mode_tile ;|MSG0|;"add_to_list" 2)
)
;;
;; Add files to both the IGES File and Drawing file list boxes.
;;
(defun add2lists (fn / dwgfilename)
  (if (not (member fn mfp_list))
    (progn
      (setq dwgfilename
    (if (= (get_tile ;|MSG0|;"dwg_path") ;|MSG0|;"spec_path")
      (strcat (addendslash dname) (strpdirs fn))
      (strpext fn)
    )
      )
      (if (member dwgfilename dwg_list)
    (alert ;|MSG12|;"**Duplicate Output File**\n\nChange Output Filename"))
      (setq mfp_list (append mfp_list (list fn)))
      (setq fp_list mfp_list)
      (setlist fp_list ;|MSG0|;"fp_list")
      (setq dwg_list (append dwg_list (list dwgfilename)))
      (setlist dwg_list ;|MSG0|;"dwg_list")
      (set_tile ;|MSG0|;"fp_list" (itoa (what_pos fn fp_list)))
      (set_tile ;|MSG0|;"dwg_list" (itoa (what_pos fn fp_list)))
      (setq pickdwgf (setq pickf (get_tile ;|MSG0|;"fp_list")))
      (greylists)
    )
  )
)
;;
;; Return the position of the item in the list
;;
(defun what_pos (item the_list / pos)
   (setq pos (- (length the_list)
        (length (member item the_list)))
   )
)
;;
;; Update list for a list_box
;;
(defun setlist (listname tilename)
  (if listname
   (progn
     (start_list tilename)
     (mapcar (quote add_list) listname)
     (end_list)
   )
   (progn
     (start_list tilename)
     (end_list)
   )
  )
)
;;
;; Return the length of the extension such .igs .iges etc to
;; extract the file name without the extension. 
;;
(defun extlen (s1)
  (setq dupstr s1)
  (setq strindex 1)
  (while (wcmatch dupstr ;|MSG0|;"*\.*")
    (progn
      (setq dupstr (substr s1 strindex))
      (setq strindex (1+ strindex))
    )
  )
  (setq lext (1+ (strlen dupstr)))
)
;;
;; Strips the extension from a file name and returns
;; the filename.
;;
(defun strpext (s1)
   (substr s1 1 (- (strlen s1) (extlen s1)))
)
;;
;; Strips the directory names preceding the file name and returns
;; the filename without the extension.
;;
(defun strpdirs (s1)
  (setq s1 (strpext s1))
  (substr s1 (findfn s1))
)
;;
;; Strips the file name and returns the path.
;;
(defun strpfn (s1)
  (substr s1 1 (- (findfn s1) 1))
)
;;
;;
(defun findfn (s1 / dupstr)
  (setq dupstr s1 strindex 0)
  (while (or (wcmatch dupstr ;|MSG0|;"*/*")(wcmatch dupstr ;|MSG0|;"*\\*"))
    (setq strindex (1+ strindex))
    (setq dupstr (substr s1 strindex))
  )
  strindex
)
;;
;; Copies the iges file list in order to maintain two
;; lists for the two modes.
;;
(defun copylists ()
  (cond
    ((= tmode ;|MSG0|;"0") (setq sfp_list fp_list))
    ((= tmode ;|MSG0|;"1") (setq mfp_list fp_list))
    (t nil)
  )
)
;;
;; Deletes files from both the iges as well as drawing lists
;; 
(defun remfile (/ pickf_list pickf_no fp_list1 dwg_list1)
  (while (setq pickf_no (read pickf))
    (setq pickf_list (cons pickf_no pickf_list))
    (setq pickf (substr pickf (+ 2 (strlen (itoa pickf_no)))))
  )
  (setq n 0)
  (while (< n (length fp_list))
    (if (not (member n pickf_list))
      (progn
    (setq fp_list1 (cons (nth n fp_list) fp_list1))
    (if (= tmode ;|MSG0|;"1")
      (setq dwg_list1 (cons (nth n dwg_list) dwg_list1))
    )
      )
    )
    (setq n (1+ n))
  )
  (setq fp_list (reverse fp_list1))
  (if (= tmode ;|MSG0|;"1")
    (progn
      (setq dwg_list (reverse dwg_list1))
      (setlist dwg_list ;|MSG0|;"dwg_list")
      (setq lfiles (length fp_list))
    )
  )
  (copylists)
  (setlist fp_list ;|MSG0|;"fp_list")
)
;;
;; Clear the iges file list and the drawings list.
;;
(defun clraccept ()
  (setq fp_list nil pickf ;|MSG0|;"")
  (if (= tmode ;|MSG0|;"1")(setq dwg_list nil))
  (copylists)
)
;;
;; Dialog box function for Clearall button.
;;
(defun clr_all ()
  (if (not (new_dialog ;|MSG0|;"modealert" dcl_id))(exit))
  (action_tile ;|MSG0|;"accept" ;|MSG0|;"(clraccept)(done_dialog 26)")
  (action_tile ;|MSG0|;"cancel" ;|MSG0|;"(done_dialog 25)")
  (setq what_next1 (start_dialog))
  (setlist dwg_list  ;|MSG0|;"dwg_list")
  (setlist fp_list ;|MSG0|;"fp_list")
  (greylists)
)
;;
;;
(defun mod_dwgname (/ pickf_no old_dwg new_dwg)
  (setq pickf_no (read pickdwgf))
  (setq old_dwg (nth pickf_no dwg_list))
  (setq new_dwg (getfiled ;|MSG13|;"Change Output Drawing File" old_dwg 
              ;|MSG0|;"dwg" 1))
  (if new_dwg 
    (progn
      (setq new_dwg (substr new_dwg 1 (- (strlen new_dwg) 4)))
      (checkdup)
    )
  )
  (setlist dwg_list ;|MSG0|;"dwg_list")
  (set_tile ;|MSG0|;"dwg_list" pickdwgf)
) 
;;
;;
(defun checkdup ()
  (if (member new_dwg dwg_list)
    (set_tile ;|MSG0|;"error" ;|MSG14|;"File is already in Output File List.")
    (progn
      (setq dwg_list (subst new_dwg old_dwg dwg_list))
      (copylists)
    )
  )
)
;;
;;
(defun delendslash (s1 / lchar)
  (if (/= ;|MSG0|;"" s1)
    (if (and (wcmatch s1 ;|MSG0|;"~*:`\\")(wcmatch s1 ;|MSG0|;"*?[`/`\\]"))
      (substr s1 1 (- (strlen s1) 1))
      s1
    )
    s1
  )
)
;;
;;
(defun revbackslash (s1 / dupstr s testchar)
  (cond
    ((wcmatch s1 ;|MSG0|;"*\\*")
      (setq dupstr s1 si 0)
      (while (wcmatch dupstr ;|MSG0|;"*\\*")
    (setq testchar (substr dupstr 1 1))
    (if (wcmatch testchar ;|MSG0|;"\\")
      (setq s1 (strcat (substr s1 1 (1- si)) ;|MSG0|;"/" (substr dupstr 2)))
    )
    (setq si (1+ si))
    (setq dupstr (substr s1 si))
      )
      s1
    )
    (t s1)
  )
)
;;
;;
(defun addendslash (s1 / vers)
  (setq vers (getvar ;|MSG0|;"PLATFORM"))
  (cond
    ((and (or (= vers ;|MSG0|;"386 DOS Extender")
          (= (substr vers 1 9) ;|MSG0|;"Microsoft"))
      (wcmatch s1 ;|MSG0|;"*?*") (wcmatch s1 ;|MSG0|;"~*:`\\")
      (wcmatch s1 ;|MSG0|;"~`\\") (wcmatch s1 ;|MSG0|;"~*`\\"))
      (setq s1 (strcat s1 ;|MSG0|;"\\"))
    )
    ((and (/= vers ;|MSG0|;"386 DOS Extender")
      (/= (substr vers 1 9) ;|MSG0|;"Microsoft")
      (wcmatch s1 ;|MSG0|;"*?*")(wcmatch s1 ;|MSG0|;"~*/"));unix
      (setq s1 (strcat s1 ;|MSG0|;"/"))
    )
    (t s1)
  )
)
;;
;;
(defun chkdir (dirname / vers dret flname)
  (if (/= ;|MSG0|;"" dirname)
    (progn
      (setq vers (getvar ;|MSG0|;"PLATFORM"))
      (cond
    ((or (= vers ;|MSG0|;"386 DOS Extender")
         (= (substr vers 1 9) ;|MSG0|;"Microsoft"))
      (setq flname (strcat (addendslash dirname) ;|MSG0|;"igesin.tmp"))
      (setq f1 (open flname ;|MSG0|;"w"))
      (if f1
        (progn
          (close f1)
          (if (not (member flname tmp_list))
        (setq tmp_list (append tmp_list (list flname)))
          )
        )
      )
      (setq dret f1)
    )
    (t (setq dret (open dirname ;|MSG0|;"r"))) ; Default platform (unix)
      )
    )
    t
  )
)
;;
;;
(defun del_tmps ()
  (if tmp_list
    (foreach n tmp_list (command ;|MSG0|;"_.del" n))
  )
)
;;
;;
(defun chgdir ()
  (if (chkdir $value)
    (Progn
      (setq dname (delendslash $value))
      (rs_err)
    )
    (set_tile ;|MSG0|;"error" invdir)
  )
)
;;
;;
(defun chgoption ( / tmpname)
  (if (isoptfile)
    (setq tmpname optname)
    (setq tmpname ;|MSG0|;"")
  )
  (setq tmpname (getfiled ;|MSG15|;"Select OPTION SETTINGS File" tmpname 
              ;|MSG0|;"opt" 10))
  (if tmpname
    (progn
      (getallopts (setq optname tmpname))
      (setopt nil)
      (if (= tmode ;|MSG0|;"0")
    (setq soptname optname)
    (setq moptname optname)
      )
    )
  )
)
;;
;;
(defun switchmode (mode)
  (if (or (= mode ;|MSG0|;"batch") (= mode ;|MSG0|;"1"))
    (setq tmode ;|MSG0|;"1")
    (setq tmode ;|MSG0|;"0")
  )
  (cond
    ((= tmode ;|MSG0|;"0")
      (setlist nil ;|MSG0|;"dwg_list")
      (setq fp_list sfp_list)
      (mode_tile ;|MSG0|;"dwg_list" 1)
      (setq optname soptname)
    )
    ((= tmode ;|MSG0|;"1")
      (setq fp_list mfp_list)
      (mode_tile ;|MSG0|;"dwg_list" 0)
      (setlist dwg_list ;|MSG0|;"dwg_list")
      (setq optname moptname)
    )
    (t nil)
  )
  (setlist fp_list ;|MSG0|;"fp_list")
  (set_tile ;|MSG0|;"fp_list" (setq pickf ;|MSG0|;"0"))
  (setpick)

  (if optname (setopt nil))
)
;;
;;
(defun setopt (tmpdesc)
  (set_tile ;|MSG0|;"curopt" optname)
  (if (not tmpdesc)
    (cond
      ((= optname curr) (setq tmpdesc curoptdesc))
      ((= optname defs) (setq tmpdesc ;|MSG0|;""))
      (T (if (not (setq tmpdesc (ISXOGD (findfile optname))))
       (setq tmpdesc ;|MSG0|;"")))
    )
  )
  (set_tile ;|MSG0|;"opts_desc_text" tmpdesc)
)
;;
;;
(defun isoptfile ()
  (if (or (= optname defs)
      (= optname curr)) nil T)
)
;;
;;
(defun waitmsg ()
  (set_tile ;|MSG0|;"error" ;|MSG16|;"Working...Please Wait")
)
;;
;; This function tests for a change in the tile's value.  If there is
;; a change, the modflag is set and T is returned, otherwise nil is returned.
;;   
(defun test_chg (previous new)
  (if (/= new previous)
    (progn (setmflag) T)
    nil
  )
)
;;
;;  This function checks the validity of an acad object name.  If legitimate,
;;  the layer name is returned in uppercase, nil otherwise.  Setting `wild' to
;;  T allows wild card characters.
;;
(defun check_objname (lname err_msg wild / teststr) ;??? need test for nil.
  (if wild   ; allows wildcard characters.
    (setq teststr ;|MSG0|;"*[- !%^&()=+\\|{}:\";`,/<>]*")
    (setq teststr ;|MSG0|;"*[]- !@#%^&*()=+\\|{}[:\"~;'`,./<>?]*")
  )
  (if (wcmatch lname teststr)
    (progn (set_tile ;|MSG0|;"error" err_msg) nil)
    (strcase lname)
  )
)
;;
;;  This function checks the validity of a layername.  If legitimate,
;;  the layer name is returned, nil otherwise.
;;
(defun check_lname (lname err_msg)
  (if (wcmatch (strcase lname) ;|MSG0|;"*[]- !@#%^&*()=+\\|{}[:\"~;'`,./<>?]*")
    (progn (set_tile ;|MSG0|;"error" err_msg) nil)
    lname
  )
)
;;
(defun optmenu ( / canexit tmpopts tmpsubopts)
  (if (not (new_dialog ;|MSG0|;"optdialog" dcl_id))(exit))
  (cond ((= optname defs) )
    ((= optname curr) )
    (T (getallopts optname))
  )
  (setq modflag 0
    tmpopts allopts
    canexit nil)
  (set_tile ;|MSG0|;"opt_file_name" optname)
  (set_tile ;|MSG0|;"desc_text" (car allopts))
  (mode_tile ;|MSG0|;"geom" 0)
  (action_tile ;|MSG0|;"desc_text" ;|MSG0|;"(setq desctxt $value) (setmflag)")
  (action_tile ;|MSG0|;"struct" ;|MSG0|;"(waitmsg)(structmenu)(rs_err)")
  (action_tile ;|MSG0|;"geom" ;|MSG0|;"(waitmsg)(geomenu)(rs_err)")
  (action_tile ;|MSG0|;"anno" ;|MSG0|;"(waitmsg)(annomenu)(rs_err)")
  (action_tile ;|MSG0|;"demap" ;|MSG0|;"(waitmsg)(demapmenu)(rs_err)")
  (action_tile ;|MSG0|;"misclog" ;|MSG0|;"(waitmsg)(logmenu)(rs_err)")
  (action_tile ;|MSG0|;"misc" ;|MSG0|;"(waitmsg)(miscmenu)(rs_err)")
  (action_tile ;|MSG0|;"def_options" ;|MSG0|;"(popdefopts)")
  (action_tile ;|MSG0|;"save_as_options" ;|MSG0|;"(saveasopts)")
  (action_tile ;|MSG0|;"save_options" ;|MSG0|;"(saveinopts)")
  (action_tile ;|MSG0|;"accept" 
           ;|MSG0|;"(exitopts)(if (not canexit)(done_dialog 19))")
  (action_tile ;|MSG0|;"cancel" ;|MSG0|;"(canallopts)")
  (action_tile ;|MSG0|;"help" 
           ;|MSG0|;"(ait_helpdlg \"opt_optsEditor_dialogBox\")")
  (setq what_next1 (start_dialog))
  (if (not canopts) (setopt desctxt))
)
;;
;;
(defun canallopts ()
  (setq canopts T desctxt (car tmpopts) allopts tmpopts)
  (setq str_opts (nth 1 allopts))
  (setq geo_opts (nth 2 allopts))
  (setq anno_opts (nth 3 allopts))
  (setq demap_opts (nth 4 allopts))
  (setq misc_opts (nth 5 allopts))
  (if (= T asrf_loaded)
    (setq asurf_geo_opts (nth 6 allopts))
  )
  (done_dialog 19)
)
;;
;;
(defun setofiletxt (ofile)
  (setq optname ofile)
  (set_tile ;|MSG0|;"opt_file_name" ofile)
  (cond ((= tmode ;|MSG0|;"0")(setq soptname optname))
      ((= tmode ;|MSG0|;"1")(setq moptname optname))
      (t nil)
  )
)
;;
;;
(defun getolist ()
  (setq allopts (list desctxt str_opts geo_opts anno_opts demap_opts misc_opts
              asurf_geo_opts))
)
;;
;;
(defun saveinopts (/ savefile err)
  (if (isoptfile)
    (progn
      (setq savefile (get_tile ;|MSG0|;"opt_file_name"))
      (set_tile ;|MSG0|;"error" saving)
      (getolist)
	  (setq err (ISXOPI savefile allopts))
      (if (null err)
         (progn
           (setq modflag 0)
           (rs_err)
         )
         (set_tile ;|MSG0|;"error" err)
      )
    )
    (saveasopts)
  )
)
;;
;;
(defun saveasopts (/ savefile err)
  (if (isoptfile)
    (setq savefile optname)
    (setq savefile ;|MSG0|;"")
  )
  (setq savefile (getfiled ;|MSG17|;"Save As..." savefile ;|MSG0|;"opt" 9))
  (if savefile 
    (progn
      (set_tile ;|MSG0|;"error" saving)
      (getolist)
	  (setq err (ISXOPI savefile allopts))
      (if (null err)
         (progn
           (setq modflag 0)
           (setofiletxt savefile)
           (rs_err)
         )
         (set_tile ;|MSG0|;"error" err)
      )
    )
  )
)
;;
;;
(defun exitopts ()
  (if (= modflag 1)
    (progn                          ; If changes were made and not saved.
      (setq canexit nil)
      (if (not (new_dialog ;|MSG0|;"optmod" dcl_id)) (exit))
      (action_tile ;|MSG0|;"accept" ;|MSG0|;"(setup_curopts)")
      (action_tile ;|MSG0|;"cancel" ;|MSG0|;"(setq canexit T)(done_dialog 20)")
      (setq what_next1 (start_dialog))
    )
    (setq canexit nil canopts nil)  ; If default or saved options.
  )
)
;;
;;
(defun setup_curopts ()
  (setofiletxt curr)
  (getolist)
  (ISXOPI ;|MSG0|;"tmpiges.opt" allopts)
  (setq canopts nil curoptdesc (car allopts))
  (done_dialog 19)
)
;;
;;
(defun getallopts (ofilename)
  (if ofilename
    (setq allopts (ISXOGI (findfile ofilename)))
    (setq defopts (setq allopts (ISXOGI)))
  )
  (set_tile ;|MSG0|;"desc_text" (setq desctxt (nth 0 allopts)))
  (setq str_opts (nth 1 allopts))
  (setq geo_opts (nth 2 allopts))
  (setq anno_opts (nth 3 allopts))
  (setq demap_opts (nth 4 allopts))
  (setq misc_opts (nth 5 allopts))
  (if (= T asrf_loaded)
    (setq asurf_geo_opts (nth 6 allopts))
  )
)
;;
;;
(defun popdefopts ()
  (set_tile ;|MSG0|;"desc_text" (setq desctxt (nth 0 defopts)))
  (setq str_opts (nth 1 defopts)
    geo_opts (nth 2 defopts)
    anno_opts (nth 3 defopts)
    demap_opts (nth 4 defopts)
    misc_opts (nth 5 defopts)
    allopts defopts)
  (if (= T asrf_loaded)
     (setq asurf_geo_opts (nth 6 defopts))
  )
  (setofiletxt defs)
  (setq modflag 0)
)
;;
;;
(defun structmenu (/ prdwgval denumval vptlayval vpnval clpextval
             sepval vwnval grpval)
  (if (not (new_dialog ;|MSG0|;"stropts" dcl_id))(exit))

  (setq lname_emsg ;|MSG18|;"Invalid layer name character(s)."
    clext_emsg ;|MSG19|;"Must be a value between 0 and 100."
    denum_emsg ;|MSG20|;"Must be an odd integer value between 1-9999999.")

  (popstructs)
  (setq wasmod modflag tmpsubopts str_opts)
  (action_tile ;|MSG0|;"drv_prim" ;|MSG0|;"(rs_err)(chgsoprim404)")
  (action_tile ;|MSG0|;"drv_de_value" ;|MSG0|;"(setdenum)")
  (action_tile ;|MSG0|;"vpt_layer" ;|MSG0|;"(rs_err)(chgvptlayer)")
  (action_tile ;|MSG0|;"vpt_name" 
           ;|MSG0|;"(setq vpnval (setlayn vpnval lname_emsg))")
  (action_tile ;|MSG0|;"clp_exp" ;|MSG0|;"(setclpext)")
  (action_tile ;|MSG0|;"lay_sep" 
           ;|MSG0|;"(setq sepval (setlayn sepval lname_emsg))")
  (action_tile ;|MSG0|;"vw_name" ;|MSG0|;"(setq vwnval $value modflag 1)")
  (action_tile ;|MSG0|;"grp_map"
      ;|MSG0|;"(rs_err)(if (test_chg grpval $value)(setq grpval $value))")
  (action_tile ;|MSG0|;"accept" ;|MSG0|;"(check_str)")
  (action_tile ;|MSG0|;"cancel" 
           ;|MSG0|;"(setq str_opts (canopt))(done_dialog 41)")
  (action_tile ;|MSG0|;"default" 
           ;|MSG0|;"(setq str_opts (nth 1 defopts))(popstructs)")
  (action_tile ;|MSG0|;"help" 
           ;|MSG0|;"(ait_helpdlg \"opt_optsEditor_StructureDialogBox\")")
  (setq what_next1 (start_dialog))
)
;;
;;
(defun check_str ()
  (cond
    ((and (= prdwgval ;|MSG0|;"drv_de") 
      (not (is_odd (get_tile ;|MSG0|;"drv_de_value"))))
      (mode_tile ;|MSG0|;"drv_de_value" 2)
      (set_tile ;|MSG0|;"error" denum_emsg))
    ((and (= vptlayval ;|MSG0|;"vpt_single")
      (not (check_objname (get_tile ;|MSG0|;"vpt_name") lname_emsg nil)))
      (mode_tile ;|MSG0|;"vpt_name" 2))
    ((not (inrange (get_tile ;|MSG0|;"clp_exp") clext_emsg 0 100))
      (mode_tile ;|MSG0|;"clp_exp" 2))
    ((not (check_objname (get_tile ;|MSG0|;"lay_sep") lname_emsg nil))
      (mode_tile ;|MSG0|;"lay_sep" 2))
    (t (waitmsg)(getstructs)(rs_err)(done_dialog 40))
  )
)
;;
;;
(defun setlayn (currval err_msg)
  (if (check_objname $value err_msg nil)
    (if (test_chg currval $value)
      (progn
    (rs_err)
    (set_tile $key (setq currval (strcase $value)))
    currval
      )
      currval
    )
    currval
  )
)
;;
;; When canceling, test to make sure that the modflag was not set prior to 
;; entering this dialog.  If it was, then do not reset.  Also returns unchanged
;; suboptions list.
;;
(defun canopt ()
  (if (= wasmod 0)
    (setq modflag 0)
  )
  tmpsubopts
)
;;
;; get all structure members and fill the tiles.
;;
(defun popstructs (/ temp)
  (set_tile ;|MSG0|;"lay_sep" (setq sepval (car str_opts)))
  (set_tile ;|MSG0|;"vw_name" (setq vwnval (itoa (nth 1 str_opts))))
  (setq temp (nth 2 str_opts) denumval ;|MSG0|;"")
  (cond
    ((= temp 0)
      (set_tile ;|MSG0|;"drv_prim" (setq prdwgval ;|MSG0|;"drv_fir"))
      (mode_tile ;|MSG0|;"drv_de_value" 1)
    )
    ((= temp -1)
      (set_tile ;|MSG0|;"drv_prim" (setq prdwgval ;|MSG0|;"drv_sec"))
      (mode_tile ;|MSG0|;"drv_de_value" 1)
    )
    ((= temp -2)
      (set_tile ;|MSG0|;"drv_prim" (setq prdwgval ;|MSG0|;"no_404"))
      (mode_tile ;|MSG0|;"drv_de_value" 1)
    )
    ( t
      (set_tile ;|MSG0|;"drv_prim" (setq prdwgval ;|MSG0|;"drv_de"))
      (set_tile ;|MSG0|;"drv_de_value" (setq denumval (itoa (fix temp))))
    )
  )
  (if (= ;|MSG0|;"" (setq vpnval (nth 3 str_opts)))
    (progn
      (set_tile ;|MSG0|;"vpt_layer" (setq vptlayval ;|MSG0|;"vpt_view"))
      (mode_tile ;|MSG0|;"vpt_name" 1)
    )
    (progn
      (set_tile ;|MSG0|;"vpt_layer" (setq vptlayval ;|MSG0|;"vpt_single"))
      (set_tile ;|MSG0|;"vpt_name" vpnval)
    )
  )
  (set_tile ;|MSG0|;"clp_exp" (setq clpextval (rtos (* 100 (nth 4 str_opts)) 2)))
  (setq grpval (nth 5 str_opts))
  (cond 
    ;; 0: No grouping
    ((= grpval 0)(setq grpval ;|MSG0|;"ungrp"))
    ((= grpval 1)(setq grpval ;|MSG0|;"grp_acad"))
    ;; 2: Entity Grouping Tool
    ((= grpval 2)(setq grpval ;|MSG0|;"grp_tool"))
    ;; 3: Was AutoSurf - force it to be grp_acad.
    ((= grpval 3)(setq grpval ;|MSG0|;"grp_acad"))
    (t nil)
  )
  (set_tile ;|MSG0|;"grp_map" grpval)
)
;;
;;
(defun getstructs ()
  (cond ((> (atof denumval) 0) (setq denumval (atof denumval)))
    ((= prdwgval ;|MSG0|;"drv_fir") (setq denumval 0.0))
    ((= prdwgval ;|MSG0|;"drv_sec") (setq denumval -1.0))
    ((= prdwgval ;|MSG0|;"no_404") (setq denumval -2.0))
  )
  (if (= vptlayval ;|MSG0|;"vpt_view")
    (setq vpnval ;|MSG0|;"")
  )
  (cond 
    ((= grpval ;|MSG0|;"ungrp")(setq grpval 0))
    ((= grpval ;|MSG0|;"grp_acad")(setq grpval 1))
    ((= grpval ;|MSG0|;"grp_tool")(setq grpval 2))
  )
  (setq str_opts
    (list sepval (atoi vwnval)
          denumval vpnval (/ (atof clpextval) 100) grpval))
)
;;
;;
(defun chgsoprim404 ()
  (if (test_chg prdwgval $value)
    (progn
      (setq prdwgval $value)
      (if (= prdwgval ;|MSG0|;"drv_de")
    (progn
      (rs_err)
      (mode_tile ;|MSG0|;"drv_de_value" 0)
      (mode_tile ;|MSG0|;"drv_de_value" 2)
    )
    (mode_tile ;|MSG0|;"drv_de_value" 1)
      )
    )
  )
)
;;
;;
(defun setdenum ()
  (if (is_odd $value)
    (if (test_chg denumval $value)
      (progn
    (rs_err)
    (setq denumval $value)
      )
    )
    (set_tile ;|MSG0|;"error" denum_emsg)
  )
)
;;
;;
(defun is_odd (value / tmpval)
  (setq tmpval (distof value))
  (cond
    ((not (is_posint value)) nil)           ; not an integer.
    ((= (rem tmpval 2) 0) nil)             ; not an odd #.
    ((not (inrange value ;|MSG0|;"" 1 9999999)) nil)
    (t value)
  )
)
;;
;;
(defun is_posint (value / tmpval)
  (setq tmpval (distof value))
  (cond
    ((= tmpval nil) nil)  ; not a number
    ((< tmpval 1) nil)    ; less than 1
    ((/= (/ tmpval (fix tmpval)) 1) nil) ; not an integer.
    (t value)
  )
)
;;
;;
(defun chgvptlayer ()
  (if (test_chg vptlayval $value)
    (progn
      (setq vptlayval $value)
      (if (= vptlayval ;|MSG0|;"vpt_single")
    (progn
      (mode_tile ;|MSG0|;"vpt_name" 0)
      (mode_tile ;|MSG0|;"vpt_name" 2)
      (rs_err)
    )
    (mode_tile ;|MSG0|;"vpt_name" 1)
      )
    )
  )
)
;;
;;
(defun setclpext ()
  (if (inrange $value clext_emsg 0 100)
    (if (test_chg clpextval $value)
      (progn
    (rs_err)
    (set_tile $key (setq clpextval (conv_lunits $value)))
      )
    )
  )
)
;;
;;
(defun inrange (value err_msg low_end high_end)
  (if (ai_num value err_msg 6)
    (if (and (>= (atoi value) low_end) (<= (atoi value) high_end))
      value
      (progn (if err_msg (set_tile ;|MSG0|;"error" err_msg)) nil)
    )
    nil
  )
)
;;
;; Returns a real number in a string format determined AutoCAD's LUNITS and
;; LUPREC system variables. `real_val' is a string containing the number to
;; convert.
;;
(defun conv_lunits (real_val)
  (rtos (atof real_val))
)
;;
;; Returns a real number as a string in scientific notation with precision
;; determined by LUPREC system variables. `real_val' is a string containing the 
;; number to convert.
;;
(defun conv_sci (real_val)
  (rtos (atof real_val) 1)
)
;;
;; ===================== AutoCAD Geometry Menu Functions =================
;;
(defun crvmnu ( / tmpcrvopts crv102val bulgeval )
  (if (not (new_dialog ;|MSG0|;"crvdia" dcl_id))(exit))
  (setq wasmod modflag tmpcrvopts geo_opts)
  (popcrv)
  (action_tile ;|MSG0|;"crvmap" ;|MSG0|;"(setcrvmap)")
  (action_tile ;|MSG0|;"use_bulge" ;|MSG0|;"(setbulge)")
  (action_tile ;|MSG0|;"comp_crv_102" ;|MSG0|;"(setcrv102)")
  (action_tile ;|MSG0|;"crv_blk" ;|MSG0|;"(setmflag)")
  (action_tile ;|MSG0|;"accept" ;|MSG0|;"(getcrv)(rs_err)(done_dialog 40)")
  (action_tile ;|MSG0|;"cancel" 
           ;|MSG0|;"(setq geo_opts tmpcrvopts)(if (= wasmod 0)(setq modflag 0))(done_dialog 46)")
  (action_tile ;|MSG0|;"default" ;|MSG0|;"(crv_defaults)")
  (action_tile ;|MSG0|;"help" 
           ;|MSG0|;"(ait_helpdlg \"opt_optsEditor_GeometryDialogBox_curvesArea\")")
  (setq what_next1 (start_dialog))
)
;;
(defun popcrv ()
  (if (= ;|MSG0|;"0" (setq crvmap (itoa (nth 14 geo_opts))))
    (set_tile ;|MSG0|;"crvmap" (setq crvmap ;|MSG0|;"crvspl"))
    (set_tile ;|MSG0|;"crvmap" (setq crvmap ;|MSG0|;"crvply"))
  )
  (setq crv102val (nth 3 geo_opts))
  (cond
    ((= crv102val 1)
      (set_tile ;|MSG0|;"comp_crv_102" (setq crv102val ;|MSG0|;"crv_ind"))
      (set_tile ;|MSG0|;"crv_blk" ;|MSG0|;"0")
    )
    ((= crv102val 2)
      (set_tile ;|MSG0|;"comp_crv_102" (setq crv102val ;|MSG0|;"as_one_crv"))
      (set_tile ;|MSG0|;"crv_blk" ;|MSG0|;"0")
      (mode_tile ;|MSG0|;"crv_blk" 1)
    )
    (t ; default is 0
      (set_tile ;|MSG0|;"comp_crv_102" (setq crv102val ;|MSG0|;"crv_ind"))
      (set_tile ;|MSG0|;"crv_blk" ;|MSG0|;"1")
    )
  )
  (if (= ;|MSG0|;"0" (setq bulgeval (itoa (nth 4 geo_opts))))
    (set_tile ;|MSG0|;"use_bulge" ;|MSG0|;"1")
    (set_tile ;|MSG0|;"use_bulge" ;|MSG0|;"0")
  )
)
;;
;;
(defun getcrv ()
  (if (= crvmap ;|MSG0|;"crvspl")
     (setq crvmap 0)
     (setq crvmap 1)
  )
  (cond
    ((= crv102val ;|MSG0|;"as_one_crv")(setq crv102val 2))
    ((and (= crv102val ;|MSG0|;"crv_ind")
      (= (get_tile ;|MSG0|;"crv_blk") ;|MSG0|;"0"))
      (setq crv102val 1))
    (t (setq crv102val 0))  ; default - crv_ind and crv_blk=1
  )
  ;; Update geo_opts for curve options
  (setq geo_opts
    (list (car geo_opts) (nth 1 geo_opts) (nth 2 geo_opts) crv102val
          (atoi bulgeval) (nth 5 geo_opts) (nth 6 geo_opts) (nth 7 geo_opts)
          (nth 8 geo_opts) (nth 9 geo_opts) (nth 10 geo_opts) (nth 11 geo_opts)
          (nth 12 geo_opts) (nth 13 geo_opts) crvmap (nth 15 geo_opts) (nth 16 geo_opts)))
)
;;
;;
(defun crv_defaults ( / opts )
  ; Get default geometry options
  (setq opts (nth 2 defopts))
  ; Update curve options in geometry options list 
  (setq geo_opts
    (list (car geo_opts) (nth 1 geo_opts) (nth 2 geo_opts) (nth 3 opts)
          (nth 4 opts) (nth 5 geo_opts) (nth 6 geo_opts) (nth 7 geo_opts)
          (nth 8 geo_opts) (nth 9 geo_opts) (nth 10 geo_opts) (nth 11 geo_opts)
          (nth 12 geo_opts) (nth 13 geo_opts) (nth 14 opts) (nth 15 geo_opts) (nth 16 geo_opts)))
  (popcrv)
)

(defun srfmnu ( / tmpsrfopts srftypval srfuval srfvval cvidpval srfblkval)
  (if (not (new_dialog ;|MSG0|;"srfdia" dcl_id))(exit))
  (setq wasmod modflag tmpsrfopts geo_opts)
  (popsrf)
  (action_tile ;|MSG0|;"srf_type" ;|MSG0|;"(swsrftype)")
  (if asrf_loaded
	(mode_tile ;|MSG0|;"asurf_surfaces" 0) ;; enable AutoSurf mapping
	(mode_tile ;|MSG0|;"asurf_surfaces" 1) ;; disable AutoSurf mapping
  )
  (action_tile ;|MSG0|;"srf_block" ;|MSG0|;"(setq srfblkval $value)(setmflag)")
  (action_tile ;|MSG0|;"use_cv_idp" ;|MSG0|;"(setmflag)")
  (action_tile ;|MSG0|;"udir_num" 
           ;|MSG0|;"(setq srfuval (setints srfuval int_emsg))")
  (action_tile ;|MSG0|;"vdir_num" 
           ;|MSG0|;"(setq srfvval (setints srfvval int_emsg))")
  (action_tile ;|MSG0|;"accept" ;|MSG0|;"(check_srf)")
  (action_tile ;|MSG0|;"cancel" 
           ;|MSG0|;"(setq geo_opts tmpsrfopts)(if (= wasmod 0)(setq modflag 0))(done_dialog 46)")
  (action_tile ;|MSG0|;"default" ;|MSG0|;"(srf_defaults)")
  (action_tile ;|MSG0|;"help" 
           ;|MSG0|;"(ait_helpdlg \"opt_optsEditor_GeometryDialogBox_surfacesArea\")")
  (setq what_next1 (start_dialog))
)

(defun popsrf ()
  ;; Surface options.
  (if (= 1 (setq cvidpval (nth 11 geo_opts)))
    (setq cvidpval ;|MSG0|;"0")
    (setq cvidpval ;|MSG0|;"1")
  )
  (set_tile ;|MSG0|;"use_cv_idp" cvidpval)
  (setq srftypval (nth 5 geo_opts))
  (cond 
     ((= 0 srftypval)
    (progn
       (set_tile ;|MSG0|;"srf_type" (setq srftypval ;|MSG0|;"facets"))
       (grey_path 1)
    )
     )
     ((= 1 srftypval)
    (progn
      (set_tile ;|MSG0|;"srf_type" (setq srftypval ;|MSG0|;"paths"))
      (grey_path 0)
    )
     )
     ((= 2 srftypval)
    (progn
	  (if asrf_loaded
	    (set_tile ;|MSG0|;"srf_type" (setq srftypval "asurf_surfaces"))
		(progn
	      (set_tile ;|MSG0|;"srf_type" (setq srftypval "facets"))
		  (grey_path 1)
	      (grey_srf_block 1)
		)
	  )
    )
     )
     ((= 3 srftypval)
    (progn
       (set_tile ;|MSG0|;"srf_type" (setq srftypval ;|MSG0|;"bodies"))
       (grey_path 1)
    )
     )
  )
  (set_tile ;|MSG0|;"udir_num" (setq srfuval (itoa (nth 9 geo_opts))))
  (set_tile ;|MSG0|;"vdir_num" (setq srfvval (itoa (nth 10 geo_opts))))
  (if (= 1 (nth 12 geo_opts))
    (setq srfblkval ;|MSG0|;"0")
    (setq srfblkval ;|MSG0|;"1")
  )
  (set_tile ;|MSG0|;"srf_block" srfblkval)
)
;;
;;
(defun getsrf ()
  (if (= srftypval ;|MSG0|;"facets")
    (setq srftypval 0)  
    (if (= srftypval ;|MSG0|;"paths")
       (setq srftypval 1)
       (if (= srftypval ;|MSG0|;"bodies")
      (setq srftypval 3)
      (setq srftypval 2)  ; default - srftypval=asurf_surfaces
       )
    )
  )
  (if (= (get_tile ;|MSG0|;"use_cv_idp") ;|MSG0|;"1")
    (setq cvidpval 0)
    (setq cvidpval 1)  ; Default - cvidpval=0
  )
  (if (= ;|MSG0|;"0" srfblkval)
    (setq srfblkval 1)
    (setq srfblkval 0)
  )
  (setq geo_opts
    (list (car geo_opts) (nth 1 geo_opts) (nth 2 geo_opts) 
          (nth 3 geo_opts) (nth 4 geo_opts) srftypval (nth 6 geo_opts) 
          (nth 7 geo_opts) (nth 8 geo_opts) (atoi srfuval) (atoi srfvval)
          cvidpval srfblkval (nth 13 geo_opts) (nth 14 geo_opts) 
          (nth 15 geo_opts) (nth 16 geo_opts)))
)
;;
;;
(defun check_srf ()
   (cond
    ((not (inrange (get_tile ;|MSG0|;"udir_num") int_emsg 2 999))
      (mode_tile ;|MSG0|;"udir_num" 2))
    ((not (inrange (get_tile ;|MSG0|;"vdir_num") int_emsg 2 999))
      (mode_tile ;|MSG0|;"vdir_num" 2))
    (t (waitmsg)(getsrf)(rs_err)(done_dialog 40))
  )
)
;;
;;
(defun srf_defaults ( / opts )
  ; Get default geometry options
  (setq opts (nth 2 defopts))
  ; Update surface options in geometry options list 
  (setq geo_opts
    (list (car geo_opts) (nth 1 geo_opts) (nth 2 geo_opts) (nth 3 geo_opts)
          (nth 4 geo_opts) (nth 5 opts) (nth 6 geo_opts) (nth 7 geo_opts)
          (nth 8 geo_opts) (nth 9 opts) (nth 10 opts) (nth 11 opts)
          (nth 12 opts) (nth 13 geo_opts) (nth 14 geo_opts) 
          (nth 15 geo_opts) (nth 16 geo_opts)))
  (popsrf)
)
;;
;;
(defun geo_defaults ()
  (setq geo_opts (nth 2 defopts))
  (set_tile ;|MSG0|;"gp19" ;|MSG0|;"0")
  (mode_tile ;|MSG0|;"pt_tol" 0) ; enable Point Tolerance
  (popgeo)
)
;;
;;
(defun geomenu (/ crvptval crvtolval srfptval srftolval )

  (if (not (new_dialog ;|MSG0|;"geopts" dcl_id))(exit))

  (setq tol_emsg posrn
    int_emsg intrng)

  (setq wasmod modflag tmpsubopts geo_opts)
  (popgeo)
  (action_tile ;|MSG0|;"pt_tol" 
           ;|MSG0|;"(setq pnttolval (setposlunit pnttolval tol_emsg 1))")
  (action_tile ;|MSG0|;"gp19" 
           ;|MSG0|;"(if (= \"1\" $value) (mode_tile \"pt_tol\" 1) (mode_tile \"pt_tol\" 0)) (setmflag)")
  (action_tile ;|MSG0|;"crv_tol" 
           ;|MSG0|;"(setq crvtolval (setposlunit crvtolval tol_emsg 1))")
  (action_tile ;|MSG0|;"srf_tol" 
           ;|MSG0|;"(setq srftolval (setposlunit srftolval tol_emsg 1))")
  (action_tile ;|MSG0|;"brepin" ;|MSG0|;"(setbrepin)")
  (if asrf_loaded
    (mode_tile "eDes" 0) ;; Enable Designer parts option
    (mode_tile "eDes" 1) ;; Disable Designer parts option
  )
  (action_tile ;|MSG0|;"crvopt" ;|MSG0|;"(crvmnu)")
  (action_tile ;|MSG0|;"srfopt" ;|MSG0|;"(srfmnu)")
  (action_tile ;|MSG0|;"accept" ;|MSG0|;"(check_geo)")
  (action_tile ;|MSG0|;"cancel" 
           ;|MSG0|;"(setq geo_opts (canopt))(done_dialog 46)")
  (action_tile ;|MSG0|;"default" ;|MSG0|;"(geo_defaults)")
  (action_tile ;|MSG0|;"help" 
           ;|MSG0|;"(ait_helpdlg \"opt_optsEditor_GeometryDialogBox\")")
  (setq what_next1 (start_dialog))

)
;;
;;
(defun check_geo ()
   (cond
    ((not (ai_num (get_tile ;|MSG0|;"crv_tol") tol_emsg 6)) 
      (mode_tile ;|MSG0|;"crv_tol" 2))
    ((not (ai_num (get_tile ;|MSG0|;"srf_tol") tol_emsg 6)) 
      (mode_tile ;|MSG0|;"srf_tol" 2))
    ((not (ai_num (get_tile ;|MSG0|;"pt_tol") tol_emsg 6))  
      (mode_tile ;|MSG0|;"pt_tol" 2))
    (t (waitmsg)(getgeo)(rs_err)(done_dialog 40))
  )
)
;;
;;
(defun setposlunit (currval err_msg mode)
  (if (ai_num $value err_msg 6)
    (if (test_chg currval $value)
      (progn
    (rs_err)
    (setq currval (if mode (conv_sci $value) (conv_lunits $value)))
    (set_tile $key currval)
    currval
      )
      currval
    )
    currval
  )
)
;;
;;
(defun grey_uvdir (mode)
  (mode_tile ;|MSG0|;"udir_num" mode)
  (mode_tile ;|MSG0|;"vdir_num" mode)
)
;;
;;
(defun grey_srf_block (mode)
  (mode_tile ;|MSG0|;"srf_block" mode)
)
;;
;;
(defun grey_path (mode)
  (mode_tile ;|MSG0|;"use_cv_idp" mode)
  (grey_srf_block mode)
  (grey_uvdir mode)
)
;;
;;
;; This function sets the surface mapping option and handles the
;; enabling/disabling of the related options
(defun swsrftype ()
  (if (test_chg srftypval $value)
    (cond
      ((= $value ;|MSG0|;"asurf_surfaces")
     (if (= T asrf_loaded)
       (progn 
         (grey_path 0) 
         (grey_srf_block 1) 
         (setq srftypval $value)
       )
       (setq srftypval ;|MSG0|;"facets");
     )
      )
      ((= $value ;|MSG0|;"facets")
     (progn (grey_path 1) (setq srftypval $value))
      )
      ((= $value ;|MSG0|;"paths")
     (progn (grey_path 0) (setq srftypval $value))
      )
      ((= $value ;|MSG0|;"bodies")
     (progn (grey_path 1) (setq srftypval $value))
      )
    )
    (if (/= $value ;|MSG0|;"paths")
      (if (is_posint (get_tile ;|MSG0|;"udir_num"))
    (if (is_posint (get_tile ;|MSG0|;"vdir_num"))
      nil
      (mode_tile ;|MSG0|;"vdir_num" 2)
    )
    (mode_tile ;|MSG0|;"udir_num" 2)
      )
    )
  )
)
;;
;;
(defun setints (currval err_msg)
  (if (inrange $value ;|MSG0|;"" 2 32767)
    (if (test_chg currval $value)
      (progn
    (rs_err)
    (setq currval $value)
      )
    )
    (set_tile ;|MSG0|;"error" err_msg)
  )
  currval
)
;;
;;
(defun setcrvmap ()
  (if (test_chg crv102val $value)
     (progn
    (if (= $value ;|MSG0|;"crvspl")
       (setq crvmap ;|MSG0|;"crvspl")
       (setq crvmap ;|MSG0|;"crvply")
    )
    (setmflag)
     )
  )
)
;;
;;
(defun setbulge ()
  (if (= $value ;|MSG0|;"0")
    (setq bulgeval ;|MSG0|;"1")
    (setq bulgeval ;|MSG0|;"0")
  )
  (setmflag)
)
;;
;;
(defun setcrv102 ()
  (if (test_chg crv102val $value)
    (if (= (setq crv102val $value) ;|MSG0|;"as_one_crv")
      (mode_tile ;|MSG0|;"crv_blk" 1)
      (mode_tile ;|MSG0|;"crv_blk" 0)
    )
  )
)
;;
;;
(defun chgudir ()
  (if (test_chg srfuval $value)
    (if (ai_num $value ;|MSG0|;"???." 6)
      (setq srfuval $value)
    )
  )
)
;;
;;
(defun chgvdir ()
  (if (test_chg srfvval $value)
    (if (ai_num $value ;|MSG0|;"???." 6)
      (setq srfvval $value)
    )
  )
)
;;
;;
(defun setbrepin ()
  (if (test_chg brepin $value)
    (progn
      (setq brepin $value)
      (setmflag)
    )
  )
)
;;
;;
(defun popgeo ()
  (if (> 0 (setq pnttolval (nth 13 geo_opts)))
    (progn
      (set_tile ;|MSG0|;"gp19" ;|MSG0|;"1")
      (mode_tile ;|MSG0|;"pt_tol" 1)
      (setq pnttolval (abs pnttolval))
    )
  )
  (set_tile ;|MSG0|;"pt_tol" (setq pnttolval (rtos pnttolval 1)))
  (setq crvptval (itoa (cadr geo_opts)))
  (set_tile ;|MSG0|;"crv_tol" (setq crvtolval (rtos (caddr geo_opts) 1)))
  ;; (nth 6) is the srf_tolmeth which can be ignored
  (setq srfptval (itoa (nth 7 geo_opts)))
  ;; (nth 6) is the srf_tolmeth which can be ignored
  (set_tile ;|MSG0|;"srf_tol" (setq srftolval (rtos (nth 8 geo_opts) 1)))
  (setq brepin (itoa (nth 15 geo_opts)))
  (if (= ;|MSG0|;"0" brepin)
    (set_tile ;|MSG0|;"brepin" (setq brepin ;|MSG0|;"eSolid"))
    (if (= ;|MSG0|;"1" brepin)
      (set_tile ;|MSG0|;"brepin" (setq brepin ;|MSG0|;"eAsurf"))
      (if (= ;|MSG0|;"2" brepin)
    (set_tile ;|MSG0|;"brepin" (setq brepin ;|MSG0|;"eDes"))
      )
    )
  )
;(setq bad_surf_prefix (itoa (nth 16 geo_opts)))
)
;;
;;
(defun getgeo (/ crvmethval srfmethval)
  (if (= ;|MSG0|;"1" (get_tile ;|MSG0|;"gp19"))
    (setq pnttolval (- 0 (atof pnttolval)))
    (setq pnttolval (atof pnttolval))
  )
  (setq crvmethval 0)  ; Default - crvmethval ctol_meth
  (setq srfmethval 0)  ; Default - srfmethval stol_meth
  (setq brepin (get_tile ;|MSG0|;"brepin"))
  (if (= brepin ;|MSG0|;"eSolid")
    (setq brepin 0)
    (if (= brepin ;|MSG0|;"eAsurf")
      (setq brepin 1)
      (if (= brepin ;|MSG0|;"eDes")
    (setq brepin 2)
      )
    )
  )
  (setq geo_opts
    (list crvmethval (atoi crvptval) (atof crvtolval) (nth 3 geo_opts)
          (nth 4 geo_opts) (nth 5 geo_opts) srftolval (atoi srfptval)
          (atof srftolval) (nth 9 geo_opts) (nth 10 geo_opts)
          (nth 11 geo_opts) (nth 12 geo_opts) pnttolval 
          (nth 14 geo_opts) brepin (nth 16 geo_opts)))
)
;;
;; ===================== Annotation Menu Functions =================
;;
(defun annomenu (/ dfont_list pickf iflist aslist aflist fcode ascode afcode altfilval subfnt_list fontmap_list fill230val)
  (if (not (new_dialog ;|MSG0|;"annopts" dcl_id))(exit))

  (setq spc_emsg posrn)

  (setq dfont_list (ait_fontlist))
  (setlist (list ;|MSG0|;"0" ;|MSG0|;"1" ;|MSG0|;"2" ;|MSG0|;"3" ;|MSG0|;"4" 
         ;|MSG0|;"5" ;|MSG0|;"6" ;|MSG0|;"7" ;|MSG0|;"8" ;|MSG0|;"9"
         ;|MSG0|;"10" ;|MSG0|;"11" ;|MSG0|;"12" ;|MSG0|;"13"
         ;|MSG0|;"14" ;|MSG0|;"15" ;|MSG0|;"16" ;|MSG0|;"17"
         ;|MSG0|;"18") ;|MSG0|;"alt_pat")
  (setq wasmod modflag tmpsubopts anno_opts)
  (popanno)
  (makestylelist)
  (action_tile ;|MSG0|;"map_list" ;|MSG0|;"(listact)")
  (action_tile ;|MSG0|;"chg_style" ;|MSG0|;"(chgstyle)")
  (action_tile ;|MSG0|;"misc_blkg" ;|MSG0|;"(setmflag)")
  (action_tile ;|MSG0|;"230_spacing"
           ;|MSG0|;"(setq fill230val (setposlunit fill230val spc_emsg nil))")
  (action_tile ;|MSG0|;"alt_pat" ;|MSG0|;"(setaltpat)")
  (action_tile ;|MSG0|;"accept" ;|MSG0|;"(check_anno)")
  (action_tile ;|MSG0|;"cancel" 
           ;|MSG0|;"(setq anno_opts (canopt))(done_dialog 44)")
  (action_tile ;|MSG0|;"default"
           ;|MSG0|;"(setq anno_opts (nth 3 defopts))(popanno)(makestylelist)")
  (action_tile ;|MSG0|;"help" 
           ;|MSG0|;"(ait_helpdlg \"opt_optsEditor_AnnotationDialogBox\")")
  (setq what_next1 (start_dialog))
)
;;
;;
(defun check_anno ()
  (if (not (ai_num (get_tile ;|MSG0|;"230_spacing") spc_emsg 6))
    (mode_tile ;|MSG0|;"230_spacing" 2)
    (progn (waitmsg)(getanno)(rs_err)(done_dialog 43))
  )
)
;;
;;
(defun setaltpat ()
  (rs_err)
  (if (test_chg altfilval $value)
    (if (and (= $value ;|MSG0|;"0") 
         (not (ai_num (get_tile ;|MSG0|;"230_spacing") spc_emsg 6)))
      (progn (set_tile ;|MSG0|;"alt_pat" altfilval)
         (mode_tile ;|MSG0|;"230_spacing" 2))
      (progn 
    (setq altfilval $value)
    (grey_spacing)
      )
    )
  )
)
;;
;;
(defun grey_spacing (/ mode)
  (if (=  (ai_strltrim altfilval) ;|MSG0|;"0") (setq mode 1) (setq mode 0)) 
  (mode_tile ;|MSG0|;"230_spacing" mode)
)
;;
;;
(defun listact ()
  (setq pickf $value)
  (if (read $value)
    (mode_tile ;|MSG0|;"chg_style" 0)
    (mode_tile ;|MSG0|;"chg_style" 1)
  )
)
;;
;;
(defun makestylelist (/ tmplist n)
 (setq subfnt_list nil)
 (setq tmplist (catlists aslist 33 aflist))
  (foreach n tmplist
    (if (not (member n subfnt_list))
      (setq subfnt_list (append subfnt_list (list n)))
    )
  )
  (setq subfnt_list (sortmax subfnt_list))
)
;;
;; This function manages the AutoCAD Styles dialogue.
(defun chgstyle (/ subfnt_tlist shx_fn apickf)
  (if (not (new_dialog ;|MSG0|;"styledia" dcl_id))(exit))
  (setlist (setq subfnt_tlist subfnt_list) ;|MSG0|;"subfnt_list")
  (stylelistact T)
  (action_tile ;|MSG0|;"subfnt_list" ;|MSG0|;"(stylelistact nil)")
  (action_tile ;|MSG0|;"chg_shape" ;|MSG0|;"(chgshxfile)")
  (action_tile ;|MSG0|;"accept" ;|MSG0|;"(updstyle)(done_dialog 45)")
  (action_tile ;|MSG0|;"cancel" ;|MSG0|;"(done_dialog 46)")
  (setq what_next1 (start_dialog))
  (setlist fontmap_list ;|MSG0|;"map_list")
  (set_tile ;|MSG0|;"map_list" pickf)
)
;;
;;
(defun updstyle ()
  (newsub (strcase (get_tile ;|MSG0|;"new_style")) 
      (get_tile ;|MSG0|;"shxfile_name"))
  (updfontlist (strcase (get_tile ;|MSG0|;"new_style")))
)
;;
;;
(defun updfontlist (subfont / pickf_no tmpstr tmppck fn)
  (setq tmppck pickf)
  (while (setq pickf_no (read tmppck))
    (setq tmpstr (nth pickf_no fontmap_list))
    (setq fn (+ 1 (strwth tmpstr)))
    (setq fontmap_list
      (subst (strcat (substr tmpstr 1 fn) subfont)
         tmpstr
         fontmap_list)
    )
    (setq tmppck (substr tmppck (+ 2 (strlen (itoa pickf_no)))))
  )
  (setq subfnt_list subfnt_tlist)
  (setmflag)
)
;;
;; Searches to see if the style exists in the list
;; and adds it if it doesn't, replaces it if it does.
;; It ensures only unique style names are included in the subfnt_tlist.
(defun newsub (subname filename / tmpstr inlist oldstr)
  (setq inlist nil)
  (foreach tmpstr subfnt_tlist
    (if (= subname (substr tmpstr 1 (strwth tmpstr)))
      (setq inlist 1 
        oldstr tmpstr))
  )
  ;; Add mapping to the list if not already in it.
  (if (not inlist)
    (setq subfnt_tlist
      (sortmax (append (list (strcat subname ;|MSG0|;"\t" filename))
                 subfnt_tlist))
    )
    ;; otherwise update the list with the new mapping.
    (setq subfnt_tlist
      (subst (strcat subname ;|MSG0|;"\t" filename)
         oldstr subfnt_tlist))
  )
)
;;
;;
(defun updfilename (colwth newfile / tmpstr)
  (setq tmpstr (nth (atoi apickf) subfnt_tlist))
  (if (= (ai_strrtrim (substr tmpstr 1 colwth))
     (ai_strrtrim (get_tile ;|MSG0|;"new_style")))
    (progn
      (setq subfnt_tlist
        (subst (strcat (substr tmpstr 1 colwth) newfile)
           tmpstr
           subfnt_tlist)
      )
      (setlist subfnt_tlist ;|MSG0|;"subfnt_list")
      (set_tile ;|MSG0|;"subfnt_list" apickf)
    )
  )
)
;;
;;
(defun stylelistact (init / temp n)
  (rs_err)
  (if init
    (progn
      (setq temp (subfield 2 (read pickf) fontmap_list))
      (setq n 0)
      (while (/= (subfield 1 n subfnt_list) temp)
    (setq n (1+ n))
      )
      (set_tile ;|MSG0|;"subfnt_list" (setq apickf (itoa n)))
    )
    (setq apickf $value)
  )
  (set_tile ;|MSG0|;"new_style" (subfield 1 (atoi apickf) subfnt_tlist))
  (set_tile ;|MSG0|;"shxfile_name" (subfield 2 (atoi apickf) subfnt_tlist))
  (if (= $reason 4)
    (progn (updstyle)(done_dialog 45))
    (mode_tile ;|MSG0|;"accept" 0)
  )
)
;;
;; This function gets the start column for a string in a list.
;;
(defun subcolumn (col the_list / n tmplist)
  (setq tmplist nil)
  (foreach tmpstr the_list
    (setq tmplist
      (append tmplist
          (list (substr tmpstr
                (setq n (col_start col tmpstr))
                (strwth (substr tmpstr n))
                )
          )
      )
    )
  )  
)
;;
;;  This function gets the width of the substring in a list.
;;
(defun strwth (str / n)
  (setq lng (strlen str))
  (setq n 1)
  (while (and (not (= lng (1- n))) (not (= ;|MSG0|;"\t" (substr str n 1))))
    (setq n (1+ n))
  )    
  (1- n)
)
;;
;;
;;
(defun subfield (col recno the_list / tmpstr cnt)
  (setq tmpstr (nth recno the_list))
  (substr tmpstr (setq cnt (col_start col tmpstr)) (strwth (substr tmpstr cnt)))
)
;;
;;
(defun chgshxfile ( / tf)
  (setq tf (strcat (get_tile ;|MSG0|;"shxfile_name") ;|MSG0|;".shx"))
  (if (setq tf (getfiled ;|MSG21|;"Select Shape File" tf ;|MSG0|;"shx;pfb;pfa;ttf" 12))
    (if (test_chg shx_fn tf)
      (progn
    (set_tile ;|MSG0|;"shxfile_name" (setq shx_fn tf))
    (updfilename 33 shx_fn)
      )
    )
  )
)
;;
;;
(defun popanno ( / tfcount tmplist)
  (setq tfcount (car anno_opts))
  (setq tmplist (mapcar (quote itoa) (setq iflist (cadr anno_opts))))
  (foreach n dfont_list (setq tmplist (subst n (itoa (read n)) tmplist)))
  (setq aslist (caddr anno_opts))
  (setq aflist (nth 3 anno_opts))
  (setq fontmap_list (catlists tmplist 24 aslist))
  (setlist fontmap_list ;|MSG0|;"map_list")
  (mode_tile ;|MSG0|;"chg_style" 1)
  (set_tile ;|MSG0|;"misc_blkg" (itoa (nth 4 anno_opts)))
  (set_tile ;|MSG0|;"alt_pat" (setq altfilval (itoa (nth 5 anno_opts))))
  (set_tile ;|MSG0|;"230_spacing" (setq fill230val (rtos (nth 6 anno_opts))))
  (grey_spacing)
)
;;
;;
(defun catlists (firstlist colwidth secondlist)
  (mapcar (quote (lambda (first second)
        (strcat first ;|MSG0|;"\t" second)))
         firstlist
         secondlist)
)
;;
;;
(defun col_start (col str / n)
  (setq n 0)
  (if (= col 1)
    col
    (+ 
      (repeat (- col 1)
    (setq n (+ n 1))
    (while (not (equal ;|MSG0|;"\t" (substr str n 1)))
      (setq n (+ n 1))
    )
      ) 
      1
    )
  )
)
;;
;; This function updates the annotation options list from the values
;; obtained from the dialogue.
(defun getanno (/ n listlg flist)
  (setq aslist (subcolumn 2 fontmap_list))
  ;; Initialize style shape file list to the list of styles.
  (setq aflist aslist)
  ;; With each style mapping, replace the corresponding style in the aflist
  ;; by breaking the mapping into the stylename and the font file, which
  ;; are separated by white space and a tab character.
  (foreach n subfnt_list
    (setq aflist (subst (ai_strltrim (substr n (+ 2 (strwth n))))
            (ai_strrtrim (substr n 1 (strwth n)))
            aflist))
  )
  (setq anno_opts (list (length iflist) iflist aslist aflist
            (atoi (get_tile ;|MSG0|;"misc_blkg")) (atoi altfilval)
            (atof fill230val) (nth 7 anno_opts)))
)
;;
;;
(defun setmflag ()
  (setq modflag 1)
)
;;
;;
(defun demapmenu (/ pickf ilflist altlist alflist lfcode
  altcode alfcode fontmap_list)
  (if (not (new_dialog ;|MSG0|;"demapopts" dcl_id))(exit))
  (setq lineflist (list ;|MSG22|;"0 None"
            ;|MSG23|;"1 Solid"
            ;|MSG24|;"2 Dashed"
            ;|MSG25|;"3 Phantom"
            ;|MSG26|;"4 Centerline"
            ;|MSG27|;"5 Dotted"))
  (setq wasmod modflag tmpsubopts demap_opts)
  (popdemap)
  (setq pickf (get_tile ;|MSG0|;"map_list"))
  (action_tile ;|MSG0|;"lin_color" ;|MSG0|;"(setmflag)")
  (action_tile ;|MSG0|;"map_list" 
           ;|MSG0|;"(setq pickf $value)(if (= $reason 4) (chgltype))")
  (action_tile ;|MSG0|;"get_ltype" ;|MSG0|;"(chgltype)")
  (action_tile ;|MSG0|;"accept" 
           ;|MSG0|;"(waitmsg)(getdemap)(rs_err)(done_dialog 45)")
  (action_tile ;|MSG0|;"cancel" 
           ;|MSG0|;"(setq demap_opts (canopt))(done_dialog 46)")
  (action_tile ;|MSG0|;"default" 
           ;|MSG0|;"(setq demap_opts (nth 4 defopts))(popdemap)")
  (action_tile ;|MSG0|;"help" 
           ;|MSG0|;"(ait_helpdlg \"opt_optsEditor_DEMappingDialogBox\")")
  (setq what_next1 (start_dialog))
)
;;
;; This function loads the AutoCAD Linetypes (ltypedia) dialogue.
;;
(defun chgltype (/ subfnt_list apickf special llist)
  (if (not (new_dialog ;|MSG0|;"ltypedia" dcl_id))(exit))
  (setq special (list ;|MSG0|;"BYBLOCK" ;|MSG0|;"BYLAYER" ;|MSG0|;"CONTINUOUS"))
  (set_tile ;|MSG0|;"lt_name" (subfield 2 (read pickf) fontmap_list))
  (if (/= ;|MSG0|;"" (setq lin_fname (subfield 3 (read pickf) fontmap_list)))
    (set_tile ;|MSG0|;"ltfile_name" (strpext lin_fname))
  )
  (makeltlist)
  (action_tile ;|MSG0|;"subfnt_list" ;|MSG0|;"(ltact)")
  (action_tile ;|MSG0|;"lt_file" ;|MSG0|;"(ldlfile)")
  (action_tile ;|MSG0|;"accept" ;|MSG0|;"(updlflist)(done_dialog 45)")
  (action_tile ;|MSG0|;"cancel" ;|MSG0|;"(done_dialog 46)")
  (setq what_next1 (start_dialog))
  (setlist fontmap_list ;|MSG0|;"map_list")
  (set_tile ;|MSG0|;"map_list" pickf)
)
;;
;;
(defun ltact ()
  (rs_err)
  (set_tile ;|MSG0|;"lt_name" (nth (atoi (setq apickf $value)) subfnt_list))
  (if (= $reason 4)
    (progn (updlflist)(done_dialog 45))
    (mode_tile ;|MSG0|;"accept" 0)
  )
)
;;
;;
(defun updlflist (/ pickf_no tmpstr tmppck ltstr ltfile ltc ltname n slen)
  (setq tmppck pickf)
  (while (setq pickf_no (read tmppck))
    (setq tmpstr (nth pickf_no fontmap_list))
    (if (>= 3 (read apickf))
      (progn 
    (setq ltname (get_tile ;|MSG0|;"lt_name"))
    ;; find first white space in string
    (setq n 1)
    (setq slen (strlen ltname))
    (while (and (< n slen) 
            (/= ;|MSG0|;"\t" (substr ltname n 1)) 
            (/= ;|MSG0|;" " (substr ltname n 1)))
      (setq n (1+ n))
    )
    (if (/= n slen)
      (setq n (1- n)))
    ;; extract linetype name
    (setq ltstr (substr ltname 1 n))
      )
      (setq ltstr (nth (- (read apickf) 3) llist))
    )
    (if (member ltstr special)
      (setq ltfile ;|MSG0|;"")
      (setq ltfile (strcat (get_tile ;|MSG0|;"ltfile_name") ;|MSG0|;".lin"))
    )
    (setq ltc (+ 1 (strwth tmpstr)))
    (setq fontmap_list
      (subst (strcat (substr tmpstr 1 ltc) ltstr ;|MSG0|;"\t" ltfile)
        tmpstr
        fontmap_list)
    )
    (setq tmppck (substr tmppck (+ 2 (strlen (itoa pickf_no)))))
  )
  (setmflag)
)
;;
;;
(defun makeltlist ()
  (if (= ;|MSG0|;"" lin_fname) (setq lin_fname ;|MSG0|;"acad.lin"))
  (set_tile ;|MSG0|;"ltfile_name" (strpext lin_fname))
  (if (setq subfnt_list (mk_readf lin_fname))
    (setlist (setq subfnt_list (append special subfnt_list)) 
         ;|MSG0|;"subfnt_list")
    (set_tile ;|MSG0|;"error" 
          (strcat ;|MSG28|;"Cannot read linetype file: " fname))
  )
  (mode_tile ;|MSG0|;"accept" 1)
)
;;
;;
(defun ldlfile ( / tmp)
  (setq tmp lin_fname)
  (if (setq tmp (getfiled ;|MSG29|;"Use Linetype File" tmp ;|MSG0|;"lin" 14))
    (if (test_chg lin_fname tmp)
      (progn
    (setq lin_fname tmp)
    (set_tile ;|MSG0|;"lt_name" ;|MSG0|;"")
    (makeltlist)
      )
    )
  )
)
;;
;; Reads the linetypes and descriptions from <fname>
;; and returns a linetype list with descriptions
;;
(defun mk_readf (fname / n fh lname desc desclist tlist)
  (setq llist nil desclist nil)
  (setq fh (open (findfile fname) ;|MSG0|;"r") n (read-char fh))
  (set_tile ;|MSG0|;"error" ;|MSG30|;"... reading file")
  ; Parse the file
  (while (while (and n (/= n 42)) (setq n (read-char fh))) ; next '*' or EOF
    (setq lname ;|MSG0|;"")
    (while (and (/= 44 (setq n (read-char fh))) (/= 10 n))  ; find comma or LF
      (setq lname (strcat lname (chr n)))
    )
    (setq desc ;|MSG0|;"")
    (if (= n 44)  ; Get Description if a comma
      (while (/= 10 (setq n (read-char fh))) ; read up to LF
    (setq desc (strcat desc (chr n)))
      )
    )
    (setq llist (append (list lname) llist))
    (setq desclist (append  (list desc) desclist))
  )
  (close fh)
  (rs_err)
  (setq tlist (sortmax (catlists llist 16 desclist)))
  (setq llist (sortmax llist))
  tlist
)
;;
;; sort in accordance with maxsort.
;;
(defun sortmax (sort_list)
  (if (>= (getvar ;|MSG0|;"MAXSORT") (length sort_list))    
    (acad_strlsort sort_list)
    sort_list
  )
)
;;
;; 
(defun popdemap (/ tmplist tfcount)
  (set_tile ;|MSG0|;"lin_color" (itoa (car demap_opts)))
  (setq tfcount (cadr demap_opts))
  (setq tmplist (mapcar (quote itoa) (setq ilflist (caddr demap_opts))))
  (foreach n lineflist (setq tmplist (subst n (itoa (read n)) tmplist)))
  (setq altlist (cadddr demap_opts))
  (setq alflist (nth 4 demap_opts))
  (setq fontmap_list (catlists (catlists tmplist 15 altlist) 46 alflist))
  (setlist fontmap_list ;|MSG0|;"map_list")
  (set_tile ;|MSG0|;"map_list" ;|MSG0|;"0")
)
;;
;;
(defun getdemap ()
  (setq altlist (subcolumn 2 fontmap_list))
  (setq alflist (subcolumn 3 fontmap_list))
  (setq demap_opts
    (list (atoi (get_tile ;|MSG0|;"lin_color")) 
          (length ilflist) ilflist altlist alflist))
)
;;
;;
(defun grey_log (/ mode)
  (if (= (get_tile ;|MSG0|;"yes_log") ;|MSG0|;"1")
    (setq mode 0)
    (setq mode 1)
  )
  (mode_tile ;|MSG0|;"log_loc" mode)
  (grey_logdir mode)
)
;;
;;
(defun grey_logdir (mode)
  (if (and (= mode 0) (= (get_tile ;|MSG0|;"log_loc") ;|MSG0|;"iges_file"))
    (setq mode 1)
  )
  (mode_tile ;|MSG0|;"log_dir" mode)
)
;;
;;
(defun grey_evm (mode)
  (if (= mode 1)
    (setq mode 0)
    (setq mode 1)
  )
  (mode_tile ;|MSG0|;"evm_pass" mode)
)
;;
;;
(defun miscmenu (/ logpathval xedtrace no_thk_102 trace acadent
           anno_angtol anno_pttol adesk_idp msg_quota)
  (if (not (new_dialog ;|MSG0|;"miscopts" dcl_id))(exit))
  (popmisc)
  (setq wasmod modflag tmpsubopts misc_opts)
  (action_tile ;|MSG0|;"yes_log" ;|MSG0|;"(grey_log)(setmflag)")
  (action_tile ;|MSG0|;"log_loc" ;|MSG0|;"(setlogloc)")
  (action_tile ;|MSG0|;"log_dir" ;|MSG0|;"(chglogdir)(setmflag)")
  (action_tile ;|MSG0|;"xform_mtx" ;|MSG0|;"(setmflag)")
  (action_tile ;|MSG0|;"evm_proc" ;|MSG0|;"(grey_evm (atoi $value))(setmflag)")
  (action_tile ;|MSG0|;"evm_pass" ;|MSG0|;"(setmflag)")
  (action_tile ;|MSG0|;"blk_copdata" ;|MSG0|;"(setmflag)")
  (action_tile ;|MSG0|;"tru_names" ;|MSG0|;"(setmflag)")
  (action_tile ;|MSG0|;"de_xed" ;|MSG0|;"(setmflag)")
  (action_tile ;|MSG0|;"accept" ;|MSG0|;"(check_misc)")
  (action_tile ;|MSG0|;"cancel" 
           ;|MSG0|;"(setq misc_opts (canopt))(done_dialog 48)")
  (action_tile ;|MSG0|;"default" 
           ;|MSG0|;"(setq misc_opts (nth 5 defopts))(popmisc)")
  (action_tile ;|MSG0|;"help" 
           ;|MSG0|;"(ait_helpdlg \"opt_optsEditor_MiscDialogBox\")")
  (setq what_next1 (start_dialog))
)
;;
;;
(defun check_misc ()
  (cond
    ((not (chkdir (get_tile ;|MSG0|;"log_dir")))
      (mode_tile ;|MSG0|;"log_dir" 2))
    (t (waitmsg)(getmisc)(rs_err)(done_dialog 47))
  )
)
;;
;;
(defun setlogloc ()
  (if (chkdir (get_tile ;|MSG0|;"log_dir"))
    (progn
      (grey_logdir 0)
      (if (= (get_tile ;|MSG0|;"log_loc") ;|MSG0|;"spec_loc")
    (mode_tile ;|MSG0|;"log_dir" 2)
      )
      (setmflag)
    )
    (progn
      (set_tile ;|MSG0|;"log_loc" ;|MSG0|;"spec_loc")
      (mode_tile ;|MSG0|;"log_dir" 2)
    )
  )
)
;;
;;
(defun chglogdir ()
  (if (chkdir $value)
    (Progn
      (setq logpathval (delendslash $value))
      (rs_err)
    )
    (set_tile ;|MSG0|;"error" invdir)
  )
)
;;
;;
(defun popmisc (/ temp)
  (if (= ;|MSG0|;"" (setq logpathval (cadr misc_opts)))
    (set_tile ;|MSG0|;"log_loc" ;|MSG0|;"iges_file")
    (progn
      (set_tile ;|MSG0|;"log_loc" ;|MSG0|;"spec_loc")
      (set_tile ;|MSG0|;"log_dir" logpathval)
    )
  )
  (set_tile ;|MSG0|;"yes_log" (itoa (car misc_opts)))
  (grey_log)
  (setq temp (caddr misc_opts))
  (cond
    ((= temp 0)(set_tile ;|MSG0|;"evm_proc" ;|MSG0|;"1")
           (set_tile ;|MSG0|;"evm_pass" ;|MSG0|;"1")
           (grey_evm 1))
    ((= temp 1)(set_tile ;|MSG0|;"evm_proc" ;|MSG0|;"1")
           (set_tile ;|MSG0|;"evm_pass" ;|MSG0|;"0")
           (grey_evm 1))
    ((= temp 2)(set_tile ;|MSG0|;"evm_proc" ;|MSG0|;"0")
           (set_tile ;|MSG0|;"evm_pass" ;|MSG0|;"0")
           (grey_evm 0))
    (t nil)
  )
  (setq xedtrace (nth 3 misc_opts))
  (set_tile ;|MSG0|;"de_xed" (itoa (boole 1 1 xedtrace))) ; test 1st bit flag
  (if (= 1 (nth 4 misc_opts))
    (set_tile ;|MSG0|;"tru_names" ;|MSG0|;"tru_end")
    (set_tile ;|MSG0|;"tru_names" ;|MSG0|;"tru_begin")  ; default
  ) 
  (setq temp (nth 5 misc_opts))
  (cond
    ((= temp 0)(set_tile ;|MSG0|;"xform_mtx" ;|MSG0|;"mtx_named"))
    ((= temp 1)(set_tile ;|MSG0|;"xform_mtx" ;|MSG0|;"mtx_all"))
    (t (set_tile ;|MSG0|;"xform_mtx" ;|MSG0|;"mtx_none")) ; default
  )
  (set_tile ;|MSG0|;"blk_copdata" (itoa (nth 6 misc_opts)))
  (setq no_thk_102 (nth 7 misc_opts))
  (setq trace (nth 8 misc_opts))
  (setq acadent (nth 9 misc_opts))
  (setq anno_angtol (nth 10 misc_opts))
  (setq anno_pttol (nth 11 misc_opts))
  (setq adesk_idp (nth 12 misc_opts))
  (setq msg_quota (nth 13 misc_opts))
)
;;
;;
(defun getmisc (/ evmval truncn xmtx)
  (if (= ;|MSG0|;"iges_file" (get_tile ;|MSG0|;"log_loc"))
    (setq logpathval ;|MSG0|;"")
  )
  (if (= ;|MSG0|;"1" (get_tile ;|MSG0|;"evm_proc"))
    (if (= ;|MSG0|;"1" (get_tile ;|MSG0|;"evm_pass"))
      (setq evmval 0)
      (setq evmval 1)
    )
    (setq evmval 2)
  )
  (if (= ;|MSG0|;"tru_end" (get_tile ;|MSG0|;"tru_names"))
    (setq truncn 1)
    (setq truncn 0)  ; Default = tru_begin
  )
  (setq xmtx (get_tile ;|MSG0|;"xform_mtx"))
  (cond
    ((= xmtx ;|MSG0|;"mtx_none") (setq xmtx 2))
    ((= xmtx ;|MSG0|;"mtx_all") (setq xmtx 1))
    (t (setq xmtx 0))  ; default
  )
  (if (= (get_tile ;|MSG0|;"de_xed") ;|MSG0|;"1")
    (setq xedtrace (boole 7 1 xedtrace)) ; set 1st bit flag
    (setq xedtrace (boole 1 (1- xedtrace) xedtrace)) ; unset 1st bit flag
  )
  (setq misc_opts (list (atoi (get_tile ;|MSG0|;"yes_log"))
            logpathval evmval xedtrace truncn xmtx 
            (atoi (get_tile ;|MSG0|;"blk_copdata")) 
            no_thk_102 trace acadent anno_angtol anno_pttol
            adesk_idp msg_quota))
)
;;
;;
(defun setpick ()
  (if fp_list
    (set_tile ;|MSG0|;"fp_list" (setq pickf ;|MSG0|;"0" pickdwgf ;|MSG0|;"0"))
    (setq pickf ;|MSG0|;"" pickdwgf ;|MSG0|;"")
  )
  (grey_modes)
)
;;
;;
(defun setdwgpath ()
  (if (chkdir (get_tile ;|MSG0|;"outdir"))
    (progn
      (greydir T)
      (if (= (get_tile ;|MSG0|;"dwg_path") ;|MSG0|;"spec_path")
    (mode_tile ;|MSG0|;"outdir" 2)
      )
      (setmflag)
    )
    (progn
      (set_tile ;|MSG0|;"dwg_path" ;|MSG0|;"spec_path")
      (mode_tile ;|MSG0|;"outdir" 2)
    )
  )
)
;;
;;
(defun check_mode ()
  (cond
    ((not (chkdir (get_tile ;|MSG0|;"outdir")))
      (set_tile ;|MSG0|;"error" invdir)
      (set_tile ;|MSG0|;"input_mode" ;|MSG0|;"batch")
      (mode_tile ;|MSG0|;"outdir" 2)
    )
    (t 
      (switchmode $value)
    )
  )
)
;;
;;
(defun check_out ()
  (cond
    ((and (= tmode ;|MSG0|;"1")  ;; batch mode
           (not (chkdir (get_tile ;|MSG0|;"outdir")))
     )
      (mode_tile ;|MSG0|;"outdir" 2)
      (set_tile ;|MSG0|;"error" invdir)
    )
    (t 
      (checkdwglist)
      (if (= canflag 0)
    (progn
      (if fp_list
        (progn
          (save_list)
          (setq proceed 1)
        )
      )
      (done_dialog 1)
    )
      )
    )
  )
)
;; About IGESIN
(defun ai_about ( / about)
  (if (not (new_dialog ;|MSG0|;"about" dcl_id))(exit))
  (ait_rxload ;|MSG0|;"igesin" igesin)
  (setq about (about_igesin))
  (if (/= nil about)
    (ait_about about ;|MSG0|;"IGESIN")
  )
  (ait_rxunload ;|MSG0|;"igesin" igesin)
  (setq what_next1 (start_dialog))
)
;;
;; Initialization
;;
  (setq tmp_list nil sfp_list nil
    dname    nil mfp_list nil
    proceed  nil tmode    ;|MSG0|;"0"
    lfiles   0   canflag  0
    fname    ;|MSG0|;"")
 
  (setq soptname (setq moptname defs))
 
  ;;; Load DCL files and exit if not available.
  (if (not (setq dcl_id (ai_dcl ;|MSG0|;"igesin"))) (exit))
  (if (not (new_dialog ;|MSG0|;"igesin" dcl_id)) (exit))

  (if (not (read_fls))
    (set_tile ;|MSG0|;"error" ;|MSG31|;"Error reading igesin.cfg file.")
  )

  (if dname
    (progn
      (set_tile ;|MSG0|;"outdir" (delendslash dname))
      (set_tile ;|MSG0|;"dwg_path" ;|MSG0|;"input_path")
    )
    (progn
      (set_tile ;|MSG0|;"outdir" 
        (setq dname (delendslash (getvar ;|MSG0|;"DWGPREFIX"))))
      (set_tile ;|MSG0|;"dwg_path" ;|MSG0|;"spec_path")
    )
  )

  (getallopts nil)  ; get default options

  (if (= tmode ;|MSG0|;"0")
    (set_tile ;|MSG0|;"input_mode" ;|MSG0|;"input1")
    (set_tile ;|MSG0|;"input_mode" ;|MSG0|;"batch")
  )
  (switchmode tmode)
  
  (action_tile ;|MSG0|;"input_mode" ;|MSG0|;"(rs_err)(check_mode)")
  (action_tile ;|MSG0|;"fp_list" 
    ;|MSG0|;"(rs_err)(setq pickf $value)(setq pickdwgf pickf) (if (= tmode \"1\")(set_tile \"dwg_list\" pickf))(greylists)")
  (action_tile ;|MSG0|;"dwg_list" 
    ;|MSG0|;"(rs_err)(setq pickdwgf $value) (set_tile \"fp_list\" pickdwgf)(setq pickf pickdwgf)(greylists)")
  (action_tile ;|MSG0|;"add_to_list" ;|MSG0|;"(rs_err)(addfile)")
  (action_tile ;|MSG0|;"out_file" ;|MSG0|;"(mod_dwgname)")
  (action_tile ;|MSG0|;"del_cur_out" ;|MSG0|;"(rs_err)(remfile)(greylists)")
  (action_tile ;|MSG0|;"clr_all" ;|MSG0|;"(clr_all)")
  (action_tile ;|MSG0|;"dwg_path" ;|MSG0|;"(setdwgpath)")
  (action_tile ;|MSG0|;"outdir" ;|MSG0|;"(chgdir)")
  (action_tile ;|MSG0|;"cur_opt" ;|MSG0|;"(chgoption)")
  (action_tile ;|MSG0|;"menu_options" ;|MSG0|;"(optmenu)")
  (action_tile ;|MSG0|;"cancel" 
    ;|MSG0|;"(ait_rxunload \"igesgui\" ISXOGI) (ait_rxunload \"igesin\" igesin)(done_dialog 0)")
  (action_tile ;|MSG0|;"accept" ;|MSG0|;"(check_out)")
  (action_tile ;|MSG0|;"help" ;|MSG0|;"(ait_helpdlg \"maindiag_igesin\")")
  (action_tile ;|MSG0|;"about" ;|MSG0|;"(waitmsg)(ai_about)(rs_err)")
  (setq what_next1 (start_dialog))
  ;(del_tmps)
  (ait_rxunload ;|MSG0|;"igesgui" ISXOGI)
  (if (= optname curr)
    (setq optname ;|MSG0|;"tmpiges.opt"))
  (if proceed
    (cond
      ((= tmode ;|MSG0|;"0")
    (ait_rxload ;|MSG0|;"igesin" igesin)
    (igesin (car fp_list) optname)
    (ait_rxunload ;|MSG0|;"igesin" igesin)
      )
      ((= tmode ;|MSG0|;"1")
    (setq scrpath (strcat (strpfn (car dwg_list)) ;|MSG0|;"igesin.scr"))
    (setq f1 (open scrpath ;|MSG0|;"w"))
    (setq fcount 0)
    (foreach n fp_list
      (setq nextfn (revbackslash 
          (strcat (nth fcount dwg_list) ;|MSG0|;".dwg")))
      ;; Create script line to start a new drawing, discarding any changes,
      ;; and replacing any existing drawing, if necessary.
      (write-line (strcat
          ;|MSG0|;"(if (= (getvar \"DBMOD\") 0)(command \"_.new\" \"\")"
          ;|MSG0|;"(command \"_.new\" \"_y\" \"\"))"
        ) f1)
      ;; Create script lines to load, execute, and unload IGESIN.
      (write-line ;|MSG0|;"(arxload \"igesin\")" f1)
      (write-line (strcat ;|MSG0|;"(igesin \""
                  (revbackslash n)
                  ;|MSG0|;"\" \""  
                  (revbackslash optname)  
                  ;|MSG0|;"\")") f1)
      (write-line (strcat
          ;|MSG0|;"(if (findfile \""
          nextfn
          ;|MSG0|;"\")(setq tmpyn \"_y\")(setq tmpyn NIL))") f1)
      (write-line ;|MSG0|;"_.save" f1)
      (write-line (strcat "\"" nextfn "\"") f1)
      (write-line ;|MSG0|;"(if (not (null tmpyn))(command tmpyn))" f1) 
      (write-line ;|MSG0|;"(arxunload \"igesin\")" f1)
      (setq fcount (1+ fcount))
    )
    (close f1)
      )
    )
  )
  (setvar ;|MSG0|;"cmdecho" old_cmd)
  (setq *error* old_error)
  (if (and proceed (= tmode ;|MSG0|;"1")) 
    (command ;|MSG0|;"_.script" scrpath))
)
(princ ;|MSG32|;"  IGESIN loaded.\n")
(princ)

;;;-----BEGIN-SIGNATURE-----
;;; 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEE+U0vr78xSzq0vXnmuWytEw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMjAwNjE1MDAwMDAwWhcNMjEwODEyMjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBAMt3bX7WxfbqKZpcgiX4jvJBSg6MCucqh4aDRHA8
;;; Hny4Fc2vKP+Xgn3mY4qtHoeNZ/j4d669d5+guDfOpD7jZX/JyR81wLE22GwswGLN
;;; M6n3N6Vudo0PcdCNXRxccGdPmJMIiEZNp84RjWN7Gy0JfgChxNiNEWS+Dezr5cYK
;;; B7UlGjGivbUdK6/HP0JlO3t3QxXYERASgPWj6YXmHGdvYHPBNit1MJTLRUj7uXyk
;;; bWzpaQEnXdey73yxg+FV2us0BicMIChoDXdTY/uAWbhkThET8GffQd08miZDNWMv
;;; IUIfFEkKjGZX6VkfkK/ShlVtjcdYlknpatvAtkFuYnQm6mECAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBACiY
;;; IcU6uh5Lz5MGiUDT3w+daDMfYW44/ak/wMK1SgkL+iHzsgHaY8plDqZ4oaxT3U45
;;; /L5BdedSZWIvR738xpjcJNKZVILKTMg3mzl0bjO/t91dj5TFlTSpCbQgBh+jbBpJ
;;; R0il59VeZ9LQTvK/2E41TK89VHXZa+8MaTrsVOyTsBuAnNdYdzzExmAqp1BZdirH
;;; JH35aOAnZz3nkcGS4knKOAc7EX8pLkhAl4UDoS2V+2MKw5IXpYO3tU5TwM7y8uGZ
;;; gj/XpMlzWXtVQvOVpwgmT0XCymP5174BFyTP1SLNhlUWUfwFCypOY6tRHd6U9uqc
;;; BATajxbYoRpvjWl9Nu8xggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQT5TS+vvzFLOrS9eea5bK0TANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQA46yNB4SJ+1I1XN+But34XxVr3R7E8FIV/
;;; OVedXKJ0hsFnusMYzrPD1J+ZE68Gb79o1ZqI4mPWz4yn4BrUpj92KDN2CiVstJCZ
;;; HEHKuGbPet08wD65uEZPtLb6pVIevCA3B/NCSlfYRiTQqA858UKwjc2Re3R1N174
;;; mX+8zNWqRPhF8knfdFJxrPC56yJcyGhR4va+jU8ZECps1vljhQH8YdseI4NT1naL
;;; CMu4kghi3TyX63436lrlGNBOwpt3nF/wH5o4E5uqPwV53npW42D4HB7X1YnCHEEP
;;; DbsKQSZ3JlDHdXWg9uiEiwnnuehf+5j0/91c2Gk1n4A10uDqhmCb
;;; -----END-SIGNATURE-----