; Next available MSG number is 21 
; MODULE_ID IGES_LSP_
;;;----------------------------------------------------------------------------
;;;
;;;   IGES.LSP
;;;   Copyright (C) 1991-1996 by Autodesk, Inc.
;;;
;;;   Permission to use, copy, modify, and distribute this software
;;;   for any purpose and without fee is hereby granted, provided
;;;   that the above copyright notice appears in all copies and that
;;;   both that copyright notice and this permission notice appear in
;;;   all supporting documentation.
;;;
;;;   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED
;;;   WARRANTY.  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR
;;;   PURPOSE AND OF MERCHANTABILITY ARE HEREBY DISCLAIMED.
;;;
;;;----------------------------------------------------------------------------
;;;
;;;=== AutoCAD IGES Translator Functions ===

(autoload ;|MSG0|;"igesin"  (quote (;|MSG0|;"igesin" ;|MSG0|;"-igesin")))
(autoload ;|MSG0|;"igesout" (quote (;|MSG0|;"igesout" ;|MSG0|;"-igesout")))

(defun ait_startup ( / f tmpfn in out platform)
  (setvar ;|MSG0|;"cmdecho" 0)
  ;; Localization on the fly
  (setq in (getcname ;|MSG0|;"_igesin"))
  (setq out (getcname ;|MSG0|;"_igesout"))
  (if (and (not (eq ;|MSG0|;"IGESIN" in)) (not (eq ;|MSG0|;"_IGESIN" in)))
    (progn
      ;; Open the aitloc.lsp file for localizing the command names
      (setq tmpfn ;|MSG0|;"aitloc.lsp")
      (setq f (open tmpfn ;|MSG0|;"w"))
      (write-line (strcat ;|MSG0|;"(command \"_.undefine\" \"" in ;|MSG0|;"\" )") f)
      (write-line (strcat ;|MSG0|;"(defun c:" in ;|MSG0|;" () (c:igesin))") f)
      (write-line (strcat ;|MSG0|;"(command \"_.undefine\" \"" out ;|MSG0|;"\" )") f)
      (write-line (strcat ;|MSG0|;"(defun c:" out ;|MSG0|;" () (c:igesout))") f)
      (close f)
      (load tmpfn)
    )
    (progn
      (command ;|MSG0|;"_.undefine" ;|MSG0|;"igesin")
      (command ;|MSG0|;"_.undefine" ;|MSG0|;"igesout")
    )
  )
  ;;   Also, define 'help functions
  (setq platform (getvar ;|MSG0|;"PLATFORM"))
  (if (eq ;|MSG0|;"Microsoft" (substr platform 1 9))
      (progn
        (setfunhelp "c:igesin"  "iges.hlp" "cmdline_main")
        (setfunhelp "c:igesout" "iges.hlp" "cmdline_main")
        (setfunhelp "c:igesval" "iges.hlp" "tool_igesval")
      )
      (progn
        (setfunhelp "c:igesin"  "iges.ahp" "cmdline_main")
        (setfunhelp "c:igesout" "iges.ahp" "cmdline_main")
        (setfunhelp "c:igesval" "iges.ahp" "tool_igesval")
      )
  )

  ;;;load the menu/toolbars, but don't show them.
  (setvar ;|MSG0|;"cmdecho" 0)
  (princ)

  (if (eq (menugroup ;|MSG0|;"DataExchange") nil)
	(command  "_.MENULOAD" "DEG")
  )
  (setvar ;|MSG0|;"cmdecho" 1)
)

(if s::startup
  (setq s::startup (append s::startup (quote ((ait_startup))) ))
  (defun s::startup () (ait_startup) )
)

;;
;; Common igesin and igesout functions follow.
;;

;;; ===================== AIT load-time error checking ========================
(defun ait_abort (app msg aitfn aittfn)
; app = application name
; msg = error message
; aitfn = IGES translator executable (igesin/igesout) for (arxunload)
; aittfn = test function for (ait_rxunload)
  (defun *error* (s)
    (if old_error (setq *error* old_error))
    (princ)
  )
  (if msg
    (alert (strcat ;|MSG1|;" Application error: " app 
                   ;|MSG0|;" \n\n  " msg 
                   ;|MSG0|;"  \n"))
  )
  (ait_rxunload ;|MSG0|;"igesgui" ISXOGI)
  (ait_rxunload aitfn aittfn)
  (exit)
)

;;;
;;; Checks CMDACTIVE and post an alert if the calling routine
;;; should not be called in the current CMDACTIVE state. The
;;; argument flags is the sum of the CMDACTIVE flags to be tested.
;;; CMDACTIVE flags are:
;;;
;;;           1 - Ordinary command active.
;;;           2 - Ordinary and transparent command active.
;;;           4 - Script file active.
;;;           8 - Dialogue box active.
;;;
(defun ait_cmdactive (flags)
  (if (zerop (logand (getvar ;|MSG0|;"CMDACTIVE") flags ))
    T
    (progn
      (alert ;|MSG2|;"This command may not be invoked transparently.")
      nil
    )    
  )  
)
;;
;; Finds `fname' and loads it if not already loaded. Returns nil if
;; `testfunc' can't be found or if arxload failed.
;;
(defun ait_rxload (fname testfunc)
  (setq fname (ait_getadsfn fname))
  (cond
    ((= (type testfunc) 'EXRXSUBR)) ; it's already loaded.
    ((not (findfile fname))                         ; find it
      (ai_alert (strcat ;|MSG3|;"Can't find " fname ;|MSG0|;"."))
      (ai_return nil)
    )
    ((eq ;|MSG0|;"failed" (arxload fname ;|MSG0|;"failed")) ; rxload it
      (ai_alert (strcat ;|MSG4|;"Can't load " fname ;|MSG0|;"."))
      (ai_return nil)
    )
    (t)
  )
)
;;
;; Unloads `fname' if it's loaded. Returns nil if
;; rxunload failed.
;;
(defun ait_rxunload (fname testfunc)
  (setq fname (ait_getadsfn fname))
  (cond
    ((/= (type testfunc) 'EXRXSUBR))
    ((eq ;|MSG0|;"failed" (arxunload fname ;|MSG0|;"failed"))
      nil)
    (t)
  )
)
;;
;; This function returns the filename & extension of the ADS
;; executable name in `filename' for each platform.  Default filename
;; is `filename' (in lower-case).
;;
(defun ait_getadsfn (filename / platform)
  (setq platform (getvar ;|MSG0|;"PLATFORM"))
  (cond
    ((eq ;|MSG0|;"Microsoft" (substr platform 1 9))
      (strcat (strcase filename) ;|MSG0|;".ARX"))
    ((eq ;|MSG0|;"386 DOS Extender" platform)
      (strcat (strcase filename) ;|MSG0|;".ARX"))
    ((eq ;|MSG0|;"Solaris" (substr platform 1 7))
      (strcat (strcase filename) ;|MSG0|;".ARX"))
    ; insert other cases as required.

    (t filename)             ; Default extension
  )
)
;;
;; IGES Help Function - uses Platform independent help or MS Windows help.
;;
;; for r14 we call help directly + only NT or greater platforms.
(defun ait_helpdlg (topic / platform )
;;  (setq platform (getvar ;|MSG0|;"PLATFORM"))
;;  (if (eq ;|MSG0|;"Microsoft" (substr platform 1 9))
;;    (acad_helpdlg (findfile ;|MSG0|;"iges.hlp") topic)
	  (help "iges.hlp" topic)
;;    (acad_helpdlg (findfile ;|MSG0|;"iges.ahp") topic)
;;  )
)
;;
;; IGES font code descriptions
;;
(defun ait_fontlist(/ fonts)
  (setq fonts (list
     ;|MSG5|;"0    Symbol Font"
     ;|MSG6|;"1    ASCII Default"
     ;|MSG7|;"2    Leroy"
     ;|MSG8|;"3    Futura"
     ;|MSG9|;"6    Comp 80"
     ;|MSG10|;"12   News Gothic"
     ;|MSG11|;"13   Lightline Gothic"
     ;|MSG12|;"14   Simplex Roman"
     ;|MSG13|;"17   Century Schoolbook"
     ;|MSG14|;"18   Helvetica"
     ;|MSG15|;"19   OCR-B [ISO1073]"
     ;|MSG16|;"1001 Symbol Font 1"
     ;|MSG17|;"1002 Symbol Font 2"
     ;|MSG18|;"1003 Drafting Font"
     ;|MSG19|;"2001 Kanji [JIS6226]"
     ;|MSG20|;"3001 Latin-1 [ISO8859-1]")
  )
)
;; About AutoCAD IGES Translator - this function manages the about
;; dialog's list box and reads the aitmotd.txt file into if the file
;; is available.
(defun ait_about ( about prod / plat acver motdfn motdfd line)
  (setq plat (getvar ;|MSG0|;"PLATFORM"))
  (setq acver (getvar ;|MSG0|;"ACADVER"))
  (start_list "about_list" 2)
  (add_list ;|MSG0|;" ")
  (add_list (strcat "Version:\t" prod " "  (nth 0 about) " (" (nth 1 about) ")"))
  (add_list (strcat "For:\t\tAutoCAD " acver " on " plat))
  (add_list ;|MSG0|;" ")
  ;; Display IGES message of the day from aitmotd.txt file.
  (setq motdfn (findfile ;|MSG0|;"aitmotd.txt"))
  (if (not (null motdfn))
    (progn
      (setq motdfd (open motdfn ;|MSG0|;"r"))
      (while (not (null (setq line (read-line motdfd))))
         (add_list line)
      )  
      (close motdfd)
    )
  )  
  (end_list)
)
;;
;;;;;;;;;;;;;;;;;
;;;; IGESVER ;;;;
;;;;;;;;;;;;;;;;;
;; IGESVER - IGES version
(defun c:igesver ( / old_cmd old_error )
  
  ;; Set up error function and save cmdecho setting.
  (setq old_cmd (getvar ;|MSG0|;"CMDECHO")    ; save current setting of cmdecho
        old_error  *error*                    ; save current error function
        *error* ai_error                      ; new error function
  )
  (setvar ;|MSG0|;"CMDECHO" 0)
  (if
    (and (ait_cmdactive (+ 1 2 8))            ; transparent/dialog box not OK
         ;; Load IGESIN application which defines the (about_igesin) function.
         (ait_rxload ;|MSG0|;"igesin" igesin)
    )
      (progn
        (princ (strcat "IGESVER = \"" (nth 0 (about_igesin)) "\"\n"))
        (ait_rxunload ;|MSG0|;"igesin" igesin)
      )
      (princ (ait_cmdactive (+ 1 2 8)))
  )
  ;; Restore error function and command echo setting.
  (setq *error* old_error)
  (setvar ;|MSG0|;"cmdecho" old_cmd)
  (princ)
)
;;
;;;;;;;;;;;;;;;;;
;;;; IGESVAL ;;;;
;;;;;;;;;;;;;;;;;
;; IGESVAL - IGES to IGES translator with entity validation and fixups.
(defun c:igesval ( / old_cmd old_error )
  
  ;; Set up error function and save cmdecho setting.
  (setq old_cmd (getvar ;|MSG0|;"CMDECHO")    ; save current setting of cmdecho
        old_error  *error*                    ; save current error function
        *error* ai_error                      ; new error function
  )
  (setvar ;|MSG0|;"CMDECHO" 0)
  (if
    (and (ait_cmdactive (+ 1 2 8))            ; transparent/dialog box not OK
         ;; Load IGESIN ADS application which defines the (igesval) function.
         (ait_rxload ;|MSG0|;"igesin" igesin)
    )
      (progn
        (igesval)
        (ait_rxunload ;|MSG0|;"igesin" igesin)
      )
      (princ (ait_cmdactive (+ 1 2 8)))
  )
  ;; Restore error function and command echo setting.
  (setq *error* old_error)
  (setvar ;|MSG0|;"cmdecho" old_cmd)
  (princ)
)

;;;;;;;;;;;;;;;;;
;;;; IGESMAP ;;;;
;;;;;;;;;;;;;;;;;
(defun c:igesmap ( / old_cmd old_error )
  
  ;; Set up error function and save cmdecho setting.
  (setq old_cmd (getvar ;|MSG0|;"CMDECHO")    ; save current setting of cmdecho
        old_error  *error*                    ; save current error function
        *error* ai_error                      ; new error function
  )
  (setvar ;|MSG0|;"CMDECHO" 0)
  (if
    (and (ait_cmdactive (+ 1 2 8))            ; transparent/dialog box not OK
         ;; Load IGESMAP ARX application which defines the (igesmap) function.
         (ait_rxload ;|MSG0|;"igesmap" igesmap)
    )
      (progn
        (igesmap)
        (ait_rxunload ;|MSG0|;"igesmap" igesmap)
      )
      (princ (ait_cmdactive (+ 1 2 8)))
  )
  ;; Restore error function and command echo setting.
  (setq *error* old_error)
  (setvar ;|MSG0|;"cmdecho" old_cmd)
  (princ)
)

;;;;;;;;;;;;;;;;;
;;;; VISIBLE ;;;;
;;;;;;;;;;;;;;;;;
(defun c:visible ( )
  (if (member "visible.arx" (arx))
		(c:visible) ;; already loaded just run it
		(progn
			(if (findfile "visible.arx")
				(progn
					(arxload "visible")
					(if (member "visible.arx" (arx)) ;; make sure load worked
						(progn
							(princ "_visible\n") ;; cosmetic only
							(c:visible)
							(arxunload "visible")
							(princ "Visible Application unloaded.") ;; consistentcy only
						)
					)
				)
				(princ "\nCan't find VISIBLE.ARX to load.\n")
			)
		);; not loaded
  )
  (princ)
)

(princ)

;;;-----BEGIN-SIGNATURE-----
;;; 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEE+U0vr78xSzq0vXnmuWytEw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMjAwNjE1MDAwMDAwWhcNMjEwODEyMjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBAMt3bX7WxfbqKZpcgiX4jvJBSg6MCucqh4aDRHA8
;;; Hny4Fc2vKP+Xgn3mY4qtHoeNZ/j4d669d5+guDfOpD7jZX/JyR81wLE22GwswGLN
;;; M6n3N6Vudo0PcdCNXRxccGdPmJMIiEZNp84RjWN7Gy0JfgChxNiNEWS+Dezr5cYK
;;; B7UlGjGivbUdK6/HP0JlO3t3QxXYERASgPWj6YXmHGdvYHPBNit1MJTLRUj7uXyk
;;; bWzpaQEnXdey73yxg+FV2us0BicMIChoDXdTY/uAWbhkThET8GffQd08miZDNWMv
;;; IUIfFEkKjGZX6VkfkK/ShlVtjcdYlknpatvAtkFuYnQm6mECAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBACiY
;;; IcU6uh5Lz5MGiUDT3w+daDMfYW44/ak/wMK1SgkL+iHzsgHaY8plDqZ4oaxT3U45
;;; /L5BdedSZWIvR738xpjcJNKZVILKTMg3mzl0bjO/t91dj5TFlTSpCbQgBh+jbBpJ
;;; R0il59VeZ9LQTvK/2E41TK89VHXZa+8MaTrsVOyTsBuAnNdYdzzExmAqp1BZdirH
;;; JH35aOAnZz3nkcGS4knKOAc7EX8pLkhAl4UDoS2V+2MKw5IXpYO3tU5TwM7y8uGZ
;;; gj/XpMlzWXtVQvOVpwgmT0XCymP5174BFyTP1SLNhlUWUfwFCypOY6tRHd6U9uqc
;;; BATajxbYoRpvjWl9Nu8xggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQT5TS+vvzFLOrS9eea5bK0TANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQATtztGNdlUlpBrAeJ5LMxApdy7vKEkxKsl
;;; rI385PRfAtf2s6F0fbaG/PqJz9YRK63L94raGCeTCVVhu0Ipc+8lTWb0Eqh/ryJM
;;; G7AqAjAXBLC6iyKHJjZrFSGrUWEKwRlIzNiPvderkQHHdbldBPg4il4bdCR5Vtic
;;; lxoRb0XPy5bgGVURlPKq/ucX+SSHG/l9fdJmeSxXEgjjn0zlD+RwAyCxY/ZQvGAG
;;; jlrViYkc7Na4vRW1CBM5DuesrJ5Tfx+0wx2F0ZXmQrD8h44WGoE30JkD2tmqtAvQ
;;; QO5Y1sX5OdPxXE1AlwsJ1ToDNBHgPhqmMNiLrSsfrBZ31sBWt6Qd
;;; -----END-SIGNATURE-----