; Next available MSG number is 11 
; MODULE_ID HANDSEL_LSP_
;;;---------------------------------------------------------------------------;
;;;
;;;   HANDSEL.LSP   Version 1.0
;;;
;;;   Copyright (C) 1992, 1993 by Autodesk, Inc.
;;;  
;;;   Permission to use, copy, modify, and distribute this software and its
;;;   documentation for any purpose and without fee is hereby granted.  
;;;
;;;   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. 
;;;   ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR PURPOSE AND OF 
;;;   MERCHANTABILITY ARE HEREBY DISCLAIMED.
;;;   
;;;---------------------------------------------------------------------------;
;;;   HANDSEL
;;;
;;;   This program highlights an entity specified by its handle and optionally
;;;   lists it with the LIST command and optionally prints its definition.
;;;
;;;---------------------------------------------------------------------------;


;;;---------------------------------------------------------------------------;
;;; Internal error handling.
;;;---------------------------------------------------------------------------;
(defun handsel_error(s)
  (if (/= s ;|MSG1|;"Function cancelled")
    (princ (strcat ;|MSG2|;"\nHANDSEL Error: " s))
  )
  (setq *error* olderr)
  (princ)
)


;;;---------------------------------------------------------------------------;
;;;  HANDSEL
;;;---------------------------------------------------------------------------;
(defun C:HANDSEL (/ echo olderr handle ename answer)
  (setq olderr *error*                ; Redefine error handler.
        echo (getvar ;|MSG0|;"cmdecho")
        *error* handsel_error)

  ;; Verify handles are on 
  (if (/= 1 (getvar ;|MSG0|;"handles"))
    (princ ;|MSG3|;"\nHandles must be enabled to use this tool.")
    (progn   
      ;; Get the entity's name from a specified handle.
      (setq handle (getstring ;|MSG4|;"Handle of entity to be selected? ")) 
      (if (/= handle ;|MSG0|;"")
        (progn
          (setq ename (handent handle))
          (if (= ename nil)
            (princ ;|MSG5|;"\nAn entity was not found with the specified handle.")
            (progn 
              (redraw ename 3)                    ; Highlight entity
              (setvar ;|MSG0|;"cmdecho" 0)        ; Turn off cmdecho sysvar
              (setq answer (getstring ;|MSG6|;"List the entity (<y>/n)? "))
              (if (/= (substr answer 1 1) ;|MSG7|;"n")(command ;|MSG8|;"_list" ename ""))
    
              (setq answer (getstring ;|MSG9|;"Get the definition of the entity (<y>/n)? "))  
              (if (/= (substr answer 1 1) ;|MSG10|;"n")(print (entget ename)))
              (setvar ;|MSG0|;"cmdecho" echo)     ; Restore cmdecho sysvar
              (redraw ename 4)                    ; De-highlight entity.
            )
          )
        )
      )
    )
  )
  (setq *error* old_error)            ; restore error function
  (princ)                             ; Quiet exit.
)

;;;-----BEGIN-SIGNATURE-----
;;; 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEE+U0vr78xSzq0vXnmuWytEw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMjAwNjE1MDAwMDAwWhcNMjEwODEyMjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBAMt3bX7WxfbqKZpcgiX4jvJBSg6MCucqh4aDRHA8
;;; Hny4Fc2vKP+Xgn3mY4qtHoeNZ/j4d669d5+guDfOpD7jZX/JyR81wLE22GwswGLN
;;; M6n3N6Vudo0PcdCNXRxccGdPmJMIiEZNp84RjWN7Gy0JfgChxNiNEWS+Dezr5cYK
;;; B7UlGjGivbUdK6/HP0JlO3t3QxXYERASgPWj6YXmHGdvYHPBNit1MJTLRUj7uXyk
;;; bWzpaQEnXdey73yxg+FV2us0BicMIChoDXdTY/uAWbhkThET8GffQd08miZDNWMv
;;; IUIfFEkKjGZX6VkfkK/ShlVtjcdYlknpatvAtkFuYnQm6mECAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBACiY
;;; IcU6uh5Lz5MGiUDT3w+daDMfYW44/ak/wMK1SgkL+iHzsgHaY8plDqZ4oaxT3U45
;;; /L5BdedSZWIvR738xpjcJNKZVILKTMg3mzl0bjO/t91dj5TFlTSpCbQgBh+jbBpJ
;;; R0il59VeZ9LQTvK/2E41TK89VHXZa+8MaTrsVOyTsBuAnNdYdzzExmAqp1BZdirH
;;; JH35aOAnZz3nkcGS4knKOAc7EX8pLkhAl4UDoS2V+2MKw5IXpYO3tU5TwM7y8uGZ
;;; gj/XpMlzWXtVQvOVpwgmT0XCymP5174BFyTP1SLNhlUWUfwFCypOY6tRHd6U9uqc
;;; BATajxbYoRpvjWl9Nu8xggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQT5TS+vvzFLOrS9eea5bK0TANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQCate+F87nFSGiqzQSILLmkqkvKmc46FmmM
;;; nZQDRno+tF+vy6Y+AKNA2hVjwlWj6DLIqkLA1Hf+ACj1p0bmqX2pH4Q8x+pa/6S0
;;; KAfNShzpILIj+y5WaAAV9Gvd9ewhtzsJMHTcIrD+RKU8GYf/HZeAwswwuWDr+L5H
;;; +ooT4SErOT/KXUgtA5Z4Xqf56Jn1wP0+wQ8eJOdczyabjJtRr9swE7XfeciL+GRO
;;; UhYpAtS5r1ixwKyny073yhMZZmpahcTrjrFGnv1f+NsC7DNvVTXgFpKmr7yRGq/O
;;; t4c3fLe/f8yEFc9wYDodIHsvCWXG3cqXhso5O50MOduUWjjQZB+5
;;; -----END-SIGNATURE-----