;; grp2layr.lsp

(defun grp2layr_error (s)
  (if (/= s ;|MSG1|;"Function cancelled")
    (princ (strcat ;|MSG2|;"\nError: " s))
  )
  (setq *error* old_error)
  (setvar ;|NOXLATE|;"tilemode" old_tilemode)
  (princ)
)

(defun C:GRP2LAYR ( / groups name group layername prefix old_echo count)
   (setq old_error *error*
         *error* grp2layr)

   (setq old_echo (getvar ;|NOXLATE|;"cmdecho"))
   ;; turn off command echo
   (setvar ;|NOXLATE|;"cmdecho" 0)

   ;; save the tilemode and switch to tilemode on
   (setq old_tilemode (getvar ;|NOXLATE|;"tilemode"))

   (setq groups nil
         name nil
         layername nil
         prefix nil
         count 0)

   ;; get the group prefix
   (setq prefix (getstring "Enter bad surface group prefix <BADSURF->: "))
   (if (or (null prefix) (= prefix ;|NOXLATE|;""))
      (setq prefix "BADSURF-")
   )      

   ;; get the layer name
   (setq layername (getstring "Enter new layername for bad surface entities <BADSURFS>: "))
   (if (or (null layername) (= layername ;|NOXLATE|;""))
      (setq layername "BADSURFS")
   )      
   (princ (strcat "\nChanging groups with names prefixed with " prefix 
                  " to layer " layername "...\n"))

   ;; make the layer if necessary
   (if (null (tblsearch ;|NOXLATE|;"layer" layername))
      (command ;|NOXLATE|;"_.layer" ;|NOXLATE|;"_make" layername ;|NOXLATE|;"")
   )

   ;; switch to tilemode on
   (setvar ;|NOXLATE|;"tilemode" 1)

   ;; get list of groups
   (setq groups (dictsearch (namedobjdict) ;|NOXLATE|;"ACAD_GROUP"))
   (if (not (null groups))
      (foreach item groups
         (progn
           ;; Note group name (group code 3) if it matches the prefix
           (if (and (= (car item) 3)
                    (wcmatch (cdr item) (strcat prefix ;|NOXLATE|;"*")))
              (setq name (cdr item))
              (if (= (car item) 350)  ;; else if
                 (setq group (entget (cdr item)))
                 (setq name nil group nil)  ;; else
              )
           )
           (if (and (not (null name)) (not (null group)))
              (progn
                ;; Ensure the group is selectable
                (if (= 0 (cdr (assoc '71 group)))
                  (command ;|NOXLATE|;"_.-group" 
                           ;; change the specified group's selectability
                           ;|NOXLATE|;"_selectable" name 
                           ;; affirm action
                           ;|NOXLATE|;"_yes")
                )
                ;; Change the layer of the entities in the group
                (command ;|NOXLATE|;"_.chprop" 
                         ;; select the group by name
                         ;|NOXLATE|;"_g" name ;|NOXLATE|;""
                         ;; change its layer
                         ;|NOXLATE|;"_layer" layername 
                         ;; finish the command
                         ;|NOXLATE|;"")
                (princ (strcat "\nGroup " name " changed.\n"))
                (setq count (1+ count))
                ;;
                (setq group nil name nil)
              )
           )
        )
      )
      (princ "\nNo groups found.\n")
   )
   (if (= 0 count)
      (princ "\nNo groups changed.\n")
      (progn
         (princ "\n")
         (princ count)
         (princ " groups changed.\n")
      )
   )

   ;; restore the tilemode
   (setvar ;|NOXLATE|;"tilemode" old_tilemode)

   ;; restore the cmdecho setting
   (setvar ;|NOXLATE|;"cmdecho"  old_echo)
   
   (setq *error* old_error)

   (princ)
)

;;;-----BEGIN-SIGNATURE-----
;;; 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEE+U0vr78xSzq0vXnmuWytEw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMjAwNjE1MDAwMDAwWhcNMjEwODEyMjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBAMt3bX7WxfbqKZpcgiX4jvJBSg6MCucqh4aDRHA8
;;; Hny4Fc2vKP+Xgn3mY4qtHoeNZ/j4d669d5+guDfOpD7jZX/JyR81wLE22GwswGLN
;;; M6n3N6Vudo0PcdCNXRxccGdPmJMIiEZNp84RjWN7Gy0JfgChxNiNEWS+Dezr5cYK
;;; B7UlGjGivbUdK6/HP0JlO3t3QxXYERASgPWj6YXmHGdvYHPBNit1MJTLRUj7uXyk
;;; bWzpaQEnXdey73yxg+FV2us0BicMIChoDXdTY/uAWbhkThET8GffQd08miZDNWMv
;;; IUIfFEkKjGZX6VkfkK/ShlVtjcdYlknpatvAtkFuYnQm6mECAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBACiY
;;; IcU6uh5Lz5MGiUDT3w+daDMfYW44/ak/wMK1SgkL+iHzsgHaY8plDqZ4oaxT3U45
;;; /L5BdedSZWIvR738xpjcJNKZVILKTMg3mzl0bjO/t91dj5TFlTSpCbQgBh+jbBpJ
;;; R0il59VeZ9LQTvK/2E41TK89VHXZa+8MaTrsVOyTsBuAnNdYdzzExmAqp1BZdirH
;;; JH35aOAnZz3nkcGS4knKOAc7EX8pLkhAl4UDoS2V+2MKw5IXpYO3tU5TwM7y8uGZ
;;; gj/XpMlzWXtVQvOVpwgmT0XCymP5174BFyTP1SLNhlUWUfwFCypOY6tRHd6U9uqc
;;; BATajxbYoRpvjWl9Nu8xggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQT5TS+vvzFLOrS9eea5bK0TANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQCwVcg4+26ieLdWESXdBbLyd84uq54xNxus
;;; /pzOHDEe6EP+Mo7nYFPpFjp1rHiXsEw4vcbfQUa4gDeM1ZFGrMbVSUGjsQfEz2iH
;;; uBGZnC5E42iWgdLmJVhF55f02/BbZ5uNhF/wPDpN1B59/j1g0arLkQcEceC65/72
;;; C8WXS8AcMiK+/mRWkAuPfy8D50Olk7eTVZOLmUcsqxDVkBJokvzTYea2FQ4s8zPk
;;; 90hNo66iXWxQq5ZzjSgjdCuGRQYUzoAsBRxLVN+3NgyhUt6ZVMQxuFHtI1VHC3eu
;;; CLVyZUQnZ2SZj5RPALhlNG1pz1Q55Bd373j1NwOVYQY4IpHT4FER
;;; -----END-SIGNATURE-----