; Next available MSG number is  8 
; MODULE_ID FINDDE_LSP_
;;;---------------------------------------------------------------------------;
;;;
;;;   FINDDE.LSP   Version 1.0
;;;
;;;   Copyright (C) 1992, 1993 by Autodesk, Inc.
;;;  
;;;   Permission to use, copy, modify, and distribute this software and its
;;;   documentation for any purpose and without fee is hereby granted.  
;;;
;;;   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. 
;;;   ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR PURPOSE AND OF 
;;;   MERCHANTABILITY ARE HEREBY DISCLAIMED.
;;;   
;;;---------------------------------------------------------------------------;
;;;   FINDDE
;;;
;;;   This program highlights the AutoCAD entity which was created from the
;;;   mapping of a specified IGES entity.   The AutoCAD model is searched 
;;;   for an entity with ACADIGES extended entity data which identifies the
;;;   IGES entity from which the entity was mapped.  The XED option must be
;;;   used when translating the IGES file in order for the ACADIGES XED
;;;   to be created.
;;;
;;;---------------------------------------------------------------------------;


;;;---------------------------------------------------------------------------;
;;; Internal error handling.
;;;---------------------------------------------------------------------------;
(defun findde_error(s)
  (if (/= s ;|MSG1|;"Function cancelled")
    (princ (strcat ;|MSG2|;"\nFINDDE Error: " s))
  )
  (setq *error* olderr) 
  (princ)
)

 
;;;---------------------------------------------------------------------------;
;;;  DEMATCH
;;;---------------------------------------------------------------------------;
;;; This function finds the IGES DE number following the "D" in the xed_str,
;;; compares it to de_str, and returns T if there is a match and nil otherwise.
;;;
;;; Syntax: (DEMATCH <xed_str> <de_str>) 
;;;
(defun DEMATCH (xed_str de_str / dupstr strindex)
  (setq dupstr xed_str strindex 0)
  (while (wcmatch dupstr ;|MSG0|;"*D*")
    (setq strindex (1+ strindex))
    (setq dupstr (substr xed_str strindex))
  )
  (if (= dupstr de_str) T nil)
)


;;;---------------------------------------------------------------------------;
;;;  findde - function
;;;---------------------------------------------------------------------------;
;;; This function returns T if the specified DE is found, otherwise NIL.
;;; The specified DE must be a string.
;;;
;;; Syntax:  (findde <de_str>)
;;;
(defun findde (de_str / dbase xd_list elist ename found)

  (princ (strcat ;|MSG3|;"Searching for DE " de_str ;|MSG0|;" ... "))

  ;; Get selection set of all entity names and initialize local vars.
  (setq 
     dbase (ssget ;|MSG0|;"_X")
     i 0
     found NIL)

  ;; For each entity in the selection set, get its XED and check it.
  (while (and (not found) (< i (sslength dbase)))

    /* Get the i'th entity name from the selection set */
    (setq ename (ssname dbase i))

    ;; Get entity and all ACADIGES XED.
    (setq elist (entget ename (list ;|MSG0|;"ACADIGES"))) 
   
    ;; If there is any XED, compare it to the DE string. 
    (if (setq xd_list (assoc -3 elist))
      (progn 
        (setq xd_list (assoc 1000 (cdr (cadr xd_list))))
        (if (DEMATCH (cdr xd_list) de_str)
          (progn
            (redraw ename 3)            ; Highlight entity.
            (princ ;|MSG4|;"found.")
            (setq found T)
          )
        )
      )
    )

    (setq i (1+ i))
  )

  (if (not found)
    (progn
      (princ ;|MSG5|;"not found.")
      nil
    )
    T
  )
)


;;;---------------------------------------------------------------------------;
;;;  FINDDE - command interface
;;;---------------------------------------------------------------------------;
;;;
(defun C:FINDDE (/ de cont)

  (setq olderr *error*                ; Redefine error handler.
        *error* findde_error)
 
  ;; Verify ACADIGES data is available 
  (if (not (tblsearch ;|MSG0|;"APPID" ;|MSG0|;"ACADIGES")) 
    (findde_error ;|MSG6|;"No AutoCAD IGES extended data found.\nRetranslate IGES data with XED option.")
    (progn   
      ;; Force the entry of an IGES DE number
      (setq cont T)
      (while cont
        (setq de (getstring T ;|MSG7|;"Enter the DE of the IGES entity: "))
        (if (/= de ;|MSG0|;"")
           (setq cont nil)
        )
      )  
      (findde de)
      (setq *error* olderr)               ; Reset the error function.
    )
  )
  (princ)                             ; Quiet exit.
)

;;;-----BEGIN-SIGNATURE-----
;;; 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEE+U0vr78xSzq0vXnmuWytEw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMjAwNjE1MDAwMDAwWhcNMjEwODEyMjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBAMt3bX7WxfbqKZpcgiX4jvJBSg6MCucqh4aDRHA8
;;; Hny4Fc2vKP+Xgn3mY4qtHoeNZ/j4d669d5+guDfOpD7jZX/JyR81wLE22GwswGLN
;;; M6n3N6Vudo0PcdCNXRxccGdPmJMIiEZNp84RjWN7Gy0JfgChxNiNEWS+Dezr5cYK
;;; B7UlGjGivbUdK6/HP0JlO3t3QxXYERASgPWj6YXmHGdvYHPBNit1MJTLRUj7uXyk
;;; bWzpaQEnXdey73yxg+FV2us0BicMIChoDXdTY/uAWbhkThET8GffQd08miZDNWMv
;;; IUIfFEkKjGZX6VkfkK/ShlVtjcdYlknpatvAtkFuYnQm6mECAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBACiY
;;; IcU6uh5Lz5MGiUDT3w+daDMfYW44/ak/wMK1SgkL+iHzsgHaY8plDqZ4oaxT3U45
;;; /L5BdedSZWIvR738xpjcJNKZVILKTMg3mzl0bjO/t91dj5TFlTSpCbQgBh+jbBpJ
;;; R0il59VeZ9LQTvK/2E41TK89VHXZa+8MaTrsVOyTsBuAnNdYdzzExmAqp1BZdirH
;;; JH35aOAnZz3nkcGS4knKOAc7EX8pLkhAl4UDoS2V+2MKw5IXpYO3tU5TwM7y8uGZ
;;; gj/XpMlzWXtVQvOVpwgmT0XCymP5174BFyTP1SLNhlUWUfwFCypOY6tRHd6U9uqc
;;; BATajxbYoRpvjWl9Nu8xggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQT5TS+vvzFLOrS9eea5bK0TANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQDFD7IQBwvlXm9BDJ/HlxrenoSkfVolVc/7
;;; C1whE+sWxwee0mUTenuwLj4ZGLcjRKXyWs7QoMiMi3SYNN+ZlBexXiRxuPa2Cb9e
;;; hcpaDbkyDRReHddJK9BDtKQO4Xibi/+TvZTAchwB1B7qUqKl75k/OFooG1ehDFaU
;;; sNuNEGzxNPK6UeqrkbE2v07vjxZo/wDWWHMotJL934aAy5mVuV416m5th0/id2rv
;;; +R2Rp6HQIqolmai6qf1neSlKZl+jvEOzZ90phxmjlic+cTp9d9B+/pTzX6SKr+HN
;;; lLUC9cmEiPFv3x1UPGxl2OQMxtV49bov5oIbCPSoAcPdxMojxWK4
;;; -----END-SIGNATURE-----