; Next available MSG number is 34 
; MODULE_ID EG_LSP_
;;;---------------------------------------------------------------------------;
;;;
;;;   EG.LSP   Version 1.0
;;;
;;;   Copyright (C) 1992, 1993 by Autodesk, Inc.
;;;
;;;   Permission to use, copy, modify, and distribute this software and its
;;;   documentation for any purpose and without fee is hereby granted.
;;;
;;;   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
;;;   ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR PURPOSE AND OF
;;;   MERCHANTABILITY ARE HEREBY DISCLAIMED.
;;;
;;;---------------------------------------------------------------------------;
;;;
;;;   This file contains utility functions for using the SDK Entity Grouping
;;;   tool.
;;;
;;;---------------------------------------------------------------------------;

;;;---------------------------------------------------------------------------;
;;; Internal error handling.
;;;---------------------------------------------------------------------------;
(defun egt_error(s)
  (if (/= s ;|MSG1|;"Function cancelled")
    (princ (strcat ;|MSG2|;"\n EGT Error: " s))
  )
  (pr_gerr (grerr_))
  (setq *error* olderr)
  (princ)
)

(defun pr_grerr(errval / prefix )
  (setq prefix ;|MSG3|;"Entity Grouping Tool error")
  (if (= errval 0)
      (princ (strcat prefix ;|MSG4|;" status:  No error.\n")))
  (if (= errval 1)
      (princ (strcat prefix ;|MSG5|;":  Invalid group name.\n")))
  (if (= errval 2)
      (princ (strcat prefix ;|MSG6|;":  Group does not exist.\n")))
  (if (= errval 3)
      (princ (strcat prefix ;|MSG7|;":  Invalid arguments.\n")))
  (if (= errval 4)
      (princ (strcat prefix ;|MSG8|;":  Duplicate name.\n")))
  (if (= errval 5)
      (princ (strcat prefix ;|MSG9|;":  Unable to create selection set.\n")))
  (if (= errval 6)
      (princ (strcat prefix ;|MSG10|;":  Group is full - request rejected.\n")))
  (if (= errval 7)
      (princ (strcat prefix ;|MSG11|;":  Cyclic group definition.\n")) )
  (eval errval)
)

(defun c:grerr (/ rc) 
  (setq rc (grerr_))
  (pr_grerr rc)
  (eval rc)
)

(defun c:creategr (/ rc)
  (setq olderr *error*                ; Redefine error handler.
        *error* egt_error)
  (setq rc (creategr (getstring ;|MSG12|;"Name of group to be created? ") (ssget)))
  (setq *error* olderr)               ; Reset the error function.
  (if (/= 0 (grerr_)) 
    (pr_grerr (grerr_))
    (eval rc)
  )
)
(defun c:selectgr (/ i len)
  (setq olderr *error*                ; Redefine error handler.
        *error* egt_error)
  (setq group (selectgr (getstring ;|MSG13|;"Name of group to be selected? ")))
  (setq *error* olderr)               ; Reset the error function.
  (if (= 0 (grerr_)) 
    (progn 
      (setq i 0)
      (setq len (sslength group))
      (while 
         (< i len)
         (redraw (ssname group i) 3)
         (setq i (1+ i))
      )
      (princ ;|MSG14|;"Use !group at Select object prompts to use the group.\n")
      (eval group)
    )
    (pr_grerr (grerr_))
  )
)
(defun c:listgr (/ groups rc)
  (setq olderr *error*                ; Redefine error handler.
        *error* egt_error)
  (setq groups (listgr))
  (setq *error* olderr)               ; Reset the error function.
  (if (/= 0 (grerr_)) 
    (pr_grerr (grerr_))
    (progn
      (princ ;|MSG15|;"Groups:  ")
      (setq rc groups)
    )
  )
)
(defun c:deletegr (/ rc)
  (setq olderr *error*                ; Redefine error handler.
        *error* egt_error)
  (setq rc (deletegr (getstring ;|MSG16|;"Group to be deleted? ")))
  (setq *error* olderr)               ; Reset the error function.
  (if (/= 0 (grerr_)) 
    (pr_grerr (grerr_))
    (eval rc)
  )
)
(defun c:renamegr (/ rc)
  (setq olderr *error*                ; Redefine error handler.
        *error* egt_error)
  (setq rc (renamegr (getstring ;|MSG17|;"Group to be renamed? ")
                    (getstring ;|MSG18|;"New group name? ")))
  (setq *error* olderr)               ; Reset the error function.
  (if (/= 0 (grerr_)) 
    (pr_grerr (grerr_))
    (eval rc)
  )
)
(defun c:linkgr (/ rc)
  (setq olderr *error*                ; Redefine error handler.
        *error* egt_error)
  (setq rc (linkgr (getstring ;|MSG19|;"Group to be linked? ")
                   (getstring ;|MSG20|;"To group? ")))
  (setq *error* olderr)               ; Reset the error function.
  (if (/= 0 (grerr_)) 
    (pr_grerr (grerr_))
    (eval rc)
  )
)
(defun c:unlinkgr (/ rc)
  (setq olderr *error*                ; Redefine error handler.
        *error* egt_error)
  (setq rc (unlinkgr (getstring ;|MSG21|;"Grouped to be unlinked? ")
                     (getstring ;|MSG22|;"From group? ")))
  (setq *error* olderr)               ; Reset the error function.
  (if (/= 0 (grerr_)) 
    (pr_grerr (grerr_))
    (eval rc)
  )
)
(defun c:listlinks (/ groups rc)
  (setq olderr *error*                ; Redefine error handler.
        *error* egt_error)
  (setq groups (listlinks (getstring ;|MSG23|;"Parent group? ")))
  (setq *error* olderr)               ; Reset the error function.
  (if (/= 0 (grerr_)) 
    (pr_grerr (grerr_))
    (setq rc groups)
  )
)
(defun c:listroot (/ groups rc)
  (setq olderr *error*                ; Redefine error handler.
        *error* egt_error)
  (setq groups (listroot))
  (setq *error* olderr)               ; Reset the error function.
  (if (/= 0 (grerr_)) 
    (pr_grerr (grerr_))
    (setq rc groups)
  )
)
(defun c:addent (/ rc)
  (setq olderr *error*                ; Redefine error handler.
        *error* egt_error)
  (setq rc (addent (getstring ;|MSG24|;"Name of group to be updated? ") (ssget)))
  (setq *error* olderr)               ; Reset the error function.
  (if (/= 0 (grerr_)) 
    (pr_grerr (grerr_))
    (eval rc)
  )
)
(defun c:delent (/ rc)
  (setq olderr *error*                ; Redefine error handler.
        *error* egt_error)
  (setq rc (delent (getstring ;|MSG25|;"Name of group to be updated? ") (ssget)))
  (setq *error* olderr)               ; Reset the error function.
  (if (/= 0 (grerr_)) 
    (pr_grerr (grerr_))
    (eval rc)
  )
)
(defun c:listent (/ groups rc)
  (setq olderr *error*                ; Redefine error handler.
        *error* egt_error)
  (setq groups (listent (car (entsel))))
  (setq *error* olderr)               ; Reset the error function.
  (if (/= 0 (grerr_)) 
    (pr_grerr (grerr_))
    (setq rc groups)
  )
)
(defun c:ismember (/ rc grpname) 
  (setq olderr *error*                ; Redefine error handler.
        *error* egt_error)
  (setq grpname (getstring ;|MSG26|;"Group to search? "))
  (setq rc (ismember (car (entsel)) grpname))
  (setq *error* olderr)               ; Reset the error function.
  (if (/= 0 (grerr_)) 
    (pr_grerr (grerr_))
    (eval rc)
  )
)
(defun c:isnested (/ rc grpname) 
  (setq olderr *error*                ; Redefine error handler.
        *error* egt_error)
  (setq grpname (getstring ;|MSG27|;"Group to search? "))
  (setq rc (isnested (car (entsel)) grpname))
  (setq *error* olderr)               ; Reset the error function.
  (if (/= 0 (grerr_)) 
    (pr_grerr (grerr_))
    (eval rc)
  )
)
(defun c:freegr (/ grpname) 
  (setq olderr *error*                ; Redefine error handler.
        *error* egt_error)
  (setq grpname (getstring ;|MSG28|;"Free selection sets associated with group: "))
  (freegr grpname) 		      ; There is no return value 
  (setq *error* olderr)               ; Reset the error function.
  (if (/= 0 (grerr_)) 
    (pr_grerr (grerr_))
    (princ)
  )
)

(defun c:syncgr () 
  (setq olderr *error*                ; Redefine error handler.
        *error* egt_error)
  (freegr)
  (syncgr)
  (setq *error* olderr)               ; Reset the error function.
  (if (/= 0 (grerr_)) 
    (pr_grerr (grerr_))
    (progn 
      (princ ;|MSG29|;"Entity Grouping Tool synchronized.\n")
      (princ)
    )
  )
)

(defun c:egconfig (/ cur rc) 
  (setq olderr *error*                ; Redefine error handler.
        *error* egt_error)
  (setq cur (egconfig))
  (if (= -1 cur)
     (princ ;|MSG30|;"EGT is configured to select all levels of nested groups ("))
  (if (= 0 cur)
     (princ ;|MSG31|;"EGT is configured to select no levels of nested groups ("))
  (if (= 1 cur)
     (princ ;|MSG32|;"EGT is configured to select one level of nested groups ("))
  (princ cur)
  (princ ").\n")
  (setq rc (egconfig 
    (getint ;|MSG33|;"Configuration: -1 (all), 0 (no nesting), or 1 (single level)? ")))
  (setq *error* olderr)               ; Reset the error function.
  (if (/= 0 (grerr_)) 
    (pr_grerr (grerr_))
    (progn 
      (princ)
      (eval rc)
    )
  )
)
(princ)

;;;-----BEGIN-SIGNATURE-----
;;; 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEE+U0vr78xSzq0vXnmuWytEw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMjAwNjE1MDAwMDAwWhcNMjEwODEyMjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBAMt3bX7WxfbqKZpcgiX4jvJBSg6MCucqh4aDRHA8
;;; Hny4Fc2vKP+Xgn3mY4qtHoeNZ/j4d669d5+guDfOpD7jZX/JyR81wLE22GwswGLN
;;; M6n3N6Vudo0PcdCNXRxccGdPmJMIiEZNp84RjWN7Gy0JfgChxNiNEWS+Dezr5cYK
;;; B7UlGjGivbUdK6/HP0JlO3t3QxXYERASgPWj6YXmHGdvYHPBNit1MJTLRUj7uXyk
;;; bWzpaQEnXdey73yxg+FV2us0BicMIChoDXdTY/uAWbhkThET8GffQd08miZDNWMv
;;; IUIfFEkKjGZX6VkfkK/ShlVtjcdYlknpatvAtkFuYnQm6mECAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBACiY
;;; IcU6uh5Lz5MGiUDT3w+daDMfYW44/ak/wMK1SgkL+iHzsgHaY8plDqZ4oaxT3U45
;;; /L5BdedSZWIvR738xpjcJNKZVILKTMg3mzl0bjO/t91dj5TFlTSpCbQgBh+jbBpJ
;;; R0il59VeZ9LQTvK/2E41TK89VHXZa+8MaTrsVOyTsBuAnNdYdzzExmAqp1BZdirH
;;; JH35aOAnZz3nkcGS4knKOAc7EX8pLkhAl4UDoS2V+2MKw5IXpYO3tU5TwM7y8uGZ
;;; gj/XpMlzWXtVQvOVpwgmT0XCymP5174BFyTP1SLNhlUWUfwFCypOY6tRHd6U9uqc
;;; BATajxbYoRpvjWl9Nu8xggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQT5TS+vvzFLOrS9eea5bK0TANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQBRRRT0WrJjPQCp8uM6T+STTn/nFk+mDCZY
;;; URji3b5EbWHbjEYQUmT72VEWzPHB5XyE4w73Pi5HpRHrjLWy9MqNgZAY1WG90JVD
;;; eIVMIEf0XvOerq9Vf3TymiBZNOXjCbBm1BuyTivqvds0YPTohqxUuC8pzXKsjEJC
;;; CfOIHw4a/R7E6cl8QZcljPto6fHYWH7d7/4vakYsWl5hXAPgYs5v9NllqKFwLmLg
;;; 4wHTYAn/SsQ69GsoVpcngy+An3SaRiM9zlQJNFX4YKkFuDQ9TwuKDHFK44JYBNs7
;;; b2gBZf6jvkkIgIL58wXw428JJuTh7G93affANAqGYrr3si6IDame
;;; -----END-SIGNATURE-----