;;;                                                                    ;
;;;  OBJEX.LSP                                                         ;
;;;                                                                    ;
;;;  Copyright 1987, 1988, 1990, 1992, 1994, 1996, 1997, 1998, 1999    ;
;;;  by Autodesk, Inc. All Rights Reserved.                            ;
;;;                                                                    ;
;;;  You are hereby granted permission to use, copy and modify this    ;
;;;  software without charge, provided you do so exclusively for       ;
;;;  your own use or for use by others in your organization in the     ;
;;;  performance of their normal duties, and provided further that     ;
;;;  the above copyright notice appears in all copies and both that    ;
;;;  copyright notice and the limited warranty and restricted rights   ;
;;;  notice below appear in all supporting documentation.              ;
;;;                                                                    ;
;;;  Incorporation of any part of this software into other software,   ;
;;;  except when such incorporation is exclusively for your own use    ;
;;;  or for use by others in your organization in the performance of   ;
;;;  their normal duties, is prohibited without the prior written      ;
;;;  consent of Autodesk, Inc.                                         ;
;;;                                                                    ;
;;;  Copying, modification and distribution of this software or any    ;
;;;  part thereof in any form except as expressly provided herein is   ;
;;;  prohibited without the prior written consent of Autodesk, Inc.    ;
;;;                                                                    ;
;;;  AUTODESK PROVIDES THIS SOFTWARE "AS IS" AND WITH ALL FAULTS.      ;
;;;  AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF           ;
;;;  MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,       ;
;;;  INC. DOES NOT WARRANT THAT THE OPERATION OF THE SOFTWARE          ;
;;;  WILL BE UNINTERRUPTED OR ERROR FREE.                              ;
;;;                                                                    ;
;;;  Restricted Rights for US Government Users.  This software         ;
;;;  and Documentation are provided with RESTRICTED RIGHTS for US      ;
;;;  US Government users.  Use, duplication, or disclosure by the      ;
;;;  Government is subject to restrictions as set forth in FAR         ;
;;;  12.212 (Commercial Computer Software-Restricted Rights) and       ;
;;;  DFAR 227.7202 (Rights in Technical Data and Computer Software),   ;
;;;  as applicable.  Manufacturer is Autodesk, Inc., 111 McInnis       ;
;;;  Parkway, San Rafael, California 94903.                            ;
;;;                                                                    ;

;;;--------------------------------------------------------------------;
;;; General Note:  THIS FILE IS A MEMBER OF THE REAC-TST PROJECT       ;
;;;--------------------------------------------------------------------;
;;;     This file contains a reactor test.                             ;
;;;	In this test three circles of the same radius                  ;
;;;	will be created and will have different colors                 ;
;;;	Try to change one circle and the others will                   ;
;;;	change their radius.                                           ;
;;;                                                                    ;
;;;--------------------------------------------------------------------;

;;;--------------------------------------------------------------------;
;;;       Function:  PREPARE-FOR-OBJEX-TST                             ;
;;;                                                                    ;
;;;    Description:  This function makes 3 circles with equal radius   ;
;;;                  in model space.                                   ;
;;;                                                                    ;
;;;      Arguments:  none                                              ;
;;;                                                                    ;
;;; Returned Value:  none                                              ;
;;;                                                                    ;
;;;          Usage:                                                    ;
;;;                   (prepare-for-OBJEX-TST)                          ;
;;; Note: This function creates the global variables:                  ;
;;;       [ ac1 ac2 ac3 acadapp acaddoc acadmodel ]                    ;
;;;       They are allowed to be global for the                        ;
;;;       perusal of their values.                                     ;
;;;--------------------------------------------------------------------;
(defun prepare-for-OBJEX-TST ()
  (setq acadApp (vlax-get-acad-object))
  (setq acadDoc (vla-get-ActiveDocument acadApp))
  (setq acadModel (vla-get-ModelSpace acadDoc))

;;; Create 3 cirles
  (setq ac1 (vla-AddCircle acadModel (vlax-3d-point '(10.0 10.0 0.0)) 10.0))
  (vla-put-Color ac1 1)
  (setq ac2 (vla-AddCircle acadModel (vlax-3d-point '(5.0 5.0 0.0)) 5.0))
  (vla-put-Color ac2 2)
  (setq ac3 (vla-AddCircle acadModel (vlax-3d-point '(3.0 3.0 0.0)) 3.0))
  (vla-put-Color ac3 3)

  (command "_.ZOOM" "_EXTENTS")
  (command "_regen")
)

;;; define some helpers
;;;--------------------------------------------------------------------;
;;;       Function:  MAKE-THE-SAME-RADIUS                              ;
;;;                                                                    ;
;;;    Description:  This function makes the 3 circles have the same   ;
;;;                  radius.                                           ;
;;;                                                                    ;
;;;      Arguments:                                                    ;
;;;            obj1 = a valid vla circle object.                       ;
;;;            obj2 = a valid vla circle object.                       ;
;;;                                                                    ;
;;; Returned Value:   a valid vla circle object.                       ;
;;;                                                                    ;
;;;          Usage:                                                    ;
;;;                   (make-the-same-radius                            ;
;;;                           vla-circle-object1                       ;
;;;                           vla-circle-object2                       ;
;;;                  )                                                 ;
;;;--------------------------------------------------------------------;
(defun make-the-same-radius (obj1 obj2)
  (if (and
	obj2
	(vlax-write-enabled-p obj2)	;; test if object can be modified
	(vlax-read-enabled-p obj1)	;; test if object can be read
      )
    (VLA-PUT-RADIUS obj2 (vla-get-radius obj1))
  )
)

;;;--------------------------------------------------------------------;
;;;       Function:  MAKE-SAME-RADIUS-REACTION                         ;
;;;                                                                    ;
;;;    Description:  This function is a call back function invoked     ;
;;;                  from a reactor.                                   ;
;;;                                                                    ;
;;;                  Required Functions:                               ;
;;;                     make-the-same-radius                           ;
;;;                                                                    ;
;;;      Arguments:                                                    ;
;;;        notifier = a valid vla object. Filled in by the calling     ;
;;;                   reactor.                                         ;
;;;         reactor = a valid vlr object reactor. Filled in by the     ;
;;;                   calling reactor.                                 ;
;;;        arg-list = argument list filled in by the calling reactor.  ;
;;;                   Filled in by the calling reactor.                ;
;;;                                                                    ;
;;; Returned Value:  A valid vlr reactor object.                       ;
;;;                                                                    ;
;;;          Usage:                                                    ;
;;;                   (make-same-radius-reaction                       ;
;;;                           notifier                                 ;
;;;                           reactor                                  ;
;;;                           arg-list                                 ;
;;;                  )                                                 ;
;;;--------------------------------------------------------------------;
(defun make-same-radius-reaction (notifier reactor arg-list)
  (make-the-same-radius notifier (VLR-Data reactor))
)

;;;--------------------------------------------------------------------;
;;;       Function:  C:OBJEX-TST                                       ;
;;;                                                                    ;
;;;    Description:  This function aids in the creation of a circle    ;
;;;                  object which will contain reactors for:           ;
;;;                  COPY, MIRROR or ARRAY                             ;
;;;                                                                    ;
;;;                  Required Functions:                               ;
;;;                    create-same-copy-reactor                        ;
;;;                    add-circle                                      ;
;;;                    reactor-make-same-radius-color                  ;
;;;                                                                    ;
;;;                                                                    ;
;;;      Arguments:  none                                              ;
;;;                                                                    ;
;;; Returned Value:  A valid reactor object such as:                   ;
;;;                 #<VLR-Object-reactor>                              ;
;;;                                                                    ;
;;;          Usage: (C:OBJEX-TST) or OBJEX-TST from                    ;
;;;                 the ACAD Command: prompt.                          ;
;;;--------------------------------------------------------------------;
(defun C:OBJEX-TST ()
  (prepare-for-OBJEX-TST)
  (setq	r1
	 (VLR-Object-reactor
	   (list ac1)
	   ac2
	   '((:vlr-modified . make-same-radius-reaction))
	 )
  )
  (setq	r2
	 (VLR-Object-reactor
	   (list ac2)
	   ac3
	   '((:vlr-modified . make-same-radius-reaction))
	 )
  )
  (setq	r3
	 (VLR-Object-reactor
	   (list ac3)
	   ac1
	   '((:vlr-modified . make-same-radius-reaction))
	 )
  )
  (vla-put-Color ac1 acRed)  ;touch of the circles to fire reactors the first time
)


;;;;;;; now take a look at ACAD console
;;;;;;; change radius of the ac1 (red one) 
;;;; both ac2 and ac3 will change there radii


;;To remove reactor
;;(vlr-remove r1)
;;(vlr-remove r2)
;;(vlr-remove r3)

;;;;; try ACAD again
;;; Now All circles radii independent again
;;; You can restore contraints by adding reactors back
;;(vlr-add r1)
;;(vlr-add r2)
;;(vlr-add r3)



;;;;;;;;;;;;;;;;;;;;; make them persistent!
;;(vlr-pers r1)
;;(vlr-pers r2)
;;(vlr-pers r3)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; to trace all events coming to circles
;|
(setq rr
       (VLR-Object-reactor
	 (list ac1 ac2 ac3)
	 nil
	 nil
	 ))

(defun vlr-full-trace (reactor)
  (foreach name (VLR-Reaction-Names reactor)
    (VLR-Reaction-Set reactor name 'VLR-trace-reaction)))

(vlr-full-trace rr)
|;

;;;--------------------------------------------------------------------;
;;;       Function:  C:OBJEX-INFO                                      ;
;;;                                                                    ;
;;;    Description:  This function displays a help file in the ACAD    ;
;;;                  Command: prompt.                                  ;
;;;                                                                    ;
;;;      Arguments:  none                                              ;
;;;                                                                    ;
;;; Returned Value:  none                                              ;
;;;                                                                    ;
;;;          Usage: (C:OBJEX-INFO) or OBJEX-INFO from                  ;
;;;                 the ACAD Command: prompt.                          ;
;;;--------------------------------------------------------------------;
(defun C:OBJEX-INFO ()
  (textscr)
  (princ "\nIn this test three circles of the same radius")
  (princ "\nwill be created and will have different colors ")
  (princ "\nTry to change one circle and the others will ")
  (princ "\nchange their radius.")

)



;;;--------------------------------------------------------------------;
;;; Add the functions within this file to the global functions list    ;
;;; to be used by the C:REACT-TEST-INFO function in R-INFO.LSP         ;
;;;--------------------------------------------------------------------;
(setq *REACT-TEST-COMMANDS-INFO*
       (cons (list "OBJEX-TST" "OBJEX-INFO")
	     *REACT-TEST-COMMANDS-INFO*))
;;EOF
;;;-----BEGIN-SIGNATURE-----
;;; 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEE+U0vr78xSzq0vXnmuWytEw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMjAwNjE1MDAwMDAwWhcNMjEwODEyMjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBAMt3bX7WxfbqKZpcgiX4jvJBSg6MCucqh4aDRHA8
;;; Hny4Fc2vKP+Xgn3mY4qtHoeNZ/j4d669d5+guDfOpD7jZX/JyR81wLE22GwswGLN
;;; M6n3N6Vudo0PcdCNXRxccGdPmJMIiEZNp84RjWN7Gy0JfgChxNiNEWS+Dezr5cYK
;;; B7UlGjGivbUdK6/HP0JlO3t3QxXYERASgPWj6YXmHGdvYHPBNit1MJTLRUj7uXyk
;;; bWzpaQEnXdey73yxg+FV2us0BicMIChoDXdTY/uAWbhkThET8GffQd08miZDNWMv
;;; IUIfFEkKjGZX6VkfkK/ShlVtjcdYlknpatvAtkFuYnQm6mECAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBACiY
;;; IcU6uh5Lz5MGiUDT3w+daDMfYW44/ak/wMK1SgkL+iHzsgHaY8plDqZ4oaxT3U45
;;; /L5BdedSZWIvR738xpjcJNKZVILKTMg3mzl0bjO/t91dj5TFlTSpCbQgBh+jbBpJ
;;; R0il59VeZ9LQTvK/2E41TK89VHXZa+8MaTrsVOyTsBuAnNdYdzzExmAqp1BZdirH
;;; JH35aOAnZz3nkcGS4knKOAc7EX8pLkhAl4UDoS2V+2MKw5IXpYO3tU5TwM7y8uGZ
;;; gj/XpMlzWXtVQvOVpwgmT0XCymP5174BFyTP1SLNhlUWUfwFCypOY6tRHd6U9uqc
;;; BATajxbYoRpvjWl9Nu8xggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQT5TS+vvzFLOrS9eea5bK0TANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQBuE6ywrsYGjUD++xYVMEe+x/gxzrpm3hoX
;;; RvZ+848JITDc10Tyc+RnOCcs3hfy789R81CwULMVIlCOXb+2MaR+XzJ/KZx3ONS6
;;; ZnSC8hc8j7RAKuokNWc28s4k4Bi6r/26LjEsPbiLe1PUl56i8vuzTA2RDZPwplLd
;;; XtXlmKFuZwVuLwOisGRKKJWanEZMhF4LzycOsL+oWDdyStaKoAaaZiXbN38jrQvl
;;; dqXEHd5JZ8uJWtmQKMZ4CFMvKAmsuBWUh4swdzR7XoEIkPtRKGZHGOsIlmw52JRT
;;; rz/lT66KuL91e7x9ze8LDOOwM9fymN2gNJT21skMp4T9XrR6RGU6
;;; -----END-SIGNATURE-----