;;;
;;;  VLX_FILE.LSP
;;;
;;;  Copyright 1987, 1988, 1990, 1992, 1994, 1996, 1997, 1998, 1999    ;
;;;  by Autodesk, Inc. All Rights Reserved.                            ;
;;;                                                                    ;
;;;  You are hereby granted permission to use, copy and modify this    ;
;;;  software without charge, provided you do so exclusively for       ;
;;;  your own use or for use by others in your organization in the     ;
;;;  performance of their normal duties, and provided further that     ;
;;;  the above copyright notice appears in all copies and both that    ;
;;;  copyright notice and the limited warranty and restricted rights   ;
;;;  notice below appear in all supporting documentation.              ;
;;;                                                                    ;
;;;  Incorporation of any part of this software into other software,   ;
;;;  except when such incorporation is exclusively for your own use    ;
;;;  or for use by others in your organization in the performance of   ;
;;;  their normal duties, is prohibited without the prior written      ;
;;;  consent of Autodesk, Inc.                                         ;
;;;                                                                    ;
;;;  Copying, modification and distribution of this software or any    ;
;;;  part thereof in any form except as expressly provided herein is   ;
;;;  prohibited without the prior written consent of Autodesk, Inc.    ;
;;;                                                                    ;
;;;  AUTODESK PROVIDES THIS SOFTWARE "AS IS" AND WITH ALL FAULTS.      ;
;;;  AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF           ;
;;;  MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,       ;
;;;  INC. DOES NOT WARRANT THAT THE OPERATION OF THE SOFTWARE          ;
;;;  WILL BE UNINTERRUPTED OR ERROR FREE.                              ;
;;;                                                                    ;
;;;  Restricted Rights for US Government Users.  This software         ;
;;;  and Documentation are provided with RESTRICTED RIGHTS for US      ;
;;;  US Government users.  Use, duplication, or disclosure by the      ;
;;;  Government is subject to restrictions as set forth in FAR         ;
;;;  12.212 (Commercial Computer Software-Restricted Rights) and       ;
;;;  DFAR 227.7202 (Rights in Technical Data and Computer Software),   ;
;;;  as applicable.  Manufacturer is Autodesk, Inc., 111 McInnis       ;
;;;  Parkway, San Rafael, California 94903.                            ;
;;;                                                                    ;
;;;
;;;
;;; This VLX application demonstrates that variables can be exchanged
;;; between application and document namespaces and between application
;;; namespace and session blackboard.
(vl-load-com)

(vl-doc-export 'import_objs)
(defun C:import_objs ()
  (setq	thisDoc	      (vla-get-ActiveDocument (setq app (vlax-get-acad-object)))
	docs	      (vla-get-documents app)
	thisDocName   (vla-get-name thisDoc)
	thisDocBlocks (vla-get-blocks thisDoc)
	thisMS	      (vla-get-modelspace thisDoc)
  )


  (setq exclude_docs (list thisDocName))

  ; Retrieve and increment counter from active document's namespace.
  ; Counter reflects number of times this function has been invoked.
  (setq import_objs_cntr (vl-doc-set 'mdi-vlx-cntr
					 (1+ (vl-doc-ref 'mdi-vlx-cntr))))
   

  (while (equal "Y" (progn
		      (initget 0 "Y N")
		      (getkword "\nImport a transfer set into active document? [Y|N] ")
		      )
		)
    ; prompt user to identify an open document
    (setq message (strcat "\nCurrently in drawing "
			  thisDocName
			  ".\nXREF in drawing from open document:"
		  )
    )

    (setq
      chosenDoc	   (vla-item docs
			     (choose_item docs message exclude_docs)
		   )
      chosenName   (vla-get-name chosenDoc)

      chosenFile   (strcat "trans" (itoa import_objs_cntr) chosenName)

      chosenSelSet (vla-item (vla-get-SelectionSets chosenDoc)
			     "mdi-vlx"
		   )
    )
    (terpri)
    (princ chosenFile)

    (vla-wblock chosenDoc chosenFile chosenSelSet)

    				;clear chosenSelSet for next loop pass

    (princ
      (strcat "\n" (vla-get-fullname chosenDoc) " is selected\n")
    )

    (setq exclude_docs (cons chosenName exclude_docs))

    (setq InsertPt
	   (vlax-3d-point (getpoint "\nChoose insertion point.\n"))
    )
    (setq importBlock
	   (vla-InsertBlock
	     thisMS
	     InsertPt
	     chosenfile
	     1
	     1
	     1
	     0
	   )
    )

    (vl-file-delete chosenFile)
    (vla-regen thisDoc acActiveViewport)
    (vla-ZoomAll (vlax-get-acad-object))
  )
)

(defun choose_item
       (collection msg excludeGrp / obj index keywds curName)
       ;|
  Allows user to identify an item in a collection, excluding members of "excludeGrp".
  excludeGrp is a list of names which might coincide with the names of items
  in the ActiveX "collection".  The user is prompted to select one number from a menu of acceptable
  collection items.  The index of the item is then returned.
  |;
  (if (or (not (listp excludeGrp))
					; collection not a vla-object
      )
    (quit)
  )

  (terpri)
  (princ msg)
  (terpri)

  (setq	index 0
	keywds ""
  )
  (terpri)
  (vlax-for obj	collection
    (if	(not (member (setq curName (vla-get-name obj))
		     excludeGrp
	     )
	)
      (progn
	(princ (strcat "[" (itoa index) "] " curName))
	(terpri)
	(setq keywds (strcat keywds (itoa index) " "))
      )
    )
    (setq index (1+ index))
  )

  (initget 1 keywds)
  (atoi (getkword "\nEnter number for an open :"))
)






;;;-----BEGIN-SIGNATURE-----
;;; 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEE+U0vr78xSzq0vXnmuWytEw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMjAwNjE1MDAwMDAwWhcNMjEwODEyMjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBAMt3bX7WxfbqKZpcgiX4jvJBSg6MCucqh4aDRHA8
;;; Hny4Fc2vKP+Xgn3mY4qtHoeNZ/j4d669d5+guDfOpD7jZX/JyR81wLE22GwswGLN
;;; M6n3N6Vudo0PcdCNXRxccGdPmJMIiEZNp84RjWN7Gy0JfgChxNiNEWS+Dezr5cYK
;;; B7UlGjGivbUdK6/HP0JlO3t3QxXYERASgPWj6YXmHGdvYHPBNit1MJTLRUj7uXyk
;;; bWzpaQEnXdey73yxg+FV2us0BicMIChoDXdTY/uAWbhkThET8GffQd08miZDNWMv
;;; IUIfFEkKjGZX6VkfkK/ShlVtjcdYlknpatvAtkFuYnQm6mECAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBACiY
;;; IcU6uh5Lz5MGiUDT3w+daDMfYW44/ak/wMK1SgkL+iHzsgHaY8plDqZ4oaxT3U45
;;; /L5BdedSZWIvR738xpjcJNKZVILKTMg3mzl0bjO/t91dj5TFlTSpCbQgBh+jbBpJ
;;; R0il59VeZ9LQTvK/2E41TK89VHXZa+8MaTrsVOyTsBuAnNdYdzzExmAqp1BZdirH
;;; JH35aOAnZz3nkcGS4knKOAc7EX8pLkhAl4UDoS2V+2MKw5IXpYO3tU5TwM7y8uGZ
;;; gj/XpMlzWXtVQvOVpwgmT0XCymP5174BFyTP1SLNhlUWUfwFCypOY6tRHd6U9uqc
;;; BATajxbYoRpvjWl9Nu8xggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQT5TS+vvzFLOrS9eea5bK0TANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQAiRIo87DvbSK7w7tWlMwNN6C7PWf6pLU7w
;;; S7LlNnBX2VAMOcq40Nrwis9CxmArGb1JNiE0rNMCDKdkh5a6+6SPh3DBoYJkhkpV
;;; 4JqGmUlRAsYUYYuFw5cex7m8+ntACYWXQpcgKsOUTZWHQKKazx9mL/qc3sLQ2Zy/
;;; K3YNq9ybWg/geOIm4geG68F6ABbC51xVypui8h9EwM5dMk0H4TNqJpV/NBERl9vG
;;; coUDyBGyOwQ0ArkIiGrbutQRZEAf4uZiNSbhhoC83NjXRLn8DP3jPuCojwxK6vBQ
;;; H7KGStCyw+vzKb6cjInvS92MwW17AoG+9sBPEATc0d6mlGTu/s0u
;;; -----END-SIGNATURE-----