Texture2D<float>  g_AOMap;
Texture2D<float4> g_ColorBuffer;

SamplerState samNearest
{
    Filter   = MIN_MAG_MIP_POINT;
    AddressU = Clamp;
    AddressV = Clamp;
};

//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float4 Pos : POSITION;
    float3 UV : TEXCOORD0;
};

struct PostProc_VSOut
{
    float4 pos : SV_Position;
    float2 tex : TEXCOORD0;
};

//Vertex shader that generates a full screen quad with texcoords g_Rom vertIDs
//To use draw 3 vertices with primitive type triangle strip
PostProc_VSOut FullScreenQuadVS( VS_INPUT IN )
{
    PostProc_VSOut output = (PostProc_VSOut)0.0f;
    output.pos=IN.Pos;
    output.tex=IN.UV.xy;

    return output;
}

//-------------------------------------------------------------------------
float4 Modulate( PostProc_VSOut IN ): SV_TARGET
{
    float accesiability = g_AOMap.Sample( samNearest, IN.tex );
    float4 color = g_ColorBuffer.Sample( samNearest, IN.tex );
    //color-=(1-accesiability)*float4(0.2f,0.2f,0.2f,1.0f);
   //return float4(accesiability,accesiability,accesiability,1.0f);
   return (color*accesiability);
    //return (color);
}

//-------------------------------------------------------------------------
technique10 BlurPass
{
    pass p0
    {
        SetVertexShader( CompileShader( vs_4_0, FullScreenQuadVS() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, Modulate() ) );
    }
}

