#define LIGHTING
//For testing
//#define IBL
#include "InventorBasicEffectDx9.fxh"

//inverse width and height of bump mapping
#ifdef BUMP_TEXTURE
	float2 g_fInverseBumpMapSize :InverseBumpMapSize=float2(1.0f/256.0f,1.0f/256.0f);
	#define GENERATENORMAPATPS
#endif

struct VSPosNormTex
{
	float3 Pos			: POSITION;
	float3 Norm			: NORMAL;
#ifdef BUMP_TEXTURE
	float3 Tangent		: TANGENT;
	float3 Binormal		: BINORMAL;
#endif
	float2 Tex			: TEXCOORD;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_PosNormTex( VSPosNormTex Input)
{
	VSOutput Out = (VSOutput) 0;
	float4 LocalPos = float4(Input.Pos,1.0f);
	Out.Pos = mul(LocalPos, g_matWorldViewProj);

	float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
	float3 Viewer = -normalize(ViewPos);                   //viewer
	float3 ViewNormal = mul(Input.Norm, (float3x3)g_matWorldViewIT); //normal in view space
	ViewNormal = normalize(ViewNormal);

#ifdef IBL
	//It is needed to use world space normal and view direction for IBL
	#ifndef BUMP_TEXTURE
		Out.Normal=normalize(mul(ViewNormal, (float3x3)transpose(g_matView)));
	#endif
	Out.Viewer=normalize(mul(Viewer, (float3x3)transpose(g_matView)));
#endif //IBL
	
#ifdef DIFFUSE_TEXTURE
	Out.Tex = float4(Input.Tex, 0, 1.0f);
#endif
	
#ifdef BUMP_TEXTURE
	Out.Tangent=normalize(Input.Tangent);
	Out.Binormal=normalize(Input.Binormal);
	Out.Locpos=Input.Pos;
	#ifndef DIFFUSE_TEXTURE
		Out.Tex = float4(Input.Tex, 0, 1.0f);
	#endif
#endif //bump texture

#ifndef IBL
	#ifdef ENVIRONMENT_TEXTURE	
		#ifndef BUMP_TEXTURE
		if (bEnvironmentMap2D)
		{			
			Out.EnvTex  = float4(ViewNormal, 1.0f);
		}
		else
		{
			float3 VwNorm = normalize(mul(Viewer, (float3x3)transpose(g_matView)));
			float3 Nw = normalize(mul(ViewNormal, (float3x3)transpose(g_matView)));
			Out.EnvTex = float4(2.f * dot(VwNorm,Nw) * Nw - VwNorm, 1.0f);
		}
		#else
			Out.EnvTex = float4(Viewer,1.0f); 
		#endif
	#endif	//Env tex
#endif //IBL

#ifndef BUMP_TEXTURE
	float Glossness = g_Misc.x;
    	float Opacity = g_Misc.y;
	TripleColor Color = CalcLighting(Input.Pos, Viewer, ViewNormal, g_Emissive, g_Ambient, g_Diffuse, g_Specular, Glossness, Opacity
#ifdef SHADOWS
        , Out.ShadowD, Out.ShadowS
#endif
        );
	Out.ColorD = Color.Diffuse;
	Out.ColorSAndFogFactor.xyz = Color.Specular.xyz; 
#endif //Bump texture

#ifdef SHADOWS
	Out.ShadowPos = mul(mul(LocalPos, g_matWorld), gShadowMapXf);
#endif
	

	if(g_fogEnabled)
	{
		Out.ColorSAndFogFactor.w = CalcFogFactor(ViewPos.z);
	}

	return Out;
}

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------

float4 PS_PosNormTex( PSInput Input ) : COLOR0
{

#ifdef BUMP_TEXTURE
	float Glossness=g_Misc.x;
	float Opacity=g_Misc.y;
	float3 Normal=(float3)0;
	float4 bumpTex= mul(Input.Tex, g_matBumpTex);
	#ifdef GENERATENORMAPATPS	
		float3 left =tex2D(gBumpSamp, bumpTex.xy- float2(g_fInverseBumpMapSize.x, 0.0f));
		float3 top = tex2D(gBumpSamp, bumpTex.xy- float2(0.0f, g_fInverseBumpMapSize.y));
		float3 right = tex2D(gBumpSamp, bumpTex.xy+ float2(g_fInverseBumpMapSize.x, 0.0f));
		float3 bottom = tex2D(gBumpSamp, bumpTex.xy+ float2(0.0f, g_fInverseBumpMapSize.y));
		float3 diffU = right - left;
		float3 diffV = bottom - top;
		float3 SampleNormal = cross(float3(1.0f, 0.0f, diffU.r*gBumpAmount), float3(0.0f, 1.0f, diffV.r*gBumpAmount));
		Normal = normalize(SampleNormal);
	#else
		float4 texColor=tex2D(gBumpSamp, bumpTex.xy);
		Normal = 2*texColor.rgb - 1.0f;
	#endif
	float3x3 tbn=float3x3(normalize(Input.Tangent),normalize(Input.Binormal),normalize(cross(Input.Tangent,Input.Binormal)));
	Normal=mul(Normal,tbn);

	Normal= mul(Normal, (float3x3)g_matWorldViewIT); //normal in view space

	float3 ViewPos = mul(float4(Input.Locpos,1.0f),g_matWorldView);    //position in view space
	float3 Viewer = -normalize(ViewPos);                   //viewer
	
	TripleColor TripColor = CalcLighting(Input.Locpos, Viewer, Normal, g_Emissive, g_Ambient, g_Diffuse, g_Specular, Glossness, Opacity
	#ifdef SHADOWS
        , Input.ShadowD, Input.ShadowS
	#endif
	);
	Input.ColorD = TripColor.Diffuse;
	Input.ColorSAndFogFactor.xyz = TripColor.Specular.xyz; 	
#endif //Bump mapping

#ifdef SHADOWS
#ifdef SOFT_SHADOWS
	float shadowFactor = VarianceShadow(Input.ShadowPos);
#else
	float shadowFactor = SampleShadowMap(Input.ShadowPos);
#endif
	Input.ColorD += Input.ShadowD * (1.0f - (1.0f - shadowFactor) * gShadowDensity);
	Input.ColorSAndFogFactor.xyz += Input.ShadowS * (1.0f - (1.0f - shadowFactor) * gShadowDensity);
#endif

#ifdef IBL
	float4 diffuse=float4(0,0,0,0);
	float3 IBLNormal=0;
	#ifdef BUMP_TEXTURE
		IBLNormal=normalize(mul(Normal, (float3x3)transpose(g_matView)));
	#else
		IBLNormal=normalize(Input.Normal);
	#endif //bump mapping
	CalcIBLEnvTexture(Input,g_Specular,g_Diffuse, g_Misc.z ,IBLNormal, Input.Viewer);
#else //IBL
	#ifdef ENVIRONMENT_TEXTURE	
		#ifdef BUMP_TEXTURE
			float3 VwNorm = normalize(mul(Input.EnvTex, (float3x3)transpose(g_matView)));
			float3 Nw = normalize(mul(Normal, (float3x3)transpose(g_matView)));
			Input.EnvTex = float4(2.f * dot(VwNorm,Nw) * Nw - VwNorm, 1.0f);
		#endif
		Input.EnvTex=mul(Input.EnvTex, g_matEnvTex);
		CalcEnvironmentTexture(Input,g_Specular,g_Misc.z);
	#endif //Env texture
#endif //IBL

#ifdef DIFFUSE_TEXTURE
		Input.Tex= mul(Input.Tex, g_matDiffTex);
		CalcDiffuseTexture(Input);
#endif

	if(Input.ColorD.a < g_Misc.w)
		discard;
			
	float4 Color=(float4)0;
	Color.xyz = saturate(Input.ColorD.xyz + Input.ColorSAndFogFactor.xyz);
	Color.a = Input.ColorD.a;

if(g_fogEnabled)
{
	float FogFactor = Input.ColorSAndFogFactor.w;
	return FogFactor * Color + (1.0 - FogFactor) * g_fogColor;
}
else
	return Color;
}

//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

#ifdef IBL
	#define SM3
#endif

#ifdef BUMP_TEXTURE
	#define SM3
#endif

#ifdef SHADOWS
	#define SM3
#endif

technique PosNormTex
{
	pass P0
	{
#ifdef SM3 
		VertexShader = compile vs_3_0 VS_PosNormTex();
		PixelShader = compile ps_3_0 PS_PosNormTex();
#else
#ifdef SHADERMODEL2
		VertexShader = compile vs_2_0 VS_PosNormTex();
		PixelShader = compile ps_2_0 PS_PosNormTex();
#else
		VertexShader = compile vs_2_a VS_PosNormTex();
		PixelShader = compile ps_2_a PS_PosNormTex();
#endif 
#endif 
	}
}