#include "InventorBasicEffectDx9.fxh"

struct VSPosColTex
{
	float3 Pos			: Position;
	float4 Col			: Color;
	float2 Tex			: TexCoord;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_PosColTex( VSPosColTex Input)
{
	VSOutput Out = (VSOutput) 0;
	float4 LocalPos = float4(Input.Pos,1.0f);
	Out.Pos = mul(LocalPos, g_matWorldViewProj);
	Out.ColorD = Input.Col;

#ifdef DIFFUSE_TEXTURE	
	Out.Tex = float4(Input.Tex, 0, 1.0f);
	Out.Tex = mul(Out.Tex, g_matDiffTex);
#endif

	if(g_fogEnabled)
	{
		float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
		Out.ColorSAndFogFactor.w = CalcFogFactor(ViewPos.z);
	}

	return Out;
}

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------

float4 PS_PosColTex( PSInput Input ) : COLOR0
{
#ifdef DIFFUSE_TEXTURE
	CalcDiffuseTexture(Input);
#endif
	if(Input.ColorD.a < g_Misc.w)
		discard;
	float4 Color=(float4)0;
	Color.xyz = saturate(Input.ColorD.xyz + Input.ColorSAndFogFactor.xyz);
	Color.a = Input.ColorD.a;

	if(g_fogEnabled)
	{
		float FogFactor = Input.ColorSAndFogFactor.w;
		return FogFactor * Color + (1.0 - FogFactor) * g_fogColor;
	}
	else
		return Color;
}

//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

technique PosColTex
{
    pass P0
    {   
		VertexShader = compile vs_2_0 VS_PosColTex();
        PixelShader = compile ps_2_0 PS_PosColTex();
    }
}