struct VSPosTex
{
	float3 Pos		: Position;
	float2 offset		: TexCoord;
};

struct VSOutput
{
	float4 Pos		: POSITION;
	float4 ColorD		: COLOR0;
};

float4	g_Emissive		: EmissiveColor;
float2		g_ViewPort			: viewportpixelsize;
//wvp transform
float4x4 g_matWorldViewProj	: WorldViewProjection;
//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_PosTex( VSPosTex Input)
{
	VSOutput Out = (VSOutput) 0;
	
	//project vertex in model space to clipping space
	float4 LocalPos = float4(Input.Pos.xyz,1.0f);
	float4 outpos = mul(LocalPos,g_matWorldViewProj);
	
	//Perspective divide
	outpos.xyz /= outpos.w;
	outpos.w = 1.0f;
	
	outpos.xy += Input.offset/g_ViewPort;
	Out.Pos = outpos;
	Out.ColorD = g_Emissive;
	return Out;
}

float4 PS_PosTex( VSOutput Input ) : SV_Target
{
	float4 Color = saturate(Input.ColorD);
	return Color;
}
//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

technique PosTex
{
    pass P0
    {   
	VertexShader = compile vs_2_0 VS_PosTex();
       	PixelShader = compile ps_2_0 PS_PosTex(); 	
    }
}