#ifdef SHADOWS
#include "ShadowMapDx9.fxh"
#ifdef SOFT_SHADOWS
float2 gExpFactor = { 20.000000, 5.000000 }; 
float  threshold = 0.0f;
float VarianceShadow( float4 Plc) 
{ 
    float3 Pndc = Plc.xyz / Plc.w; 
    if (any(Pndc < -1.0f) || any(Pndc > 1.0f)) return 1.0f; 
    float2 uv = Pndc.xy * float2(0.5, -0.5) + 0.5; 
    float4 moments1 = tex2D(gShadowMapSamp, uv); 
    float4 moments2 = tex2D(gShadowMapSamp, uv + float2(gTexelSize, 0.0f)); 
    float4 moments3 = tex2D(gShadowMapSamp, uv + float2(0.0f, gTexelSize)); 
    float4 moments4 = tex2D(gShadowMapSamp, uv + float2(gTexelSize, gTexelSize)); 
    float2 texelFrac = frac(gShadowMapSize * uv); 
    float4 moments = lerp(lerp(moments1, moments2, texelFrac.x), 
                          lerp(moments3, moments4, texelFrac.x), texelFrac.y); 
    // Compute the positive contribution.
    float depth = exp(gExpFactor.x * Pndc.z); 
    float p = (depth <= moments.x); 
    float variance = moments.y - moments.x * moments.x; 
    variance = max(variance, 1.0e-3f*max(1.0f, depth*depth)); 
    float d = depth - moments.x; 
    float p_max = variance / (variance + d * d); 
    float posValue = max(p, p_max); 
            
    // Compute the negative contribution.
    depth = -exp(-gExpFactor.y * Pndc.z); 
    p = (depth <= moments.z); 
    variance = moments.w - moments.z * moments.z; 
    variance = max(variance, 1.0e-3f*max(1.0f, depth*depth)); 
    d = depth - moments.z; 
    p_max = variance / (variance + d * d); 
    float negValue = max(p, p_max); 

    // Use the minimum.
    float light = min(negValue, posValue);
    return saturate((light - threshold) / (1.0f - threshold));
} 
#endif 
#endif

#define epsilon (10e-6)
#define E 2.71828
#define MAXLIGHTINGNUM 8
struct TripleColor
{
	float4	Ambient;
	float4 	Diffuse;
	float4 	Specular;
};

struct VSOutput
{
	float4 Pos		: Position;
#ifdef BUMP_TEXTURE
	//SM3.0 would be used. Diffuse tex and bump tex would be calculated at PS
	float4 Tex				: TEXCOORD0;
#else
	#ifdef DIFFUSE_TEXTURE
		float4 Tex				: TEXCOORD0;
	#endif
#endif

//When IBL is enabled, the normal reflection map would be surpressed.
#ifndef IBL
	#ifdef ENVIRONMENT_TEXTURE
		float4 EnvTex		: TEXCOORD1;
	#endif
#endif

	float4 ColorD					: COLOR0;
	//the first 3 floats would be used as specular color and last float would hold fog factor
	float4 ColorSAndFogFactor		: COLOR1;
	
#ifdef BUMP_TEXTURE
	float3 Tangent		: COLOR2;
	float3 Binormal		: COLOR3;
	float3 Locpos		: COLOR4;
#endif

#ifdef IBL
	//Normal and viewer direction at world space
	#ifndef BUMP_TEXTURE
		float3 Normal		: COLOR5;
	#endif
	float3 Viewer		: COLOR6;
#endif

#ifdef SHADOWS
    float4 ShadowPos    	: TEXCOORD2;
    float4 ShadowD      	: TEXCOORD3;
    float4 ShadowS      	: TEXCOORD4;
#endif
};

struct PSInput
{
#ifdef BUMP_TEXTURE
	//SM3.0 would be used. Diffuse tex and bump tex would be calculated at PS
	float4 Tex				: TEXCOORD0;
#else
	#ifdef DIFFUSE_TEXTURE
		float4 Tex				: TEXCOORD0;
	#endif
#endif

//When IBL is enabled, the normal reflection map would be surpressed.
#ifndef IBL
#ifdef ENVIRONMENT_TEXTURE
	float4 EnvTex		: TEXCOORD1;
#endif
#endif

	float4 ColorD					: COLOR0;
	//the first 3 floats would be used as specular color and last float would hold fog factor
	float4 ColorSAndFogFactor		: COLOR1;
	
#ifdef BUMP_TEXTURE
	float3 Tangent		: COLOR2;
	float3 Binormal		: COLOR3;
	float3 Locpos		: COLOR4;
#endif

#ifdef IBL
	//Normal and viewer direction at world space
	#ifndef BUMP_TEXTURE
		float3 Normal		: COLOR5;
	#endif
	float3 Viewer		: COLOR6;
#endif

#ifdef SHADOWS
    float4 ShadowPos    	: TEXCOORD2;
    float4 ShadowD      	: TEXCOORD3;
    float4 ShadowS      	: TEXCOORD4;
#endif
};

#ifdef BUMP_TEXTURE
float		gBumpAmount				: BumpAmount=1.0f;
texture	    gBumpTex				: BumpTexture = NULL;
float4x4    g_matBumpTex			: BumpTexCoordTransMatrix = 
{
	{1.0f, 0.0f, 0.0f, 0.0f},
	{0.0f, 1.0f, 0.0f, 0.0f},
	{0.0f, 0.0f, 1.0f, 0.0f},
	{0.0f, 0.0f, 0.0f, 1.0f}
};	
sampler2D gBumpSamp : BumpSampler = sampler_state
{
	Texture = <gBumpTex>;
};

#endif

#ifdef	LIGHTING
struct Light
{
	float4	DiffColor;
    	float4	AmbColor;
    	float4	SpecColor;
    	float3	Dir;
   	float3	Pos;
   	float4	Attenuation;	//1, D, D^2, Range;
   	float4	Spot;		//cos(theta/2), cos(phi/2), falloff
};
#endif

//Material

float4		g_Emissive			: EmissiveColor;
float4		g_Ambient			: AmbientColor;
float4		g_Diffuse			: DiffuseColor;
float4		g_Specular			: SpecularColor;
float2		g_ViewPort			: viewportpixelsize;

//SpecularPower, Opacity, ReflectionBlend, AlphaTestRef
float4		g_Misc				: Miscellaneous = float4(1.0f, 1.0f, 0.0f, 0.0f);

//Transform
float4x4 	g_matWorldViewProj		: WorldViewProjection;
float4x4 	g_matWorld			: World;
float4x4 	g_matWorldView			: WorldView;
float4x4    	g_matViewIT			: ViewInverseTranspose;
float4x4    	g_matView			: View;

#ifndef	NONORMAL
float4x4 	g_matWorldViewIT		: WorldViewInverseTranspose;
#endif //NONORMAL

#ifdef LIGHTING
//Lights
Light		g_lights[8]			: LightArray;
int		g_numDirLight			: DirLightCount = 0;
int		g_numPointLight			: PointLightCount = 0;
int		g_numSpotLight			: SpotLightCount = 0;
bool	g_enabledLight			:LightEnable=true;
#endif


#define FOGMODE_LINEAR		0
#define FOGMODE_EXP		1
#define FOGMODE_EXP2		2

//Fog
bool		g_fogEnabled		: FogEnabled = false;
int		    g_fogMode			: FogMode  = FOGMODE_LINEAR;
//x for start, y for end, z for density
float4		g_fogRange			: FogRange = float4(0.0f, 0.0f, 1.0f, 1.0f);
float4		g_fogColor			: FogColor = float4(0, 0, 0, 0);

// Vertex lighting calculation
// A vertex's color is the sum of the contribution from:
// 1. a material emission term, Em
// 2. global ambient lighting, Ag, and a material ambient term, Am
// 3. individual light's contributions L(i)

// VertexColor = Em + Ag*Am + sum(L(i)), where
// L(i) = Attenuation(i)*SpotlightFactor(i)*[Ai*Am + max(L.N, 0)*D(i)*Dm + pow(max(H.N, 0), shineness)*S(i)*Sm]

//-----------------------------------------------------------------------------
// Name: DoDirLight()
// Desc: Directional light computation (in eye space)
// N: Normal in eye space; V: Viewer in eye space; Index: Light Index
//-----------------------------------------------------------------------------

#ifdef LIGHTING
#ifdef NONORMAL
#ifdef ALLLIGHTTYPES
TripleColor DoSpotLightAmb(float4 P,int Index)
{
	TripleColor Out=(TripleColor)0;

	//Ambient
	Out.Ambient = g_lights[Index].AmbColor;
    
	float AttenSpot = 1.f;
	float LD = length(g_lights[Index].Pos-(float3)mul(P, g_matWorld));
	if(LD > g_lights[Index].Attenuation.w)
	{
		AttenSpot = 0.f;
	}
	else
	{
		AttenSpot *= 1.f/(g_lights[Index].Attenuation.x + g_lights[Index].Attenuation.y*LD + 
			g_lights[Index].Attenuation.z*LD*LD);
	}
	
	//spot cone computation
	float3 L = mul(normalize((g_lights[Index].Pos-(float3)mul(P, g_matWorld))), 
		(float3x3)g_matViewIT);
	float3 L2 = mul(g_lights[Index].Dir, (float3x3)g_matViewIT);
	float Rho = dot(L, L2);
	AttenSpot *= pow(saturate((Rho - g_lights[Index].Spot.y)/(g_lights[Index].Spot.x - g_lights[Index].Spot.y)), 1.0f);
		//g_lights[Index].Spot.z);
	Out.Ambient *= AttenSpot;
	Out.Diffuse *= AttenSpot;
	Out.Specular *= AttenSpot;
	return Out;
}
TripleColor DoPointLightAmb(float4 P, int Index)
{
	TripleColor Out=(TripleColor)0;
	
	//Ambient
	Out.Ambient = g_lights[Index].AmbColor;
	//Attenuation
	float Atten = 1.f;
	float LD = length(g_lights[Index].Pos-(float3)mul(P, g_matWorld));
	if(LD > g_lights[Index].Attenuation.w)//Attenuation.w is Range
	{
		Atten = 0.f;
	}
	else
	{
		Atten *= 1.f/(g_lights[Index].Attenuation.x + 
			g_lights[Index].Attenuation.y*LD + 
			g_lights[Index].Attenuation.z*LD*LD);
	}
	Out.Ambient *= Atten;
	return Out;
}
#endif
//For those case without normal, ambient color is just needed
TripleColor DoDirLightAmb(int Index)
{
   	TripleColor Out=(TripleColor)0;

   	//Ambient
   	Out.Ambient = g_lights[Index].AmbColor;
   	return Out;
}

//For those cases without normal
TripleColor CalcLightingAmb(float3 Pos, float4 Emissive,float4 Ambient,float Opacity)
{
	TripleColor Color;
	//Emissive and Ambient lights
	Color.Diffuse = Emissive;
	Color.Specular = 0;

//directional lights
//If the graphics card just supports 2.0, this branch would be used.
//Using the old way to calculating lightings. But the shader compile time may be a little longer.
#ifdef SHADERMODEL2
	for(int i = 0; i < g_numDirLight; i++)
	{
#else
	//This should be used by SM2.1 or higher version
	//This is the optimized way. It would reduce shader compile time greately. It is needed that the card supports at least vs_2_a and ps_2_a version
	//Because vs_2_0 don't support dynamic flow control.
	[loop] for(int i = 0; i < MAXLIGHTINGNUM; i++)
	{
		if(i<g_numDirLight)
		{
#endif
		TripleColor ColOut = DoDirLightAmb(i);
		Color.Diffuse += ColOut.Ambient*Ambient;
#ifndef SHADERMODEL2
		}
#endif
	}

#ifdef ALLLIGHTTYPES
	float4 LocalPos = float4(Pos,1.0f);
	int Stride = g_numDirLight;
//point lights
//If the graphics card just supports 2.0, this branch would be used.
//Using the old way to calculating lightings. But the shader compile time may be a little longer.
#ifdef SHADERMODEL2
	for(int j = 0; j < g_numPointLight; j++)
	{
#else
	//This should be used by SM2.1 or higher version
	//This is the optimized way. It would reduce shader compile time greately. It is needed that the card supports at least vs_2_a and ps_2_a version
	//Because vs_2_0 don't support dynamic flow control.
	[loop] for(int j = 0; j < MAXLIGHTINGNUM; j++)
	{
		if(j<g_numPointLight)
		{
#endif
			TripleColor ColOut = DoPointLightAmb(LocalPos,j+Stride);
			Color.Diffuse += ColOut.Ambient*Ambient ;
#ifndef SHADERMODEL2
		}
#endif
	}
	Stride = g_numDirLight+g_numPointLight;
	//spot lights
//If the graphics card just supports 2.0, this branch would be used.
//Using the old way to calculating lightings. But the shader compile time may be a little longer.
#ifdef SHADERMODEL2
	for(int k = 0; k < g_numSpotLight; k++)
	{
#else
	//This should be used by SM2.1 or higher version
	//This is the optimized way. It would reduce shader compile time greately. It is needed that the card supports at least vs_2_a and ps_2_a version
	//Because vs_2_0 don't support dynamic flow control.
	[loop] for(int k = 0; k < MAXLIGHTINGNUM; k++)
	{
		if(k<g_numSpotLight)
		{
#endif
			TripleColor ColOut = DoSpotLightAmb(LocalPos,k+Stride);
			Color.Diffuse += ColOut.Ambient*Ambient ;
#ifndef SHADERMODEL2
		}
#endif
	}
#endif 
	Color.Diffuse.w = Opacity;//Opacity
	Color.Specular.w = 0;
	return Color;
}

#else

TripleColor DoDirLight(float3 N, float3 V, int Index, float Glossness)
{	
   	TripleColor Out=(TripleColor)0;

   	float3 L = mul(g_lights[Index].Dir, (float3x3)g_matViewIT);
   	//Ambient
   	Out.Ambient = g_lights[Index].AmbColor;
   	//Diffuse
   	Out.Diffuse = max(dot(N, L), 0.0f) * g_lights[Index].DiffColor;
   	//Specular
   	if(dot(N, L)>=0.0f)
   	{
		Out.Specular+= pow(max(dot(normalize(L + V), N),0.000001f), Glossness)*g_lights[Index].SpecColor;
   	} 
   	return Out;
}

#ifdef ALLLIGHTTYPES
//-----------------------------------------------------------------------------
// Name: DoPointLight()
// Desc: Point light computation (in eye space)
// P: Position in local space; N: Normal in eye space; V: Viewer in eye space; Index: Light Index
//-----------------------------------------------------------------------------
TripleColor DoPointLight(float4 P, float3 N, float3 V, int Index, float Glossness)
{
	float3 L = mul(normalize((g_lights[Index].Pos-(float3)mul(P, g_matWorld))), (float3x3)g_matViewIT);
	TripleColor Out=(TripleColor)0;
	//Ambient
	Out.Ambient = g_lights[Index].AmbColor;
	//Diffuse
	Out.Diffuse = max(dot(N, L), 0.0f) * g_lights[Index].DiffColor;
	//Specular
    if(dot(N, L)>=0.0f)
    {
			Out.Specular+= pow(max(dot(normalize(L + V), N),0.000001f), Glossness)*g_lights[Index].SpecColor;
	}
	//Attenuation
	float Atten = 1.f;
	float LD = length(g_lights[Index].Pos-(float3)mul(P, g_matWorld));
	if(LD > g_lights[Index].Attenuation.w)//Attenuation.w is Range
	{
		Atten = 0.f;
	}
	else
	{
		Atten *= 1.f/(g_lights[Index].Attenuation.x + 
			g_lights[Index].Attenuation.y*LD + 
			g_lights[Index].Attenuation.z*LD*LD);
	}
	Out.Ambient *= Atten;
	Out.Diffuse *= Atten;
	Out.Specular *= Atten;
	return Out;
}

//-----------------------------------------------------------------------------
// Name: DoSpotLight()
// Desc: Spot light computation (in eye space)
// P: Position in local space; N: Normal in eye space; V: Viewer in eye space; Index: Light Index
//-----------------------------------------------------------------------------
TripleColor DoSpotLight(float4 P, float3 N, float3 V, int Index, float Glossness)
{
	float3 L = mul(normalize((
		g_lights[Index].Pos-(float3)mul(P, g_matWorld))), 
		(float3x3)g_matViewIT);
	TripleColor Out=(TripleColor)0;
	//Ambient
	Out.Ambient = g_lights[Index].AmbColor;
	//Diffuse
	Out.Diffuse = max(dot(N, L), 0.0f) * g_lights[Index].DiffColor;
	//Specular    
    if(dot(N, L)>=0.0f)
    {
		Out.Specular+= pow(max(dot(normalize(L + V), N),0.000001f), Glossness)*g_lights[Index].SpecColor;
	}
	float AttenSpot = 1.f;
	float LD = length(g_lights[Index].Pos-(float3)mul(P, g_matWorld));
	if(LD > g_lights[Index].Attenuation.w)
	{
		AttenSpot = 0.f;
	}
	else
	{
		AttenSpot *= 1.f/(g_lights[Index].Attenuation.x + g_lights[Index].Attenuation.y*LD + 
			g_lights[Index].Attenuation.z*LD*LD);
	}
	
	//spot cone computation
	float3 L2 = mul(g_lights[Index].Dir, (float3x3)g_matViewIT);
	AttenSpot *= pow(saturate(( dot(L, L2) - g_lights[Index].Spot.y)/(g_lights[Index].Spot.x - g_lights[Index].Spot.y)), 1.0f);
		//g_lights[Index].Spot.z);
	Out.Ambient *= AttenSpot;
	Out.Diffuse *= AttenSpot;
	Out.Specular *= AttenSpot;
	return Out;
}
#endif 

//-----------------------------------------------------------------------------
// Name: CalcLighting
// Desc: Calculate the lighting for each vertex
//-----------------------------------------------------------------------------
TripleColor CalcLighting(float3 Pos, float3 Viewer, float3 ViewNormal, 
			float4 Emissive, float4 Ambient, float4 Diffuse, 
			float4 Specular, float Glossness, float Opacity
#ifdef SHADOWS
			,inout float4 shadowD, inout float4 shadowS
#endif
			)
{
	TripleColor Color;
	//Emissive and Ambient lights
	Color.Diffuse = Emissive;
	Color.Specular = 0;
	float4 LocalPos = float4(Pos,1.0f);
	
	//directional lights
//If the graphics card just supports 2.0, this branch would be used.
//Using the old way to calculating lightings. But the shader compile time may be a little longer.
#ifdef SHADERMODEL2
	for(int i = 0; i < g_numDirLight; i++)
	{
#else
	//This should be used by SM2.1 or higher version
	//This is the optimized way. It would reduce shader compile time greately. It is needed that the card supports at least vs_2_a and ps_2_a version
	//Because vs_2_0 don't support dynamic flow control.
	[loop] for(int i = 0; i < MAXLIGHTINGNUM; i++)
	{
		if(i<g_numDirLight)
		{
#endif
		TripleColor ColOut = DoDirLight(ViewNormal, Viewer, i, Glossness);
		Color.Diffuse += (ColOut.Ambient*Ambient + ColOut.Diffuse*Diffuse);
		Color.Specular += ColOut.Specular*Specular;
// at least 2.1 version is needed for shadows.
#ifdef SHADOWS
			if (i == 0)
			{
        		shadowD = ColOut.Diffuse*Diffuse;
        		shadowS = ColOut.Specular*Specular;
        		Color.Diffuse -= shadowD;
        		Color.Specular -= shadowS;
			}
#endif
#ifndef SHADERMODEL2
		}
#endif
	}
	
#ifdef ALLLIGHTTYPES
	int Stride = g_numDirLight;
	//point lights
//If the graphics card just supports 2.0, this branch would be used.
//Using the old way to calculating lightings. But the shader compile time may be a little longer.
#ifdef SHADERMODEL2
	for(int j = 0; j < g_numPointLight; j++)
	{
#else
	//This should be used by SM2.1 or higher version
	//This is the optimized way. It would reduce shader compile time greately. It is needed that the card supports at least vs_2_a and ps_2_a version
	//Because vs_2_0 don't support dynamic flow control.
	[loop] for(int j = 0; j < MAXLIGHTINGNUM; j++)
	{
		if(j<g_numPointLight)
		{
#endif
			TripleColor ColOut = DoPointLight(LocalPos, ViewNormal, Viewer, j+Stride, Glossness);
			Color.Diffuse += (ColOut.Ambient*Ambient + ColOut.Diffuse*Diffuse);
			Color.Specular += ColOut.Specular*Specular;
#ifndef SHADERMODEL2
		}
#endif
	}
	
	Stride = g_numDirLight+g_numPointLight;
	//spot lights
//If the graphics card just supports 2.0, this branch would be used.
//Using the old way to calculating lightings. But the shader compile time may be a little longer.	
#ifdef SHADERMODEL2
	for(int k = 0; k < g_numSpotLight; k++)
	{
#else
	//This should be used by SM2.1 or higher version
	//This is the optimized way. It would reduce shader compile time greately. It is needed that the card supports at least vs_2_a and ps_2_a version
	//Because vs_2_0 don't support dynamic flow control.
	[loop] for(int k = 0; k < MAXLIGHTINGNUM; k++)
	{
		if(k<g_numSpotLight)
		{
#endif
			TripleColor ColOut = DoSpotLight(LocalPos, ViewNormal, Viewer, k+Stride, Glossness);
			Color.Diffuse += (ColOut.Ambient*Ambient + ColOut.Diffuse*Diffuse);
			Color.Specular += ColOut.Specular*Specular;
#ifndef SHADERMODEL2
		}
#endif
	}
#endif 	

	Color.Diffuse.w = Opacity;//Opacity
	Color.Specular.w = 0;
	return Color;
}
#endif //NONORMAL
#endif //LIGHTING

#ifdef DIFFUSE_TEXTURE

#define TEX_COORD_SPECIFY			0
#define TEX_COORD_POSITION			1
#define TEX_COORD_NORMAL			2
#define TEX_COORD_CAMERASPACEPOSITION		3
#define TEX_COORD_CAMERASPACENORMAL		4	
#define TEX_COORD_CAMERASPACEREFLECTIONVECTOR	5

#define TEX_OP_DISABLE				0
#define TEX_OP_DIFFUSE				1
#define TEX_OP_DECAL				2
#define TEX_OP_MODULATE				3
#define TEX_OP_MIX				4

int	g_texOpType				: TexOpMode     = TEX_OP_DISABLE;
int	g_texCoordType				: TexCoordMode  = TEX_COORD_SPECIFY;

texture	    gDiffTex				: DiffuseTexture = NULL;
float4x4    g_matDiffTex			: DiffuseTexCoordTransMatrix = 
{
	{1.0f, 0.0f, 0.0f, 0.0f},
	{0.0f, 1.0f, 0.0f, 0.0f},
	{0.0f, 0.0f, 1.0f, 0.0f},
	{0.0f, 0.0f, 0.0f, 1.0f}
};	
sampler2D gDiffSamp : DiffuseSampler = sampler_state
{
	Texture = <gDiffTex>;
//	MinFilter = Linear;
//	MipFilter = Linear;
//	MagFilter = Linear;
//	AddressU = Wrap;
//	AddressV = Wrap;
};

bool    gTextureOnOff : TextureOnOff = true;
float4  gAverageColor : AverageColor = float4(1.0f,1.0f,1.0f,1.0f);

void CalcDiffuseTexture(inout PSInput Out)
{   
    float4 diffuse;
    if (gTextureOnOff)
		diffuse = tex2D(gDiffSamp, Out.Tex.xy);
    else 
        diffuse = gAverageColor;
		
	if(g_texOpType == TEX_OP_DECAL)
	{
        	Out.ColorD = diffuse;
	}

    	if(g_texOpType == TEX_OP_MODULATE)
	{
		Out.ColorD *= diffuse;
	}
	
	if(g_texOpType == TEX_OP_MIX)
	{
		Out.ColorD.w = diffuse.w;
	}
}

#endif

#ifdef IBL
float3			gGlossGain          : glossgain =float3(1.0f,1.0f,1.0f);
float3			gSharpGain          : envgain =float3(1.0f,1.0f,1.0f);
float3			gAmbGain			: ambgain =float3(1.0f,1.0f,1.0f);
texture		gGlossyEnvTex			: glossytexture =NULL;
texture	    gAmbEnvTex				: ambienttexture = NULL;
// When IBL is enabled, gEnvTex would be used to hold the sharp environment texture
texture		gEnvTex					: EnvironmentTexture =NULL;
samplerCUBE gGloEnvSamp : EnvSampler = sampler_state
{
    Texture   = <gGlossyEnvTex>;
	MinFilter = Linear;
	MipFilter = Linear;
	MagFilter = Linear;
	AddressU  = Wrap;
	AddressV  = Wrap;
	AddressW  = Wrap;
};
samplerCUBE gAmbEnvSamp : EnvSampler = sampler_state
{
   Texture   = <gAmbEnvTex>;
	MinFilter = Linear;
	MipFilter = Linear;
	MagFilter = Linear;
	AddressU  = Wrap;
	AddressV  = Wrap;
	AddressW  = Wrap;
};
samplerCUBE gSharpEnvSamp : EnvSampler = sampler_state
{
	Texture   = <gEnvTex>; 
	MinFilter = Linear;
	MipFilter = Linear;
	MagFilter = Linear;
	AddressU  = Wrap;
	AddressV  = Wrap;
	AddressW  = Wrap;
};

float4x4    g_matIBLMat			: IBLTransform = 
{
	{1.0f, 0.0f, 0.0f, 0.0f},
	{0.0f, 1.0f, 0.0f, 0.0f},
	{0.0f, 0.0f, 1.0f, 0.0f},
	{0.0f, 0.0f, 0.0f, 1.0f}
};


void CalcIBLEnvTexture(inout PSInput Out,float4 specCoef,float4 diffCoef, float glossy, float3 Nw, float3 Vw)
{
	 //fresnel factor 
	 //For ambient environment image
	 float3 NL = mul(float4(Nw,1.0f), g_matIBLMat).xyz;
	 float3 amb=diffCoef.xyz*texCUBE(gAmbEnvSamp, NL).xyz*gAmbGain*0.5f;
	 float NV=dot(Nw, Vw);
	 float3 reflDir=2.0f*NV*Nw-Vw;
	 //It is needed to be careful for IBL matrix. Because IBL texture coordinate is a vector.
	 //For example, there is a rotation M for IBL. MatIBL should be transpose inverse M.
	 reflDir=mul(float4(reflDir,1.0f), g_matIBLMat).xyz;
	 //calculate fresnel factor
	 float f = lerp(0.05f, 1.0f, pow(1.0f - abs(NV), 5.0f)); 
	 float3 specular = specCoef.xyz*(f*texCUBE(gGloEnvSamp, reflDir).xyz*gGlossGain*0.5f
								+texCUBE(gSharpEnvSamp, reflDir).xyz*gSharpGain*0.5f*glossy);
	 Out.ColorD.xyz += amb;
	 Out.ColorD.xyz = Out.ColorD.xyz * (1-glossy);
	 Out.ColorSAndFogFactor.xyz += specular;
}
#endif //IBL


#ifndef IBL
#ifdef ENVIRONMENT_TEXTURE
//bool		g_EnvEnabled           :EnironmentTexEnabled=false;
// Environment texture.
texture		gEnvTex				: EnvironmentTexture =NULL;
texture		gEnvTex2D			: EnvironmentTexture2D =NULL;

texture     gReflectionMap      : ReflectionMap = NULL;
float4x4    g_matEnvTex				: EnvironmentTexCoordTransMatrix = 
{
	{1.0f, 0.0f, 0.0f, 0.0f},
	{0.0f, 1.0f, 0.0f, 0.0f},
	{0.0f, 0.0f, 1.0f, 0.0f},
	{0.0f, 0.0f, 0.0f, 1.0f}
};	

float4x4    g_matReflectionMap          : ReflectionMapTransMatrix = 
{
	{1.0f, 0.0f, 0.0f, 0.0f},
	{0.0f, 1.0f, 0.0f, 0.0f},
	{0.0f, 0.0f, 1.0f, 0.0f},
	{0.0f, 0.0f, 0.0f, 1.0f}
};	

samplerCUBE gEnvSamp : EnvSampler = sampler_state
{
#ifdef REFLECTIONMAP
   Texture   = <gReflectionMap>;
#else
	Texture   = <gEnvTex>; 
#endif
};

bool bEnvironmentMap2D : EnvironmentMap2D = false;
sampler2D gEnvSamp2D : EnvSampler2D = sampler_state
{
	Texture   = <gEnvTex2D>; 
};
#define M_PI 3.14159265f
void CalcEnvironmentTexture(inout PSInput Out,float4 specCoef,float refBlend)
{
	float4 clrEnvTex = float4(0.0f,0.0f,0.0f,0.0f);
	if (bEnvironmentMap2D)
	{
		clrEnvTex = tex2D(gEnvSamp2D, Out.EnvTex.xy*0.5f + 0.5f) * specCoef;
	}
	else 
		clrEnvTex = texCUBE(gEnvSamp, Out.EnvTex.xyz) * specCoef;
	Out.ColorD = lerp(Out.ColorD, clrEnvTex,refBlend);
}
#endif
#endif //IBL


//-----------------------------------------------------------------------------
// Name: CalcFogFactor
// Desc: Calculate the fog factor for one vertex
//-----------------------------------------------------------------------------
float CalcFogFactor(float FogDist)
{
	float FogFactor = 1.0f;
	if(g_fogMode == FOGMODE_LINEAR)
	{
		FogFactor = (g_fogRange.y - FogDist)/(g_fogRange.y - g_fogRange.x);
	}
	else if(g_fogMode == FOGMODE_EXP)
	{
		FogFactor = 1.f/exp(FogDist * g_fogRange.z);
	}
	else if(g_fogMode == FOGMODE_EXP2)
	{
		FogFactor = 1.f/exp(pow(FogDist * g_fogRange.z, 2));
	}
	return clamp( FogFactor, 0.0f, 1.0f );
}
