#define LIGHTING
#define NONORMAL
#include "InventorBasicEffectDx10.fxh"


struct VSPosTex
{
	float3 Pos			: Position;
	float2 Tex			: TEXCOORD0;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_PosTex( VSPosTex Input)
{
	VSOutput Out = (VSOutput) 0;
	float4 LocalPos = float4(Input.Pos,1.0f);
	float4 clipPos = mul(LocalPos, g_matWorldViewProj);
	Out.Pos = clipPos;
#ifdef WEIGHTEDPRODUCT
	Out.PosC = clipPos;
#endif
	//float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
	if(g_enabledLight)
	{
		float Opacity = g_Misc.y;
		TripleColor Color = CalcLightingAmb(Input.Pos,g_Emissive, g_Ambient,Opacity);
		Out.ColorD = Color.Diffuse;
#ifdef IBL
		if (Out.ColorD.r<0.001 && Out.ColorD.g<0.001 && Out.ColorD.b<0.001)
		{
			float4 fIBLAmbColor = float4(0.5, 0.5, 0.5, 1.0);
			Out.ColorD += fIBLAmbColor*g_Ambient;
		}
#endif
	}else
	{
		Out.ColorD = g_Emissive;
	}
	Out.ColorD.w = g_Misc.y;//Opacity

#ifdef DIFFUSE_TEXTURE
	Out.Tex = float4(Input.Tex, 0, 1.0f);
	Out.Tex = mul(Out.Tex, g_matDiffTex);
#endif
	
	if(g_fogEnabled)
	{
		float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
		Out.FogFactor =	CalcFogFactor(ViewPos.z);
	}
 	//Apply user specified clipping
	Out.ClipplaneDist0.x = Out.ClipplaneDist0.y = Out.ClipplaneDist0.z =Out.ClipplaneDist0.w = 1;
	Out.ClipplaneDist1.x = Out.ClipplaneDist1.y = Out.ClipplaneDist1.z =Out.ClipplaneDist1.w = 1;
	if( g_bClippingEnable )
	{
		CalcClipping(LocalPos, Out);
	}
	return Out;
}

#if defined(WEIGHTEDAVERAGE) || defined(WEIGHTEDPRODUCT)
struct pixelOutput {
	float4 oColor0 : SV_Target0;
	float4 oColor1 : SV_Target1;
};
pixelOutput PS_PosTex(VSOutput Input)
#else
float4 PS_PosTex(VSOutput Input) : SV_Target
#endif
{

#ifdef DIFFUSE_TEXTURE
	CalcDiffuseTexture(Input);
#endif
	
	if(Input.ColorD.a < g_Misc.w)
		discard;

#ifdef IBL
	float4 Color = Input.ColorD + Input.ColorS;
#ifdef INVTM
	if (gBackgroundBlendEnabled && Color.a<1.0)
	{
		float texW = 1.0f;
		float texH = 1.0f;
		gBackgroundTexture.GetDimensions(texW, texH);
		float sampleX = Input.Pos.x/texW;//(Input.Pos.x / Input.Pos.w + 1.0) / 2.0;
		float sampleY = Input.Pos.y/texH;//(1.0 - Input.Pos.y / Input.Pos.w) / 2.0;
		float4 BGColor = gBackgroundTexture.Sample(gBackgroundSamp2D, float2(sampleX, sampleY));
		BGColor = CanonTM_Color(BGColor);
		if (BGColor.r>0.8 && BGColor.g>0.8 && BGColor.b>0.8)
		{
			Color.r = BGColor.r*(1.0-Input.ColorD.a) + Color.r*Input.ColorD.a;
			Color.g = BGColor.g*(1.0-Input.ColorD.a) + Color.g*Input.ColorD.a;
			Color.b = BGColor.b*(1.0-Input.ColorD.a) + Color.b*Input.ColorD.a;
			Color.a = 1.0;
		}
	}
	Color = CanonTM_InverseColor(Color);
#endif
	//float3 IBLAmb = CalcIBLEnvAmb(g_Ambient, normalize(Input.Normal));
	//Color += float4(IBLAmb, 0.0f);
#else
	float4 Color = saturate(Input.ColorD + Input.ColorS);
#endif

if(g_fogEnabled)
	Color = Input.FogFactor * Color + (1.0 - Input.FogFactor) * g_fogColor;
Color *= gExtraColorAndAlpha;

#ifdef WEIGHTEDAVERAGE
pixelOutput output;
output.oColor0 = max(0, float4(Color.rgb * Color.a, Color.a));
output.oColor1 = 1.0;
return output;
#elif defined WEIGHTEDPRODUCT
pixelOutput output;
float4 nPos = PosC(Input.PosC);
float weight = weightedProductWeight(Color, nPos);
output.oColor0 = WeightedProductTextureA(Color, weight);
output.oColor1 = weightedProductTextureB(Color, weight);
return output;
#else
return Color;
#endif
}
//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

technique10 PosTex
{
    pass P0
    {   
		SetVertexShader(CompileShader(vs_4_0,VS_PosTex()));
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, PS_PosTex()) );
    }
}