#define LIGHTING
/// for test
//#define BUMP_TEXTURE
//#define DIFFUSE_TEXTURE
#include "InventorBasicEffectDx10.fxh"

//inverse width and height of bump mapping
#ifdef BUMP_TEXTURE
	float2 g_fInverseBumpMapSize:InverseBumpMapSize =float2(1.0f/256.0f,1.0f/256.0f);
	#define GENERATENORMAPATPS
#endif
struct VSPosNormTex
{
	float3 Pos			: Position;
	float3 Norm			: Normal;	
#ifdef BUMP_TEXTURE
	float3 Tangent		: TANGENT;
	float3 Binormal		: BINORMAL;
#endif
	float2 Tex			: TEXCOORD0;

};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_PosNormTex( VSPosNormTex Input)
{
	VSOutput Out = (VSOutput) 0;
	float4 LocalPos = float4(Input.Pos,1.0f);
	float4 clipPos = mul(LocalPos, g_matWorldViewProj);
#ifdef WEIGHTEDPRODUCT
	Out.PosC = clipPos;
#endif
	Out.Pos = clipPos;
	
	float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
	float3 Viewer = -normalize(ViewPos);                   //viewer
	float3 ViewNormal = mul(Input.Norm, (float3x3)g_matWorldViewIT); //normal in view space
	ViewNormal = normalize(ViewNormal);
	
#ifdef IBL
	//It is needed to use world space normal and view direction for IBL
	#ifndef BUMP_TEXTURE
		Out.Normal=normalize(mul(ViewNormal, (float3x3)transpose(g_matView)));
	#endif //bump mapping
	Out.Viewer=normalize(mul(Viewer, (float3x3)transpose(g_matView)));
#endif //IBL
	
#ifdef BUMP_TEXTURE
	Out.Tangent=normalize(Input.Tangent);
	Out.Binormal=normalize(Input.Binormal);
	Out.Locpos=Input.Pos;
	Out.Tex = float4(Input.Tex, 0, 1.0f);
#endif

#ifndef BUMP_TEXTURE
	#ifdef DIFFUSE_TEXTURE
		Out.Tex = float4(Input.Tex, 0, 1.0f);
		Out.Tex = mul(Out.Tex, g_matDiffTex);
	#endif // diffuse texture
#endif //bump texture

//The reflection Dir would be calculated at PS when IBL is enabled
#ifndef IBL
	#ifdef ENVIRONMENT_TEXTURE	
		#ifndef BUMP_TEXTURE
		if (bEnvironmentMap2D)
		{			
			Out.EnvTex  = float4(ViewNormal, 1.0f);
		}
		else
		{
			float3 VwNorm = normalize(mul(Viewer, (float3x3)transpose(g_matView)));
			float3 Nw = normalize(mul(ViewNormal, (float3x3)transpose(g_matView)));
			Out.EnvTex = float4(2.f * dot(VwNorm,Nw) * Nw - VwNorm, 1.0f);
			Out.EnvTex = mul(Out.EnvTex, g_matEnvTex);
		}
		#else
			Out.EnvTex = float4(Viewer,1.0f); 
		#endif //bump tex
	#endif //ENV tex	
#endif


#ifndef BUMP_TEXTURE
	float Glossness=g_Misc.x;
	float Opacity=g_Misc.y;
	TripleColor Color = CalcLighting(Input.Pos, Viewer, ViewNormal, g_Emissive, g_Ambient, g_Diffuse, g_Specular, Glossness, Opacity
#ifdef SHADOWS
        , Out.ShadowD, Out.ShadowS
#endif
        );
	Out.ColorD = Color.Diffuse;
	Out.ColorS = Color.Specular;

	// Enable it to increase the weight of standard lights, this is necessary for case only Emissive color (no other material properties, IBL computing can not take effect) is specified
#ifdef INVTM
	Out.ColorD = CanonTM_InverseColor(Out.ColorD);
	Out.ColorS = CanonTM_InverseColor(Out.ColorS);
#endif

#endif //bump texture

#ifdef SHADOWS
	Out.ShadowPos = mul(mul(LocalPos, g_matWorld), gShadowMapXf);
#endif //shadows

	if(g_fogEnabled)
	{
		Out.FogFactor =	CalcFogFactor(ViewPos.z);
	}
 	//Apply user specified clipping
    Out.ClipplaneDist0.x = Out.ClipplaneDist0.y = Out.ClipplaneDist0.z =Out.ClipplaneDist0.w = 1;
    Out.ClipplaneDist1.x = Out.ClipplaneDist1.y = Out.ClipplaneDist1.z =Out.ClipplaneDist1.w = 1;
    if( g_bClippingEnable )
    {
		CalcClipping(LocalPos, Out);
    }
	return Out;
}

#if defined(WEIGHTEDAVERAGE) || defined(WEIGHTEDPRODUCT)
struct pixelOutput {
	float4 oColor0 : SV_Target0;
	float4 oColor1 : SV_Target1;
};
pixelOutput PS_PosNormTex(VSOutput Input)
#else
float4 PS_PosNormTex( VSOutput Input ) : SV_Target
#endif
{
#ifdef BUMP_TEXTURE
	float Glossness=g_Misc.x;
	float Opacity=g_Misc.y;
	float3 Normal=(float3)0;
	float4 bumpTex= mul(Input.Tex, g_matBumpTex);
	#ifdef GENERATENORMAPATPS	
		float3 left	 = gBumpTex.Sample(gBumpSamp, bumpTex.xy- float2(g_fInverseBumpMapSize.x, 0.0f));
		float3 top	 = gBumpTex.Sample(gBumpSamp, bumpTex.xy- float2(0.0f, g_fInverseBumpMapSize.y));
		float3 right = gBumpTex.Sample(gBumpSamp, bumpTex.xy+ float2(g_fInverseBumpMapSize.x, 0.0f));
		float3 bottom = gBumpTex.Sample(gBumpSamp, bumpTex.xy+ float2(0.0f, g_fInverseBumpMapSize.y));
		float3 diffU = right - left;
		float3 diffV = bottom - top;
		float3 SampleNormal = cross(float3(1.0f, 0.0f, diffU.r*gBumpAmount), float3(0.0f, 1.0f, diffV.r*gBumpAmount));
		Normal = normalize(SampleNormal);
	#else
		float4 texColor=gBumpTex.Sample(gBumpSamp, bumpTex.xy);
		Normal = 2*texColor.rgb - 1.0f;
	#endif
	float3x3 tbn=float3x3(normalize(Input.Tangent),normalize(Input.Binormal),normalize(cross(Input.Tangent,Input.Binormal)));
	Normal=mul(Normal,tbn);
	Normal= mul(Normal, (float3x3)g_matWorldViewIT); //normal in view space
	float3 ViewPos = mul(float4(Input.Locpos,1.0f),g_matWorldView);    //position in view space
	float3 Viewer = -normalize(ViewPos);                   //viewer
	TripleColor TripColor = CalcLighting(Input.Locpos, Viewer, Normal, g_Emissive, g_Ambient, g_Diffuse, g_Specular, Glossness, Opacity
	#ifdef SHADOWS
        , Input.ShadowD, Input.ShadowS
	#endif
	);
	Input.ColorD = TripColor.Diffuse;
	Input.ColorS = TripColor.Specular;

	// Enable it to increase the weight of standard lights, this is necessary for case only Emissive color (no other material properties, IBL computing can not take effect) is specified
#ifdef INVTM
	Input.ColorD = CanonTM_InverseColor(Input.ColorD);
	Input.ColorS = CanonTM_InverseColor(Input.ColorS);
#endif

#endif //BUMP_TEXTURE

float shadowFactor = 1.0;
#ifdef SHADOWS
#ifdef SOFT_SHADOWS
	shadowFactor = VarianceShadow(Input.ShadowPos);
#else 
	shadowFactor = SampleShadowMap(Input.ShadowPos);
#endif 
	Input.ColorD += Input.ShadowD * (1.0f - (1.0f - shadowFactor) * gShadowDensity);
	Input.ColorS += Input.ShadowS * (1.0f - (1.0f - shadowFactor) * gShadowDensity);
#endif //SHADOWS

//When IBL is enabled, the normal environment reflection would be surpressed.
#ifdef IBL
	float4 diffuse=float4(0,0,0,0);
	float3 IBLNormal=0;
	#ifdef BUMP_TEXTURE
		IBLNormal=normalize(mul(Normal, (float3x3)transpose(g_matView)));
	#else
		IBLNormal=normalize(Input.Normal);
	#endif //bump mapping

	CalcIBLEnvTexture(Input,g_Specular,g_Diffuse, g_Misc.z, g_Misc.x, IBLNormal, Input.Viewer);
#else //IBL
	#ifdef ENVIRONMENT_TEXTURE	
		#ifdef BUMP_TEXTURE
			float3 VwNorm = normalize(mul(Input.EnvTex, (float3x3)transpose(g_matView)));
			float3 Nw = normalize(mul(Normal, (float3x3)transpose(g_matView)));
			Input.EnvTex = float4(2.f * dot(VwNorm,Nw) * Nw - VwNorm, 1.0f);
			Input.EnvTex = mul(Input.EnvTex, g_matEnvTex);
		#endif
		CalcEnvironmentTexture(Input,g_Specular,g_Misc.z);
	#endif //Env texture
#endif //IBL

#ifdef DIFFUSE_TEXTURE
	#ifdef BUMP_TEXTURE
		Input.Tex= mul(Input.Tex, g_matDiffTex);
	#endif
	CalcDiffuseTexture(Input);

#ifdef INVTM
	if(g_texOpType == TEX_OP_DECAL)
	{
		Input.ColorD = CanonTM_InverseColor(Input.ColorD);
	}
#endif

#endif //diffuse texture

	if(Input.ColorD.a < g_Misc.w)
		discard;

#ifdef IBL
	float4 Color = Input.ColorD + Input.ColorS;
#else
	float4 Color = saturate(Input.ColorD + Input.ColorS);
#endif //IBL

	if(g_fogEnabled)
		Color = Input.FogFactor * Color + (1.0 - Input.FogFactor) * g_fogColor;
Color *= gExtraColorAndAlpha;

#ifdef WEIGHTEDAVERAGE
	pixelOutput output;
	output.oColor0 = max(0, float4(Color.rgb * Color.a, Color.a));
	output.oColor1 = 1.0;
	return output;
#elif defined WEIGHTEDPRODUCT
	pixelOutput output;
	float4 nPos = PosC(Input.PosC);
	float weight = weightedProductWeight(Color, nPos);
	output.oColor0 = WeightedProductTextureA(Color, weight);
	output.oColor1 = weightedProductTextureB(Color, weight);
	return output;
#else
	return Color;
#endif
}
//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

technique10 PosNormTex
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0,VS_PosNormTex()));
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, PS_PosNormTex()) );
	}

}
