#include "InventorBasicEffectDx10.fxh"

struct VSPosCol
{
	float3 Pos			: Position;
	float4 Col			: Color;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_PosCol( VSPosCol Input)
{
	VSOutput Out = (VSOutput) 0;
	float4 LocalPos = float4(Input.Pos,1.0f);
	float4 clipPos = mul(LocalPos, g_matWorldViewProj);

#ifdef WEIGHTEDPRODUCT
	Out.PosC = clipPos;
#endif

	Out.Pos = clipPos;
	float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
	//Input color is compressed as a Dword in vertex buffer. 
	//But Dx9 is incompatiable to translate this Dword into float4 with Dx10. Dx9 treats Dword as ARGB. Dx10 treats Dword as ABGR.
	//And Dword is padding with order ARGB in application layer. So a translation is needed in Dx10.
	Out.ColorD.xyzw = Input.Col.zyxw;

#ifdef DIFFUSE_TEXTURE
	//automatic texture coordinate generation
	Out.Tex += float4(Input.Pos*(g_texCoordType == TEX_COORD_POSITION), 1.0f);
	Out.Tex += float4(ViewPos * (g_texCoordType == TEX_COORD_CAMERASPACEPOSITION), 0);
	Out.Tex = mul(Out.Tex, g_matDiffTex);
#endif

	if(g_fogEnabled)
	{
		Out.FogFactor =	CalcFogFactor(ViewPos.z);
	}
	//Apply user specified clipping
    	Out.ClipplaneDist0.x = Out.ClipplaneDist0.y = Out.ClipplaneDist0.z =Out.ClipplaneDist0.w = 1;
    	Out.ClipplaneDist1.x = Out.ClipplaneDist1.y = Out.ClipplaneDist1.z =Out.ClipplaneDist1.w = 1;
    	if( g_bClippingEnable )
    	{
		CalcClipping(LocalPos, Out);
    	}
	return Out;
}
//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
#if defined(WEIGHTEDAVERAGE) || defined(WEIGHTEDPRODUCT)
struct pixelOutput {
	float4 oColor0 : SV_Target0;
	float4 oColor1 : SV_Target1;
};
pixelOutput PS_PosCol(VSOutput Input)
#else
float4 PS_PosCol(VSOutput Input) : SV_Target
#endif
{
#ifdef DIFFUSE_TEXTURE
	CalcDiffuseTexture(Input);
#endif
	if(Input.ColorD.a < g_Misc.w)
		discard;

#ifdef IBL
	float4 Color = Input.ColorD + Input.ColorS;

#ifdef INVTM
	Color = CanonTM_InverseColor(Color);
#endif

#else
	float4 Color = saturate(Input.ColorD + Input.ColorS);
#endif

if(g_fogEnabled)
	Color = Input.FogFactor * Color + (1.0 - Input.FogFactor) * g_fogColor;
Color *= gExtraColorAndAlpha;

#ifdef WEIGHTEDAVERAGE
pixelOutput output;
output.oColor0 = max(0, float4(Color.rgb * Color.a, Color.a));
output.oColor1 = 1.0;
return output;
#elif defined WEIGHTEDPRODUCT
pixelOutput output;
float4 nPos = PosC(Input.PosC);
float weight = weightedProductWeight(Color, nPos);
output.oColor0 = WeightedProductTextureA(Color, weight);
output.oColor1 = weightedProductTextureB(Color, weight);
return output;
#else
return Color;
#endif
}

//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

technique10 PosCol
{
    pass P0
    {   
		SetVertexShader( CompileShader( vs_4_0, VS_PosCol()) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, PS_PosCol()) );
	}
}