;;;
;;;    TREX.LSP - Written by Randy Kintzley
;;;    Copyright  1999 by Autodesk, Inc.
;;;
;;;    Your use of this software is governed by the terms and conditions of the
;;;    License Agreement you accepted prior to installation of this software.
;;;    Please note that pursuant to the License Agreement for this software,
;;;    "[c]opying of this computer program or its documentation except as
;;;    permitted by this License is copyright infringement under the laws of
;;;    your country.  If you copy this computer program without permission of
;;;    Autodesk, you are violating the law."
;;;
;;;    AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
;;;    AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
;;;    MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
;;;    DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
;;;    UNINTERRUPTED OR ERROR FREE.
;;;
;;;    Use, duplication, or disclosure by the U.S. Government is subject to
;;;    restrictions set forth in FAR 52.227-19 (Commercial Computer
;;;    Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
;;;    (Rights in Technical Data and Computer Software), as applicable.
;;;
;;;  ----------------------------------------------------------------
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;TREX
;Trim and Extend combined!
;Pick to trim and shift+pick to extend.
;
(defun c:trex ( / )
 (acet-error-init
  (list '("cmdecho" 0)
         0 ;0 means place an undo begin and end mark but do not
           ;use undo to back up on an error event.
        '(if ss (acet-ss-redraw ss 4))	;; clear the redraw on any selected objects
  );list
 )
 (acet-trim-extend)
(acet-error-restore)
);defun c:trex
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun acet-trim-extend ( / ss flt flag p1 errno lst n a u ulst endit )
 
(setq flt '((-4 . "<NOT")
             (-4 . "<OR")
              (0 . "INSERT")
              (0 . "ATTDEF")
              (0 . "DIMENSION")
              (0 . "SOLID")
              (0 . "3DSOLID")
              (0 . "3DFACE")
              (0 . "POINT")
              (-4 . "<AND")
               (0 . "POLYLINE")
               (-4 . "&") (70 . 80) ;16 64 / 3dmesh and pface mesh.
              (-4 . "AND>")
              (0 . "TRACE")
              (0 . "SHAPE")
             (-4 . "OR>")
            (-4 . "NOT>")
           )
);setq
 
(acet-trex-print-modes)
(princ "\nSelect cutting/boundary edges or press enter for implied.")
 
(if (setq ss (ssget))
    (progn
     (setq ss (acet-ss-filter
               (list ss
                     (list (list flt
                                 "\n1 object was invalid as a cutting/boundary edge."
                                 "\n%1 objects were invalid as cutting/boundary edges."
                           );list
                     );list
                     T
               );list
              );acet-ss-filter
           ss (car ss)
     );setq
     (if (not ss)
         (setq endit T)
     );if
    );progn then
);if

(while (and (not endit)
            (or
                (progn
                 (acet-ss-redraw ss 3)
                 (initget "Fence Undo Project Edge")
                 (setvar "errno" 0)
                 (setq p1 (entsel "\nPick to trim or Shift+Pick to extend [Project/Edge/Undo]: "));setq
                 (acet-ss-redraw ss 4)
                 p1
                );progn
                (equal (setq errno (getvar "errno"))
                       7
                );equal
            );or
       );and
 (setq flag (acet-sys-shift-down))
 
 (setq u 0)
 
 (cond
  ((equal p1 "Undo")
   (if ulst
       (progn
        (command "_.undo" (car ulst))
        (setq ulst (cdr ulst))
       );progn then
       (princ "\nCommand has been completely undone.")
   );if
   (setq u nil)
  );cond #1
 
  ((or (equal p1 "Project") 
       (equal p1 "Edge")
   );or
   (command "_.trim" "")
   (setvar "cmdecho" 1)
    (command (strcat "_" p1) pause)
   (setvar "cmdecho" 0)
   (acet-safe-command nil T (list "")) ;exit the trim command
   (setq u (+ u 1))
  );cond #2
 
  ((not (equal (getvar "errno") 7))
   (if (equal (type p1) 'LIST)
       (setq p1 (cadr p1))
   );if
   (if flag
       (command "_.extend")
       (command "_.trim")
   );if
   (if ss
       (command ss)
   );if
   (command "")
   (if (equal p1 "Fence")
       (progn
        (command nil)
        (setq u (+ u 1));setq
        (setq lst (acet-ui-fence-select))
        (setq flag (acet-sys-shift-down))
        (if lst
            (progn
             (if flag
                 (command "_.extend")
                 (command "_.trim")
             );if
             (if ss (command ss));if
             (command "" "_F")
             (setq n 0)
             (repeat (length lst)
              (if (setq a (nth n lst))
                  (command a)
              );if
             (setq n (+ n 1));setq
             );repeat
             (command "" "")
             (setq u (+ u 1))
            );progn then
        );if
       );progn then fence
       (progn
        (command p1 "")
        (setq u (+ u 1))
       );progn else point pick
   );if
  );cond #3
 
  ((equal (getvar "errno") 7)
   (princ "\nYou missed! Try again...")
   (setq u nil)  
  );cond #4
 );cond close
 (if (and u
          (> u 0)
     );and
     (setq ulst (cons u ulst))
 );if
);while

(acet-safe-command nil T (list "")) ;exit any active command

 
);defun acet-trim-extend
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;print the status of projmode and edgemode the same wy that trim and extend do.
(defun acet-trex-print-modes ( / a b )
 (setq a (getvar "projmode")
       b (getvar "edgemode")
 );setq
 (cond
  ((equal a 0) (setq a "Projmode = None"))
  ((equal a 1) (setq a "Projmode = UCS"))
  ((equal a 2) (setq a "Projmode = View"))
  (T (setq a ""))
 );cond close
 
 (cond
  ((equal b 0) (setq b "Edgemode = No extend"))
  ((equal b 1) (setq b "Edgemode = Extend"))
  (T (setq b ""))
 );cond close
 
 (setq a (strcat "\n(" a ", " b ")"))
 (princ a)
 
);defun acet-trex-print-modes


(princ)
;;;-----BEGIN-SIGNATURE-----
;;; 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEE+U0vr78xSzq0vXnmuWytEw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMjAwNjE1MDAwMDAwWhcNMjEwODEyMjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBAMt3bX7WxfbqKZpcgiX4jvJBSg6MCucqh4aDRHA8
;;; Hny4Fc2vKP+Xgn3mY4qtHoeNZ/j4d669d5+guDfOpD7jZX/JyR81wLE22GwswGLN
;;; M6n3N6Vudo0PcdCNXRxccGdPmJMIiEZNp84RjWN7Gy0JfgChxNiNEWS+Dezr5cYK
;;; B7UlGjGivbUdK6/HP0JlO3t3QxXYERASgPWj6YXmHGdvYHPBNit1MJTLRUj7uXyk
;;; bWzpaQEnXdey73yxg+FV2us0BicMIChoDXdTY/uAWbhkThET8GffQd08miZDNWMv
;;; IUIfFEkKjGZX6VkfkK/ShlVtjcdYlknpatvAtkFuYnQm6mECAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBACiY
;;; IcU6uh5Lz5MGiUDT3w+daDMfYW44/ak/wMK1SgkL+iHzsgHaY8plDqZ4oaxT3U45
;;; /L5BdedSZWIvR738xpjcJNKZVILKTMg3mzl0bjO/t91dj5TFlTSpCbQgBh+jbBpJ
;;; R0il59VeZ9LQTvK/2E41TK89VHXZa+8MaTrsVOyTsBuAnNdYdzzExmAqp1BZdirH
;;; JH35aOAnZz3nkcGS4knKOAc7EX8pLkhAl4UDoS2V+2MKw5IXpYO3tU5TwM7y8uGZ
;;; gj/XpMlzWXtVQvOVpwgmT0XCymP5174BFyTP1SLNhlUWUfwFCypOY6tRHd6U9uqc
;;; BATajxbYoRpvjWl9Nu8xggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQT5TS+vvzFLOrS9eea5bK0TANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQAiR0TCQIRsxjX+cAHbcIkvUAPD6J9wuS/B
;;; gJtzZ3OY7anEmXmXkuJuq97IpWFwyPiPdnbKoFGW9iqWGdvrsfIyvN0UiJjiRJYj
;;; 4unhUrxr3xPVx3S51yshzDzih8OF336qr1nZBzD1NW12WMgywH7WTTHrMgBZrr/N
;;; mcHHkTW7E8K0uvRaEOYKifal2KsMrFdq+VQMcGxsOMyIEH0Zyu9vGY5wO7tNCVE9
;;; kkeuQFLu9iPI9KTUXQFw1NIACn1NJeRb9QBaMeBU63R4gF/mnyRJvC98VALHX49J
;;; /Cji/OGn3cy1axrMl+d0eQ0P+k4u3urPoRA6GWMT+VRiHEiFYyUe
;;; -----END-SIGNATURE-----