;;
;;;
;;;    MSTRETCH.LSP
;;;    Copyright  2007 by Autodesk, Inc.
;;;
;;;    Your use of this software is governed by the terms and conditions of the
;;;    License Agreement you accepted prior to installation of this software.
;;;    Please note that pursuant to the License Agreement for this software,
;;;    "[c]opying of this computer program or its documentation except as
;;;    permitted by this License is copyright infringement under the laws of
;;;    your country.  If you copy this computer program without permission of
;;;    Autodesk, you are violating the law."
;;;
;;;    AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
;;;    AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
;;;    MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
;;;    DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
;;;    UNINTERRUPTED OR ERROR FREE.
;;;
;;;    Use, duplication, or disclosure by the U.S. Government is subject to
;;;    restrictions set forth in FAR 52.227-19 (Commercial Computer
;;;    Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
;;;    (Rights in Technical Data and Computer Software), as applicable.
;;;
;;;  ----------------------------------------------------------------
 
(defun c:mstretch ( / n ss ss2 a b lst lst2 lst3 lst4 flag p1 p2 p3 p4 zflag delname ssrmv templst checkss found)
    (acet-error-init
        (list
            (list   "cmdecho" 0
                "highlight" 0
                "dragmode" (getvar "dragmode")
                "osmode" 0
                "cecolor" "6"
                "celtype" "CONTINUOUS"
                "limcheck" 0
            )
            T
            '(progn
                (acet-temp-segment nil nil nil 1)
                (acet-sysvar-set (list "cmdecho" 0));turn cmdecho off
                (command "_.redraw");do redraw
                (acet-sysvar-restore);re-set cmdecho back
                (princ)
                ;(command "_.redraw")
             )
        )
    )
    (sssetfirst nil nil)
    (princ "\nDefine crossing windows or crossing polygons...")
    (setvar "highlight" 1)
    (setq ss (ssadd))
    (command "_.select")
    (while (not flag)
        (if (not lst)
            (progn
                (initget 128 "CP C _CP C")
                (princ "\nOptions: Crossing Polygon or Crossing first point")
                (setq a (getpoint "\nSpecify an option [CP/C] <Crossing first point>: "))
            );progn
            (progn
                (initget 128 "CP C Undo _CP C Undo")
                (princ "\nOptions: Crossing Polygon, Crossing first point or Undo")
                (setq a (getpoint "\nSpecify an option [CP/C/Undo] <Crossing first point>: "))
            );progn
        );if
        (cond
            ;cond #1
            ((or (and (= a "C")
                     (progn (initget 1) (setq a (getpoint "\nSpecify first corner: ")))
                     (progn (initget 33) (setq b (getcorner a "\nSpecify other corner: ")))
                     ;(setq lst2 (acet-geom-rect-points a b));setq
                 );and
                 (and a
                     (equal (type a) 'LIST)
                     (progn (initget 33) (setq b (getcorner a "\nSpecify other corner: ")))
                     ;(setq lst2 (acet-geom-rect-points a b));setq
                 );and
             );or

                (setq  lst (append lst (list (list a b)))
                       lst4 (append lst4 (list (ssget "_c" a b)))
                       p3 (trans '(0.0 0.0 0.0) 1 0)
                       p4 (trans (getvar "viewdir") 1 0 T);rk added T 4:12 PM 8/12/97
                );setq
     
                (acet-lwpline-make
                    (list
                        (list (cons 210 p4))
                        ;(acet-geom-m-trans (acet-geom-rect-points a b) 1 2)
                        (acet-geom-rect-points (trans a 1 p4); p4 was 2
                            (trans b 1 p4)
                        )
                    );list
                );acet-lwpline-make-make
     
                (command (entlast))
                (setq lst3 (append lst3 (list (entlast))))
            );cond #1
            ;cond #2
            ((= a "CP")
                (progn
                    (if (setq lst2 (acet-ui-polygon-select 1))
                        (progn
                            (setq lst2 (append lst2 (list (car lst2)))
                                  lst (append lst (list lst2))
                                  lst4 (append lst4 (list (ssget "_cp" (cdr lst2))))
                                  p3 (trans '(0.0 0.0 0.0) 1 0)
                                  p4 (trans (getvar "viewdir") 1 0 T)
                                  ;p4 (list (- (car p4) (car p3)) (- (cadr p4) (cadr p3)) (- (caddr p4) (caddr p3)))
                            );setq
                            (acet-lwpline-make
                                (list
                                    (list (cons 210 p4))
                                    (acet-geom-m-trans
                                        lst2
                                        1
                                        p4 ;rk 2 4:27 PM 8/12/97
                                    )
                                );list
                            );acet-lwpline-make-make
     
                            (command (entlast))
                            (setq lst3 (append lst3 (list (entlast))))
                        );progn
                    );if
                );progn
            ); cond #2
            ; cond #3
            ((and lst (= a "Undo"))                ;;;;;Undo the last window definition
                (command "_r" (last lst3) "_a")
                (if (acet-layer-locked (getvar "clayer"))
                    (progn
                        (command "")
                        (command "_.layer" "_unl" (getvar "clayer") "")
                        (entdel (last lst3))
                        (command "_.layer" "_lock" (getvar "clayer") "")
                        (command "_.select")
                        (if (> (length lst3) 1)
                            (eval (append '(command) (cdr (reverse lst3))))
                        );if
                    );progn then the current layer is locked
                    (entdel (last lst3))
                );if
                (setq lst3 (reverse (cdr (reverse lst3)))
                      lst4 (reverse (cdr (reverse lst4)))
                      lst (reverse (cdr (reverse lst)))
                );setq
            ); cond #3
            ; cond #4
            ((or (= a "") (not a))
                (setq flag T)
            ); cond #4
            ; default
            (T
                (princ "\nInvalid")
            ); default
        );cond all
    );while
    (command "");end select
    (setvar "highlight" 0)
 
    (if lst
        (progn
            (princ "\nDone defining windows for stretch...")
            (if (acet-layer-locked (getvar "clayer"))
                (progn
                    (command "_.layer" "_unl" (getvar "clayer") "")
                    (setq lst (reverse lst))
                    (setq n 0)
                    (repeat (length lst3)
                        (entdel (nth n lst3))
                        (setq n (+ n 1))
                    );repeat
                    (command "_.layer" "_lock" (getvar "clayer") "")
                );progn then the current layer is locked
            ;else
                (progn
                    (setq lst (reverse lst))
                    (setq n 0)
                    (repeat (length lst3)
                        (entdel (nth n lst3))
                        (setq n (+ n 1))
                    );repeat
                );progn else
            );if
            (setvar "highlight" 1)
            (command "_.select")
            (repeat (length lst4)
                (if (car lst4) (command (car lst4)))
                (setq lst4 (cdr lst4))
            );repeat
            (command "")
            (setq ss (ssget "_p"))
            (if ss
                (progn
                    (command "_.select" ss)
                    (if (assoc "OSMODE" (car acet:sysvar-list))
                        (setvar "osmode" (cadr (assoc "OSMODE" (car acet:sysvar-list))))
                    );if
                    (setq p1 nil)
                    (while (not p1)
                        (initget 128 "Remove _Remove")
                        (setq p1 (getpoint "\nSpecify an option [Remove objects] <Base point>: "))
                        (if (not p1) (setq p1 (car (acet-geom-view-points))))
                        (if (and p1 (not (equal p1 "Remove")) (not (equal (type p1) 'LIST)))
                            (progn
                                (setq p1 nil)
                                (princ "\nInvalid input.")
                            );progn then
                        );if
                    );while
                    (command "")
                    (if (= p1 "Remove")
                        (progn
                            (setvar "highlight" 0)
                            (acet-ss-clear-prev)
                            ;(command "_.select" (entnext) "")
                            ;(command "_.undo" "1")
                            (setvar "highlight" 1)
                            (command "_.select" ss "_r" "_auto")
                            (setvar "cmdecho" 1)
                            (while (wcmatch (getvar "cmdnames") "*SELECT*")
                                (command pause)
                            );while
                            (if (setq ss2 (ssget "_P"));setq
                                (progn
                                    (command "_.select" ss2)
                                    (setq p1 (getpoint "\nSpecify base point: "))
                                    (command "")
                                    (if (not p1) (setq p1 (car (acet-geom-view-points))))
                                );progn
                            );if
                        );progn
                    ;else
                        (setq ss2 ss)
                    );if
                    (if ss2
                        (progn
                            ;;get the extents of the crossing window definitions
                            (setq lst2 lst)
                            (repeat (length lst2)
                                (if (> (length (car lst2)) 2)
                                    (setq lst2 (append (cdr lst2) (car lst2)))
                                ;else
                                    (setq lst2 (cdr lst2))
                                );if
                            );repeat
                            (if (and (> (length (car lst)) 2)                 ;;;cp_off_screen?
                                     (acet-geom-zoom-for-select (car lst))
                                );and
                                (progn
                                    (setvar "cmdecho" 0)
                                    (command "_.select" ss2)
                                    (setq p2 (getpoint p1 "\nSpecify second base point: "))
                                    (command "")
                                );progn
                            ;else
                                (progn
                                    ;;get removed objects(bug fix 761695)
                                    (setq ssrmv ss)
                                    (setq n 0)
                                    (repeat (sslength ss2)
                                        (setq delname (ssname ss2 n))
                                        (if (= nil (ssdel delname ssrmv))
                                            (setq n (+ n 1))
                                        );if
                                    );repeat
                                    (setvar "cmdecho" 0)
                                    ;remove empty selection from lst until first non-empty selection is seen
                                    (setq templst nil) ;new list without empty boxes
                                    (setq checkss nil)
                                    (setq found 0)
                                    (setq n 0)
                                    (repeat (length lst)
                                        (setq a (nth n lst))
                                        (if (equal found 1)
                                            ;if first non-empty selection is found, just append the rest of the list
                                            (setq templst (append templst (list a)))
                                        ;else
                                            (progn
                                                (if (equal (length a) 2)
                                                    (setq checkss (ssget "_c" (car a) (cadr a)))
                                                ;else
                                                    (setq checkss (ssget "_cp" a))
                                                );if
                                                (if (/= checkss nil) ;if there's any object selected, append it
                                                    (progn
                                                        (setq templst (append templst (list a)))
                                                        (setq found 1) ;we've found the first non-empty selection
                                                    );end progn
                                                );end if
                                            );end progn
                                        );endif
                                        (setq n (+ n 1))
                                    );repeat
                                    (setq lst templst)
                                    (command "_.stretch")
                                    (cp_loop (car lst))
                                    (command "_r" ssrmv "_a" ss2 "" p1)
                                    (setvar "cmdecho" 1)
                                    (princ "\nSecond base point: ")
                                    (command pause)
                                    (setvar "cmdecho" 0)
                                    (setq p2 (getvar "lastpoint"))
                                    (setq lst (cdr lst))
                                );progn
                            );if
                            (if (setq zflag (acet-geom-zoom-for-select lst2))
                                (command "_.zoom" "_w" (car zflag) (cadr zflag))
                            );if
                            ;;get removed objects(bug fix 761695)
                            (setq ssrmv ss)
                            (setq n 0)
                            (repeat (sslength ss2)
                                (setq delname (ssname ss2 n))
                                (if (= nil (ssdel delname ssrmv) )
                                    (setq n (+ n 1))
                                );if
                            );repeat
                            (setvar "highlight" 0)
                            (setvar "dragmode"  0)
                            (setvar "osmode"    0)
                            (setq n 0);setq
                            (repeat (length lst)
                                (setq a (nth n lst))
                                (command "_.stretch")
                                (cp_loop a)
                                (command "_r" ssrmv "" p1 p2)
                                (setq n (+ n 1))
                            );repeat
                            (if zflag (command "_.zoom" "_p"))
                        );progn then ss2
                        (princ "\nNothing selected")
                    );if
                );progn then ss
                (princ "\nNothing selected")
            );if
        );progn then lst
    );if
    (acet-error-restore)
    (princ)
);defun c:mstretch
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun cp_loop ( lst / n)
    (if (equal (length lst) 2)
        (command "_c" (car lst) (cadr lst))
    ;else
        (progn
            (command "_cp")
            (setq n 0)
            (repeat (length lst)
                (command (nth n lst))
                (setq n (+ n 1))
            );repeat
            (command "")
        );progn
    );if
);defun cp_loop

(princ)

;;;-----BEGIN-SIGNATURE-----
;;; 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEE+U0vr78xSzq0vXnmuWytEw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMjAwNjE1MDAwMDAwWhcNMjEwODEyMjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBAMt3bX7WxfbqKZpcgiX4jvJBSg6MCucqh4aDRHA8
;;; Hny4Fc2vKP+Xgn3mY4qtHoeNZ/j4d669d5+guDfOpD7jZX/JyR81wLE22GwswGLN
;;; M6n3N6Vudo0PcdCNXRxccGdPmJMIiEZNp84RjWN7Gy0JfgChxNiNEWS+Dezr5cYK
;;; B7UlGjGivbUdK6/HP0JlO3t3QxXYERASgPWj6YXmHGdvYHPBNit1MJTLRUj7uXyk
;;; bWzpaQEnXdey73yxg+FV2us0BicMIChoDXdTY/uAWbhkThET8GffQd08miZDNWMv
;;; IUIfFEkKjGZX6VkfkK/ShlVtjcdYlknpatvAtkFuYnQm6mECAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBACiY
;;; IcU6uh5Lz5MGiUDT3w+daDMfYW44/ak/wMK1SgkL+iHzsgHaY8plDqZ4oaxT3U45
;;; /L5BdedSZWIvR738xpjcJNKZVILKTMg3mzl0bjO/t91dj5TFlTSpCbQgBh+jbBpJ
;;; R0il59VeZ9LQTvK/2E41TK89VHXZa+8MaTrsVOyTsBuAnNdYdzzExmAqp1BZdirH
;;; JH35aOAnZz3nkcGS4knKOAc7EX8pLkhAl4UDoS2V+2MKw5IXpYO3tU5TwM7y8uGZ
;;; gj/XpMlzWXtVQvOVpwgmT0XCymP5174BFyTP1SLNhlUWUfwFCypOY6tRHd6U9uqc
;;; BATajxbYoRpvjWl9Nu8xggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQT5TS+vvzFLOrS9eea5bK0TANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQBdfjdIagePkeICAaTrNW5nIK+2BhCVhRKi
;;; 2977xTqxOz/y0LBoIf+mGJFnyPb5+5QymNhugZ1AWj0iOKReG/hG7XRO99axvNoO
;;; 3cpqjZgNKjgvm5afV4XFzM09tEQ0BFs9tJLjHuHO++kIKHkeEh/twgQqh3HHk7nW
;;; 9w4yBuy3GckCg8fWGeZ052PPO7OZGGJnJ7m20x8GsYm0OehjSN/cTmGev69oAYe4
;;; LQHZ6xNr2jRQ7sNcVNSt1PZaZMmp0l/SzwZHET74Zm23Hq1aaZ0orp5pPruyEv94
;;; qX4cE7iW5B8OfYcxo9lNkYqVofptHlHzFoD9RTaQ0A1K4KJn64QS
;;; -----END-SIGNATURE-----