;;;
;;;    TREX.LSP - Written by Randy Kintzley
;;;    Copyright  1999 by Autodesk, Inc.
;;;
;;;    Your use of this software is governed by the terms and conditions of the
;;;    License Agreement you accepted prior to installation of this software.
;;;    Please note that pursuant to the License Agreement for this software,
;;;    "[c]opying of this computer program or its documentation except as
;;;    permitted by this License is copyright infringement under the laws of
;;;    your country.  If you copy this computer program without permission of
;;;    Autodesk, you are violating the law."
;;;
;;;    AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
;;;    AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
;;;    MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
;;;    DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
;;;    UNINTERRUPTED OR ERROR FREE.
;;;
;;;    Use, duplication, or disclosure by the U.S. Government is subject to
;;;    restrictions set forth in FAR 52.227-19 (Commercial Computer
;;;    Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
;;;    (Rights in Technical Data and Computer Software), as applicable.
;;;
;;;  ----------------------------------------------------------------
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;TREX
;Trim and Extend combined!
;Pick to trim and shift+pick to extend.
;
(defun c:trex ( / )
 (acet-error-init
  (list '("cmdecho" 0)
         0 ;0 means place an undo begin and end mark but do not
           ;use undo to back up on an error event.
        '(if ss (acet-ss-redraw ss 4))	;; clear the redraw on any selected objects
  );list
 )
 (acet-trim-extend)
(acet-error-restore)
);defun c:trex
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun acet-trim-extend ( / ss flt flag p1 errno lst n a u ulst endit )
 
(setq flt '((-4 . "<NOT")
             (-4 . "<OR")
              (0 . "INSERT")
              (0 . "ATTDEF")
              (0 . "DIMENSION")
              (0 . "SOLID")
              (0 . "3DSOLID")
              (0 . "3DFACE")
              (0 . "POINT")
              (-4 . "<AND")
               (0 . "POLYLINE")
               (-4 . "&") (70 . 80) ;16 64 / 3dmesh and pface mesh.
              (-4 . "AND>")
              (0 . "TRACE")
              (0 . "SHAPE")
             (-4 . "OR>")
            (-4 . "NOT>")
           )
);setq
 
(acet-trex-print-modes)
(princ "\nSelect cutting/boundary edges or press enter for implied.")
 
(if (setq ss (ssget))
    (progn
     (setq ss (acet-ss-filter
               (list ss
                     (list (list flt
                                 "\n1 object was invalid as a cutting/boundary edge."
                                 "\n%1 objects were invalid as cutting/boundary edges."
                           );list
                     );list
                     T
               );list
              );acet-ss-filter
           ss (car ss)
     );setq
     (if (not ss)
         (setq endit T)
     );if
    );progn then
);if

(while (and (not endit)
            (or
                (progn
                 (acet-ss-redraw ss 3)
                 (initget "Fence Undo Project Edge")
                 (setvar "errno" 0)
                 (setq p1 (entsel "\nPick to trim or Shift+Pick to extend [Project/Edge/Undo]: "));setq
                 (acet-ss-redraw ss 4)
                 p1
                );progn
                (equal (setq errno (getvar "errno"))
                       7
                );equal
            );or
       );and
 (setq flag (acet-sys-shift-down))
 
 (setq u 0)
 
 (cond
  ((equal p1 "Undo")
   (if ulst
       (progn
        (command "_.undo" (car ulst))
        (setq ulst (cdr ulst))
       );progn then
       (princ "\nCommand has been completely undone.")
   );if
   (setq u nil)
  );cond #1
 
  ((or (equal p1 "Project") 
       (equal p1 "Edge")
   );or
   (command "_.trim" "")
   (setvar "cmdecho" 1)
    (command (strcat "_" p1) pause)
   (setvar "cmdecho" 0)
   (acet-safe-command nil T (list "")) ;exit the trim command
   (setq u (+ u 1))
  );cond #2
 
  ((not (equal (getvar "errno") 7))
   (if (equal (type p1) 'LIST)
       (setq p1 (cadr p1))
   );if
   (if flag
       (command "_.extend")
       (command "_.trim")
   );if
   (if ss
       (command ss)
   );if
   (command "")
   (if (equal p1 "Fence")
       (progn
        (command nil)
        (setq u (+ u 1));setq
        (setq lst (acet-ui-fence-select))
        (setq flag (acet-sys-shift-down))
        (if lst
            (progn
             (if flag
                 (command "_.extend")
                 (command "_.trim")
             );if
             (if ss (command ss));if
             (command "" "_F")
             (setq n 0)
             (repeat (length lst)
              (if (setq a (nth n lst))
                  (command a)
              );if
             (setq n (+ n 1));setq
             );repeat
             (command "" "")
             (setq u (+ u 1))
            );progn then
        );if
       );progn then fence
       (progn
        (command p1 "")
        (setq u (+ u 1))
       );progn else point pick
   );if
  );cond #3
 
  ((equal (getvar "errno") 7)
   (princ "\nYou missed! Try again...")
   (setq u nil)  
  );cond #4
 );cond close
 (if (and u
          (> u 0)
     );and
     (setq ulst (cons u ulst))
 );if
);while

(acet-safe-command nil T (list "")) ;exit any active command

 
);defun acet-trim-extend
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;print the status of projmode and edgemode the same wy that trim and extend do.
(defun acet-trex-print-modes ( / a b )
 (setq a (getvar "projmode")
       b (getvar "edgemode")
 );setq
 (cond
  ((equal a 0) (setq a "Projmode = None"))
  ((equal a 1) (setq a "Projmode = UCS"))
  ((equal a 2) (setq a "Projmode = View"))
  (T (setq a ""))
 );cond close
 
 (cond
  ((equal b 0) (setq b "Edgemode = No extend"))
  ((equal b 1) (setq b "Edgemode = Extend"))
  (T (setq b ""))
 );cond close
 
 (setq a (strcat "\n(" a ", " b ")"))
 (princ a)
 
);defun acet-trex-print-modes


(princ)
;;;-----BEGIN-SIGNATURE-----
;;; 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEHxuVyBe6V6ZeOAF5DEIBhAw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMTgwNzA1MDAwMDAwWhcNMTkwODA1MjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBAO5kcjVxvkILSlWX29+2WZtsA4JBZ8fZGcuXJcBs
;;; b60hZqNEUG+YEehM9JYZUETbHwVXGGa6dGMjcSoNuaAnSw4D52qopQomtFJEU6TG
;;; CFHWg9GnD/Auwm+6+KHipdnN6lThqb8gkjOxKcder+x7TtMXojrQhlPnENpLrLBs
;;; g8Yrr4NJ7AjEeM1e23ING4ykt6ttic5MzayacUiST53phIn+TUFUBMYPA4PGDlFQ
;;; BIT3Ofk0QrVh9H0/nOGrChFKPVK8+UwUcKqoNof04pNqlD6JN2JR6yPCSDninyLX
;;; 4FOD2LcK+sreDz1uyYntYHGIuiTQbrcAFCMEXwiNW6yMocECAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBAKxD
;;; AZViem3OQChKsMjuE1jXZ7GF/Ra3llGrl54hipQMBoQJB+zeDGtbBN8irUIuqRO5
;;; /tbdG5pTzy4gFn0YCKA2f2cIlpDqD+wPt9UO7JCo3VDdTPekI3GzVEIw5Bascmx1
;;; K2la9ID5RlKZzEdZ6VwBR4Fwq8OORdTU/i2TR1rf5QJn0LKrk5gzb7O6NH/wIUK+
;;; OWJaPPxrK/J3qI5tiKPIhaXDB6mO43DZ1S+HrYWF1VXWNCUgTflYP9htI/y6vInP
;;; iH/C4lnQZZW9w1K1a4HY5gSB2AsTzyU14LExr+IcJUYn0kJDMPN5wXYFrDm57LCp
;;; wyRDq4ZvQ2vBURy+P38xggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQfG5XIF7pXpl44AXkMQgGEDANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQB6rtUp82BAo2K65cbQK2bfhkiCN/FrC8OP
;;; MtXPukYYlksANB+yB4fIzMF0AfoXi5LDTHIlZqKPBdZwntET6Dz1wVd51pCptK12
;;; Iv+9RQroIS9xQEj810g8Uj7K9vVZJ5rDnGIqmpe/GITr8rUx3ewj+Z+lsEWCaI6W
;;; VZXVOQNiS34VuY2WgC28/W3PDupLStTlZCWk6+oogsNga7qgdjW3SKj2YRxdSmCv
;;; gcYFFBVO/2EFdJwLbnytzHvfMmdt4jSQ/xXSkuV0fhCjXCohwBgYmyrvTlkTUpIa
;;; Kis3FE+bUtgJM7b5v3XYl4975Ot/ZtfXGgaGWNBa//qcEDb/gIn+
;;; -----END-SIGNATURE-----