;;
;;  qquit.lsp - QQUIT command
;;
;;  Copyright  2000 by Autodesk, Inc.
;;
;;  Your use of this software is governed by the terms and conditions
;;  of the License Agreement you accepted prior to installation of this
;;  software.  Please note that pursuant to the License Agreement for this
;;  software, "[c]opying of this computer program or its documentation
;;  except as permitted by this License is copyright infringement under
;;  the laws of your country.  If you copy this computer program without
;;  permission of Autodesk, you are violating the law."
;;
;;  AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
;;  AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
;;  MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
;;  DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
;;  UNINTERRUPTED OR ERROR FREE.
;;
;;  Use, duplication, or disclosure by the U.S. Government is subject to
;;  restrictions set forth in FAR 52.227-19 (Commercial Computer
;;  Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
;;  (Rights in Technical Data and Computer Software), as applicable.
;;  
;;-------------------------------------------------------------------------
;;
;;  DESCRIPTION
;;    Implements the QQUIT command.
;;
;;-------------------------------------------------------------------------
 
 
;;
;;  quick quit
;;
(defun C:QQUIT (/ item cur saveQuery)
  ;;  save if requested
  (defun saveQuery (item / titled writeable name reply)
    (vl-load-com)
    (setq titled (= 1 (vlax-variant-value (vla-getvariable item "DWGTITLED")))
          writeable (= 1 (vlax-variant-value (vla-getvariable item "WRITESTAT")))
          name (if titled
                 (vlax-get item "fullname")
                 (vlax-variant-value (vla-getvariable item "DWGNAME")) )
          reply (acet-ui-message
                    (acet-str-format "Save changes to %1?" name)
                                     "AutoCAD"
                                     (+ Acet:YESNOCANCEL Acet:ICONWARNING) ) )
    (cond
      ((= Acet:IDYES reply)
        (cond
          ;;  REFEDIT active ??
          ((/= "" (vlax-variant-value (vla-getvariable item "REFEDITNAME")))
            (acet-ui-message "Cannot Save while REFEDIT active."
                             "AutoCAD - QQUIT"
                             Acet:ICONSTOP )
            (exit)
          )
          ((and titled writeable)
            (vla-save item)
          )
          (T
            (if (setq name (ACET-FILE-WRITEDIALOG "Save Drawing As" name "dwg" "Acet:SaveAll" 1665))
              (vla-saveas item (vlax-make-variant name))
              (exit)
            )
          )
        )
      )
      ((= Acet:IDCANCEL reply)
        (exit) )
    )
  )
 
  ;;  only valid in MDI
  (vl-load-com)
  (if (= 0 (getvar "SDI"))
    (progn
      ;;  quiet
      (acet-error-init '(("CMDECHO" 0)))
      ;;  locate current doc
      (setq cur (vla-get-activedocument (vlax-get-acad-object)))
      ;;  for each doc
      (vlax-for item (vla-get-documents (vlax-get-acad-object))
        ;;  skip current doc
        (if (not (equal cur item))
          (progn
            ;;  save if modified ??
            (if (/= 0 (vlax-variant-value (vla-getvariable item "DBMOD")))
              (saveQuery item) )
            ;;  close without saving
            (vla-close item (vlax-make-variant :vlax-false))
          )
        )
      )
      ;;  close current
      (vla-sendcommand cur "_.QUIT ")
    )
    (command "_.QUIT")
  )
  (princ)
)


(vl-load-com)
(princ)

;;;-----BEGIN-SIGNATURE-----
;;; 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEHxuVyBe6V6ZeOAF5DEIBhAw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMTgwNzA1MDAwMDAwWhcNMTkwODA1MjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBAO5kcjVxvkILSlWX29+2WZtsA4JBZ8fZGcuXJcBs
;;; b60hZqNEUG+YEehM9JYZUETbHwVXGGa6dGMjcSoNuaAnSw4D52qopQomtFJEU6TG
;;; CFHWg9GnD/Auwm+6+KHipdnN6lThqb8gkjOxKcder+x7TtMXojrQhlPnENpLrLBs
;;; g8Yrr4NJ7AjEeM1e23ING4ykt6ttic5MzayacUiST53phIn+TUFUBMYPA4PGDlFQ
;;; BIT3Ofk0QrVh9H0/nOGrChFKPVK8+UwUcKqoNof04pNqlD6JN2JR6yPCSDninyLX
;;; 4FOD2LcK+sreDz1uyYntYHGIuiTQbrcAFCMEXwiNW6yMocECAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBAKxD
;;; AZViem3OQChKsMjuE1jXZ7GF/Ra3llGrl54hipQMBoQJB+zeDGtbBN8irUIuqRO5
;;; /tbdG5pTzy4gFn0YCKA2f2cIlpDqD+wPt9UO7JCo3VDdTPekI3GzVEIw5Bascmx1
;;; K2la9ID5RlKZzEdZ6VwBR4Fwq8OORdTU/i2TR1rf5QJn0LKrk5gzb7O6NH/wIUK+
;;; OWJaPPxrK/J3qI5tiKPIhaXDB6mO43DZ1S+HrYWF1VXWNCUgTflYP9htI/y6vInP
;;; iH/C4lnQZZW9w1K1a4HY5gSB2AsTzyU14LExr+IcJUYn0kJDMPN5wXYFrDm57LCp
;;; wyRDq4ZvQ2vBURy+P38xggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQfG5XIF7pXpl44AXkMQgGEDANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQCfbi514PaSTFQX2QKiydjXqrGNqx+tx7VZ
;;; c3fb1kzzOq/tvaMSet2wCg0hlWrabfQRCv1GoWrW0Okwj6AIxwp1MncfwKTqm+UK
;;; pXWefGjnE/T5wU77aest0S54cIyvszTr6F5JwUTA3PWZyWul6ZhhHZWvkhp7R7zo
;;; z2QcfovxPYmOa1vE4ABd2yt6h//TmPYtPFutxNhM2FwrgL8PqA5dE6+3qRBxyjHy
;;; 6T+97jDvT1BVrwWP1tiaP+xxMkdhk4a+OvG8YdKK/qGs6KO6PdsVMCYF+bXU7Xgg
;;; LhDRvsQegfHmaBb7ppkRhVg0t7AC+HJRdcTw787P1uYi+6ruy6Dh
;;; -----END-SIGNATURE-----