;;;
;;;    PLT2DWG.LSP - Written by Randy Kintzley
;;;    Copyright  1999 by Autodesk, Inc.
;;;
;;;    Your use of this software is governed by the terms and conditions of the
;;;    License Agreement you accepted prior to installation of this software.
;;;    Please note that pursuant to the License Agreement for this software,
;;;    "[c]opying of this computer program or its documentation except as
;;;    permitted by this License is copyright infringement under the laws of
;;;    your country.  If you copy this computer program without permission of
;;;    Autodesk, you are violating the law."
;;;
;;;    AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
;;;    AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
;;;    MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
;;;    DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
;;;    UNINTERRUPTED OR ERROR FREE.
;;;
;;;    Use, duplication, or disclosure by the U.S. Government is subject to
;;;    restrictions set forth in FAR 52.227-19 (Commercial Computer
;;;    Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
;;;    (Rights in Technical Data and Computer Software), as applicable.
;;;
;;;  ----------------------------------------------------------------
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Reads a plt file (HPGL format only) and creates polylines in the current drawing
;from the plot file information.
; Each pen number is directly related to the color of the polyline that will be created.
;i.e. pen 1 will create red polylines.
;
(defun c:plt2dwg ( / a n fna fh flag p1 pd ptcnt)
(acet-error-init
 (list (list   "cmdecho" 0
             "regenmode" 1
              "limcheck" 0
                "clayer" nil
       )
       0  ;do not undo everything if cancel is pressed
 );list
);acet-error-init
 
(setq fna (acet-ui-getfile "Enter the plot file" (acet-filename-ext-remove (getvar "dwgname")) "PLT" "Acet:plt2dwg" 1664));setq
(cond
 ((not fna) (princ))
 ((not (setq flag (acet-plt2dwg-file-is-hpgl fna)))
  (acet-alert "\nThe selected plt file is not the proper HPGL format.")
 )
 (flag                   ;(= flag 1)
  (acet-plt2dwg fna)
  (command "_.zoom" "_e")
 )
);cond close
 
(acet-error-restore)
);defun c:plt2dwg
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun acet-plt2dwg ( fna / fh n a b pd p1 ptcnt lst n lst2 na ss )
 
    (setq fh (acet-file-open fna "r")
          na (entlast) 
    );setq
    (setq n 0);setq
    (while (setq a (acet-plt2dwg-plt-read fh));setq
      (setq    a (acet-str-replace "PU" ";PU;" a)
               a (acet-str-replace "PD" ";PD;" a)
            lst2 (acet-str-to-list ";" a)
      );setq
 
     (foreach a lst2
      (if (equal n (* 75 (/ n 75)))
          (acet-spinner)
      );if
      (setq b (substr a 3)
            a (substr a 1 2)
      );setq
 
      (if (= b "")
          (setq b nil)
      );if
      (cond
       ((= a "")(princ));cond #1
       ((acet-str-equal a "PD")
        (if (not (wcmatch (getvar "cmdnames") "*PLINE*"))
            (progn
             (acet-cmd-exit)
             (command "_.pline")
            );progn then
        );if
        (setq    pd T
              ptcnt 0
        );setq
       );cond #2
       ((and b
             (acet-str-equal a "SP") ;;;set pen
        );and
        (if (and pd
                 (equal ptcnt 0)
                 p1
            )
            (command p1 p1 "")
         );if
         (acet-cmd-exit)
         (if (not (tblobjname "layer" b))
             (command "_.-layer" "_make" b "_color" b b "") 
             (command "_.-layer" "_thaw" b "_on" b "_set" b "")
         );if
         (princ (acet-str-format "\rImporting pen number: %1" b))
         (setq pd nil)
       );cond #3
       ((and b
             (acet-str-equal a "CI")
        );and
         (if pd
             (progn
              (if (equal ptcnt 0)
                  (command p1 b)
                  (command b)
              );if
             );progn
         );if
         (command "_.circle" p1 b)
       );cond #4
       ((and b
             (acet-str-equal a "PA")
        );and
         (if pd
             (progn
              (if (equal ptcnt 0)
                  (command p1 b)
                  (command b)
              );if
             );progn
         );if
         (setq p1 b)
       );cond #5
       ((and b
             (acet-str-equal a "PR")
        )
        (if (and pd 
                 (= ptcnt 0)
            )
            (command p1) ;;drop the first point
        );if 
        (setq lst (acet-str-to-list "," b))
        (setq n 0)
        (repeat (/ (length lst) 2)
         (setq  a (list (atoi (nth n lst))
                        (atoi (nth (+ n 1) lst))
                  )
               p1 (mapcar 'atoi (acet-str-to-list "," p1))
               p1 (strcat (itoa (+ (car p1) (car a)))
                          ","
                          (itoa (+ (cadr p1) (cadr a)))
                  )
         );setq
         (if pd 
             (progn
              (command p1)
              (setq ptcnt (+ ptcnt 1))
             );progn then
         );if 
         (setq n (+ n 2))
        );repeat
       );cond #6
       ((acet-str-equal a "PU")
        (if (and pd
                 (equal ptcnt 0)
                 p1
            )
            (command p1 p1 "")
        );if
        (acet-cmd-exit)
        (setq pd nil)
       );cond #7
      );cond close
 
     );foreach
 
    );while reading the file
    (close fh)
    (acet-cmd-exit)
 
    (if (setq ss (acet-ss-new na))
        (command "_.scale" ss "" "0,0" (/ 1.0 1020.0))
    );if
 
    (princ "\r                                                                   ")
    (princ)
);defun acet-plt2dwg
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;takes a plt file name and returns 
;- 1 if the file is in ABSOLUTE HPGL format.
;- 2 if the file is in RELATIVE HPGL format.
;
(defun acet-plt2dwg-file-is-hpgl (fna / a b n fh flag aplt rplt )
 (setq aplt "\e.(;\e.I81;;17:\e.N;19:IN;SC;PU"
       rplt "\e.(;\e.I81;;17:\e.N;19:IN;SC;PU"
 );setq
 (if (and (setq fna (findfile fna))
          (setq fh (acet-file-open fna "r"))
     );and
     (progn
      (setq b "")
      (setq n 1)
      (while (and (<= n 29)
                  (setq a (read-char fh))
                  (or (acet-str-equal (chr a) (substr aplt n 1))
                      (acet-str-equal (chr a) (substr rplt n 1))
                  );or
             );and
       (setq b (strcat b (chr a)));setq
      (setq n (+ n 1))
      );while
      (cond
       ((acet-str-equal aplt b)
        (setq flag 1) ;absolute 
       )
       ((acet-str-equal rplt b)
        (setq flag 2) ;relative
       )
      ); 
      (close fh)
     );progn then
 );if
 flag
);defun acet-plt2dwg-file-is-hpgl
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun acet-plt2dwg-plt-read ( fh / a b c )
 
 (while (and (setq a (read-char fh));setq ;;read past any leading semi-colons.
             (setq a (chr a))
             (equal a (chr 59))
        );and
 );while
 (if a
     (setq b a)
     (setq b "")
 );if
 (while (and (setq a (read-char fh));setq
             (setq a (chr a))
             (not (equal a (chr 59)))
        );and
  
  (setq b (strcat b a));setq
 );while
 (if (equal b "")
     (setq b nil);setq
 );if
 b
);defun acet-plt2dwg-plt-read


(princ)
;;;-----BEGIN-SIGNATURE-----
;;; 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEHxuVyBe6V6ZeOAF5DEIBhAw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMTgwNzA1MDAwMDAwWhcNMTkwODA1MjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBAO5kcjVxvkILSlWX29+2WZtsA4JBZ8fZGcuXJcBs
;;; b60hZqNEUG+YEehM9JYZUETbHwVXGGa6dGMjcSoNuaAnSw4D52qopQomtFJEU6TG
;;; CFHWg9GnD/Auwm+6+KHipdnN6lThqb8gkjOxKcder+x7TtMXojrQhlPnENpLrLBs
;;; g8Yrr4NJ7AjEeM1e23ING4ykt6ttic5MzayacUiST53phIn+TUFUBMYPA4PGDlFQ
;;; BIT3Ofk0QrVh9H0/nOGrChFKPVK8+UwUcKqoNof04pNqlD6JN2JR6yPCSDninyLX
;;; 4FOD2LcK+sreDz1uyYntYHGIuiTQbrcAFCMEXwiNW6yMocECAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBAKxD
;;; AZViem3OQChKsMjuE1jXZ7GF/Ra3llGrl54hipQMBoQJB+zeDGtbBN8irUIuqRO5
;;; /tbdG5pTzy4gFn0YCKA2f2cIlpDqD+wPt9UO7JCo3VDdTPekI3GzVEIw5Bascmx1
;;; K2la9ID5RlKZzEdZ6VwBR4Fwq8OORdTU/i2TR1rf5QJn0LKrk5gzb7O6NH/wIUK+
;;; OWJaPPxrK/J3qI5tiKPIhaXDB6mO43DZ1S+HrYWF1VXWNCUgTflYP9htI/y6vInP
;;; iH/C4lnQZZW9w1K1a4HY5gSB2AsTzyU14LExr+IcJUYn0kJDMPN5wXYFrDm57LCp
;;; wyRDq4ZvQ2vBURy+P38xggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQfG5XIF7pXpl44AXkMQgGEDANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQCTDK+IoRCRS07lfSB4VPVvZpi4TxzM+g2b
;;; pLasocxbZq3sNnDeRIMXf1bCAugDc0yUQ++IZkfv+WeKcnHiepp9kVw4y7VHWGF+
;;; Nzr5lPSu4G51ZGRTPLAN/oF3VRhOtxoCQHTtSIlEtZXvMaQzfzS4+6EkF8yQ2BxI
;;; oEXIzwp65OU1lwxxktQJ8mtoUlNoVrOvFemtz4WwyJTNdK2DEJMoooawxuMUe2KM
;;; wFNHIxlz7zG9qHJ14ZDHRGL43N+2YYeSJroBDzgiCCqjz+JwjpsNo1gYyGc+uOtG
;;; QbKp1tTF8m0Rqy2pm/LLl/uHz7s/Ny1YW05RX7jSJv5Na/K1qpYu
;;; -----END-SIGNATURE-----