;;
;;
;;  movebak.lsp - MOVEBAK command
;;
;;  Copyright  1999 by Autodesk, Inc.
;;
;;  Your use of this software is governed by the terms and conditions
;;  of the License Agreement you accepted prior to installation of this
;;  software.  Please note that pursuant to the License Agreement for this
;;  software, "[c]opying of this computer program or its documentation
;;  except as permitted by this License is copyright infringement under
;;  the laws of your country.  If you copy this computer program without
;;  permission of Autodesk, you are violating the law."
;;
;;  AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.  AUTODESK
;;  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR
;;  FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.  DOES NOT WARRANT THAT
;;  THE OPERATION OF THE PROGRAM WILL BE UNINTERRUPTED OR ERROR FREE.
;;
;;  Use, duplication, or disclosure by the U.S. Government is subject to
;;  restrictions set forth in FAR 52.227-19 (Commercial Computer Software -
;;  Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) (Rights in Technical
;;  Data and Computer Software), as applicable.
;;
;;----------------------------------------------------------------
;;
;;  DESCRIPTION
;;  Provides an interface to the MOVEBAK ObjectARX app.
;;
;;----------------------------------------------------------------
 
 
(defun C:MOVEBAK (/ cur new)
  (acet-error-init nil)
  (if (member nil (mapcar
        '(lambda (x) (if (member x (arx)) T (arxload x nil)))
           '("acetutil.arx") ) )
    (alert "Could not load required ObjectARX modules.")
    (progn
      (setq cur (getenv "AcetMovebak")
            cur (if cur cur "")
            new (getstring T
                    (acet-str-format
                        "New value for MOVEBAK, or . for none <%1>: " cur ) )
            new (cond
                  ((= "" new) cur)
                  ((= "~" new) (acet-ui-pickdir
                                 "Select MOVEBAK directory" cur ) )
                  ((= "." new) "")
                  (T new)
                )
      )
      (if new
        (setq new (acet-str-replace "/" "\\" new)) )
      (if (and new
               (/= "" new)
               (/= ":\\" (substr new 2))
               (/= Acet:DIRECTORY (acet-file-attr new)) )
        (progn
          (princ (acet-str-format "Not a directory: %1" new))
          (setq new nil)
        )
      )
 
      (if new
        (setenv "AcetMoveBak" new) )
    )
  )
  (acet-error-restore)
  (princ)
)
 
;;  verify 'acetutil.fas'
(if (and (not acet-error-init) (not (load "acetutil" nil)))
  (progn
    (princ "Missing 'acetutil.fas', MOVEBAK not loaded.")
    (setq C:MOVEBAK nil)
  )
  (princ "MOVEBAK command loaded.")
)


(princ)

;;;-----BEGIN-SIGNATURE-----
;;; 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEHxuVyBe6V6ZeOAF5DEIBhAw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMTgwNzA1MDAwMDAwWhcNMTkwODA1MjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBAO5kcjVxvkILSlWX29+2WZtsA4JBZ8fZGcuXJcBs
;;; b60hZqNEUG+YEehM9JYZUETbHwVXGGa6dGMjcSoNuaAnSw4D52qopQomtFJEU6TG
;;; CFHWg9GnD/Auwm+6+KHipdnN6lThqb8gkjOxKcder+x7TtMXojrQhlPnENpLrLBs
;;; g8Yrr4NJ7AjEeM1e23ING4ykt6ttic5MzayacUiST53phIn+TUFUBMYPA4PGDlFQ
;;; BIT3Ofk0QrVh9H0/nOGrChFKPVK8+UwUcKqoNof04pNqlD6JN2JR6yPCSDninyLX
;;; 4FOD2LcK+sreDz1uyYntYHGIuiTQbrcAFCMEXwiNW6yMocECAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBAKxD
;;; AZViem3OQChKsMjuE1jXZ7GF/Ra3llGrl54hipQMBoQJB+zeDGtbBN8irUIuqRO5
;;; /tbdG5pTzy4gFn0YCKA2f2cIlpDqD+wPt9UO7JCo3VDdTPekI3GzVEIw5Bascmx1
;;; K2la9ID5RlKZzEdZ6VwBR4Fwq8OORdTU/i2TR1rf5QJn0LKrk5gzb7O6NH/wIUK+
;;; OWJaPPxrK/J3qI5tiKPIhaXDB6mO43DZ1S+HrYWF1VXWNCUgTflYP9htI/y6vInP
;;; iH/C4lnQZZW9w1K1a4HY5gSB2AsTzyU14LExr+IcJUYn0kJDMPN5wXYFrDm57LCp
;;; wyRDq4ZvQ2vBURy+P38xggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQfG5XIF7pXpl44AXkMQgGEDANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQBThxk+UWSBFFYDG3nXLe8c9NJYUp/9ua8k
;;; oorwHgF1WFXqlyPD12IQZTIc4fhHPF4tdjCmd8v7vQtoBHJsMz+Zxh2Oe8lil5lZ
;;; ryCljDis6pXWwXB9lNiqM+YEQ9HZEX7j5vBFxvQJ24zsRaVRijeATI/SmNVnpV0R
;;; utxQqJEVPvvTx2s0NJamFuIX4tCb7N+1C8rxS7ajUQiAeecwAmXYYF4Cw+6xBcE1
;;; hIQi7EeWxQLpgTy85nzUuB7u8wQGc8MbWsvIvAugbxAqzZsovo7jedtiUC6mRGRV
;;; wxiGQYuTJKk3LwyHwadeSezWOLaMwuG8yBKGT3+M9ilLq/IBvuh6
;;; -----END-SIGNATURE-----