;;;
;;;    ASPACE.LSP - C:ALIGNSPACE Written by Randy Kintzley
;;;    Copyright  1999 by Autodesk, Inc.
;;;
;;;    Your use of this software is governed by the terms and conditions of the
;;;    License Agreement you accepted prior to installation of this software.
;;;    Please note that pursuant to the License Agreement for this software,
;;;    "[c]opying of this computer program or its documentation except as
;;;    permitted by this License is copyright infringement under the laws of
;;;    your country.  If you copy this computer program without permission of
;;;    Autodesk, you are violating the law."
;;;
;;;    AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
;;;    AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
;;;    MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
;;;    DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
;;;    UNINTERRUPTED OR ERROR FREE.
;;;
;;;    Use, duplication, or disclosure by the U.S. Government is subject to
;;;    restrictions set forth in FAR 52.227-19 (Commercial Computer
;;;    Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
;;;    (Rights in Technical Data and Computer Software), as applicable.
;;;
;;;  ----------------------------------------------------------------
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 
;  Align-SPACE
(defun c:alignspace ( / ss2 p1 p2 p3 p4 flag flag2 a)
 
(acet-error-init
 (list (list   "cmdecho" 0
             "regenmode" 1
             "ucsfollow" 0
       );list
       T
 );list
);acet-error-init
 
(cond
 ((not (equal 0 (getvar "tilemode")))
  (princ "\n  Command not allowed unless TILEMODE is set to 0  ")
 );cond #1
 ((and (setq flag (acet-viewport-next-pickable))
       (car flag)
  );and
  (progn
   (command "_.mspace")
   (if (not (equal (car flag) (getvar "cvport")))
       (progn
        (princ "\nPicking in perspective view not allowed...")
        (princ "\nSwitching to next available model space viewport")
        (setvar "cvport" (car flag))
       );progn then
   );if
   (while (not flag2)
    (if (setq p1 (getpoint "\nFIRST alignment point in MODEL space: "))
        (progn
         (setq p2
               (getpoint p1 "\nSECOND point in MODEL space or <Return> for none: ")
         );setq
         (setq p1 (trans p1 1 0))
         (if p2
             (setq p2 (trans p2 1 0))
         )
        );progn then
    );if
    (if (and p1
             (equal p1 p2)
        );and
        (princ "\n*Invalid* Points cannot be the same.")
        (setq flag2 T)
    );if
   );while
   (if p1
       (progn
        (command "_.pspace")
        (setq flag2 nil)
        (while (not flag2)
         (if p2
             (setq a "\nFIRST alignment point in PAPER space: ")
             (setq a "\nAlignment point in PAPER space: ")
         );if
         (if (and (setq p3 (getpoint a))
                  p2
             );and
             (setq p4 (getpoint p3 "\nSECOND alignment point in PAPER space: "))
         );if
         (if (and p3
                  (equal p3 p4)
             );and
             (princ "\n*Invalid* Points cannot be the same.")
             (setq flag2 T)
         );if
        );while
        (setq flag2 nil)
        (command "_.mspace")
        (if (and (setq ss2 (ssget "_x" '((0 . "VIEWPORT") (67 . 1))));setq
                 (= (sslength ss2) 2)
            );and
            (setq flag2 T)
        );if
        (while (not flag2)
         (getstring "\nActivate the desired viewport to align and press ENTER to continue.")
         (if (equal (getvar "cvport")
                    (car (setq flag (acet-viewport-next-pickable)))
             );equal
             (setq flag2 T)
             (progn
              (princ "\n*Invalid*")
              (princ (strcat "\nCannot use viewports that are turned"
                             " off or have perspective view on."
                     )
              );princ
             );progn
         );if
        );while
        (if (or (and p1
                     (not p2)
                     p3
                     (not p4)
                );and
                (and p1 p2 p3 p4);and
            );or
            (alignspace p1 p2 p3 p4)
        );if
       );progn then got 2 model space points
   );if
  );progn
 );cond #2
 ((cadr flag)
  (princ (cadr flag))
 );cond #3
);cond close
 
(acet-error-restore)
(princ)
);defun c:aspace
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;takes two points in model space (p1 p2) and zooms in the current viewport to align
;it visually woith the two matching point in paper space (p3 p4).
;if p2 and p4 are nil then no view scaling occurrs and only p1 is matched to p3.
;NOTE model space points must be provided in world coords.
;
(defun alignspace ( p1 p2 p3 p4 / vp a b c d na vplocked )
 
(if (= 1 (getvar "cvport"))
    (command "_.mspace")
);if
(setq       na (acet-currentviewport-ename)
      vplocked (acet-viewport-lock-set na nil) ;unlock the viewport if needed.
                                               ;sets vplocked to the ename of viewport if locked/nil if not
);setq
 
(command "_.pspace")
(setq p3 (trans p3 1 3))
(if p4
    (setq p4 (trans p4 1 3))
);if
 
(command "_.mspace")
 
(acet-ucs-cmd (list "_view"))
 
(setq p1 (trans p1 0 1));setq
(if p2
    (setq p2 (trans p2 0 1))
);if
 
(if (not p2)
    (progn
     (setq vp (acet-currentviewport-ename)
           vp (entget vp)
           vp (cdr (assoc 41 vp))
            a (/ vp (getvar "viewsize"))
     );setq
    );progn
    (setq p2 (list (car p2) (cadr p2) (caddr p1)) ;rk added 5:39 PM 9/1/97
          p4 (list (car p4) (cadr p4) (caddr p3))
           a (/ (distance p3 p4)
                (distance p1 p2)
             )
    );setq else
);if
 
(setq c (trans p3 3 2)
      c (trans c 2 1)
);setq
(if p4
    (setq d (trans p4 3 2)
          d (trans d 2 1)
    );setq
);if
(if (and p2
         p4
         (not (equal (angle p1 p2) (angle c d) 0.0001))
    );and
    (progn
     (acet-ucs-cmd (list "_z" (* (- (angle p1 p2) (angle c d))
                              (/ 180.0 pi)
                           )
                   );list
     );acet-ucs-cmd
     (command "_.plan" "_c")
     (acet-ucs-cmd (list "_p"))
    );progn then
);if
(if (and p2 p4)
    (command "_.zoom" (strcat (rtos a 2 6) "xp"))
);if
(setq b (trans p3 3 2)
      b (trans b 2 1)
);setq
(command "_.-pan" p1 b)
 
;restore the original ucs
(acet-ucs-cmd (list "_p"))
 
(if vplocked
    (acet-viewport-lock-set na T) ;re-lock the viewport
)
 
(if (and p2 p4
         (or (not (equal (caddr p1) (caddr p2) 0.0001))
             (not (equal (caddr c) (caddr d) 0.0001))
         );or
    );and
    (progn
     (princ "\nWarning: Selected Points are not parallel to view")
     (princ "\nCommand results may not be obvious")
    );progn
);if
(princ "\nPaper space = Model space")
(princ (strcat "\n"
               (substr "             " 1
                       (max (- 11 (strlen (rtos 1.0))) 0)
               );substr
               (rtos 1.0)
               " = "
               (rtos (/ 1.0 a))
       );strcat
);princ
(princ (strcat "\nCurrent zoom factor = " (rtos a) "xp"))
);defun alignspace


(princ)

;;;-----BEGIN-SIGNATURE-----
;;; 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEHxuVyBe6V6ZeOAF5DEIBhAw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMTgwNzA1MDAwMDAwWhcNMTkwODA1MjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBAO5kcjVxvkILSlWX29+2WZtsA4JBZ8fZGcuXJcBs
;;; b60hZqNEUG+YEehM9JYZUETbHwVXGGa6dGMjcSoNuaAnSw4D52qopQomtFJEU6TG
;;; CFHWg9GnD/Auwm+6+KHipdnN6lThqb8gkjOxKcder+x7TtMXojrQhlPnENpLrLBs
;;; g8Yrr4NJ7AjEeM1e23ING4ykt6ttic5MzayacUiST53phIn+TUFUBMYPA4PGDlFQ
;;; BIT3Ofk0QrVh9H0/nOGrChFKPVK8+UwUcKqoNof04pNqlD6JN2JR6yPCSDninyLX
;;; 4FOD2LcK+sreDz1uyYntYHGIuiTQbrcAFCMEXwiNW6yMocECAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBAKxD
;;; AZViem3OQChKsMjuE1jXZ7GF/Ra3llGrl54hipQMBoQJB+zeDGtbBN8irUIuqRO5
;;; /tbdG5pTzy4gFn0YCKA2f2cIlpDqD+wPt9UO7JCo3VDdTPekI3GzVEIw5Bascmx1
;;; K2la9ID5RlKZzEdZ6VwBR4Fwq8OORdTU/i2TR1rf5QJn0LKrk5gzb7O6NH/wIUK+
;;; OWJaPPxrK/J3qI5tiKPIhaXDB6mO43DZ1S+HrYWF1VXWNCUgTflYP9htI/y6vInP
;;; iH/C4lnQZZW9w1K1a4HY5gSB2AsTzyU14LExr+IcJUYn0kJDMPN5wXYFrDm57LCp
;;; wyRDq4ZvQ2vBURy+P38xggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQfG5XIF7pXpl44AXkMQgGEDANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQApEDM4reIC6qxbP1akuYqoNYXcMcHeuooZ
;;; lVNDAQ00qDsu50VomxJ6nV3fp92CJQ/7zkWkN/QjjeSYoVArIecNSzwuaFfsDRP0
;;; 5iniIE9pxxBBo2+mOFdhrREyVUCkxNlXXMtlviHYyLL2mfYeU/ZfHfxVd8rVPKbh
;;; 6C+BNTIDOR/++VHHZ7IXOox2oT06O+sb0/7dZdK0BrgFDdIplLu/PW2zU5uTaxGI
;;; D3L0ynziiB2bACHLOCm3P4HhQSgnhvAC6FQF/TOw8WiJEVRMDsBhrYgaAukcatpg
;;; m//mfJtEE760hO0pDQHX8g9pjmmGqX90xrQsdQtElVN+Z9JQ69Mt
;;; -----END-SIGNATURE-----