!define PROGRAM_NAME "Universal C Runtime Installer"
!define VERSION "1.0.1290.77"

Name "${PROGRAM_NAME}"
OutFile AdUcrtInstaller.exe

;Run as admin on Vista, Windows 7 etc.
RequestExecutionLevel admin

;Show progress to the user at install time
ShowInstDetails show

  VIAddVersionKey ProductName "${PROGRAM_NAME}"

  VIAddVersionKey Comments ""
  VIAddVersionKey CompanyName "Autodesk, Inc."
  VIAddVersionKey LegalCopyright "(C) Autodesk, Inc."
  VIAddVersionKey FileDescription "${PROGRAM_NAME}"
  VIAddVersionKey FileVersion "${VERSION}"
  VIAddVersionKey ProductVersion "${VERSION}"
  VIAddVersionKey InternalName ""
  VIAddVersionKey LegalTrademarks ""
  VIAddVersionKey OriginalFilename ""
  VIAddVersionKey PrivateBuild ""
  VIAddVersionKey SpecialBuild ""

  VIProductVersion ${VERSION}

!include "FileFunc.nsh"

!include "x64.nsh"

;Modern UI
!include "MUI2.nsh"

!define MUI_ICON Setup.ico

;------------------------------------------------------------------
;
;Global variables
;
var num_products_installed
var products_installed

;------------------------------------------------------------------
;
;UI Pages
;

;Titles are a bit long so we need more space
!define MUI_WELCOMEPAGE_TITLE_3LINES
!define MUI_FINISHPAGE_TITLE_3LINES

!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_INSTFILES
;Must redefine the text prior to including the finish page macro
!define MUI_FINISHPAGE_TEXT $products_installed
!insertmacro MUI_PAGE_FINISH

;------------------------------------------------------------------
;
;Languages
;

!insertmacro MUI_LANGUAGE "English"

Section

StrCpy $products_installed "${PROGRAM_NAME} has attempted the following installations:$\r$\n"

;-------------------------------------------------------------
; Check current bittyness; Store in $8 and System dir in $9
;-------------------------------------------------------------
${If} ${RunningX64}
  ;have to access the 64bit system dir and we are a 32 bit process
  StrCpy $8 'x64'
  StrCpy $9 '$WINDIR\SysNative'
  ;have to access the 64bit registry...
  SetRegView 64
${Else}
  StrCpy $8 'x86'
  StrCpy $9 '$SYSDIR'
${EndIf}

;-------------------------------------------------------------
; Check current installed version
;-------------------------------------------------------------
DetailPrint "Checking installed versions of $9\api-ms-win-crt-runtime-l1-1-0.dll against 10.0.10240.16390..."
ClearErrors
GetDllVersion $9\api-ms-win-crt-runtime-l1-1-0.dll $R0 $R1
IfErrors need_to_install
IntOp $R2 $R0 / 0x00010000
IntOp $R3 $R0 & 0x0000FFFF
IntOp $R4 $R1 / 0x00010000
IntOp $R5 $R1 & 0x0000FFFF

; IntOp jumps are =                <               >
IntCmp $R2 10    +1                need_to_install already_installed
IntCmp $R3 0     +1                need_to_install already_installed
IntCmp $R4 10586 +1                need_to_install already_installed
IntCmp $R5 9     already_installed need_to_install already_installed

;-------------------------------------------------------------
; Pick which install payload to use for current OS
;-------------------------------------------------------------
need_to_install:
DetailPrint "Chosing MSU for current OS..."
ReadRegStr $R6 HKLM "SOFTWARE\Microsoft\Windows NT\CurrentVersion" CurrentVersion
StrCmp $R6 '6.0' vista
StrCmp $R6 '6.1' windows_7
StrCmp $R6 '6.2' windows_8
StrCmp $R6 '6.3' windows_8_1
StrCmp $R6 '6.4' windows_10
goto unknown_or_post_windows_10_version

vista:
StrCpy $1 "Windows6.0-KB3118401-$8"
goto do_install

windows_7:
StrCpy $1 "Windows6.1-KB3118401-$8"
goto do_install

windows_8:
StrCpy $1 "Windows8-RT-KB3118401-$8"
goto do_install

windows_8_1:
; Microsoft have made this hard because they have stopped incrementing CurrentVersion value
; Therefore I need to look at CurrentMajorVersionNumber as well.
ClearErrors
ReadRegDWORD $R6 HKLM "SOFTWARE\Microsoft\Windows NT\CurrentVersion" CurrentMajorVersionNumber
IfErrors really_windows_8_1 windows_10
IntCmp $6 10 windows_10 really_windows_8_1 unknown_or_post_windows_10_version

really_windows_8_1:
; NW-52474.  Since Microsoft have inserted a bogus dependency on KB2913955,
; a monster (800MB) update, installation fails (sliently) on windows 8.1 if 
; that update is missing.  Don't want to ship KB2913955 as well.  Ultimately,
; users on Windows 8.1 will need that update so just let the VC2015 redist and
; WUSA.exe try to sort that out.  It will look like a hang (see NW-52403)...
goto nothing_to_do_on_windows_8_1

windows_10:
unknown_or_post_windows_10_version:
; Nothing to do.  Should come built-in

goto already_installed

;-------------------------------------------------------------
; Execute the installation
;-------------------------------------------------------------
do_install:
DetailPrint "Checking that $EXEDIR\$1.msu is present..."
IfFileExists $EXEDIR\$1.msu 0 skip_install

DetailPrint "Unpacking the CAB from the MSU..."
SetOutPath $TEMP\UCRT ; SetOutPath creates the directory as a side effect
SetOutPath $EXEDIR
ClearErrors
DetailPrint 'expand $1.msu -F:$1.cab "$TEMP\UCRT"'
nsExec::Exec 'expand $1.msu -F:$1.cab "$TEMP\UCRT"'
Pop $2
IntCmp $2 0 0 skip_install skip_install
IfErrors skip_install

DetailPrint "Installing the CAB with DISM.exe..."
SetOutPath $TEMP\UCRT
ClearErrors
DetailPrint '"$9\DISM.exe" /Online /Add-Package /PackagePath:$1.cab /LogPath:..\$1.cab.log /LogLevel:4 /Quiet /Norestart'
nsExec::Exec '"$9\DISM.exe" /Online /Add-Package /PackagePath:$1.cab /LogPath:..\$1.cab.log /LogLevel:4 /Quiet /Norestart'
Pop $2
IfErrors skip_install
DetailPrint "$1.cab (Exit code: $2, Log File:%TEMP%\$1.cab.log)"
StrCpy $products_installed "$products_installed$\r$\n- $1.cab (Exit code: $2, Log File:%TEMP%\$1.cab.log)"
IntOp $num_products_installed $num_products_installed + 1

DetailPrint "Cleaning up..."
Delete /REBOOTOK $TEMP\UCRT\$1.cab
SetOutPath $TEMP ; Can't delete $TEMP\CRT if it is the current working dir
RMDir /REBOOTOK $TEMP\UCRT

skip_install:
IntCmp $num_products_installed 0 0 end_of_section end_of_section
    Abort "No C Runtime installations were succesfully installed"

already_installed:
IntCmp $num_products_installed 0 0 end_of_section end_of_section
    StrCpy $products_installed "$products_installed$\r$\nNothing installed -- C Runtimes already present"
goto end_of_section

nothing_to_do_on_windows_8_1:
IntCmp $num_products_installed 0 0 end_of_section end_of_section
    StrCpy $products_installed "$products_installed$\r$\nNothing installed -- Windows 8.1 requires KB2919355 to be installed first"
goto end_of_section
    
; Check we didn't see an error code from installing the CAB
end_of_section:
IntCmp $2 3010 0 check_error_success check_error_success ; 3010 is ERROR_SUCCESS_REBOOT_REQUIRED
SetRebootFlag true
goto success
check_error_success:
IntCmp $2 0 success                  ;  0 is ERROR_SUCCESS
    Abort

success:
SectionEnd