// Topic controller.
(function($, UTILS) {
    var self = undefined;

	$.widget('adsk.topiccontroller', {

		options: {
            targetId: 'topic',
            topicPathPrefix: './files',
            wrappedTopicPathPrefix: './wrapped-files',
            topicHTML: '',
            toc: undefined,
            favoritesController: undefined,
            searchOptions: undefined
		},

		/* Private members. */

		_view: undefined,
		_tocLoading: undefined,

        _defaultTopicData: undefined,
        _currentTopicData: undefined,
        _parentTopicData: undefined,

        _siblingTopicData: {
            prn: undefined, // previous
            nxn: undefined // next
        },

		_create: function() {
            console.log('topiccontroller: _create');

            this._tocLoading = $.Deferred();

            self = this;

            // Some initialization staff.
            $('#' + this.options.targetId).topicview({
                create: $.proxy(this._viewCreateHandler, this)
            });
		},

		_init: function() {
            this._trigger('ready');
        },

		_viewCreateHandler: function(event, ui) {
		    console.log('topiccontroller: _viewCreateHandler');

		    this._view = $(event.target).topicview('instance');
		},

		// Get JS wrapped file href by HTM file href.
        _getTopicHref: function(href) {
            console.log('topiccontroller: _getTopicHref, href = ' + href);

            // Turn ./files/topic.htm to ./wrapped-files/topic.htm.js
            // or something.htm to something.htm.js
            if (href.indexOf(this.options.topicPathPrefix) == 0) {
                // If starts with ./files
                return this.options.wrappedTopicPathPrefix + this._getFileFolderPathFromFullPath(href) + '.js';
            } else {
                return href + '.js';
            }
        },

		_getFileFolderPathFromFullPath: function(path) {
		    var prefix = this.options.topicPathPrefix,
		        pos = path.lastIndexOf(prefix),
		        filename = path.substring(pos + prefix.length);
		    return filename;
		},

		// Get topic data (title, href, id etc.) from TOC tree by ID, HREF or topic number.
        _fetchTopicData: function(data, bookName) {
            console.log('appcontroller: _fetchTopicData, data = ', data);

            var toc = this.options.toc,
                topic = undefined;

            if (toc !== undefined) {
                // Get topic data by topic ID.
                if (data.id !== undefined && data.id !== '') {
                    if (toc.tocDataIndexedById !== undefined) {
                        topic = toc.tocDataIndexedById[bookName][data.id];
                    }
                // Get topic data by href.
                } else if (data.href !== undefined && data.href !== '') {
                    // Crop url fragment.
                    var href = data.href;

                    if (data.href.lastIndexOf('#') != -1) {
                        href = data.href.substr(0, data.href.lastIndexOf('#'));
                    }

                    if (toc.tocDataIndexedByHref !== undefined &&
                        toc.tocDataIndexedByHref[bookName] !== undefined) {
                        topic = toc.tocDataIndexedByHref[bookName][href];
                    }
                // Get topic data by topic number.
                } else if (data.tn !== undefined && data.tn !== '') {
                    if (toc.tocDataIndexedByTopicNumber !== undefined) {
                        topic = toc.tocDataIndexedByTopicNumber[bookName][data.tn];
                    }
                }
            }

            if (topic === undefined) {
                topic = {
                    attr: {
                        href: data.href
                    }
                };
            } else {
                topic.attr.href = data.href; // Preserve url fragment.
            }

            return topic;
        },

        // Disable/enable navigation buttons and favorites.
        _setupTopicRelatedFeatures: function(topic, bookName) {
            console.log('topiccontroller: _setupTopicRelatedFeatures');

            var toc = this.options.toc,
                view = this._view;

            if (topic !== undefined && topic.attr.id !== undefined) {
                this._setupGoToParentFeature(toc, topic, view, bookName);
                this._setupGoToSiblingFeature('prn', toc, topic, view, bookName);
                this._setupGoToSiblingFeature('nxn', toc, topic, view, bookName);
                this._setupFavoritesFeature(topic, view);
                this._setupBreadcrumbsFeature(topic, bookName);
                this._setupTocFeature(topic);
            } else {
                this._disableTopicRelatedFeatures(view);
            }

        },

        _setupTocFeature: function(topicData) {
            console.log('topiccontroller: _setupTocFeature');

            this._trigger('setuptoc', {}, {
                href: topicData.attr.href
            });
        },

        _disableTopicRelatedFeatures: function(view) {
            console.log('topiccontroller: _disableTopicRelatedFeatures');

            this._initGoToPreviousButton(false);
            this._initGoToParentButton(false);
            this._initGoToNextButton(false);
            this._initFavoritesButton(false);

            this._siblingTopicData['prn'] = undefined;
            this._siblingTopicData['nxn'] = undefined;

            this._flagFavorites(false);
        },

        _setupGoToParentFeature: function(toc, topic, view, bookName) {
            console.log('topiccontroller: _setupGoToParentFeature');

            // Enable "Go to parent" button if parent topic available.
            var parentTopic = undefined;

            if (toc !== undefined) {
                var parentTopicNumber = topic.attr.pn;

                if (parentTopicNumber !== undefined) {
                    parentTopic = toc.tocDataIndexedByTopicNumber[bookName][parentTopicNumber]
                }

                var goToParentButtonEnabled = (parentTopic !== undefined) ? true: false;

                if (goToParentButtonEnabled) {
                    this._parentTopicData = parentTopic;
                } else {
                    this._parentTopicData = undefined;
                }

                this._initGoToParentButton(goToParentButtonEnabled);
            } else {
                this._initGoToParentButton(false);
            }
        },

        // attr = prn || nxn.
        _setupGoToSiblingFeature: function(attr, toc, topic, view, bookName) {
            console.log('topiccontroller: _setupGoToSiblingFeature');

            // Fetch target topic (following or previous).
            var targetTopic = undefined;

            if (toc !== undefined) {
                var topicNumber = topic.attr[attr];

                if (topicNumber !== undefined) {
                    targetTopic = toc.tocDataIndexedByTopicNumber[bookName][topicNumber];
                }
            }

            // Enable button if 'previous/next' topic is available.
            var enabled = (targetTopic) ? true : false;

            if (attr == 'prn') {
                this._initGoToPreviousButton(enabled);
            } else {
                this._initGoToNextButton(enabled);
            }

            this._siblingTopicData[attr] = targetTopic;
        },

        _setupFavoritesFeature: function(topic, view) {
            console.log('topiccontroller: _setupFavoritesFeature');
            // Indicate if opened topic page is in favorites.
            if (this.options.favoritesController !== undefined) {
                this._initFavoritesButton(true);

                var isTopicInFavorites = this.options.favoritesController.isTopicIdInFavorites(topic.attr.id);

                this._flagFavorites(isTopicInFavorites);
            }
        },

        _setupBreadcrumbsFeature: function(topic, bookName) {
            console.log('topiccontroller: _setupBreadcrumbsFeature');

            this._trigger('setupbreadcrumbs', {}, {
                breadcrumbs: this._getBreadcrumbs(topic, bookName)
            });
        },

        _getBreadcrumbs: function(topic, bookName) {
            console.log('topiccontroller: _getBreadcrumbs');


            var breadcrumbs = [],
                parents = this._getTopicParents(bookName, topic.attr.tn)
                self = this;

            $.each(parents, function(index, parent) {
                breadcrumbs.push(self._getParentTopicData(parent));
            });

            return breadcrumbs;

        },

        _getTopicParents: function(bookName, topicNumber) {
            var parentsArray = [],
                currentTopic = this._getTopicData(bookName, topicNumber);

            if (currentTopic) {
                this._fillTopicParentsArray(bookName, currentTopic.attr.pn, parentsArray);
            }

            return parentsArray;
        },

        _getTopicData: function(bookName, topicNumber) {
            var toc = this.options.toc.tocDataIndexedByTopicNumber;

            return toc[bookName] ? toc[bookName][topicNumber] : undefined;
        },

        _fillTopicParentsArray: function(bookName, topicNumber, parentsArray) {
            var currentTopic = this._getTopicData(bookName, topicNumber);

            if (currentTopic) {
                var parentNumber = currentTopic.attr.pn;

                this._fillTopicParentsArray(bookName, parentNumber, parentsArray);

                parentsArray.push(currentTopic);
            }
        },

        _getParentTopicData: function(topic) {
            if (topic) {
                return {
                    title: topic.data,
                    href: topic.attr.href
                };
            } else {
                return undefined;
            }
        },

        _initGoToPreviousButton: function(enabled) {
            console.log('topiccontroller: _initGoToPreviousButton');

            this._trigger('initgotopreviousbutton', {}, {
                enabled: enabled
            });
        },

        _initGoToParentButton: function(enabled) {
            console.log('topiccontroller: _initGoToParentButton');

            this._trigger('initgotoparentbutton', {}, {
                enabled: enabled
            });
        },

        _initGoToNextButton: function(enabled) {
            console.log('topiccontroller: _initGoToNextButton');

            this._trigger('initgotonextbutton', {}, {
                enabled: enabled
            });
        },

        _initFavoritesButton: function(enabled) {
            console.log('topiccontroller: _initFavoritesButton');

            this._trigger('initfavoritesbutton', {}, {
                enabled: enabled
            });
        },

        _fireOpenTopicEvent: function(topic) {
            console.log('topiccontroller: _fireOpenTopicEvent');

            if (topic !== undefined) {
                this._currentTopicData = topic;

                this._trigger('opentopic', {}, {
                    href: topic.attr.href
                });
            }
        },

        _flagFavorites: function(added) {
            console.log('topiccontroller: _flagFavorites');

            this._trigger('flagfavorites', {}, {
                added: added
            });
        },

        // Get book name from path.
        // ./filesTEST1/topichead.htm => TEST1
        _getBookBase: function(path) {
            var pos = path.lastIndexOf('/'),
                base = path.substring(0, pos + 1);

            return base;
        },

        _getBookName: function(bookBase) {
            var files = '/files',
                startIndex = bookBase.lastIndexOf(files) + files.length,
                endIndex = bookBase.lastIndexOf('/');

            return bookBase.substring(startIndex, endIndex);
        },

		/* Public members. */

		setTocData: function(tocData) {
            console.log('topiccontroller: setTocData');

            if (tocData !== undefined) {
                this.options.toc = tocData;
                this._tocLoading.resolve();
            }
        },

        openTopic: function(data) {
            console.log('topiccontroller: openTopic, topic = ', data);

            var self = this;

            self._tocLoading.done(function() {
                // Show topic content.
                if (data) {
                    var href = data.href;

                    if (href.lastIndexOf('#') != -1) {
                        href = href.substr(0, data.href.lastIndexOf('#'));
                    }

                    // Get href to JS file.
                    var realHref = self._getTopicHref(href);

                    // Get book name to resolve inner links.
                    var bookBase = self._getBookBase(href);

                    // Get topic content either from local JS file or TODO: load with AJAX.

                    // yepnope.injectJs( scriptSource [, callback ] [, elemAttributes ] [, timeout ]);
                    // TODO: do not cache local js.
                    window.topic = '';

                    yepnope.injectJs(realHref, $.proxy(function() {
                        // Render topic content.
                        if ((window.topic !== '') && (window.topic !== self.options.topicHTML)) {
                            self.options.topicHTML = window.topic;

                            self._view.showTopicContent(self.options.topicHTML, bookBase);

                            self._view.scrollToFragment(data.href);

                            self._view.highlight(self.options.searchOptions);

                            // Get topic TOC data for specified book (parent topic, next topic etc.)
                            var bookName = self._getBookName(bookBase);

                            var topicData = self._currentTopicData = self._fetchTopicData(data, bookName);

                            // Initialize navigation buttons, favorites and else related to current topic.
                            self._setupTopicRelatedFeatures(topicData, bookName);
                        } else if (window.topic == self.options.topicHTML) {
                            console.log('Selected the same topic as current.');

                            self._view.scrollToFragment(data.href);
                        } else {
                            console.log('Something goes wrong :(');
                        }
                    }, self));

                }
            });
        },

        openPreviousTopic: function() {
            console.log('topiccontroller: openPreviousTopic');

            var prevTopic = this._siblingTopicData['prn'];

            this._fireOpenTopicEvent(prevTopic);
        },

        openParentTopic: function() {
            console.log('topiccontroller: openParentTopic');

            var parentTopic = this._parentTopicData;

            this._fireOpenTopicEvent(parentTopic);
        },

        openFollowingTopic: function() {
            console.log('topiccontroller: openFollowingTopic');

            var nextTopic = this._siblingTopicData['nxn'];

            this._fireOpenTopicEvent(nextTopic);
        },

        addOrRemoveTopicFromFavorites: function() {
            console.log('topiccontroller: addOrRemoveTopicFromFavorites');

            console.log('this._currentTopicData: ', this._currentTopicData);
            if (!this._currentTopicData) {
                return;
            }

            var attr = this._currentTopicData.attr;

            if (attr.id !== undefined) {
                console.log('topiccontroller: topicId = ', attr.id);
                var added = this.options.favoritesController.addOrRemoveFavoriteTopicId(attr.id);
                this._flagFavorites(added);
            }
        },

        highlightQuery: function(searchOptions) {
            console.log('topiccontroller: highlight');

            this.options.searchOptions = searchOptions;

            if (this._view) {
                this._view.highlight(searchOptions);
            }
        }
	});
})(jQuery);
// SIG // Begin signature block
// SIG // MIIXrwYJKoZIhvcNAQcCoIIXoDCCF5wCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFG1WBqQCP7QH
// SIG // 8u5C1kf/ih/YfVFHoIIS3zCCA+4wggNXoAMCAQICEH6T
// SIG // 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
// SIG // CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
// SIG // cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
// SIG // EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
// SIG // Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
// SIG // aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
// SIG // NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
// SIG // bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
// SIG // bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
// SIG // RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
// SIG // AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
// SIG // FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
// SIG // a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
// SIG // AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
// SIG // +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
// SIG // 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
// SIG // 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
// SIG // RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
// SIG // gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
// SIG // gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
// SIG // aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
// SIG // CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
// SIG // Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
// SIG // bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
// SIG // VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
// SIG // VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
// SIG // BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
// SIG // nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
// SIG // sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
// SIG // JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
// SIG // g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
// SIG // UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
// SIG // BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
// SIG // dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
// SIG // MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
// SIG // AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
// SIG // cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
// SIG // sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
// SIG // duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
// SIG // TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
// SIG // YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
// SIG // vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
// SIG // nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
// SIG // 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
// SIG // EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
// SIG // FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
// SIG // BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
// SIG // AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
// SIG // MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
// SIG // bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
// SIG // MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
// SIG // ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
// SIG // MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
// SIG // VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
// SIG // IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
// SIG // SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
// SIG // st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
// SIG // JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
// SIG // dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
// SIG // bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
// SIG // K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
// SIG // SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
// SIG // ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
// SIG // w7wc2AR1MIIE5TCCA82gAwIBAgIQGGKWU9W9DKB4gLDR
// SIG // /Nm99TANBgkqhkiG9w0BAQsFADB/MQswCQYDVQQGEwJV
// SIG // UzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24x
// SIG // HzAdBgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsx
// SIG // MDAuBgNVBAMTJ1N5bWFudGVjIENsYXNzIDMgU0hBMjU2
// SIG // IENvZGUgU2lnbmluZyBDQTAeFw0xNjAxMjgwMDAwMDBa
// SIG // Fw0xODA0MTAyMzU5NTlaMH0xCzAJBgNVBAYTAkNIMRIw
// SIG // EAYDVQQIEwlOZXVjaGF0ZWwxEjAQBgNVBAcTCU5ldWNo
// SIG // YXRlbDEiMCAGA1UEChQZQXV0b2Rlc2sgRGV2ZWxvcG1l
// SIG // bnQgU2FybDEiMCAGA1UEAxQZQXV0b2Rlc2sgRGV2ZWxv
// SIG // cG1lbnQgU2FybDCCASIwDQYJKoZIhvcNAQEBBQADggEP
// SIG // ADCCAQoCggEBALOBje/8PFtBHV0+YQz+EJZzXU+JAy6j
// SIG // OhMiK0n4pWQrgLdfLmoNZUvUL5AVuWoHkzK4f6WLWEjQ
// SIG // eGR4SEZcvDCJjol0n6vdsYAfRurwhekestab635tKUEy
// SIG // JRNKXhC4zuDSgryc+2zUsZa08HSHZaTsFGZzEuQAdxWf
// SIG // iyvD6G5oTu72nj3kDWWn3vqh+zyGkOIhtsIDKZyHpg71
// SIG // 7hPiqEe96bX5LpZgkSOJdAdwpl40NEUFfpNdelT2sOCh
// SIG // MfG63Dg2PR6EjOK5zHgMZm09mPgZBfyNoBV03C1ySSUi
// SIG // UsAHM2ND4wnGfl/GbYEgIVQXWlspRbtpRHTaNavebLJY
// SIG // tWECAwEAAaOCAV0wggFZMAkGA1UdEwQCMAAwDgYDVR0P
// SIG // AQH/BAQDAgeAMCsGA1UdHwQkMCIwIKAeoByGGmh0dHA6
// SIG // Ly9zdi5zeW1jYi5jb20vc3YuY3JsMGEGA1UdIARaMFgw
// SIG // VgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8v
// SIG // ZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0
// SIG // dHBzOi8vZC5zeW1jYi5jb20vcnBhMBMGA1UdJQQMMAoG
// SIG // CCsGAQUFBwMDMFcGCCsGAQUFBwEBBEswSTAfBggrBgEF
// SIG // BQcwAYYTaHR0cDovL3N2LnN5bWNkLmNvbTAmBggrBgEF
// SIG // BQcwAoYaaHR0cDovL3N2LnN5bWNiLmNvbS9zdi5jcnQw
// SIG // HwYDVR0jBBgwFoAUljtT8Hkzl699g+8uK8zKt4YecmYw
// SIG // HQYDVR0OBBYEFHqJl6/oWFvaZKJVCptH8DQRl8JIMA0G
// SIG // CSqGSIb3DQEBCwUAA4IBAQAXhA6ZwymxqqV+k4uKThLd
// SIG // PgPsvZBRcCJJZi3eYMl7HjIDbxSdx03ueVc/Sx3n9OUK
// SIG // U+DupPpLFUnKUJa/X8HPWhcvJftXom9NvGWbYPJM7CBc
// SIG // eTKuXgP5ffKwf1r9pJhok0pEhSA8b6N97pmKQwJDE6XI
// SIG // Z4M5FYw9YELKPRCHhinZCfPHLo+0GxaH+W4AbGd1N2BZ
// SIG // dX2egsgNTGBnC6xGxGMC8ckaj5wyIm4LgklE0pKbxuG9
// SIG // 075426gJ6ASAtCevNViBj9hH3TcNy4aU0ruH6By5gZaR
// SIG // 5lc7ZdaTuBWz0+4wGIK1IiviMSJv19v+h0vpEyn1b8sE
// SIG // 6L7D8JD4szHnMIIFWTCCBEGgAwIBAgIQPXjX+XZJYLJh
// SIG // ffTwHsqGKjANBgkqhkiG9w0BAQsFADCByjELMAkGA1UE
// SIG // BhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8w
// SIG // HQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTow
// SIG // OAYDVQQLEzEoYykgMjAwNiBWZXJpU2lnbiwgSW5jLiAt
// SIG // IEZvciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQD
// SIG // EzxWZXJpU2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5
// SIG // IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzUwHhcN
// SIG // MTMxMjEwMDAwMDAwWhcNMjMxMjA5MjM1OTU5WjB/MQsw
// SIG // CQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29y
// SIG // cG9yYXRpb24xHzAdBgNVBAsTFlN5bWFudGVjIFRydXN0
// SIG // IE5ldHdvcmsxMDAuBgNVBAMTJ1N5bWFudGVjIENsYXNz
// SIG // IDMgU0hBMjU2IENvZGUgU2lnbmluZyBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAJeDHgAWryyx
// SIG // 0gjE12iTUWAecfbiR7TbWE0jYmq0v1obUfejDRh3aLvY
// SIG // NqsvIVDanvPnXydOC8KXyAlwk6naXA1OpA2RoLTsFM6R
// SIG // clQuzqPbROlSGz9BPMpK5KrA6DmrU8wh0MzPf5vmwsxY
// SIG // aoIV7j02zxzFlwckjvF7vjEtPW7ctZlCn0thlV8ccO4X
// SIG // fduL5WGJeMdoG68ReBqYrsRVR1PZszLWoQ5GQMWXkorR
// SIG // U6eZW4U1V9Pqk2JhIArHMHckEU1ig7a6e2iCMe5lyt/5
// SIG // 1Y2yNdyMK29qclxghJzyDJRewFZSAEjM0/ilfd4v1xPk
// SIG // OKiE1Ua4E4bCG53qWjjdm9sCAwEAAaOCAYMwggF/MC8G
// SIG // CCsGAQUFBwEBBCMwITAfBggrBgEFBQcwAYYTaHR0cDov
// SIG // L3MyLnN5bWNiLmNvbTASBgNVHRMBAf8ECDAGAQH/AgEA
// SIG // MGwGA1UdIARlMGMwYQYLYIZIAYb4RQEHFwMwUjAmBggr
// SIG // BgEFBQcCARYaaHR0cDovL3d3dy5zeW1hdXRoLmNvbS9j
// SIG // cHMwKAYIKwYBBQUHAgIwHBoaaHR0cDovL3d3dy5zeW1h
// SIG // dXRoLmNvbS9ycGEwMAYDVR0fBCkwJzAloCOgIYYfaHR0
// SIG // cDovL3MxLnN5bWNiLmNvbS9wY2EzLWc1LmNybDAdBgNV
// SIG // HSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwMwDgYDVR0P
// SIG // AQH/BAQDAgEGMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQD
// SIG // ExFTeW1hbnRlY1BLSS0xLTU2NzAdBgNVHQ4EFgQUljtT
// SIG // 8Hkzl699g+8uK8zKt4YecmYwHwYDVR0jBBgwFoAUf9Nl
// SIG // p8Ld7LvwMAnzQzn6Aq8zMTMwDQYJKoZIhvcNAQELBQAD
// SIG // ggEBABOFGh5pqTf3oL2kr34dYVP+nYxeDKZ1HngXI939
// SIG // 7BoDVTn7cZXHZVqnjjDSRFph23Bv2iEFwi5zuknx0ZP+
// SIG // XcnNXgPgiZ4/dB7X9ziLqdbPuzUvM1ioklbRyE07guZ5
// SIG // hBb8KLCxR/Mdoj7uh9mmf6RWpT+thC4p3ny8qKqjPQQB
// SIG // 6rqTog5QIikXTIfkOhFf1qQliZsFay+0yQFMJ3sLrBkF
// SIG // IqBgFT/ayftNTI/7cmd3/SeUx7o1DohJ/o39KK9KEr0N
// SIG // s5cF3kQMFfo2KwPcwVAB8aERXRTl4r0nS1S+K4ReD6bD
// SIG // dAUK75fDiSKxH3fzvc1D1PFMqT+1i4SvZPLQFCExggQ8
// SIG // MIIEOAIBATCBkzB/MQswCQYDVQQGEwJVUzEdMBsGA1UE
// SIG // ChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAdBgNVBAsT
// SIG // FlN5bWFudGVjIFRydXN0IE5ldHdvcmsxMDAuBgNVBAMT
// SIG // J1N5bWFudGVjIENsYXNzIDMgU0hBMjU2IENvZGUgU2ln
// SIG // bmluZyBDQQIQGGKWU9W9DKB4gLDR/Nm99TAJBgUrDgMC
// SIG // GgUAoHAwEAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcN
// SIG // AQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEO
// SIG // MAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFHba
// SIG // QpVdgtJCoE8l8VF3AhAr+bLMMA0GCSqGSIb3DQEBAQUA
// SIG // BIIBAKmwT3fN/cRbdv4NFs9Hu7aN1IlwxuMD8vORhhSD
// SIG // 5yLjDfiFIuZCzBP/J9WhkcfUfi46ZgR+SjTWTb0tVyZq
// SIG // gFp1ctMuwTjT5q0AQM07vrlZBNCp3def3LZcwxolOrAh
// SIG // feKTKCpw0TVlMvwmr+n8nvagKnGuMV+M1ycQbLAMEVbR
// SIG // JTjco/Hhz2ACgNS14nx//HOSs67PDVaNR5He6Umu4fF2
// SIG // NGQD1qqaOCXvjajPFfSyyWL1LEIdUbB9w9H/tRkyMb1v
// SIG // wgviy3sxwvjbnL0lOTJhD9T8Os4Zx3SP1z5yhCpnyiIF
// SIG // 82LLYCssmhoQvU9CypI3qkqGkQc0pijKCoi7zzahggIL
// SIG // MIICBwYJKoZIhvcNAQkGMYIB+DCCAfQCAQEwcjBeMQsw
// SIG // CQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29y
// SIG // cG9yYXRpb24xMDAuBgNVBAMTJ1N5bWFudGVjIFRpbWUg
// SIG // U3RhbXBpbmcgU2VydmljZXMgQ0EgLSBHMgIQDs/0OMj+
// SIG // vzVuBNhqmBsaUDAJBgUrDgMCGgUAoF0wGAYJKoZIhvcN
// SIG // AQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUxDxcN
// SIG // MTgwMjEyMDc0MTIzWjAjBgkqhkiG9w0BCQQxFgQUWwmU
// SIG // xjR3hKMkY1Yn5ZoFBnIBZ/gwDQYJKoZIhvcNAQEBBQAE
// SIG // ggEAHgwmiMS6atfnMYtZpxEm0mPSCi1ExZja+JgdW0DS
// SIG // aGszgTG2iQY5LjF24YvokrE+0wWKuU6kiZ1kC6hE/vvi
// SIG // Wa6a/KOApbqKrB1QCKGgRUHJrkG7g+IKDS9IEeS+HU9K
// SIG // a/1trz5thPI75+qbLe6yB2DIYHdSr8vqrPCDhPhnbL4G
// SIG // UCtMpf96DGvfE47AnIK20I7ar5wb99dafsYugF5bRr80
// SIG // Hf7PL8TPuN2sYyLAF0ecZPHMeZpzSt8223lzBbkkS19A
// SIG // nKGJ6/xd/DrHeQGPqGWaR7z9WUPvkMPD/aeFOYqVBVL5
// SIG // Pai4oOb5N6rXOATK4FsDN2xVu33xouXrz+35bA==
// SIG // End signature block
