// Next available MSG number is   494
// MODULE_ID ACAD_DCL_
//
//
//  acad.dcl - AutoCAD dialogs
//
//////////////////////////////////////////////////////////////////////////////
//
//  Copyright 2018 Autodesk, Inc.  All rights reserved.
//
//  Use of this software is subject to the terms of the Autodesk license 
//  agreement provided at the time of installation or download, or which 
//  otherwise accompanies this software in either electronic or hard copy form.   
//
//////////////////////////////////////////////////////////////////////////////
//

//  This file should not be modified when used with AutoCAD.
//  Modification to the dialog definitions can have serious adverse
//  effects on the use of the product.  Since no modifications to this
//  file are allowed, there should be no need for any internal error
//  checking on the contents of this file, hence we disable audit
//  checks by default.

acad_snap : dialog {
        label = "ͼ";
        : row {
            : column {
                : boxed_column {
                    label = "ģʽ";
                    : toggle {
                        label = "(&O)";
                        key = "ortho";
                    }
                    : toggle {
                        label = "ʵ(&F)";
                        key = "fill";
                    }
                    : toggle {
                        label = "(&Q)";
                        key = "qtext";
                    }
                    : toggle {
                        label = "(&B)";
                        key = "blips";
                    }
                    : toggle {
                        label = "(&G)";
                        key = "hilite";
                    }
                    : toggle {
                        label = "(&U)";
                        key = "group";
                    }
                    : toggle {
                        label = "ͼ(&C)";
                        key = "hatch";
                    }

                }
            }
            : boxed_column {
                label = "׽(&S)";
                : toggle {
                    label = "";
                    key = "snap";
                }
                : edit12_box {
                    label = "X (&X)";
                    key = "s_xsp";
                    errmsg = "׽ X ";
                }
                : edit12_box {
                    label = "Y (&Y)";
                    key = "s_ysp";
                    errmsg = "׽ Y ";
                }
                : edit12_box {
                    label = "׽Ƕ(&N)";
                    key = "s_ang";
                    errmsg = "׽Ƕ";
                }
                : edit12_box {
                    label = "X (&A)";
                    key = "xbase";
                    errmsg = "׽ X ";
                }
                : edit12_box {
                    label = "Y (&E)";
                    key = "ybase";
                    errmsg = "׽ Y ";
                }
            }
            : column {
                : boxed_column {
                    label = "դ(&D)";
                    fixed_height = true;
                    : toggle {
                        label = "";
                        key = "grid";
                    }
                    : edit12_box {
                        label = "X (&P)";
                        key = "g_xsp";
                        errmsg = "դ X ";
                    }
                    : edit12_box {
                        label = "Y (&I)";
                        key = "g_ysp";
                        errmsg = "դ Y ";
                    }
                }
                : boxed_column {
                    label = "Ⲷ׽/դ(&M)";
                    : toggle {
                        label = "";
                        key = "iso";
                    }
                    : radio_row {
                        key = "isorad";
                        : radio_button {
                            label = "(&L)";
                            key = "ileft";
                        }
                        : radio_button {
                            label = "(&T)";
                            key = "itop";
                        }
                        : radio_button {
                            label = "(&R)";
                            key = "iright";
                        }
                    }
                }
            }
       }
       ok_cancel_help_errtile;
}

rq_chroma :dialog {
    label = "ѡɫ";
    key = "chroma";                   // used by Help button to obtain label
    std_rq_color;
}

lt_text: text {
    width = 25;
}

lt_image: image_button {
    height = 1;
    width = 15;
    allow_accept = true;
}

acad_tstyle : dialog {
    label = "ѡʽ";
    : row {
        : column {
            : list_box {
                key = "style_list";
                width = 16;
                height = 8;
                allow_accept = true;
            }
            : button {
                label = "ȫʾ(&A)...";
                key = "showall";
            }
        }
        : column {
            : image {
                key = "style_image";
                height = 7;
                width = 20;
            }
            : edit_box {
                key = "style_sample";
                label = "(&S):";
                edit_width = 6;
                fixed_width = true;
                alignment = centered;
            }
        }
    }
    spacer;
    : edit_box {
        key = "style_edit";
        label = "ʽ(&N):";
        edit_width = 31;
        edit_limit = 217;
        fixed_width = true;
        allow_accept = true;
    }
    : row {
        : paragraph {
            : text_part {
                label = ":";
            }
            : text_part {
                label = "߶:";
            }
            : text_part {
                label = ":";
            }
            : text_part {
                label = "б:";
            }
            : text_part {
                label = ":";
            }
        }
        : paragraph {
            : text_part {
                key = "font";
                width = 32;
            }
            : text_part {
                key = "height";
                width = 32;
            }
            : text_part {
                key = "width";
                width = 32;
            }
            : text_part {
                key = "oblique";
                width = 32;
            }
            : text_part {
                key = "gen";
                width = 32;
            }
        }
    }
    ok_cancel_err;
}

acad_tstyle_sym : dialog {
    key = "acad_tstyle_sym";
    label = "ż";
    : text {
        key = "page";
        width = 10;
    }
    : image {
        key = "showall";
        color = graphics_background;
        height = 16;
        width = 70;
    }
    : row {
        : ok_button {
            is_cancel = true;
        }
        : button {
            label = "һ(&P)";
            key = "pagedown";
            width = 10;
        }
        : button {
            label = "һ(&N)";
            key = "pageup";
            width = 10;
        }
    }
}

acad_icon: dialog {
        key = "label";
        initial_focus               = "listbox";
        : row {
            : list_box {
                width               = 20;
                height              = 21;
                fixed_height        = true;
                key                 = "listbox";
                allow_accept        = true;
            }
            : column {
                : row {
                    : icon_image {
                        key         = "icon1";
                    }
                    : icon_image {
                        key         = "icon2";
                    }
                    : icon_image {
                        key         = "icon3";
                    }
                    : icon_image {
                        key         = "icon4";
                    }
                }
                : row {
                    : icon_image {
                        key         = "icon5";
                    }
                    : icon_image {
                        key         = "icon6";
                    }
                    : icon_image {
                        key         = "icon7";
                    }
                    : icon_image {
                        key         = "icon8";
                    }
                }
                : row {
                    : icon_image {
                        key         = "icon9";
                    }
                    : icon_image {
                        key         = "icon10";
                    }
                    : icon_image {
                        key         = "icon11";
                    }
                    : icon_image {
                        key         = "icon12";
                    }
                }
                : row {
                    : icon_image {
                        key         = "icon13";
                    }
                    : icon_image {
                        key         = "icon14";
                    }
                    : icon_image {
                        key         = "icon15";
                    }
                    : icon_image {
                        key         = "icon16";
                    }
                }
                : row {
                    : icon_image {
                        key         = "icon17";
                    }
                    : icon_image {
                        key         = "icon18";
                    }
                    : icon_image {
                        key         = "icon19";
                    }
                    : icon_image {
                        key         = "icon20";
                    }
                }
/*
 *              : row {
 *                  : icon_image {
 *                      key         = "icon21";
 *                  }
 *                  : icon_image {
 *                      key         = "icon22";
 *                  }
 *                  : icon_image {
 *                      key         = "icon23";
 *                  }
 *                  : icon_image {
 *                      key         = "icon24";
 *                  }
 *              }
 */
            }
        }
        : row {
            : row {
                spacer_0;
                : row {
                    fixed_width = true;
                    : button {
                        label = "һ(&P)";
                        key = "prev";
                        width = 8;
                    }
                    :spacer {
                        width = 2;
                    }
                    :button {
                        label = "  һ(&N)  ";
                        key = "next";
                        width = 8;
                    }
                }
                spacer_0;
            }
            spacer;
            ok_cancel;
        }
}

acad_mtprop_edit_box : edit_box {
    edit_width = 20;
    edit_limit = 30;
}

acad_mtprop_popup_list : popup_list {
    edit_width = 24;
}

acad_mtprop : dialog {
    label = "";
    :boxed_column {
        label = "";
        :acad_mtprop_popup_list {
            label = "ʽ(&S):";
            key = "sty";
        }
        :acad_mtprop_edit_box {
            label = "ָ߶(&G):";
            key = "hgt";
        }
        :acad_mtprop_popup_list {
            label = "(&D):";
            list = "\nϵ";
            key = "dir";
        }
    }
    :boxed_column {
        label = "";
        :acad_mtprop_popup_list {
            label = "(&A):";
            list = "\n\n\n\n\n\n\n\n";
            key = "att";
        }
        :acad_mtprop_edit_box {
            label = "(&W):";
            key = "wid";
        }
        :acad_mtprop_edit_box {
            label = "ת(&R):";
            key = "rot";
        }
    }
    ok_cancel_help_errtile;
}

acad_plan6 : dialog {
    label = "UCS";
    : concatenation {
        : text_part {
            label = ": ";
        }
        : text_part {
            label = "**";
            key = "name";
            width = 40;
        }
    }
    : row {
        : boxed_column {
            label = "ԭ";
            : concatenation {
                : text_part {
                    label = "X=";
                }
                : text_part {
                    key = "00";
                    width = 12;
                }
            }
            : concatenation {
                : text_part {
                    label = "Y=";
                }
                : text_part {
                    key = "10";
                    width = 12;
                }
            }
            : concatenation {
                : text_part {
                    label = "Z=";
                }
                : text_part {
                    key = "20";
                    width = 12;
                }
            }
        }
        : boxed_column {
            label = "X ";
            : concatenation {
                : text_part {
                    label = "X=";
                }
                : text_part {
                    key = "01";
                    width = 12;
                }
            }
            : concatenation {
                : text_part {
                    label = "Y=";
                }
                : text_part {
                    key = "11";
                    width = 12;
                }
            }
            : concatenation {
                : text_part {
                    label = "Z=";
                }
                : text_part {
                    key = "21";
                    width = 12;
                }
            }
        }
        : boxed_column {
            label = "Y ";
            : concatenation {
                : text_part {
                    label = "X=";
                }
                : text_part {
                    key = "02";
                    width = 12;
                }
            }
            : concatenation {
                : text_part {
                    label = "Y=";
                }
                : text_part {
                    key = "12";
                    width = 12;
                }
            }
            : concatenation {
                : text_part {
                    label = "Z=";
                }
                : text_part {
                    key = "22";
                    width = 12;
                }
            }
        }
        : boxed_column {
            label = "Z ";
            : concatenation {
                : text_part {
                    label = "X=";
                }
                : text_part {
                    key = "03";
                    width = 12;
                }
            }
            : concatenation {
                : text_part {
                    label = "Y=";
                }
                : text_part {
                    key = "13";
                    width = 12;
                }
            }
            : concatenation {
                : text_part {
                    label = "Z=";
                }
                : text_part {
                    key = "23";
                    width = 12;
                }
            }
        }
    }
    : ok_button {
        is_cancel = true;
    }
}

acad_plan : dialog {
    label = "UCS ";
    initial_focus = "listbox";
    spacer;
    : list_box {
        label = "UCS (&U)";
        tabs = "34";
        key = "listbox";
        width = 44;
        tab_truncate = true;
    }
    : row {
        : button {
            label = "ǰ(&C)";
            key = "cur";
        }
        : button {
            label = "ɾ(&D)";
            key = "delete";
        }
        : button {
            label = "б(&L)...";
            key = "list";
        }
    }
    : row {
        : button {
            label = "Ϊ(&R):";
            key = "rename";
            fixed_width = true;
        }
        : edit_box {
            key = "rename_edit_box";
            edit_width = 28;
            edit_limit = 217;
        }
    }
    ok_cancel_help_errtile;
}

acad_txtedit : dialog {
    label = "༭";
    initial_focus = "text_edit";
    : edit_box {
        label = ":";
        key = "text_edit";
        edit_width = 40;
        edit_limit = 2048;
        allow_accept = true;
    }
    ok_cancel;
}

acad_attedit : dialog {
    label = "༭Զ";
    initial_focus = "tag_edit";
    : edit_box {
        key = "tag_edit";
        label = "ǩ:";
        edit_width = 40;
        edit_limit = 2048;
    }
    : edit_box {
        key = "prompt_edit";
        label = "ʾ:";
        edit_width = 40;
        edit_limit = 2048;
    }
    : edit_box {
        key = "default_edit";
        label = "Ĭ:";
        edit_width = 40;
        edit_limit = 2048;
    }
    ok_cancel;
    : errtile { width = 45; }
}

acad_dlfname : dialog {               // Single-file dialog
    initial_focus = "fedit";
    key = "dlfname";
    files_topdf;
    : row {
        : list_box {
            label = "Ŀ¼(&R):";
            key = "dirbox";
            width = 15;
        }
        : list_box {
            label = "ļ(&I):";
            key = "filebox";
            width = 15;
            allow_accept = true;
        }
        : column {
            : image {          // Drawing icon image will go here
                key = "icon";
                color = dialog_background;    // Invisible
                height = 4;
                aspect_ratio = 1.4;
                fixed_height = true;
                fixed_width = true;
            }
            : button {
                label = "(&T)";
                key = "typeit";
            }
            : button {
                label = "Ĭ(&D)";
                key = "default";
            }
        }
    }
    files_bottomdf;
}

//  acad_dlfmulti is used by the FILES command's Delete and Unlock
//  options.  It is similar to acad_dlfname (above), except that:
//
//    - its file listbox has the "multiple_select" attribute,
//    - its file listbox does not have the "allow_accept" attribute,
//    - it has additional "Select all" and "Clear all" buttons, and
//    - its title bar label is slightly different.
//
//  Modifications to either dialog should be examined for their relevance
//  to the other.

acad_dlfmulti : dialog {              // Multiple-file dialog
    initial_focus = "fedit";
    key = "dlfname";
    files_topdf;
    : row {
        : list_box {
            label = "Ŀ¼(&R):";
            key = "dirbox";
            width = 15;
        }
        : list_box {
            label = "ļ(&I):";
            key = "filebox";
            width = 15;
            multiple_select = true;
        }
        : column {
            : image {          // Drawing icon image will go here
                key = "icon";
                color = dialog_background;    // Invisible
                alignment = centered;
                height = 4;
                aspect_ratio = 1.4;
                fixed_height = true;
                fixed_width = true;
            }
            spacer_1;
            : button {
                label = "ȫѡ(&S)";
                key = "all";
            }
            : button {
                label = "ȫ(&C)";
                key = "clear";
                is_enabled = false;
            }
            spacer_1;
            : button {
                label = "(&T)";
                key = "typeit";
            }
            : button {
                label = "Ĭ(&E)";
                key = "default";
            }
        }
    }
    files_bottomdf;
}

acad_files : dialog {
    label = "ļʵù";
    initial_focus = "exit";
    : row {
        : column {
            : button {
                label = "ļб(&L)... ";
                key = "list";
            }
            : button {
                label = "ɾļ(&D)...";
                key = "delete";
            }
        }
        : column {
            : button {
                label = " ļ(&C)... ";
                key = "copy";
            }
            : button {
                label = "ļ(&U)...";
                key = "unlock";
            }
        }
        : column {
            : button {
                label = "ļ(&R)...";
                key = "rename";
            }
            : help_button {
                fixed_width = false;
            }
        }
    }
    errtile;
    : button {
        label = "     ˳(&X)     ";
        key = "cancel";
        fixed_width = true;
        alignment = centered;
        is_cancel = true;
        is_default = true;
    }
}

acad_info : dialog {
    label = "Ϣ";    // Overridden by caller
    key = "acad_info";
    : row {
        : image {
            key = "logo";
            width = 8;
            aspect_ratio = 1.0;
            fixed_height = true;
            alignment = top;
            color = dialog_background;
        }
        : paragraph {
            : text_part {
                key = "text1";
                width = 63;
            }
            : text_part {
                key = "text2";
                width = 63;
            }
            : text_part {
                key = "text3";
                width = 63;
            }
            : text_part {
                key = "text4";
                width = 63;
            }
            : text_part {
                key = "text5";
                width = 63;
            }
            : text_part {
                key = "text6";
                width = 63;
            }
            : text_part {
                key = "text7";
                width = 63;
            }
            : text_part {
                key = "text8";
                width = 63;
            }
            : text_part {
                key = "text9";
                width = 63;
            }
            : text_part {
                key = "text10";
                width = 63;
            }
        }
    }
    spacer;
    : list_box {
        width = 63;
        key = "listbox";
    }
    : ok_button {                     // Permit exit via either ENTER
        is_cancel = true;             //   or CTRL-C.
    }
}

init_view : dialog {

    key = "title";
    initial_focus = "listbox";
    : list_box {
        tabs = "33";
        width = 40;
        key = "listbox";
        allow_accept = true;
    }
    ok_cancel_err;
}




acad_plot : dialog {
    label = "ӡ";
    : row {
        : column {
            : boxed_column {
                label = "豸ĬϢ";
                : text {
                    key = "userid";
                    width = 35;
                }
                : button {
                    label = "豸Ĭѡ(&D)...";
                    fixed_width = true;
                    key = "devsel";
                    alignment = centered;
                }
            }
            : boxed_row {
                label = "ʲ";
                children_fixed_width = true;
                : button {
                    label = "ָ(&P)...";
                    key = "assign";
                }
                : button {
                    label = "Ż(&O)...";
                    key = "optimize";
                }
            }
            : boxed_column {
                label = "";
                : row {
                    : radio_column {
                        fixed_width = true;
                        : radio_button {
                            label = "ʾ(&Y)";
                            key = "D";
                        }
                        : radio_button {
                            label = "ͼηΧ(&X)";
                            key = "E";
                        }
                        : radio_button {
                            label = "ͼν(&L)";
                            key = "L";
                        }
                        : radio_button {
                            label = "ͼ(&V)";
                            key = "V";
                        }
                        : radio_button {
                            label = "(&W)";
                            key = "W";
                        }
                    }
                    : column {
                        : edit12_box {
                            label = "ֱַ";
                            key = "textreso";
                            errmsg = "Text Resolution";
                        }
                        : toggle {
                            label = "";
                            key = "textfill";
                        }
                        : toggle {
                            label = "(&-)";
                            key = "hide";
                        }
                        : toggle {
                            label = "(&J)";
                            key = "plfill";
                        }
                        : toggle {
                            label = "ӡļ(&F)";
                            key = "file";
                        }
                        : toggle {
                            label = "Auto&spool";
                            key = "aspool";
                        }
                    }
                }
                : row {
                    alignment = centered;
                    : button {
                        label = "ͼ(&E)...";
                        key = "view";
                        fixed_width = true;
                    }
                    : button {
                        label = "(&N)...";
                        key = "selwind";
                        fixed_width = true;
                    }
                    : button {
                        label = "ļ(&A)...";
                        key = "sfile";
                        fixed_width = true;
                    }
                }
            }
        }
        : column {
                : boxed_column {
                    label = "ͼֽߴͷ";
                    : row {
                        : radio_column {
                            fixed_width = true;
                            : radio_button {
                                label = "Ӣ(&C)";
                                key = "I";
                            }
                            : radio_button {
                                label = "(&M)";
                                key = "M";
                            }
                        }
                        : row {
                            fixed_width = true;
                            : button {
                                label = "ߴ(&Z)...";
                                key = "sizbuttn";
                                fixed_width = true;
                            }
                            : text {
                                key = "size";
                                width = 6;
                            }
                            : column {
                                spacer;
                                : image {
                                    key = "vec_image";
                                    width = 4.0;
                                    fixed_width = true;
                                    aspect_ratio = 1.0;
                                    color = dialog_background;
                                }
                                spacer;
                            }
                        }
                    }
                    : text {
                        key = "area";
                        width = 25;
                    }
                }
                : boxed_column {
                    label = "תԭ";
                    : button {
                        label = "תԭ(&G)...";
                        key = "rot&or";
                        alignment = centered;
                        fixed_width = true;
                    }
                    : row {
                        : column {
                            children_fixed_width = true;
                            : text {
                                key = "pu";
                                width = 14;
                                alignment = right;
                            }
                            : edit_box {
                                edit_width = 10;
                                key = "punit";
                                alignment = centered;
                            }
                        }
                        : column {
                            children_fixed_width = true;
                            children_alignment = centered;
                            : text {
                                label = "=";
                            }
                            : text {
                                label = "=";
                            }
                        }
                        : column {
                            children_fixed_width = true;
                            : text {
                                label = "ͼελ";
                            }
                            : edit_box {
                                edit_width = 10;
                                key = "dunit";
                                alignment = centered;
                            }
                        }
                    }
                    : toggle {
                        label = "ŵ(&T)";
                        key = "fit";
                    }
                }
                : boxed_column {
                    label = "ӡԤ";
                    : row {
                        children_fixed_width = true;
                        : button {
                            label = "Ԥ(&R)...";
                            key = "prev";
                        }
                        : radio_row {
                            : radio_button {
                                label = "(&I)";
                                key = "earea";
                            }
                            : radio_button {
                                label = "ȫ(&U)";
                                key = "full";
                            }
                        }
                    }
                }
        }
    }
    ok_cancel_help;
    : row {
        : errtile { fixed_width = true; }

        // This spacer_0 between the two fixed-width items serves
        // to left-justify the first and right-justify the second,
        // since it's the only flexible-width item in the row.
        spacer_0;

        : row {
            fixed_width = true;
            : text {
                key = "zero";
                width = 3;
            }
            : image {
                key = "pre_image";
                color = dialog_background;
                height = 1;
                width = 18;
            }
            : text {
                key = "comp";
                width = 5;
            }
        }
    }
}

acad_plwin : dialog {
    label = "ѡ";
        : button {
            label = "ʰȡ(&P) <";
            key = "pick";
            fixed_width = true;
        }
            : boxed_row {
                label = "һǵ(&F)";
                : edit_box {
                    label = "   X:";
                    key = "fpx";
                    edit_width = 10;
                }
                : edit_box {
                    label = "   Y:";
                    key = "fpy";
                    edit_width = 10;
                }
            }
            : boxed_row {
                label = "һǵ(&O)";
                : edit_box {
                    label = "   X:";
                    key = "spx";
                    edit_width = 10;
                }
                : edit_box {
                    label = "   Y:";
                    key = "spy";
                    edit_width = 10;
                }
            }
        ok_cancel_err;
}

acad_plopt : dialog {
    aspect_ratio = 0;
    label = "˱Ż";
    : column {
        : toggle {
            label = "Ż(&N)";
            key = "0";
        }
        : toggle {
            label = "Ӷ˵㽻(&E)";
            key = "1";
        }
        : toggle {
            label = "ӻ(&P)";
            key = "2";
        }
        : toggle {
            label = "˱Ż(&L)";
            key = "3";
        }
        : toggle {
            label = "ȫ˱Ż(&F)";
            key = "4";
        }
        : toggle {
            label = "ˮƽֱصʸ(&A)";
            key = "5";
        }
        : toggle {
            label = "صԽʸ(&D)";
            key = "6";
        }
    }
    ok_cancel;
}

acad_plsize : dialog {
    label = "ͼֽߴ";
    : row {
        : column {
            : concatenation {
                : text_part {
                    label = "ߴ(&S)";
                    width = 8;
                }
                : text_part {
                    label = "";
                    width = 9;
                }
                : text_part {
                    label = "߶";
                }
            }
            : list_box {
                key = "listbox";
                tabs = "0 8 17";
                width = 28;
                height = 13;
            }
        }
        spacer_1;
        : column {
            : row {
                : text_part {
                    label = "ߴ";
                    width = 8;
                }
                : text_part {
                    label = "";
                    width = 11;
                }
                : text_part {
                    label = "߶";
                }
            }
            spacer_0;
            : row {
                : text_part {
                    label = "û(&U):";
                    width = 8;
                }
                : edit_box {
                    key = "0w";
                    edit_width = 10;
                }
                : edit_box {
                    key = "0h";
                    label = " ";
                    edit_width = 10;
                }
            }
            : row {
                : text_part {
                    label = "û1(&1):";
                    width = 8;
                }
                : edit_box {
                    key = "1w";
                    edit_width = 10;
                }
                : edit_box {
                    key = "1h";
                    label = " ";
                    edit_width = 10;
                }
            }
            : row {
                : text_part {
                    label = "û2(&2):";
                    width = 8;
                }
                : edit_box {
                    key = "2w";
                    edit_width = 10;
                }
                : edit_box {
                    label = " ";
                    key = "2h";
                    edit_width = 10;
                }
            }
            : row {
                : text_part {
                    label = "û3(&3):";
                    width = 8;
                }
                : edit_box {
                    key = "3w";
                    edit_width = 10;
                }
                : edit_box {
                    label = " ";
                    key = "3h";
                    edit_width = 10;
                }
            }
            : row {
                : text_part {
                    label = "û4(&4):";
                    width = 8;
                }
                : edit_box {
                    key = "4w";
                    edit_width = 10;
                }
                : edit_box {
                    label = " ";
                    key = "4h";
                    edit_width = 10;
                }
            }
            : row {
                : column {
                    spacer_1;
                    : row {
                        alignment = left;
                        : text_part {
                            label = "Ϊ";
                            fixed_width = true;
                        }
                        : text_part {
                            key = "land";
                            width = 12;
                        }
                    }
                    spacer;
                }
                : column {
                    spacer;
                    : image {
                        key = "vec_image";
                        width = 4.0;
                        fixed_width = true;
                        aspect_ratio = 1.0;
                        color = dialog_background;
                    }
                    spacer;
                }
            }
        }
    }
    ok_cancel_err;
}

acad_plpen : dialog {
    label = "ָ";
    : column {
        : row {
            : paragraph {
                : concatenation {
                    : text_part {
                        label = "ɫ     ʺ";
                        key = "1";
                        width = 20;
                    }
                    : text_part {
                        label = "";
                        key = "2";
                        width = 11;
                    }
                    : text_part {
                        label = "ٶ";
                        key = "3";
                        width = 7;
                    }
                    : text_part {
                        label = "ʿ";
                        key = "4";
                    }
                }
                : list_box {
                    key = "listbox";
                    tabs = "2 11 22 32 38";
                    width = 50;
                    multiple_select = true;
                }
            }
            : boxed_column {
                label = "޸ֵ";
                : row {
                    : text_part {
                        label = "ɫ:";
                        width = 7;
                        fixed_width = true;
                    }
                    : image {
                        key = "color_image";
                        width = 4.0;
                        height = 0.5;
                    }
                }
                : text {
                    width = 13;
                    key = "varies";
                }
                : row {
                    : text_part {
                        label = "(&P):";
                        width = 7;
                        fixed_width = true;
                    }
                    : edit_box {
                        key = "penno";
                        edit_width = 8;
                    }
                }
                : row {
                    : text_part {
                        label = "(&L):";
                        width = 7;
                        fixed_width = true;
                    }
                    : edit_box {
                        key = "ltype";
                        edit_width = 8;
                    }
                }
                : row {
                    : text_part {
                        label = "ٶ(&S):";
                        width = 7;
                        fixed_width = true;
                    }
                    : edit_box {
                        key = "speed";
                        edit_width = 8;
                    }
                }
                : row {
                    : text_part {
                        label = "(&W):";
                        width = 7;
                        fixed_width = true;
                    }
                    : edit_box {
                        key = "width";
                        edit_width = 8;
                    }
                }
            }
        }
        : row {
            : button {
                label = "ͼ(&F)...";
                key = "legend";
                fixed_width = true;
            }
            : spacer { width = 2; }
            : edit_box {
                label = "ʿ(&E):";
                key = "lpwidth";
                edit_width = 8;
                fixed_width = true;
            }
        }
    }
    ok_cancel_err;
}

acad_plpre : dialog {
    label = "ԤЧӡ";
        : image {
            key = "pimage";
            height = 11.25;
            width = 25;
            fixed_width = true;
            fixed_height = true;
            alignment = centered;
        }
        : row {
            : image {
                key = "cpaper";
                width = 2.0;
                color = red;
                height = 0.1;
                fixed_width = true;
                fixed_height = true;
            }
            : text {
                key = "paper";
                width = 50;
            }
        }
        : row {
            : image {
                key = "earea";
                width = 2.0;
                color = blue;
                height = 0.1;
                fixed_width = true;
                fixed_height = true;
            }
            : text {
                key = "area";
                width = 50;
            }
        }
        : row {
            : image {
                key = "clip";
                width = 2.0;
                height = 0.1;
                fixed_width = true;
                fixed_height = true;
            }
            : text {
                key = "cliptxt";
                width = 50;
            }
        }
        : text {
            width = 50;
            key = "warn";
        }
        : list_box {
            height = 3;
            key = "listbox";
        }
    ok_only;
}

acad_plok : dialog {
   label = "ӡԤ";
   : column {
       width = 15;
       : button {
           label = "ƽƺ(&P)";
           key = "zoomd";
       }
       : button {
           key = "accept";
           label = "Ԥ(&E)";
           is_cancel = true;
       }
   }
}

acad_plokcan : dialog {
    label = "ӡԤ";
    : column {
        width = 15;
        : button {
            label = "ŵһ(&Z)";
            key = "zoomd";
        }
        : button {
            key = "accept";
            label = "Ԥ(&E)";
            is_cancel = true;
        }
    }
}

acad_devdesc : dialog {
    label = "豸";
    : column {
        : text {
            label = "AutoCAD Ҫṩ豸˵Աûҡ";
        }
        : edit_box {
            edit_limit = 80;
            label = "˵:";
            key = "desc";
        }
    }
    ok_cancel;
}

acad_devinf : dialog {
    label = "豸Ĭѡ";
    : boxed_column {
                label = "ѡ豸";
                : list_box {
                        key = "listbox";
                        width = 60;
                        height = 6;
                        tabs = "36";
                }
                : concatenation {
                        : text_part {
                        label = ": ";
                        fixed_width = true;
                        width = 14;
                        }
                        : text_part {
                        key = "device";
                        width = 50;
                        }
                }
                : concatenation {
                        : text_part {
                        label = "˿: ";
                        width = 6;
                        }
                        : text_part {
                        key = "port";
                        width = 50;
                        }
                }
    }
    : boxed_row {
                label = "ļ";
            : column {
                    : text {
                            label = "ȫ (PC2)";
                alignment = centered;
                    }
            : row {
                        : button {
                                label = "(&A)...";
                                key = "savepc2";
                        }
                        : button {
                                label = "滻(&R)...";
                                key = "loadpc2";
                        }
            }
            }
        spacer_0;
        : column {
                    : text {
                            label = " (PCP - R12/R13)";
                alignment = centered;
                    }
            : row {
                        : button {
                                label = "(&S)...";
                                key = "sfile";
                        }
                        : button {
                                label = "ϲ(&M)...";
                                key = "ffile";
                        }
            }
        }
    }
    : boxed_row {
                label = "豸ض";
                : text_part {
                        label = "豸: ";
                        width = 35;
                }
                : button {
                        label = "ʾ(&O)...";
                        key = "showreq";
                        is_enabled = false;
                }
                : button {
                        label = "޸(&C)...";
                        key = "cfgreq";
                        is_enabled = false;
                }
    }
    ok_cancel_help_errtile;
}

acad_plferr : dialog {
    label = "ĬļдϢ";
    : list_box {
        width = 62;
        height = 8;
        key = "listbox";
    }
    : row {
        spacer_0;
        : row {
            fixed_width = true;
            : button {
                key = "save";
                label = "ļ(&C)";
            }
            : spacer {
                width = 2;
            }
            ok_only;
        }
        spacer_0;
    }
    errtile;
}

acad_rotor : dialog {
    label = "ӡתԭ";
    : boxed_radio_row {
        label = "ӡת";
        : radio_button {
            label = "&0";
            key = "0";
        }
        : radio_button {
            label = "&90";
            key = "90";
        }
        : radio_button {
            label = "&180";
            key = "180";
        }
        : radio_button {
            label = "&270";
            key = "270";
        }
    }
    : boxed_row {
        label = "ӡԭ";
        : edit_box {
            label = "X ԭ(&X):";
            key = "originx";
            edit_width = 10;
        }
        : edit_box {
            label = "Y ԭ(&Y):";
            key = "originy";
            edit_width = 10;
        }
    }
    spacer;
    ok_cancel_err;
}


acad_dwgmod : dialog {
   label = "ͼ޸";
   initial_focus = "save";
   : column {
       : text {
           label = "ǰͼѱ޸ġ";
           alignment = centered;
       }
       : row {
           : button {
               label = "޸(&S)...";
               is_default = true;
               key = "save";
           }
           : button {
               label = "޸(&D)";
               key = "discard";
           }
           : button {
               label = "ȡ(&C)";
               is_cancel = true;
               key = "cancel";
           }
       }
   }
}

acad_newdwg : dialog {
    label = "ͼ";
    initial_focus = "fedit";
    : boxed_column {
        : row {
            : button {
                label = "ԭ(&P)...";
                key = "template";
            }
            : edit32_box {
                key = "protype";
            }
        }
        : column {
            : toggle {
                label = "ԭ(&N)";
                key = "dflts";
                value = "0";
            }
            : toggle {
                label = "ΪĬ(&R)";
                key = "retain";
                value = "0";
            }
        }
    }
    spacer_1;
    : column {
        : row {
            : button {
                label = "ͼ(&D)...";
                key = "fdialog";
            }
            : edit32_box {
                key = "fedit";
                allow_accept = true;
            }
        }
    }
    ok_cancel_err;
}

// acad_opendwg is used by the OPEN command and is the same as
// acad_dlfname except it has additional toggles:
//          Select Initial View and Read Only Mode
// and the title is fixed in the definition.

acad_opendwg : dialog {
    label = "ͼ";
    initial_focus = "fedit";
    files_topdf;
    : row {
        : list_box {
            label = "Ŀ¼(&R):";
            key = "dirbox";
            width = 15;
        }
        : list_box {
            label = "ļ(&I):";
            key = "filebox";
            width = 15;
            allow_accept = true;
        }
        : column {
            : image {          // Drawing icon image will go here
                key = "icon";
                color = dialog_background;    // Invisible
                height = 6;
                aspect_ratio = 1.4;
                fixed_height = true;
                fixed_width = true;
            }
            : button {
                label = "(&T)";
                key = "typeit";
            }
            : button {
                label = "Ĭ(&D)";
                key = "default";
            }
        }
    }
    : row {
        : toggle {
            label = "ѡʼͼ(&S)";
            key = "vselect";
            value = "0";
        }
        : toggle  {
            label = "ֻģʽ(&O)";
            key = "read";
            value = "0";
        }
    }
    files_bottomdf;
}

acad_reinit : dialog {
    label = "³ʼ";
    : boxed_column {
        label = "I/O ˿ڳʼ";
        : row {
            : toggle {
                label = "ֻ(&D)";
                key = "1";
                value = "0";
            }
        }
    }
    : boxed_column {
        label = "豸ļʼ";
        : toggle {
            label = "ֻ(&G)";
            key = "g";
            value = "0";
        }
        : toggle {
            label = "PGP ļ(&F)";
            key = "p";
            value = "0";
        }
    }
    ok_cancel_help;
}

acad_wait : dialog {
   key = "title";
   initial_focus = "accept";
   width = 25;
   spacer;
   : column {
       fixed_width = true;
       fixed_height = true;
       alignment = centered;
       : button {
           key = "accept";
           label = "(&C)";
           is_cancel = true;
       }
    }
    spacer;
}

fh_open : dialog {
    label = "߽綨";
    initial_focus = "accept";
    width = 30;
    spacer;
    : column {
        fixed_height = true;
        alignment = centered;
        : text {
            alignment = centered;
            label = "߽粻պϡ";
        }
    }
    spacer_1;
    ok_look;
    spacer;
}


fh_outside : dialog {
    aspect_ratio = 0;
    label = "߽綨";
    initial_focus = "accept";
    width = 30;
    spacer;
    : column {
        fixed_height = true;
        alignment = centered;
        : text {
            alignment = centered;
            label = "ڱ߽⡣";
        }
    }
    spacer_1;
    ok_look;
    spacer;
}


fh_on : dialog {
    aspect_ratio = 0;
    label = "߽綨";
    initial_focus = "accept";
    width = 30;
    spacer;
    : column {
        fixed_height = true;
        alignment = centered;
        : text {
            alignment = centered;
            label = "ֱڶϡ";
        }
    }
    spacer_1;
    ok_look;
    spacer;
}


fh_dup : dialog {
    aspect_ratio = 0;
    label = "߽綨";
    initial_focus = "accept";
    width = 30;
    spacer;
    : column {
        fixed_height = true;
        alignment = centered;
        : text {
            alignment = centered;
            label = "б߽ظ";
        }
    }
    spacer_1;
    ok_only;
    spacer;
}


fh_nohatch : dialog {
    aspect_ratio = 0;
    label = "ͼ";
    width = 30;
    spacer;
    : column {
        fixed_height = true;
        alignment = centered;
        : text {
            alignment = centered;
            label = "δͼ";
        }
    }
    spacer_1;
    ok_only;
    spacer;
}


fh_toodense : dialog {
    aspect_ratio = 0;
    label = "ͼ";
    width = 30;
    spacer;
    : column {
        fixed_height = true;
        alignment = centered;
        : text {
            alignment = centered;
            label = "ͼ̫ܣ߳ߴ̫С";
        }
    }
    spacer_1;
    ok_only;
    spacer;
}


falert : dialog {
    label = "";
    spacer;
    : text {
        key = "alert_text_1";
        horizontal_alignment = centered;
        width = 50;
    }
    : text {
        key = "alert_text_2";
        horizontal_alignment = centered;
        width = 50;
    }
    spacer_1;
    ok_only;
    spacer;
}

big_button :button{
    fixed_width = true;
    width = 25;
}


look_button : retirement_button {
    label           = "鿴(&L)";
    key             = "look";
    vertical_alignment = centered;
}


ok_look : column {
    : row {
        fixed_width = true;
        alignment = centered;
        : ok_button { is_cancel = true; }
        : spacer { width = 2; }
        look_button;
    }
}


next_button : button {
        label           = "һ(&N)";
        key             = "next";
        fixed_width     = true;
        width           = 9;
        vertical_alignment = centered;
        horizontal_alignment = centered;
}


prev_button : button {
        label           = "һ(&P)";
        key             = "previous";
        fixed_width     = true;
        width           = 9;
        vertical_alignment = centered;
        horizontal_alignment = centered;
}


pick_cancel : column {
    : row {
        fixed_width = true;
        alignment = centered;
        : button {
            label = "ʰȡ(&P) <";
            key = "accept";
            is_default = true;
        }
        : spacer { width = 1; }
        cancel_button;
        : spacer { width = 1; }
        help_button;
    }
}

//
// support functions
//

isopwidth : popup_list {
    label = "ISO ʿ(&I):";
    list = " \n0.13 \n0.18 \n0.25 \n0.35 \n0.5 \n0.7 \n1.0 \n1.4 \n2.0 \n";
    popup_height = 3;
    key = "isopenwidth";
    edit_width = 12;
}

text_35 : text {
    width = 35;
}


acad_group : dialog {
    label = "";
    initial_focus = "name";
    : column {
        : concatenation {
            : text_part {
                label = "(&P)";
                width = 32;
            }
            : text_part {
                label = "ѡ";
            }
        }
        : list_box {
            tabs = "36";
            key = "grp_list";
            width = 48;
            height = 18;
            tab_truncate = true;
        }
    }
    : boxed_column {
        label = "ʶ";
        : column {
            : row {
                : text_part {
                    label = "(&G):";
                    width = 13;
                }
                : edit_box {
                    key = "name";
                    edit_width = 32;
                    edit_limit = 217;
                }
            }
            : row {
                : text_part {
                    label = "˵(&D):";
                    width = 13;
                }
                : edit_box {
                    key = "desc";
                    edit_width = 32;
                    edit_limit = 448;
                }
            }
        }
        : row {
            children_fixed_width = true;
            : button {
                label = "(&F) <";
                key = "find";
            }
            : button {
                label = "(&H) <";
                key = "h_light";
            }
            : toggle {
                label = "δ(&I)";
                key = "anon";
            }
        }
    }
    : boxed_column {
        label = "";
        : row {
            alignment = centered;
            : button {
                label = "½(&N) <";
                key = "add_new";
            }
            spacer_1;
            : toggle {
                label = "ѡ(&S)";
                value = "1";
                key = "select";
            }
            : toggle {
                label = "δ(&U)";
                value = "0";
                key = "unnamed";
            }
        }
    }
    : boxed_column {
        label = "޸ı";
        key = "chg_column";
        : row {
            : button {
                label = "ɾ(&R) <";
                key = "remove";
            }
            : button {
                label = "(&A) <";
                key = "add";
            }
            : button {
                label = "(&M)";
                key = "rename";
            }
            : button {
                label = "(&O)...";
                key = "order";
            }
        }
        : row {
            : button {
                label = "˵(&D)";
                key = "chg_desc";
            }
            : button {
                label = "ֽ(&E)";
                key = "explode";
            }
            : button {
                label = "ѡ(&L)";
                key = "chg_select";
            }
        }
    }
    ok_cancel_help_errtile;
}


acad_grp_order : dialog {
    label = "";
    : column {
        : text {
            label = "(&G)";
        }
        : list_box {
            key = "grp_list";
            width = 45;
            height = 6;
        }
    }
    : boxed_column {
        label = "˵(&D)";
        : text {
            key = "desc";
            width = 43;
        }
    }
    : boxed_column {
        children_fixed_width = true;
        : row {
            : text {
                key = "remove";
                width = 50;
                horizontal_alignment = right;
            }
            : edit_box {
                edit_width = 10;
                key = "from";
                horizontal_alignment = left;
            }
        }
        : row {
            : text {
                key = "replace";
                width = 50;
                horizontal_alignment = right;
            }
            : edit_box {
                edit_width = 10;
                key = "to";
                horizontal_alignment = left;
            }
        }
        : row {
            : text {
                key = "qtext";
                width = 50;
                horizontal_alignment = right;
            }
            : edit_box {
                edit_width = 10;
                key = "quantity";
                horizontal_alignment = left;
            }
        }
    }
    : row {
        key = "action";
        : button {
            label = "(&R)";
            key = "reorder";
        }
        : button {
            label = "(&H)";
            key = "hlight";
        }
        : button {
            label = "(&O)";
            key = "reverse";
        }
    }
    ok_cancel_help_errtile;
}

acad_grp_member : dialog {
    label = "Աб";
    initial_focus = "accept";
    : list_box {
        key = "listbox";
        width = 35;
        height = 8;
        fixed_width = true;
    }
    spacer;
    : ok_button {
        is_cancel = true;
    }
}

acad_msg : dialog {
   label = "";
   width = 30;
   : row {
       next_button;
       prev_button;
   }
   spacer_1;
   : ok_button {
       is_cancel = true;
   }
   errtile;
}

ddfcf : dialog {
  label        = "λ";
  :row {
      : boxed_column {
          label = "";
          children_fixed_height = true;
          children_fixed_width = true;
          : text {
             label = "";
          }
          spacer_1;
          : fcf_ibut {
             key         = "sym11";
          }
          spacer_1;
          : fcf_ibut {
             key         = "sym21";
          }
      }
      : boxed_column {
          label = " 1";
          children_fixed_height = true;
          children_fixed_width = true;
          : text {
              label = "ֱֵ MC";
          }
          spacer_1;
          : row {
              : fcf_ibut {
                  key         = "sym12";
              }
              : fcf_ebox {
                  key         = "ebox11";
              }
              : fcf_ibut {
                  key         = "sym13";
              }
          }
          spacer_1;
          : row {
              : fcf_ibut {
                  key         = "sym22";
              }
              : fcf_ebox {
                  key         = "ebox21";
              }
              : fcf_ibut {
                  key         = "sym23";
              }
          }
      }

      : boxed_column {
          label = " 2";
          children_fixed_height = true;
          children_fixed_width = true;
          : text {
              label = "ֱֵ MC";
          }
          spacer_1;
          : row {
               : fcf_ibut {
                   key         = "sym14";
               }
               : fcf_ebox {
                   key         = "ebox12";
               }
               : fcf_ibut {
                   key         = "sym15";
               }
          }
          spacer_1;
          : row {
              : fcf_ibut {
                  key         = "sym24";
              }
              : fcf_ebox {
                  key         = "ebox22";
              }
              : fcf_ibut {
                  key         = "sym25";
              }
          }
      }

      : boxed_column {
          label = "׼ 1";
          children_fixed_height = true;
          children_fixed_width = true;
          : text {
              label = "׼ ӷ";
          }
          spacer_1;
          : row {
              : fcf_ebox1 {
                  key         = "ebox13";
              }
              : fcf_ibut {
                  key         = "sym16";
              }
          }
          spacer_1;
          : row {
              : fcf_ebox1 {
                  key         = "ebox23";
              }
              : fcf_ibut {
                  key         = "sym26";
              }
          }
      }

      : boxed_column {
          label = "׼ 2";
          children_fixed_height = true;
          children_fixed_width = true;
          : text {
              label = "׼ ӷ";
          }
          spacer_1;
          : row {
              : fcf_ebox1 {
                  key         = "ebox14";
              }
              : fcf_ibut {
                  key         = "sym17";
              }
          }
          spacer_1;
          : row {
              : fcf_ebox1 {
                  key         = "ebox24";
              }
              : fcf_ibut {
                  key         = "sym27";
              }
          }
      }

      : boxed_column {
          label = "׼ 3";
          children_fixed_height = true;
          children_fixed_width = true;
          : text {
              label = "׼ ӷ";
          }
          spacer_1;
          : row {
              : fcf_ebox1 {
                  key         = "ebox15";
              }
              : fcf_ibut {
                  key         = "sym18";
              }
          }
          spacer_1;
          : row {
              : fcf_ebox1 {
                  key         = "ebox25";
              }
              : fcf_ibut {
                  key         = "sym28";
              }
          }
      }
  }
  spacer_1;
  : column {
      children_fixed_height = true;
      : row {
          fixed_width = true;
          : text {
               label = "߶";
          }
          : fcf_ebox {
              key         = "ebox31";
          }
          : text {
               label = "칫";
          }
          : fcf_ibut {
              key         = "sym31";
          }
      }
      spacer_1;
      : row {
          fixed_width = true;
          : text {
               label = "׼ʶ";
          }
          : fcf_ebox {
              key         = "ebox32";
          }
      }
  }
  spacer_1;
  ok_cancel_help_errtile;
}

ddfcfsub: dialog {
  label        = "";
  : column {
   : row {
      : fcf_ibut1 {
        key          = "gdtj";      /* Position */
      }
      : fcf_ibut1 {
        key          = "gdtr";      /* Circularity */
      }
      : fcf_ibut1 {
        key          = "gdti";      /* Symmetry */
      }
      : fcf_ibut1 {
        key          = "gdtf";      /* Parallel */
      }
      : fcf_ibut1 {
        key          = "gdtb";       /* Perpendicular */
      }
    }
    : row {
      : fcf_ibut1 {
        key          = "gdta";      /* Angular */
      }
      : fcf_ibut1 {
        key          = "gdtg";      /* Cylindricity */
      }
      : fcf_ibut1 {
        key          = "gdtc";       /* Flatness */
      }
      : fcf_ibut1 {
        key          = "gdte";      /* Circularity */
      }
      : fcf_ibut1 {
        key          = "gdtu";      /* Straightness    */
      }
    }
    : row {
      : fcf_ibut1 {
        key          = "gdtd";      /* Profile of a surface */
      }
      : fcf_ibut1 {
        key          = "gdtk";      /* Line Profile */
      }
      : fcf_ibut1 {
        key          = "gdth";      /* Circular Runout */
      }
      : fcf_ibut1 {
        key          = "gdtt";      /* Total Runout    */
      }
      : fcf_ibut1 {
        key          = "gdt-";      /* Nothing */
      }
    }
  }
  spacer_1;
  ok_cancel_help_errtile;
}

ddfcfsub1: dialog {
  label        = "ӷ";
  : row {
      : fcf_ibut1 {
       key          = "gdtm";   /* Maximum */
      }
      : fcf_ibut1 {
       key          = "gdtl";   /* Least */
      }
      : fcf_ibut1 {
       key          = "gdts";   /* Regardless of feature size */
      }
      : fcf_ibut1 {
       key          = "gdt-";   /* Nothing */
      }
  }
  spacer_1;
  ok_cancel_help_errtile;
}


//==================================================================
// LispEd.dcl
//
//
// Prototype layout for single-line MText editor.


//==================================================================
// LispEd - main dialogue:

LispEd : dialog {
  label = "༭";
  initial_focus = "text";
  : edit_box {
    label = ":";
    key = "contents";
    edit_width = 40;
    edit_limit = 100;
    allow_accept = true;
  }
  spacer;
  : column {
    : row {
      fixed_width = true;
      alignment = centered;
      ok_button;
      : spacer { width = 2; }
      cancel_button;
      : spacer { width = 2; }
      : retirement_button {
        label = "ȫ༭(F)...";
        mnemonic = "F";
        key = "mtexted";
      }
    }
  }
}

block_equal : dialog {
  key = "block_equal";
  label = "滻";
    : text {
      label = "ѡļ";
      alignment = centered;
    }
    : edit_box {
        label = "½:";
        key = "blockname";
        edit_width = 31;   /* Leave the edit window at pre-ESN length.  */
        edit_limit = 2040; /* Allow 255 MIF sequences for new symbol name. */
        alignment = centered;
        allow_accept = true;
    }
    ok_cancel_err;

}