; Next available MSG number is    12
; MODULE_ID EDGE_LSP_

;;;
;;;    edge.lsp            
;;;    
;;;  Copyright 2018 Autodesk, Inc.  All rights reserved.
;;;
;;;  Use of this software is subject to the terms of the Autodesk license 
;;;  agreement provided at the time of installation or download, or which 
;;;  otherwise accompanies this software in either electronic or hard copy form.
;;;
;;;
;;;
;;; --------------------------------------------------------------------------;
;;; DESCRIPTION
;;;
;;;   Interactive editor for changing the visibility of 3DFACE edges.           
;;;   Prompt:         "Display/<Select edge>: "                                 
;;;
;;;   Features:                                                                 
;;;    > "Display" -  Allows selective regeneration of 3DFACE's highlighting    
;;;                   invisible edges.                                          
;;;    >  Select   -  Reverses the visibility of each edge found.               
;;;
;;;   Note:                                                                     
;;;    >  EDGE uses Osnap MIDpoint as the center of a small crossing box        
;;;       when selecting edges.                                                 
;;;    >  Only edges displayed (or highlighted) can be modified.  (Use          
;;;       "Display" to display a 3DFACE.)                                       
;;;    >  Invisible edges will always be displayed if the system variable       
;;;       SPLFRAME is set to 1.                                                 
;;;
;;; --------------------------------------------------------------------------;


;;; Set CMDECHO without undo recording
(defun edge_setCmdEcho ( newVal / _oldEnvVal)
  ; Only do it if the value is different than the current value
  (if (/= newVal (getvar "CMDECHO"))
    (progn
      (setq _oldEnvVal (getenv "acedChangeCmdEchoWithoutUndo"))
      ; If not set yet, use 0 for default
      (if (not _oldEnvVal)
          (setq _oldEnvVal "0"))
      (setenv "acedChangeCmdEchoWithoutUndo" "1")
      (setvar "cmdecho" newVal)
      (setenv "acedChangeCmdEchoWithoutUndo" _oldEnvVal)
    )
  )
)

;;; ----------------------------- CREATE NEW *ERROR* -------------------------;

(defun edge-er (n) 
  (setq *error* lisp-er)
  (if (/= s "ȡ") 
    (princ (strcat "\n: " n))
  ) 
  (edge_setCmdEcho 0)
  (command-s "_.UCS" "_P") 
  (setvar "osmode" o1)
  (setvar "gridmode" g1)
  (setvar "aperture" a1)
  (setvar "splframe" v1)
  (setvar "ucsfollow" u1)
  (setq n1 -1)
  (repeat (sslength faclst) 
    (redraw (entupd (ssname faclst (setq n1 (1+ n1)))))
  )  
  (command-s "_.UNDO" "_E")
  ;; Restore CMECHO without undo recording
  (edge_setCmdEcho _edge_oldCmdEcho)
  (edge_setCmdEcho _edge_oldCmdEcho)
  (prin1)
) 
;;; ---------------------------- COMMONLY USED MACROS ------------------------;

(defun getval (n e) 
  (cdr (assoc n e))
) 

(defun fltfac (ss / n1) 
  (setq n1 0)
  (if ss 
    (repeat (sslength ss) 
      (if (/= (getval 0 (entget (setq e1 (ssname ss n1)))) "3DFACE") 
        (ssdel e1 ss) 
        (setq n1 (1+ n1))
      )
    )
  ) 
  ss
) 

;;; ------------------------- FORCE DISPLAY OF ALL EDGES ---------------------;

(defun dsply (/ ss n1 t1) 
  (setvar "osmode" 0)
  (initget "All Select") 
  (setq ss (if (eq (getkword "\nرʾѡ񷽷 [ѡ(S)/ȫѡ(A)] <ȫѡ>: ") "Select") 
             (fltfac (ssget)) 
             (ssget "_x" '((0 . "3dface")))
           ) 
        n1 -1)
  (setvar "osmode" 2)
  (cond (ss (princ "\n** ά...") 
            (repeat (sslength ss) 
              (ssadd (setq t1 (ssname ss (setq n1 (1+ n1)))) faclst) 
              (shohdn (entget (entupd t1)))) 
            (princ "ɡ") T) 
    (T (princ "\nδҵά") nil)
  )
) 
;;; ----------------------------- SHOW HIDDEN EDGES --------------------------;

(defun shohdn (e / b1 p1 p2 p3 p4) 
  (setq b1 (getval 70 e))
  (mapcar '(lambda (j k) (set j (getval k e))) 
          '(p1 p2 p3 p4) 
          '(10 11 12 13)) 
  (if (= (logand b1 1) 1) 
    (grdraw p1 p2 c1 1)
  ) 
  (if (= (logand b1 2) 2) 
    (grdraw p2 p3 c1 1)
  ) 
  (if (= (logand b1 4) 4) 
    (grdraw p3 p4 c1 1)
  ) 
  (if (= (logand b1 8) 8) 
    (grdraw p4 p1 c1 1)
  )
) 

;;; --------------------------- GET ENTITY TO EDIT ---------------------------;

(defun getfce (pt / ll ur n1 ss e1 p1) 
  (setq p1 (trans pt 0 2) 
        ll (trans (polar P1 (/ (* pi 5) 4) h1) 2 0) 
        ur (trans (polar P1 (/ pi 4) h1) 2 0) 
        n1 0)
  (setvar "osmode" 0)
  (if (setq ss (ssget "_c" ll ur))
    (setq ss (fltfac ss))
  ) 
  (setvar "osmode" 2)
  ss
) 

;;; --------------------- MODIFY 3DFACE EDGE VISIBILITY FLAG -----------------;

(defun modfce (ss pt / n1 e1 e0 p0 b1 b2 b3) 
  (setq n1 0)
  (repeat (sslength ss) 
    (setq e1 (entget (ssname ss n1)) 
          e0 (getval -1 e1))
    (ssadd e0 faclst) 
    (mapcar '(lambda (j k) (set j (getval k e1))) 
            '(p1 p2 p3 p4) 
            '(10 11 12 13)) 
    (setq p0 (if (equal (distance p3 p4) 0 1e-8) 
               (mapcar '(lambda (j k l) (/ (+ j k l) 3)) p1 p2 p3) 
               (mapcar '(lambda (j k l m) (/ (+ j k l m) 4)) p1 p2 p3 p4)
             ))
    (setq b1 (getval 70 e1) 
          b2 (cond ((equal pt (inters p0 pt p1 p2) h1) 1) 
               ((equal pt (inters p0 pt p2 p3) h1) 2) 
               ((equal pt (inters p0 pt p3 p4) h1) 4) 
               ((equal pt (inters p0 pt p4 p1) h1) 8) 
               (T 0)
             ) 
          b3 (+ b1 (if (= (logand b1 b2) b2) 
                     (- b2) 
                     b2
                   )
             ) 
          e1 (shohdn (entmod (subst (cons 70 b3) (assoc 70 e1) e1))) 
          n1 (1+ n1))
  ) 
  T
) 
;;; ------------------------------ MAIN PROGRAM ------------------------------;

(defun c:EDGE (/ lisp-er s1 o1 g1 a1 v1 h1 u1 faclst c1 r1 t1 ss pt n e n1) 
  (setq lisp-er *error* 
        *error* edge-er 
        s1 (getvar "cmdecho") 
        _edge_oldCmdEcho s1
        o1 (getvar "osmode") 
        g1 (getvar "gridmode") 
        a1 (getvar "aperture") 
        v1 (getvar "splframe") 
        u1 (getvar "ucsfollow") 
        h1 (/ (getvar "viewsize") 100) 
        faclst (ssadd) 
        c1 7 
        r1 T)
   ; Set CMDECHO without undo recording
  (edge_setCmdEcho 0)
  (command "_.UNDO" "_GROUP") 
  (setvar "osmode" 2)
  (setvar "gridmode" 0)
  (setvar "aperture" 5)
  (setvar "splframe" 1)
  (setvar "ucsfollow" 0)
  (command "_.UCS" "_W") 
  (edge_setCmdEcho _edge_oldCmdEcho)
  (while r1 
    (initget "Display") 
    (setq t1 (getpoint "\nָҪлɼԵάı߻ [ʾ(D)]: ") 
          r1 (cond ((eq t1 "Display") (dsply)) 
               ((eq (type t1) 'LIST) (setq ss (getfce t1))
                (cond ((null ss) (princ " δҵάߡ")) 
                  ((= (sslength ss) 0) (princ " ά档")) 
                  (t (modfce ss t1))
                )
               ) 
               (T nil)
             ))
  ) 
  (edge_setCmdEcho 0)
  (command "_.UCS" "_P") 
  (setvar "osmode" o1)
  (setvar "gridmode" g1)
  (setvar "aperture" a1)
  (setvar "splframe" v1)
  (setvar "ucsfollow" u1)
  (setq n1 -1)
  (repeat (sslength faclst) 
    (redraw (entupd (ssname faclst (setq n1 (1+ n1)))))
  ) 
  (redraw) ; to remove highlighted screen graphics
  (command "_.UNDO" "_E") 
  ;; Restore CMECHO without undo recording
  (edge_setCmdEcho _edge_oldCmdEcho)

  (setq *error* lisp-er)
  (prin1)
) 

;;;-----BEGIN-SIGNATURE-----
;;; SgcAADCCB0YGCSqGSIb3DQEHAqCCBzcwggczAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
;;; 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
;;; qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
;;; XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
;;; Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
;;; OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
;;; FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
;;; LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
;;; dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
;;; CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
;;; G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
;;; c9v3Xoh1gTIPCte7VPsxggIsMIICKAIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQAGTDmoYPlBK7is1sJZt3ZQCY8JHo2L7jAH
;;; i+jAGE28LPY5W1mJMaZNXjQ/w/UhfgBcFKo6N8GM7U01iuTKQL7oAifDZuMfwtq6
;;; SdgxYW8UqFhXE4V5j99m04mfTBvcCCDmFob3NOeiRQtwkuyRvPc5EbdM1Sa1JsiH
;;; UOuN3kfSZe1/Zs+5PvgRjCpKo263JalKNJ+zb671es1TgSAAhK27mMXg9cgT/naB
;;; Z25qQGkVLM+LTvANtoN8zML1rXs3hRc2ypYCk2v78wVTMQUbG5RBd2OaQ6mbMj4P
;;; d4tQa3URPcFye1wlmG0V2BL/HYxklgTxE0f522xfWAFLCakIymfCoWUwYwYDVR0O
;;; MVwEWjQAMQA7ADEALwAzADAALwAyADAAMQA4AC8ANAAvADUAMQAvADQANQAvAFQA
;;; aQBtAGUAIABmAHIAbwBtACAAdABoAGkAcwAgAGMAbwBtAHAAdQB0AGUAcgAAAA==
;;; -----END-SIGNATURE-----