//////////////////////////////////////////////////////////////////////////////
//  Copyright 2014 by Autodesk, Inc.  All rights reserved.
//
// This computer source code and related instructions and comments 
// are the unpublished confidential and proprietary information of 
// Autodesk, Inc. and are protected under applicable copyright and 
// trade secret law.  They may not be disclosed to, copied or used 
// by any third party without the prior written consent of Autodesk, Inc.
//////////////////////////////////////////////////////////////////////////////

/*globals $,jQuery,document, window, navigator*/

/*!
* ntp.content - Dynamic updates of new tab page content
*/

// Namespace
var ntp = ntp || {};
ntp.content = ntp.content || {};

/**
 * Load string table as json data
 */
ntp.content.applyLocalizedStrings = function(localizedStrings) {
    // Verify string data
    if (localizedStrings !== null) {
        // Load localized strings and initialize text elements
        $('*[data-text-id]').each(function() {
            var $element = $(this);
            $element.html(localizedStrings[$element.data('text-id')]);
        });

        $('*[data-text-map]').each(function() {
            var $element = $(this);
            var textMap = $element.data('text-map');
            $.each(textMap, function(index, value) {
                $element.attr(index, localizedStrings[value]);
            });
        });
    }
};
/**
 * Gets or sets the map from file type to thumbnail image
 */
ntp.content.thumbnail = (function() {
    var thumbnails = {};
    var defaultThumbnail = 'images/default_thumb.png';

    // Gets or sets the settings object.
    return function(param, param1) {
        if ( typeof param === 'string') {
            if ( typeof param1 === 'string') {
                // Setting value
                thumbnails[param] = param1;
            } else {
                // Getting value
                var thumbnail = thumbnails[param];

                if ( typeof thumbnail === 'string') {
                    return thumbnail;
                } else {
                    return defaultThumbnail;
                }
            }

        } else {
            $.error('Invalid paramters.');
        }
    };
})();

ntp.content.tryTab = (function () {
    var isEnabled = false;
    var isTrial = false;
    var productLine;
    var productRelease;
    var productLang;
    var daysLeft = 0;
    var country;
    var basicUrl = null;
    var settingUrl = null;
    var isLoaded = false;
    // Gets or sets the settings object.
    return {
        getLoaded: function () {
            return isLoaded;
        },

        setTrial: function (state) {
            isTrial = state;
        },
        
        getTrial: function () {
            return isTrial;
        },
        
        applySettings: function (settings, spec){
            if(typeof settings.widgets !== 'undefined' && typeof spec !== 'undefined'){
                if(typeof settings.widgets.itm !== 'undefined' && typeof spec.tryTab !== 'undefined' ){
                    if(typeof spec.tryTab.enabled === 'string' && spec.tryTab.enabled.toLowerCase() === 'yes'){
                        if(typeof settings.widgets.itm.BasicURL === 'string')
                            basicUrl = settings.widgets.itm.BasicURL;
                        if(typeof spec.tryTab.settingUrl === 'string')
                            settingUrl = spec.tryTab.settingUrl;

                        //Get product information that will be used by ITM page.
                        if(basicUrl !== null && settingUrl !== null)
                            ntp.acad.getProductInfoAsJSON().done(ntp.utils.makeCallback(this, 'refreshProductInfoWithJSON'));
                    }
                }
            }
        },
        
        //Get product information from native side.
        refreshProductInfoWithJSON: function (productInfo) {
            var data = $.parseJSON(productInfo);
            if (typeof data.retValue !== 'undefined')
                data = data.retValue; // hoist retValue if present 

            if (data.trial === true && data.productLine !== null &&
                    data.productRelease !== null && data.productLang !== null
                    && data.country !== null && data.daysleft >= 0) {
                $('#tab_try .placeholder').addClass('loading');
                //save product information
                isTrial = true;
                productLine = data.productLine;
                productRelease = data.productRelease;
                productLang = data.productLang.toLowerCase();
                country = data.country.toLowerCase();
                daysLeft = data.daysleft;
                //Load try tab setting
                $.ajax({
                    url : settingUrl,
                    dataType : 'jsonp',
                    jsonpCallback : 'tryTabCallback',
                    crossDomain : true,
                    timeout : 5000,
                    success : function(data) {
                        //get setting file from ITM server
                        //try to load ITM page.
                        ntp.content.tryTab.loadITMPage(data);
                    },
                    error : function(xhr, status, error) {
                        // Don't get settings file.
                        $('#tab_try .placeholder').removeClass('loading');
                    }
                });
            }
        },
        
        //Refresh page
        refreshTryTabWithJSON: function (licenseInfo) {
            var data = $.parseJSON(licenseInfo);
            if (typeof data.retValue !== 'undefined')
                data = data.retValue; // hoist retValue if present
            if (data.type !== 2) {
                if (isLoaded === true) {
                    ntp.page.tabs.removeVisibleTab('tab_try', 'tab_create');
                }
            }
            else {
                if (isLoaded === false && basicUrl !== null && settingUrl !== null){
                    ntp.acad.getProductInfoAsJSON().done(ntp.utils.makeCallback(this, 'refreshProductInfoWithJSON'));
                }
            }
        },
        
        loadITMPage: function (data) {
            //load ITM page into try tab.
            if (typeof data !== 'undefined') {
                if (typeof data.retValue !== 'undefined')
                    data = data.retValue; // hoist retValue if present
                if (data.enabled.toLowerCase() == "yes") {
                    if(data.country instanceof Array && data.language instanceof Array){
                        var isSupportCountry = false;
                        var isSupportLang = false;
                        for(var i = 0; i < data.country.length; i++){
                            if(data.country[i].toLowerCase() === country){
                                isSupportCountry = true;
                                for(var k = 0; k < data.language.length; k++){
                                    if(data.language[k].toLowerCase() === productLang){
                                        isSupportLang = true;
                                        break;
                                    }
                                }
                                break;
                            }
                        }
                    }
                    if (isSupportCountry && isSupportLang) {
                        var pageUrl = basicUrl + productLine + "/" + productRelease
                                + "/" + productLang + "?redirected2=1&d="
                                + daysLeft + "&country=" + country;
                        $('#try_page').attr("src", pageUrl);
    
                        // Change current tab into Try Tab
                        ntp.page.tabs.addVisibleTab("tab_try", true);
                        isLoaded = true;
                        // Move hidden try tab content to target place.
                        var $preloaditm = $('#preload_try');
                        if ($preloaditm !== null) {
                            $('#tab_try .placeholder').remove();
                            $('#tab_try .content').empty().append(
                                    $preloaditm.children());
                            $preloaditm.remove();
                        }
                    }
                }
            }
            if(!isLoaded)
                $('#tab_try .placeholder').removeClass('loading');
        }
    };
})();

/**
 * Updates of learn tab content
 */
ntp.content.learnTab = (function() {

    var prevTipImage = 'images/prev_tip.png';
    var nextTipImage = 'images/next_tip.png';
    var hilightedContents = {};
    var hasFeaturedVideo = false;
    var hasGetStartedVideo = false;
    var hasResource = false;
    var hasTip = false;
    var notificationNum = 0;
    var $footerBadge = null;
    var $tipsData = null;
    var hilight = (function () {
        return {
            createElement: function (linkurl, uploadTime) {
                return $('<span>').addClass('newcontent').addClass('hidden').data({
                    url: linkurl,
                    upload_time: new Date(uploadTime)
                });
            }
        };
    })();
    var loadVideoList = function ($list, videos) {
        $list.empty();

        $.each(videos, function (i, video) {
            var $preview = $('<div>').addClass('video_preview');
            $preview.append($('<img>').addClass('thumb').attr({
                src : video.thumb,
                alt : 'thumbnail'
            })).append($('<span>').addClass('overlay'));

            var $title = $('<div>').addClass('title').html(video.title);
            var $info = $('<div>').append($title, $('<div>').addClass('desc').html(video.description).append($('<div>').addClass('duration').html(video.duration)), $('<div>').css('clear', 'both'));

            var $item = $('<li>').append($preview, $info).data({
                url: video.video,
                title: video.title,
                upload_time: video.upload_time
            });
            $list.append($item);

            if (typeof video.video !== 'undefined' && typeof video.upload_time !== 'undefined') {
                var uploadTimeFromServer = new Date(video.upload_time);

                if (uploadTimeFromServer > ntp.video.releasetime) {
                    $preview.append(hilightedContents[video.video] = hilight.createElement(video.video, video.upload_time));
                }
            }

            $item.click(ntp.utils.makeCallbackWithArgs(ntp.video, 'showPlayer', $item));
        });
    };

    var urlIsHilightedContent = function (url) {
        if (typeof hilightedContents[url] !== 'undefined' && !hilightedContents[url].hasClass('hidden')) {
            return true;
        } else {
            return false;
        }
    };

    var updateSectionVideos = function (data) {
        if (typeof data.retValue !== 'undefined')
            data = data.retValue; // hoist retValue if present
        hasFeaturedVideo = (typeof data.featuredVideoList !== 'undefined');
        hasGetStartedVideo = (typeof data.videoListSmall !== 'undefined');
        
        //Getting started videos
        if (typeof data.videoListSmall === 'object' && data.videoListSmall.video instanceof Array) {
            if (typeof data.videoListSmall.title === 'string') {
                $('#getting_started h1').text(data.videoListSmall.title);
            }

            loadVideoList($('#getting_started ol'), data.videoListSmall.video);
        } else {
            var $gettingStarted = $("#getting_started");
            $gettingStarted.next().remove();
            $gettingStarted.remove();
        }
        //feature videos
        if (typeof data.featuredVideoList === 'object' && data.featuredVideoList.video instanceof Array) {
            if (typeof data.featuredVideoList.title === 'string') {
                $('#feature_videos h1').text(data.featuredVideoList.title);
            }

            loadVideoList($('#feature_videos ol'), data.featuredVideoList.video);
        } else {
            var $featureVideos = $('#feature_videos');
            $featureVideos.remove();
        }
        //If the Getting Started and Feature Videos are not there remove section
        if ($('#feature_videos').length === 0 && $('#getting_started').length === 0) {
            var $sectionVidoes = $('#section_videos');
            $sectionVidoes.next().remove();
            $sectionVidoes.remove();
        }
        //update video column height.
        ntp.page.layout.updateVideoSectionHeight();
    };

    var updateLearnTipsSection = function (data) {
        if (typeof data.retValue !== 'undefined')
            data = data.retValue; // hoist retValue if present
        if (typeof data.tipsData !== 'undefined') {
            $tipsData = data.tipsData;
            $tipsData.whichTip = "next";
            updateTip();
        }
    };

    function updateTip() {
        var RecentlyUpdatedUrls = [];
        // Read current tipID and date
        RecentlyUpdatedUrls.push("tipID");
        RecentlyUpdatedUrls.push("tipExpireDate");

        ntp.acad.getLearnContentStateListAsJSON(RecentlyUpdatedUrls).done(ntp.utils.makeCallback(ntp.content.learnTab, 'LoadCurrentTip'));
    };

    function mouseRolloverImageUpdate(currentImage) {
        var str = currentImage.src;
        if (str.search("images/mouseover_") == -1) {
            str = str.replace("images/", "images/mouseover_");
        }
        else {
            str = str.replace("images/mouseover_", "images/");
        }
        currentImage.src = str;
    };

    function getTipToDisplay(currentTipData, tips, whichTip) {
        var $getCurrent = false;
        var $iter = 1;
        var $index = 0;

        while ($index < tips.length) {
            if (tips[$index].disabled == "true") {
                $index++;
            } else {
                break;
            }
        }
        if (whichTip == "forcePrev") {
            $index = tips.length - 1;
            $iter = -1;
        }
        else {
            if (whichTip == "next") {
                var $currentDate = new Date();
                var $tipExpireDate = new Date(currentTipData.tipExpireDate);

                if ($currentDate < $tipExpireDate) {
                    $getCurrent = true;
                }
            }
        }

        var i = 0;
        var $tiptodispaly = tips[$index];

        while (i < tips.length) {
            if (tips[$index].disabled == "true") {
                $index = ($index + $iter + tips.length)%tips.length;
                i++;
                continue;
            }
            if ($getCurrent == true) {
                if (tips[$index].id == currentTipData.tipID) {
                    $tiptodispaly = tips[$index];
                    break;
                }
            }
            else {
                if ($iter > 0 && tips[$index].id > currentTipData.tipID) {
                    $tiptodispaly = tips[$index];
                    break;
                }
                else if ($iter < 0 && tips[$index].id < currentTipData.tipID) {
                    $tiptodispaly = tips[$index];
                    break;
                }
            }
            $index = ($index + $iter + tips.length)%tips.length;
            i++;
        }
        return $tiptodispaly;
    };

    function parseTipContent(tipContent) {
        var $tipContentNode = $('<p id="tipcontent" >');

        for (var i = 0; i < tipContent.length; i++) {
            if (tipContent[i].text !== 'undefined') {
                $tipContentNode.append(tipContent[i].text);
            }
            if (typeof tipContent[i].icon !== 'undefined' && tipContent[i].icon !== null) {
                var icon = new Image();
                icon.src = tipContent[i].icon;

                $tipContentNode.append(icon);
            }
            if (typeof tipContent[i].image !== 'undefined' && tipContent[i].image !== null) {
                // We always want image in a new para
                var $tipImageNode = $('<p>');
                var icon = new Image();
                icon.src = tipContent[i].image;
                $tipImageNode.append(icon);

                $tipContentNode.append($tipImageNode);
            }
        }

        return $tipContentNode;
    };

    var updateOnlineResource = function (data) {
        if (typeof data.retValue !== 'undefined')
            data = data.retValue; // hoist retValue if present
        if (data.onlineResources) {
            hasResource = true;
            var $onlineResources = $('#online_resources_box');
            if (data.onlineResources.title) {
                $('#section_resources h1.resources').text(data.onlineResources.title);
            }
            if (data.onlineResources.description) {
                $onlineResources.append($('<p>').text(data.onlineResources.description));
            }
            if (data.onlineResources.links instanceof Array) {
                var $list = $('<ol>').addClass('flex');
                $onlineResources.append($list);

                $.each(data.onlineResources.links, function (i, link) {

                    var $listItem = $('<li>').addClass('button').append($('<img>').attr({
                        src: link.banner,
                        alt: link.caption
                    })).append($('<p>').text(link.caption));

                    //Append the hilight span if its a new link
                    if ((typeof link.url !== 'undefined' || typeof link.helpTopicId !== 'undefined') && typeof link.upload_time !== 'undefined') {

                        var uploadTimeFromServer = new Date(link.upload_time);
                        if (uploadTimeFromServer > ntp.video.releasetime) {
                            {
                                if (typeof link.url !== 'undefined')
                                    $listItem.append(hilightedContents[link.url] = hilight.createElement(link.url, link.upload_time));
                                else
                                    $listItem.append(hilightedContents[link.helpTopicId] = hilight.createElement(link.helpTopicId, link.upload_time));
                            }
                        }
                    }

                    $list.append($listItem);

                    if (link.url) {
                        if (link.external === true) {
                            $listItem.click(function () {
                                ntp.utils.openExternalUrlWithBrowser(link.url);
                                var $lightBoxPanel = $('#lightbox_panel');
                                $lightBoxPanel.addClass('leave_autodesk');

                                if (urlIsHilightedContent(link.url) === true) {
                                    ntp.acad.updateLearnContentState(link.url, link.upload_time);
                                }
                            });
                        } else {
                            $listItem.click(function () {
                                ntp.acad.openUrlWithBrowser(link.url);

                                if (urlIsHilightedContent(link.url) === true) {
                                    ntp.acad.updateLearnContentState(link.url, link.upload_time);
                                }
                            });
                        }
                    } else if (typeof link.helpTopicId === 'string' && link.helpTopicId !== "") {
                        $listItem.click(function (e) {
                            ntp.acad.openUrlWithHelpBrowser(link.helpTopicId);
                            e.preventDefault();
                            if (urlIsHilightedContent(link.helpTopicId) === true) {
                                ntp.acad.updateLearnContentState(link.helpTopicId, link.upload_time);
                            }
                        });
                    }
                });
            }

            ntp.page.layout.updateOnlineResourceHeight();
        } else {
            var $sectionResources = $('#section_resourceslinks');
            $sectionResources.remove();
        }
    };

    return {
        // ntp.content.learnTab
        urlIsHilightedContent: urlIsHilightedContent,

        hilightNewLearnConents: function (registryRecords) {
            if (typeof registryRecords.retValue !== 'undefined')
                registryRecords = registryRecords.retValue; // hoist retValue if present
            for (var url in hilightedContents) {
                if (hilightedContents.hasOwnProperty(url) && typeof hilightedContents[url] !== 'undefined') {
                    if (typeof registryRecords[url] === 'undefined' ||
                        hilightedContents[url].data('upload_time') > new Date(registryRecords[url])) {
                            hilightedContents[url].removeClass('hidden');
                            notificationNum++;
                        }
                }
            }

            //Update badge showing number.
            $footerBadge.html(notificationNum.toString());
            if (notificationNum > 0) {
                $footerBadge.removeClass('hidden');
            }
        },

        handleNextTip: function () {
            $tipsData.whichTip = "forceNext";
            updateTip();
        },
        mouseRolloverImageUpdate: function (obj) {
            mouseRolloverImageUpdate(obj);
        },
        handlePrevTip: function () {
            $tipsData.whichTip = "forcePrev"
            updateTip();
        },
        
        changeMouseOverImage: function() {
            this.src = "images/mouseover_next_tip.png";
        },

        LoadCurrentTip: function (RegisteredInfo) {
            var $currentTipData = $.parseJSON(RegisteredInfo);
            if (typeof $currentTipData.retValue !== 'undefined')
                $currentTipData = $currentTipData.retValue; // hoist retValue if present

            if ($tipsData && typeof $tipsData.learnTips !== 'undefined') {
                hasTip = true;
                var $tipContainer = $('#tip_container');
                var $tipResources = $('#tip_resource_box');
                var $tipDiv = $('<div id="tipdiv" style="position:relative;padding-right:15px" >');
                var $tipHeader = $('#tip_header');

                // Add images only when whole page is reloaded, not with next/previous tip
                if ($tipsData.whichTip == "next") {
                    $tipHeader.append($('<img id="nextImage" class="tip_header" >').attr({
                        'src' : nextTipImage,
                        'onclick' : 'ntp.content.learnTab.handleNextTip()',
                        'onMouseOver': 'ntp.content.learnTab.mouseRolloverImageUpdate(this)',
                        'onMouseOut': 'ntp.content.learnTab.mouseRolloverImageUpdate(this)',
                        }));

                    $tipHeader.append($('<img id="prevImage" class="tip_header" >').attr({
                        'src' : prevTipImage,
                        'onclick' : 'ntp.content.learnTab.handlePrevTip()',
                        'onMouseOver': 'ntp.content.learnTab.mouseRolloverImageUpdate(this)',
                        'onMouseOut': 'ntp.content.learnTab.mouseRolloverImageUpdate(this)',
                        }));
                    $.when(ntp.deferred.strings).done(function() {
                        $('#nextImage').prop('title', ntp.utils.localize('learn_next_tip'));
                        $('#prevImage').prop('title', ntp.utils.localize('learn_prev_tip'));
                    });

                }

                if ($tipsData.title) {
                    $('#section_resources h1.tip').text($tipsData.title);
                }

                var $tipToDisplay = getTipToDisplay($currentTipData, $tipsData.learnTips, $tipsData.whichTip);

                if ($tipToDisplay.content) {
                    var $tipContentNode = parseTipContent($tipToDisplay.content);

                    $tipDiv.append($tipContentNode);

                    if (typeof $tipToDisplay.caption !== 'undefined') {
                        $tipDiv.append($('<a href="fakeurl" tabindex="-1">').text($tipToDisplay.caption).on("click", function (e) {

                            if (typeof $tipToDisplay.helpTopicId !== 'undefined' && $tipToDisplay.helpTopicId !== "")
                                ntp.acad.openUrlWithHelpBrowser($tipToDisplay.helpTopicId);
                            else if (typeof $tipToDisplay.url !== 'undefined' && $tipToDisplay.url !== "")
                                ntp.acad.openUrlWithBrowser($tipToDisplay.url);

                            e.preventDefault();
                        }));
                    }
                    $tipResources.empty();
                    $tipResources.append($tipDiv);

                    var $todayDate = new Date();
                    $todayDate.setHours(23);
                    $todayDate.setMinutes(59);
                    $todayDate.setSeconds(59);

                    $tipResources.data({
                        upload_time: new Date(),
                        tip_ID: $tipToDisplay.id,
                        tip_Expire_Date: $todayDate,
                    });

                    //Append the hilight span if the tip is never visited
                    if (typeof $tipToDisplay.content !== 'undefined') {

                        if ($currentTipData.tipID != $tipToDisplay.id) {
                            if ( typeof hilightedContents['tip'] == 'undefined') {
                                $tipContainer.append(hilightedContents['tip'] = hilight.createElement('tip', new Date()));
                            }
                            // Update the tip data as user see next or previous tip
                            if ($tipsData.whichTip !== "next") {
                                ntp.acad.updateLearnContentState('tip', new Date());
                                ntp.acad.updateLearnContentState('tipID', $tipToDisplay.id);
                                ntp.acad.updateLearnContentState('tipExpireDate', $todayDate);
                            }
                        }
                    }
                }
            }
            else {
                var $tipSection = $('#Section_tip');
                if (typeof $tipSection != 'undefined' && $tipSection != null)
                    $('#Section_tip').remove();
            }

        },

        hasFeaturedVideos: function() {
            return hasFeaturedVideo;
        },
        
        hasGetStartedVideos: function() {
            return hasGetStartedVideo;
        },
        
        hasOnlineResource: function() {
            return hasResource;
        },
        
        hasTips: function() {
            return hasTip;
        },

        updateLearnTipsData: function (data) {
            updateLearnTipsSection(data);
        },

        unhilightViewedLearnConents: function (registryRecords) {

            if (typeof registryRecords.retValue !== 'undefined')
                registryRecords = registryRecords.retValue; // hoist retValue if present

            if (typeof registryRecords['RecentViewed'] !== 'undefined' &&
                urlIsHilightedContent(registryRecords['RecentViewed']) === true) {

                if (registryRecords['RecentViewed'] === 'tip' && ntp.page.tabs.isTipContentsVisited() === false) {
                    hilightedContents[registryRecords['RecentViewed']].addClass('hidden');
                    notificationNum--;
                } else if (registryRecords['RecentViewed'] !== 'tip') {
                    hilightedContents[registryRecords['RecentViewed']].addClass('hidden');
                    notificationNum--;
                }
            }

            if (typeof registryRecords['tip'] !== 'undefined' && urlIsHilightedContent('tip') === true) {
                hilightedContents['tip'].addClass('hidden');
                notificationNum--;
            }
            //Update badge showing number.
            if ($footerBadge !== null) {
                $footerBadge.html(notificationNum.toString());
                if (notificationNum === 0) {
                    $footerBadge.addClass('hidden');
                }
            }
        },

        unhilightRecentViewed: function (RegisteredInfo) {
            this.unhilightViewedLearnConents($.parseJSON(RegisteredInfo));
        },

        hilightRecentUpdates: function (RegisteredInfo) {
            this.hilightNewLearnConents($.parseJSON(RegisteredInfo));
        },

        load: function(data) {

            if (typeof data.retValue !== 'undefined')
                data = data.retValue; // hoist retValue if present

            $footerBadge = $('#footer_learn_badge');

            //load A360 widget based on url.
            if (typeof data.url_connect_widget === 'string' && data.url_connect_widget !== "") {
                //Set url and try to load A360 widget
                ntp.widget.connect.setWidgetURL(data.url_connect_widget);
            }
            ntp.widget.connect.beginRefresh();

            if (typeof data.release_time === 'string') {
                ntp.video.releasetime = new Date(data.release_time);
            }
            if ( typeof data.videoWidth === 'number') {
                ntp.video.videoWidth = data.videoWidth;
            }
            if ( typeof data.videoHeight === 'number') {
                ntp.video.videoHeight = data.videoHeight;
            }

            if ( typeof data.videoListLarge === 'object' && data.videoListLarge.video instanceof Array) {
                if ( typeof data.videoListLarge.title === 'string') {
                    $('#section_whats_new h1').text(data.videoListLarge.title);
                }
                loadVideoList($('#section_whats_new ol'), data.videoListLarge.video);
            } else {
                var $sectionWhatsNew = $('#section_whats_new');
                $sectionWhatsNew.next().remove();
                $sectionWhatsNew.remove();
            }

            //update Section videos
            updateSectionVideos(data);

            //update online resource
            updateOnlineResource(data);

            //Hilight the Recently added learn contents.
            var RecentlyUpdatedUrls = [];
            for (var url in hilightedContents) {
                if (hilightedContents.hasOwnProperty(url))
                    RecentlyUpdatedUrls.push(url);
            }
            if (RecentlyUpdatedUrls.length > 0)
                ntp.acad.getLearnContentStateListAsJSON(RecentlyUpdatedUrls).done(ntp.utils.makeCallback(this, 'hilightRecentUpdates'));

        }
    };
})();

/**
 * Triggers update of content on events
 */
(function() {
    ntp.deferred.customization.done(function() {
        ntp.deferred.strings.done(function(data) {
            ntp.content.applyLocalizedStrings(data);
            ntp.deferred.localization.resolve();
        });
    });

    $.when(ntp.deferred.localization, ntp.deferred.customization).done(function() {
        
        $.when.apply(null, ntp.asyncLoadings).always(function() {
            ntp.widget.notifications.adjustContainerHeight();
            $('#preload_mask').remove();
        });

        // Load the content of learn tab
        ntp.deferred.learnTab.done(function(data) {

            ntp.widget.connect.setIsOnline(true);
            ntp.content.learnTab.load(data);

            // Move hidden learn tab content to target place.
            var $preloadLearn = $('#preload_learn');
            $('#tab_learn .placeholder').remove();
            $('#tab_learn .content').empty().append($preloadLearn.children());
            $preloadLearn.remove();

            ntp.page.tabs.addVisibleTab("tab_learn", false);
            ntp.page.layout.update(); 
        }).fail(function() {
            // Show offine help download notification box when load learn page failure.
            ntp.widget.notifications.beginGetOfflineHelpStatus();
            ntp.widget.connect.setIsOnline(false);
            ntp.widget.connect.beginRefresh();
        });
    });
})();

// SIG // Begin signature block
// SIG // MIIZuQYJKoZIhvcNAQcCoIIZqjCCGaYCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // A9bD2TQeVSXQsTb8WiBJLhTdPvt6gUz04JlvnFA5Qwug
// SIG // ggopMIIE2jCCA8KgAwIBAgIQDl0r5acblsN6Y+ZZVIFE
// SIG // GDANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCVVMx
// SIG // HTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8w
// SIG // HQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTUw
// SIG // MwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
// SIG // b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xNzA4MDQwMDAw
// SIG // MDBaFw0xODA4MDQyMzU5NTlaMIGKMQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECAwKQ2FsaWZvcm5pYTETMBEGA1UEBwwK
// SIG // U2FuIFJhZmFlbDEXMBUGA1UECgwOQXV0b2Rlc2ssIElu
// SIG // Yy4xHzAdBgNVBAsMFkRlc2lnbiBTb2x1dGlvbnMgR3Jv
// SIG // dXAxFzAVBgNVBAMMDkF1dG9kZXNrLCBJbmMuMIIBIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAs9HnSHLU
// SIG // WStY4GY/6wZd8pYVSkUAoH04sOU3dSP3hYEt0eN77CwF
// SIG // q/8A4vUF6fio5rvg9akkdMl3yOmHgxIaEpkTegU0/IBV
// SIG // cJWFQCOqUtphBeQcNYx7LP7LsVZfigrUHUf5I1Vydzb6
// SIG // QAHRsQhPhUAi9BzK9rjVOGlUbM9dkz8koMOkDq2hwxDf
// SIG // 3flQCMdi6+g4AMSQW3k7+URbM9PPRpCRUsaIPXyuAXG5
// SIG // LD5TPaPK4NlnmXI0FBEX4rhy7x+V724vZapto7uSgfPv
// SIG // p2Qms1b3ACaR0YJ1+PcxCj44Pg7kmNIxgcRyaNVsfKj5
// SIG // kr8EhXKQCnFzS183YdElK4eUbQIDAQABo4IBPjCCATow
// SIG // CQYDVR0TBAIwADAOBgNVHQ8BAf8EBAMCB4AwEwYDVR0l
// SIG // BAwwCgYIKwYBBQUHAwMwYQYDVR0gBFowWDBWBgZngQwB
// SIG // BAEwTDAjBggrBgEFBQcCARYXaHR0cHM6Ly9kLnN5bWNi
// SIG // LmNvbS9jcHMwJQYIKwYBBQUHAgIwGQwXaHR0cHM6Ly9k
// SIG // LnN5bWNiLmNvbS9ycGEwHwYDVR0jBBgwFoAU1MAGIknr
// SIG // OUvdk+JcobhHdglyA1gwKwYDVR0fBCQwIjAgoB6gHIYa
// SIG // aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcmwwVwYIKwYB
// SIG // BQUHAQEESzBJMB8GCCsGAQUFBzABhhNodHRwOi8vcmIu
// SIG // c3ltY2QuY29tMCYGCCsGAQUFBzAChhpodHRwOi8vcmIu
// SIG // c3ltY2IuY29tL3JiLmNydDANBgkqhkiG9w0BAQsFAAOC
// SIG // AQEAt+AVE1Tf82ntInlNGzyzy0+c5N3gPlZ76y0sK5DQ
// SIG // jWSNUjKIhj5ndxDPYAH3HxVe5gUtxedPpFzVwxgm2VPI
// SIG // HtnsRmR/FCYWBzhyFV+eC5Ok+pS1+jdAxP9LX5Ah1h8h
// SIG // uTV1K8UGZnBEZq2YZufaHscaIiA2pBo7pMPsXH1MQk/A
// SIG // iKIIrwXdvgQ2lhAeWAfc4B0JEtrUhY994DTfIXc8irz4
// SIG // 2EuyeDDUU2b34LpQ4zeZ/eMfDFOtu3iighmy2M8Dg9Qb
// SIG // XoWSEmDuXZEINHqwT2JPsUwKw7q0AdfelLxp8XI3IRV+
// SIG // AlUp/OiF0M6P5dAuTOlz2/deiHWBMg8K17tU+zCCBUcw
// SIG // ggQvoAMCAQICEHwbNTVK59t050FfEWnKa6gwDQYJKoZI
// SIG // hvcNAQELBQAwgb0xCzAJBgNVBAYTAlVTMRcwFQYDVQQK
// SIG // Ew5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
// SIG // Z24gVHJ1c3QgTmV0d29yazE6MDgGA1UECxMxKGMpIDIw
// SIG // MDggVmVyaVNpZ24sIEluYy4gLSBGb3IgYXV0aG9yaXpl
// SIG // ZCB1c2Ugb25seTE4MDYGA1UEAxMvVmVyaVNpZ24gVW5p
// SIG // dmVyc2FsIFJvb3QgQ2VydGlmaWNhdGlvbiBBdXRob3Jp
// SIG // dHkwHhcNMTQwNzIyMDAwMDAwWhcNMjQwNzIxMjM1OTU5
// SIG // WjCBhDELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFu
// SIG // dGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRl
// SIG // YyBUcnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRl
// SIG // YyBDbGFzcyAzIFNIQTI1NiBDb2RlIFNpZ25pbmcgQ0Eg
// SIG // LSBHMjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
// SIG // ggEBANeVQ9Tc32euOftSpLYmMQRw6beOWyq6N2k1lY+7
// SIG // wDDnhthzu9/r0XY/ilaO6y1L8FcYTrGNpTPTC3Uj1Wp5
// SIG // J92j0/cOh2W13q0c8fU1tCJRryKhwV1LkH/AWU6rnXmp
// SIG // AtceSbE7TYf+wnirv+9SrpyvCNk55ZpRPmlfMBBOcWNs
// SIG // WOHwIDMbD3S+W8sS4duMxICUcrv2RZqewSUL+6Mcntim
// SIG // CXBx7MBHTI99w94Zzj7uBHKOF9P/8LIFMhlM07Acn/6l
// SIG // eCBCcEGwJoxvAMg6ABFBekGwp4qRBKCZePR3tPNgKuZs
// SIG // UAS3FGD/DVH0qIuE/iHaXF599Sl5T7BEdG9tcv8CAwEA
// SIG // AaOCAXgwggF0MC4GCCsGAQUFBwEBBCIwIDAeBggrBgEF
// SIG // BQcwAYYSaHR0cDovL3Muc3ltY2QuY29tMBIGA1UdEwEB
// SIG // /wQIMAYBAf8CAQAwZgYDVR0gBF8wXTBbBgtghkgBhvhF
// SIG // AQcXAzBMMCMGCCsGAQUFBwIBFhdodHRwczovL2Quc3lt
// SIG // Y2IuY29tL2NwczAlBggrBgEFBQcCAjAZGhdodHRwczov
// SIG // L2Quc3ltY2IuY29tL3JwYTA2BgNVHR8ELzAtMCugKaAn
// SIG // hiVodHRwOi8vcy5zeW1jYi5jb20vdW5pdmVyc2FsLXJv
// SIG // b3QuY3JsMBMGA1UdJQQMMAoGCCsGAQUFBwMDMA4GA1Ud
// SIG // DwEB/wQEAwIBBjApBgNVHREEIjAgpB4wHDEaMBgGA1UE
// SIG // AxMRU3ltYW50ZWNQS0ktMS03MjQwHQYDVR0OBBYEFNTA
// SIG // BiJJ6zlL3ZPiXKG4R3YJcgNYMB8GA1UdIwQYMBaAFLZ3
// SIG // +mlIR59TEtXC6gcydgfRlwcZMA0GCSqGSIb3DQEBCwUA
// SIG // A4IBAQB/68qn6ot2Qus+jiBUMOO3udz6SD4Wxw9FlRDN
// SIG // J4ajZvMC7XH4qsJVl5Fwg/lSflJpPMnx4JRGgBi7odSk
// SIG // VqbzHQCR1YbzSIfgy8Q0aCBetMv5Be2cr3BTJ7noPn5R
// SIG // oGlxi9xR7YA6JTKfRK9uQyjTIXW7l9iLi4z+qQRGBIX3
// SIG // FZxLEY3ELBf+1W5/muJWkvGWs60t+fTf2omZzrI4RMD3
// SIG // R3vKJbn6Kmgzm1By3qif1M0sCzS9izB4QOCNjicbkG8a
// SIG // vggVgV3rL+JR51EeyXgp5x5lvzjvAUoBCSQOFsQUecFB
// SIG // NzTQPZFSlJ3haO8I8OJpnGdukAsak3HUJgLDwFojMYIO
// SIG // 6DCCDuQCAQEwgZkwgYQxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjEfMB0GA1UE
// SIG // CxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1MDMGA1UE
// SIG // AxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBT
// SIG // aWduaW5nIENBIC0gRzICEA5dK+WnG5bDemPmWVSBRBgw
// SIG // DQYJYIZIAWUDBAIBBQCgfDAQBgorBgEEAYI3AgEMMQIw
// SIG // ADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgor
// SIG // BgEEAYI3AgELMQ4wDAYKKwYBBAGCNwIBFTAvBgkqhkiG
// SIG // 9w0BCQQxIgQgozgTYZq8tDaxED/QRBAEhGOMClXT1gyM
// SIG // 28e9h2dx3nkwDQYJKoZIhvcNAQEBBQAEggEAZL64/H1K
// SIG // LWELWuliC+kyEBQ3bD6gw2dKmJEXLD9GQeFtpF6rSd0k
// SIG // cskSo4UKRII4hxBLArDiv74bTjihMwKP/2ksUdaEVCUA
// SIG // x5g1SP2OAMrjmNct0LhzWSD11bSVi1MvokcS5NnrPqhb
// SIG // FPFpIGghbyuAAKepOE2JHT/itDkx9Td4JvfG2VFtxvgr
// SIG // gMK+GKuarPys2yNWdk7Z6zdAQzoXXHgqP/BJPQu4fTI8
// SIG // o4ja/SkqtX+AdbQ9qVr/v1yZHeYExTyEqfT7msyJHZnJ
// SIG // z7PiP0YNMfR67n/KFh7NSwzrcwjU5va064iv53sygrzE
// SIG // miFshnnOgQTdB4e9UHkkOCkTuKGCDKEwggydBgorBgEE
// SIG // AYI3AwMBMYIMjTCCDIkGCSqGSIb3DQEHAqCCDHowggx2
// SIG // AgEDMQ8wDQYJYIZIAWUDBAIBBQAwgd0GCyqGSIb3DQEJ
// SIG // EAEEoIHNBIHKMIHHAgEBBgkrBgEEAaAyAgMwMTANBglg
// SIG // hkgBZQMEAgEFAAQgkQqcjnZH/yp42S9S2kvnnIOkuO8q
// SIG // ob1CWZbS1KaDf5QCFEtASgIZRpayx55Aqk9qPykxIr66
// SIG // GA8yMDE4MDEzMDA0NTExN1qgXaRbMFkxCzAJBgNVBAYT
// SIG // AlNHMR8wHQYDVQQKExZHTU8gR2xvYmFsU2lnbiBQdGUg
// SIG // THRkMSkwJwYDVQQDEyBHbG9iYWxTaWduIFRTQSBmb3Ig
// SIG // QWR2YW5jZWQgLSBHMqCCCMYwggSpMIIDkaADAgECAhIR
// SIG // IQbxD85o8Jv65VsYzY8gAXcwDQYJKoZIhvcNAQELBQAw
// SIG // WzELMAkGA1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNp
// SIG // Z24gbnYtc2ExMTAvBgNVBAMTKEdsb2JhbFNpZ24gVGlt
// SIG // ZXN0YW1waW5nIENBIC0gU0hBMjU2IC0gRzIwHhcNMTYw
// SIG // NTI0MDAwMDAwWhcNMjcwNjI0MDAwMDAwWjBZMQswCQYD
// SIG // VQQGEwJTRzEfMB0GA1UEChMWR01PIEdsb2JhbFNpZ24g
// SIG // UHRlIEx0ZDEpMCcGA1UEAxMgR2xvYmFsU2lnbiBUU0Eg
// SIG // Zm9yIEFkdmFuY2VkIC0gRzIwggEiMA0GCSqGSIb3DQEB
// SIG // AQUAA4IBDwAwggEKAoIBAQC3x5KKKNjzkctQDV3rKUTB
// SIG // glmlymTOvYO1UeWUzG6Amhds3P9i5jZDXgHCDGSNynee
// SIG // 9l13RbleyCTrQTcRZjesyM10m8yz70zifxvOc77Jlp01
// SIG // Hnz3VPds7KAS1q6ZnWPEeF9ZqS4i9cMn2LJbRWMnkP+M
// SIG // sT2ptPMOwPEgZQaJnQMco7BSQYU067zLzlT2Ev6zAYlK
// SIG // pvpUxR/70xzA47+X4z/QG/lAxxvV6yZ8QzDHcPJ4EaqF
// SIG // TqUODQBKOhF3o8ojAYCeyJNWXUbMitjSqgqEhbKJW9Uy
// SIG // zkF7GE5UyqvRUl4S0ySeVvMMj929ko551UGJw6Og5ZH8
// SIG // x2edhzPOcTJzAgMBAAGjggFnMIIBYzAOBgNVHQ8BAf8E
// SIG // BAMCB4AwTAYDVR0gBEUwQzBBBgkrBgEEAaAyAR4wNDAy
// SIG // BggrBgEFBQcCARYmaHR0cHM6Ly93d3cuZ2xvYmFsc2ln
// SIG // bi5jb20vcmVwb3NpdG9yeS8wCQYDVR0TBAIwADAWBgNV
// SIG // HSUBAf8EDDAKBggrBgEFBQcDCDBGBgNVHR8EPzA9MDug
// SIG // OaA3hjVodHRwOi8vY3JsLmdsb2JhbHNpZ24uY29tL2dz
// SIG // L2dzdGltZXN0YW1waW5nc2hhMmcyLmNybDBYBggrBgEF
// SIG // BQcBAQRMMEowSAYIKwYBBQUHMAKGPGh0dHA6Ly9zZWN1
// SIG // cmUuZ2xvYmFsc2lnbi5jb20vY2FjZXJ0L2dzdGltZXN0
// SIG // YW1waW5nc2hhMmcyLmNydDAdBgNVHQ4EFgQULW5u0Y3l
// SIG // A4Du52Ppp9naCzxXIj0wHwYDVR0jBBgwFoAUkiGnSpVd
// SIG // ZLCbtB7mADdH5p1BK0wwDQYJKoZIhvcNAQELBQADggEB
// SIG // AFedU+Td7qUs3uS/YoCiYYZKn5udJCMwm48nhy/6BFnO
// SIG // cIg9RlJ3xJtF0o+9tyEYSdguh/+SLnf5Pwr5oCFcE0/k
// SIG // hCsoh8xcFbkTq+ISVcP4RR5JGc6qdQ8h6O9R/DQsCzIF
// SIG // CbLkFmmt2S5+4fwtSL8a03Q1ATrfMENwZ3o417oRwlb7
// SIG // MUi6W/EhEmLgdomRH0k41FhNeQmKqdpvAtat5NqJfUzZ
// SIG // sTBwQGrbRbpTdpDcS0IWIc/k0liU1FVlm3YDrK4YCLaD
// SIG // EoxBPl+ARWTIidQzF6GhTL0/xJL+f4XyvrGs1/aey84T
// SIG // Ku4CQ0/8/3A1NKMzfM/iDTIkIHwAPqMyEd4wggQVMIIC
// SIG // /aADAgECAgsEAAAAAAExicZQBDANBgkqhkiG9w0BAQsF
// SIG // ADBMMSAwHgYDVQQLExdHbG9iYWxTaWduIFJvb3QgQ0Eg
// SIG // LSBSMzETMBEGA1UEChMKR2xvYmFsU2lnbjETMBEGA1UE
// SIG // AxMKR2xvYmFsU2lnbjAeFw0xMTA4MDIxMDAwMDBaFw0y
// SIG // OTAzMjkxMDAwMDBaMFsxCzAJBgNVBAYTAkJFMRkwFwYD
// SIG // VQQKExBHbG9iYWxTaWduIG52LXNhMTEwLwYDVQQDEyhH
// SIG // bG9iYWxTaWduIFRpbWVzdGFtcGluZyBDQSAtIFNIQTI1
// SIG // NiAtIEcyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIB
// SIG // CgKCAQEAqpuOw6sRUSUBtpaU4k/YwQj2RiPZRcWVl1ur
// SIG // Gr/SbFfJMwYfoA/GPH5TSHq/nYeer+7DjEfhQuzj46FK
// SIG // bAwXxKbBuc1b8R5EiY7+C94hWBPuTcjFZwscsrPxNHaR
// SIG // ossHbTfFoEcmAhWkkJGpeZ7X61edK3wi2BTX8QceeCI2
// SIG // a3d5r6/5f45O4bUIMf3q7UtxYowj8QM5j0R5tnYDV56t
// SIG // LwhG3NKMvPSOdM7IaGlRdhGLD10kWxlUPSbMQI2CJxtZ
// SIG // IH1Z9pOAjvgqOP1roEBlH1d2zFuOBE8sqNuEUBNPxtyL
// SIG // ufjdaUyI65x7MCb8eli7WbwUcpKBV7d2ydiACoBuCQID
// SIG // AQABo4HoMIHlMA4GA1UdDwEB/wQEAwIBBjASBgNVHRMB
// SIG // Af8ECDAGAQH/AgEAMB0GA1UdDgQWBBSSIadKlV1ksJu0
// SIG // HuYAN0fmnUErTDBHBgNVHSAEQDA+MDwGBFUdIAAwNDAy
// SIG // BggrBgEFBQcCARYmaHR0cHM6Ly93d3cuZ2xvYmFsc2ln
// SIG // bi5jb20vcmVwb3NpdG9yeS8wNgYDVR0fBC8wLTAroCmg
// SIG // J4YlaHR0cDovL2NybC5nbG9iYWxzaWduLm5ldC9yb290
// SIG // LXIzLmNybDAfBgNVHSMEGDAWgBSP8Et/qC5FJK5NUPpj
// SIG // move4t0bvDANBgkqhkiG9w0BAQsFAAOCAQEABFaCSnzQ
// SIG // zsm/NmbRvjWek2yX6AbOMRhZ+WxBX4AuwEIluBjH/NSx
// SIG // N8RooM8oagN0S2OXhXdhO9cv4/W9M6KSfREfnops7yyw
// SIG // 9GKNNnPRFjbxvF7stICYePzSdnno4SGU4B/EouGqZ9uz
// SIG // nHPlQCLPOc7b5neVp7uyy/YZhp2fyNSYBbJxb051rvE9
// SIG // ZGo7Xk5GpipdCJLxo/MddL9iDSOMXCo4ldLA1c3PiNof
// SIG // KLW6gWlkKrWmotVzr9xG2wSukdduxZi61EfEVnSAR3hY
// SIG // jL7vK/3sbL/RlPe/UOB74JD9IBh4GCJdCC6MHKCX8x2Z
// SIG // faOdkdMGRE4EbnocIOM28LZQuTGCArQwggKwAgEBMHEw
// SIG // WzELMAkGA1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNp
// SIG // Z24gbnYtc2ExMTAvBgNVBAMTKEdsb2JhbFNpZ24gVGlt
// SIG // ZXN0YW1waW5nIENBIC0gU0hBMjU2IC0gRzICEhEhBvEP
// SIG // zmjwm/rlWxjNjyABdzANBglghkgBZQMEAgEFAKCCARQw
// SIG // GgYJKoZIhvcNAQkDMQ0GCyqGSIb3DQEJEAEEMBwGCSqG
// SIG // SIb3DQEJBTEPFw0xODAxMzAwNDUxMTdaMC8GCSqGSIb3
// SIG // DQEJBDEiBCAgfMgEe77eqyBMSPThyloB/wmjoLYSto9/
// SIG // PcUUTSRNcTCBpgYLKoZIhvcNAQkQAgwxgZYwgZMwgZAw
// SIG // gY0EFH1V2OdaVqL8c4JD97hUh1xctSoNMHUwX6RdMFsx
// SIG // CzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWdu
// SIG // IG52LXNhMTEwLwYDVQQDEyhHbG9iYWxTaWduIFRpbWVz
// SIG // dGFtcGluZyBDQSAtIFNIQTI1NiAtIEcyAhIRIQbxD85o
// SIG // 8Jv65VsYzY8gAXcwDQYJKoZIhvcNAQEBBQAEggEAXmij
// SIG // BuHusaCp555G73WlOGfyuyR72QBD0mB8gkCF2F4YkfHv
// SIG // xV7k0oeTV23yOc3GwJgMUxibv8lvrz6p8j81YXvfvruh
// SIG // SFu8U0t7u/EXH87f36yYYU1SUbY48j3vc9NQe4HqBiuG
// SIG // bLovk5ZoXf37+3wnxGUZLg4gp8lvkorN5p6L3L8NODew
// SIG // CUus8jyrxbgUx1swHYdyMztQkRTZT6HhFJybYLrPQxlb
// SIG // YWc0k5d//nEfDEISSOWQF5M8I7srEj8lDIR6sgeJiyoO
// SIG // Nh05qqqCoTdsa9N8gQlEyW/aDziJhAtrLm1npEeITDfr
// SIG // Ld5kYFqF1LTvRcmT4z1Fvq9Tmszzyg==
// SIG // End signature block
