;;
;;  revert.lsp - REVERT command
;;
;;  Copyright  1999 by Autodesk, Inc.
;;
;;  Your use of this software is governed by the terms and conditions
;;  of the License Agreement you accepted prior to installation of this
;;  software.  Please note that pursuant to the License Agreement for this
;;  software, "[c]opying of this computer program or its documentation
;;  except as permitted by this License is copyright infringement under
;;  the laws of your country.  If you copy this computer program without
;;  permission of Autodesk, you are violating the law."
;;
;;  AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
;;  AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
;;  MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
;;  DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
;;  UNINTERRUPTED OR ERROR FREE.
;;
;;  Use, duplication, or disclosure by the U.S. Government is subject to
;;  restrictions set forth in FAR 52.227-19 (Commercial Computer
;;  Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
;;  (Rights in Technical Data and Computer Software), as applicable.
;;  
;;-------------------------------------------------------------------------
;;
;;  DESCRIPTION
;;    Implements the REVERT command.
;;
;;-------------------------------------------------------------------------
 
 
;;
;;  revert to previous saved version of this drawing
;;
(defun C:REVERT (/ dwg reply sdiOpen)
  ;;  special open for SDI mode
  (defun sdiOpen (name force)
    (vl-load-com)
    (vla-sendcommand
        (vla-get-activedocument
            (vlax-get-acad-object))
                (acet-str-format "(command \"_.OPEN\"%1)\n%2\n"
                                 (if force " \"_Y\"" "")
                                 name ) )
  )
 
  ;;  quiet
  (acet-error-init '(("CMDECHO" 0)))
  ;;  check for the necessary support code
  (if (acet-reg-get (strcat "HKEY_LOCAL_MACHINE\\"
                            (acet-reg-machine-prodkey)
                            "\\Applications\\acadvba\\commands" )
                    "VBASTMT" )
    ;;  worth trying ??
    (if (= 1 (getvar "DWGTITLED"))
      (progn
        ;;  pick file name
        (setq dwg (strcat (getvar "DWGPREFIX") (getvar "DWGNAME")))
        ;;  drawing modified ??
        (if (and (/= 0 (getvar "DBMOD"))
                 (= Acet:IDCANCEL
                    (acet-ui-message
                        (acet-str-format "Abandon changes to %1?" dwg)
                                         "AutoCAD - REVERT"
                                         (+ Acet:OKCANCEL
                                            Acet:ICONWARNING
                                            Acet:DEFBUTTON2 ) ) ) )
          (exit)
        )
        ;; SDI ??
        (if (/= 0 (getvar "SDI"))
          (sdiOpen dwg (/= 0 (getvar "DBMOD")))
          (command "_vbastmt" (acet-str-format
              "ThisDrawing.Close(FALSE):AcadApplication.Documents.Open \"%1\""
              dwg ) )
        )
      )
      (acet-ui-message "Drawing has never been saved."
                       "AutoCAD - REVERT"
                       Acet:ICONSTOP )
    )
    (acet-ui-message "VBA support not installed."
                     "AutoCAD - REVERT"
                     Acet:ICONSTOP )
  )
 
  (acet-error-restore)
  (princ)
)


(princ)
;;;-----BEGIN-SIGNATURE-----
;;; SgcAADCCB0YGCSqGSIb3DQEHAqCCBzcwggczAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
;;; 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
;;; qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
;;; XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
;;; Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
;;; OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
;;; FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
;;; LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
;;; dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
;;; CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
;;; G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
;;; c9v3Xoh1gTIPCte7VPsxggIsMIICKAIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQACKBlBC8LxrTI7g+IeJA1kJfVrvGK/26Hi
;;; u5T5d8dnJw53NYtorFCkPUkrn/Hpz3dAByLt32k1fcN+YOG4AQI5QBB3Ilc2Z9yq
;;; A/xro17cT0EG8BLiBIY+vcIFetJBnuyDEr/G2MVbO5oLWOkom+DnV++Zicocsfvb
;;; Sy4gAxmQufmzkh+4yz+f7qyjJo/1tUIE5RMoUiZo/lDZ/lhCcL+QGkEHZt/mSjuK
;;; WcDK+a7GkIu5TaiOJgohCars/O5vbNyS0nBDnbqnBm7FuZ8Tha1Y2H3TmWPb7RDK
;;; bDVFnBWXR5+Swxe81q0wJJPuiObuluLEIp1DaoCc5P9QuPxIci9EoWUwYwYDVR0O
;;; MVwEWjQAMQA7ADEALwAzADAALwAyADAAMQA4AC8ANAAvADUAMQAvADMANwAvAFQA
;;; aQBtAGUAIABmAHIAbwBtACAAdABoAGkAcwAgAGMAbwBtAHAAdQB0AGUAcgAAAA==
;;; -----END-SIGNATURE-----