;;
;;  qquit.lsp - QQUIT command
;;
;;  Copyright  2000 by Autodesk, Inc.
;;
;;  Your use of this software is governed by the terms and conditions
;;  of the License Agreement you accepted prior to installation of this
;;  software.  Please note that pursuant to the License Agreement for this
;;  software, "[c]opying of this computer program or its documentation
;;  except as permitted by this License is copyright infringement under
;;  the laws of your country.  If you copy this computer program without
;;  permission of Autodesk, you are violating the law."
;;
;;  AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
;;  AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
;;  MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
;;  DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
;;  UNINTERRUPTED OR ERROR FREE.
;;
;;  Use, duplication, or disclosure by the U.S. Government is subject to
;;  restrictions set forth in FAR 52.227-19 (Commercial Computer
;;  Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
;;  (Rights in Technical Data and Computer Software), as applicable.
;;  
;;-------------------------------------------------------------------------
;;
;;  DESCRIPTION
;;    Implements the QQUIT command.
;;
;;-------------------------------------------------------------------------
 
 
;;
;;  quick quit
;;
(defun C:QQUIT (/ item cur saveQuery)
  ;;  save if requested
  (defun saveQuery (item / titled writeable name reply)
    (vl-load-com)
    (setq titled (= 1 (vlax-variant-value (vla-getvariable item "DWGTITLED")))
          writeable (= 1 (vlax-variant-value (vla-getvariable item "WRITESTAT")))
          name (if titled
                 (vlax-get item "fullname")
                 (vlax-variant-value (vla-getvariable item "DWGNAME")) )
          reply (acet-ui-message
                    (acet-str-format "Save changes to %1?" name)
                                     "AutoCAD"
                                     (+ Acet:YESNOCANCEL Acet:ICONWARNING) ) )
    (cond
      ((= Acet:IDYES reply)
        (cond
          ;;  REFEDIT active ??
          ((/= "" (vlax-variant-value (vla-getvariable item "REFEDITNAME")))
            (acet-ui-message "Cannot Save while REFEDIT active."
                             "AutoCAD - QQUIT"
                             Acet:ICONSTOP )
            (exit)
          )
          ((and titled writeable)
            (vla-save item)
          )
          (T
            (if (setq name (ACET-FILE-WRITEDIALOG "Save Drawing As" name "dwg" "Acet:SaveAll" 1665))
              (vla-saveas item (vlax-make-variant name))
              (exit)
            )
          )
        )
      )
      ((= Acet:IDCANCEL reply)
        (exit) )
    )
  )
 
  ;;  only valid in MDI
  (vl-load-com)
  (if (= 0 (getvar "SDI"))
    (progn
      ;;  quiet
      (acet-error-init '(("CMDECHO" 0)))
      ;;  locate current doc
      (setq cur (vla-get-activedocument (vlax-get-acad-object)))
      ;;  for each doc
      (vlax-for item (vla-get-documents (vlax-get-acad-object))
        ;;  skip current doc
        (if (not (equal cur item))
          (progn
            ;;  save if modified ??
            (if (/= 0 (vlax-variant-value (vla-getvariable item "DBMOD")))
              (saveQuery item) )
            ;;  close without saving
            (vla-close item (vlax-make-variant :vlax-false))
          )
        )
      )
      ;;  close current
      (vla-sendcommand cur "_.QUIT ")
    )
    (command "_.QUIT")
  )
  (princ)
)


(vl-load-com)
(princ)

;;;-----BEGIN-SIGNATURE-----
;;; SgcAADCCB0YGCSqGSIb3DQEHAqCCBzcwggczAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
;;; 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
;;; qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
;;; XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
;;; Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
;;; OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
;;; FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
;;; LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
;;; dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
;;; CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
;;; G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
;;; c9v3Xoh1gTIPCte7VPsxggIsMIICKAIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQA/Z0hj6fyB/dor+VI2MKWBRarCro8KOcdX
;;; rCzUEwfqaCaO/2sql9rsPg5WGQ3KP/6ZN3P20K2njQ8zt/d59qfZJIspXkzlZbBx
;;; o5RK9MHZlI0v2OZZASSCkJaukoeQlfl+DwxgkoHEwTPwAbOVfy+BRrCy9aZuOYmt
;;; COmBLlJTS5sjZbfEeBJlovMPKQYrZqeazadNHLm5TkqWA2QFTLFSRSjis0flBGq/
;;; Pgl4JMcTvKLx9i2U0PBZ7lksd6ZVBfdQeUheP/HC9lnjUs7E1s0wkXn5cfmpMA2b
;;; iEFINLj2gk784j2TxWIpBP/c19lCZgnFXEtd+61BfvBI4/VJ795OoWUwYwYDVR0O
;;; MVwEWjQAMQA7ADEALwAzADAALwAyADAAMQA4AC8ANAAvADUAMQAvADMANwAvAFQA
;;; aQBtAGUAIABmAHIAbwBtACAAdABoAGkAcwAgAGMAbwBtAHAAdQB0AGUAcgAAAA==
;;; -----END-SIGNATURE-----