;;
;;  explan.lsp - Express Tools plan replacement command
;;                    
;;
;;  Copyright  1999 by Autodesk, Inc.
;;
;;  Your use of this software is governed by the terms and conditions
;;  of the License Agreement you accepted prior to installation of this
;;  software.  Please note that pursuant to the License Agreement for this
;;  software, "[c]opying of this computer program or its documentation
;;  except as permitted by this License is copyright infringement under
;;  the laws of your country.  If you copy this computer program without
;;  permission of Autodesk, you are violating the law."
;;
;;  AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
;;  AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
;;  MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
;;  DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
;;  UNINTERRUPTED OR ERROR FREE.
;;
;;
;; Description:
;;  Similar to PLAN except that EXPLAN automatically zooms to the center 
;; of the extents of selected objects after performing a plan view to
;; the specified ucs. i.e. In other words; it keeps the zoom distance 
;; consistant.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
(defun c:explan ( / ss c s lst d )
 (acet-error-init 
   (list '( "cmdecho" 0
            "ucsicon" nil
          ) 
         1
         '(setq ACET:UCS-LIST nil)
   );list
 )
 (setq s (getvar "viewsize"))
 (princ "\nSelect objects to zoom to or press <enter> to select everything on screen...")
 (if (and (setq ss (ssget))
          (setq c (acet-geom-ss-extents ss nil))
     );and
     (setq c (acet-geom-midpoint (car c) (cadr c)));setq then
     (progn
      (setq lst (acet-explan-view-extents)
            lst (acet-geom-m-trans lst 0 1)
            lst (acet-geom-cube-points lst)
            lst (acet-geom-list-extents lst)
              c (acet-geom-midpoint (car lst) (cadr lst))
              d (distance (car lst) (cadr lst))
      );setq
      (if (> d s)
          (setq s (/ (+ d s) 2.0));then use the average of the two
      );if
      ;(command "_.line" c pause "")
     );progn else
 );if
 (princ "\nEnter an option [Current ucs/Ucs/World] <Current>: ")
 (command "_.plan")
 (setvar "cmdecho" 1)
 (while (wcmatch (getvar "cmdnames") "*PLAN*")
  (command pause)
 );while
 (setvar "cmdecho" 0)
 (if c
     (command "_.zoom" "_c" c s)
 );if
 (acet-error-restore)
);defun c:explan
 
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Selects everything  on screen and uses the extents of that combined with the screen 
;corcer points to determine the center point (wcs) to use for the zoom after the plan 
;command.
;Returns list of points in wcs
;
(defun acet-explan-view-extents ( / ss p1 p2 p3 p4 lst px )
 (princ "\nSelecting objects on screen...")
 (acet-sysvar-set (list "ucsicon" 0))
 (acet-ucs-cmd (list "_view"))
 (setq  p1 (acet-geom-view-points)
        p2 (cadr p1)
        p1 (car p1)
        px (acet-geom-pixel-unit)
        p1 (list (+ (car p1) px)
                 (+ (cadr p1) px)
                 (caddr p1)
           )
        p2 (list (- (car p2) px)
                 (- (cadr p2) px)
                 (caddr p2)
           )
 );setq
 (if (or (setq ss (ssget "_w" p1 p2))
         (setq ss (ssget "_c" p1 p2))
     );or
     (setq p3 (acet-geom-ss-extents ss nil) ;no shrinkwrap
           p4 (cadr p3)
           p3 (car p3)
           p1 (list (car p1)		;; combine the view extents xy with extents of objects in z
                    (cadr p1)
                    (min (caddr p3) (caddr p4))
              )
           p2 (list (car p2)
                    (cadr p2)
                    (max (caddr p3) (caddr p4))
              )
     );setq then
 );if
 (setq lst (acet-geom-cube-points (list p1 p2)) ;generate the remaining points based on lower left and upper right
       lst (acet-geom-m-trans lst 1 0)
 );setq
 (acet-ucs-cmd (list "_previous"))
 (acet-sysvar-restore)
 (princ "Done")
 lst
);defun acet-explan-view-extents
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Returns a list of 8 points 4 top and 4 bottom.
;
(defun acet-geom-cube-points ( lst / p1 p2 z1 z2 )
 (setq lst (acet-geom-list-extents lst)
        p1 (car lst)
        p2 (cadr lst)
        z1 (min (caddr p1) (caddr p2))
        z2 (max (caddr p1) (caddr p2))
 );setq
 (list (list (car p1) (cadr p1) z1)
       (list (car p2) (cadr p1) z1)
       (list (car p2) (cadr p2) z1)
       (list (car p1) (cadr p2) z1)
       (list (car p1) (cadr p1) z2)
       (list (car p2) (cadr p1) z2)
       (list (car p2) (cadr p2) z2)
       (list (car p1) (cadr p2) z2)
 );list
);defun acet-geom-cube-points


(princ)
;;;-----BEGIN-SIGNATURE-----
;;; SgcAADCCB0YGCSqGSIb3DQEHAqCCBzcwggczAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
;;; 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
;;; qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
;;; XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
;;; Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
;;; OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
;;; FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
;;; LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
;;; dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
;;; CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
;;; G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
;;; c9v3Xoh1gTIPCte7VPsxggIsMIICKAIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQBU/DcZODhRpZGT8l//txx0Y3YG93vgZ30u
;;; ZAHI4Ph8CRgnKVSpiDP5+D2tWhKdEkP4f13jJApMnVBbXUfIbc4BEKcp3SwEUaxn
;;; skpD+hucvxXHs/H4sLrY0rHb+0fvPOw7n9rqDArKMXnbz16YO6HHzs44c5faKJdh
;;; dhgz6aIyJuX2yJLOCTtDdXlGVQaNagsvTYKn2uZR0K5cgFmpFlkMdjlFnvUe8dpU
;;; UkiBkO9j0dHj77JVmr2OPF0nsiEM0FbbkqAbeMnMnUSBAoWRD7FrTjYujzqiaelm
;;; I3vCYZVCrPILpp5dUWZxc898WoBcoYjZ6/Pe2iuOmq6dTAceESvWoWUwYwYDVR0O
;;; MVwEWjQAMQA7ADEALwAzADAALwAyADAAMQA4AC8ANAAvADUAMQAvADMANAAvAFQA
;;; aQBtAGUAIABmAHIAbwBtACAAdABoAGkAcwAgAGMAbwBtAHAAdQB0AGUAcgAAAA==
;;; -----END-SIGNATURE-----