;;;
;;;    ASPACE.LSP - C:ALIGNSPACE Written by Randy Kintzley
;;;    Copyright  1999 by Autodesk, Inc.
;;;
;;;    Your use of this software is governed by the terms and conditions of the
;;;    License Agreement you accepted prior to installation of this software.
;;;    Please note that pursuant to the License Agreement for this software,
;;;    "[c]opying of this computer program or its documentation except as
;;;    permitted by this License is copyright infringement under the laws of
;;;    your country.  If you copy this computer program without permission of
;;;    Autodesk, you are violating the law."
;;;
;;;    AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
;;;    AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
;;;    MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
;;;    DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
;;;    UNINTERRUPTED OR ERROR FREE.
;;;
;;;    Use, duplication, or disclosure by the U.S. Government is subject to
;;;    restrictions set forth in FAR 52.227-19 (Commercial Computer
;;;    Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
;;;    (Rights in Technical Data and Computer Software), as applicable.
;;;
;;;  ----------------------------------------------------------------
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 
;  Align-SPACE
(defun c:alignspace ( / ss2 p1 p2 p3 p4 flag flag2 a)
 
(acet-error-init
 (list (list   "cmdecho" 0
             "regenmode" 1
             "ucsfollow" 0
       );list
       T
 );list
);acet-error-init
 
(cond
 ((not (equal 0 (getvar "tilemode")))
  (princ "\n  Command not allowed unless TILEMODE is set to 0  ")
 );cond #1
 ((and (setq flag (acet-viewport-next-pickable))
       (car flag)
  );and
  (progn
   (command "_.mspace")
   (if (not (equal (car flag) (getvar "cvport")))
       (progn
        (princ "\nPicking in perspective view not allowed...")
        (princ "\nSwitching to next available model space viewport")
        (setvar "cvport" (car flag))
       );progn then
   );if
   (while (not flag2)
    (if (setq p1 (getpoint "\nFIRST alignment point in MODEL space: "))
        (progn
         (setq p2
               (getpoint p1 "\nSECOND point in MODEL space or <Return> for none: ")
         );setq
         (setq p1 (trans p1 1 0))
         (if p2
             (setq p2 (trans p2 1 0))
         )
        );progn then
    );if
    (if (and p1
             (equal p1 p2)
        );and
        (princ "\n*Invalid* Points cannot be the same.")
        (setq flag2 T)
    );if
   );while
   (if p1
       (progn
        (command "_.pspace")
        (setq flag2 nil)
        (while (not flag2)
         (if p2
             (setq a "\nFIRST alignment point in PAPER space: ")
             (setq a "\nAlignment point in PAPER space: ")
         );if
         (if (and (setq p3 (getpoint a))
                  p2
             );and
             (setq p4 (getpoint p3 "\nSECOND alignment point in PAPER space: "))
         );if
         (if (and p3
                  (equal p3 p4)
             );and
             (princ "\n*Invalid* Points cannot be the same.")
             (setq flag2 T)
         );if
        );while
        (setq flag2 nil)
        (command "_.mspace")
        (if (and (setq ss2 (ssget "_x" '((0 . "VIEWPORT") (67 . 1))));setq
                 (= (sslength ss2) 2)
            );and
            (setq flag2 T)
        );if
        (while (not flag2)
         (getstring "\nActivate the desired viewport to align and press ENTER to continue.")
         (if (equal (getvar "cvport")
                    (car (setq flag (acet-viewport-next-pickable)))
             );equal
             (setq flag2 T)
             (progn
              (princ "\n*Invalid*")
              (princ (strcat "\nCannot use viewports that are turned"
                             " off or have perspective view on."
                     )
              );princ
             );progn
         );if
        );while
        (if (or (and p1
                     (not p2)
                     p3
                     (not p4)
                );and
                (and p1 p2 p3 p4);and
            );or
            (alignspace p1 p2 p3 p4)
        );if
       );progn then got 2 model space points
   );if
  );progn
 );cond #2
 ((cadr flag)
  (princ (cadr flag))
 );cond #3
);cond close
 
(acet-error-restore)
(princ)
);defun c:aspace
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;takes two points in model space (p1 p2) and zooms in the current viewport to align
;it visually woith the two matching point in paper space (p3 p4).
;if p2 and p4 are nil then no view scaling occurrs and only p1 is matched to p3.
;NOTE model space points must be provided in world coords.
;
(defun alignspace ( p1 p2 p3 p4 / vp a b c d na vplocked )
 
(if (= 1 (getvar "cvport"))
    (command "_.mspace")
);if
(setq       na (acet-currentviewport-ename)
      vplocked (acet-viewport-lock-set na nil) ;unlock the viewport if needed.
                                               ;sets vplocked to the ename of viewport if locked/nil if not
);setq
 
(command "_.pspace")
(setq p3 (trans p3 1 3))
(if p4
    (setq p4 (trans p4 1 3))
);if
 
(command "_.mspace")
 
(acet-ucs-cmd (list "_view"))
 
(setq p1 (trans p1 0 1));setq
(if p2
    (setq p2 (trans p2 0 1))
);if
 
(if (not p2)
    (progn
     (setq vp (acet-currentviewport-ename)
           vp (entget vp)
           vp (cdr (assoc 41 vp))
            a (/ vp (getvar "viewsize"))
     );setq
    );progn
    (setq p2 (list (car p2) (cadr p2) (caddr p1)) ;rk added 5:39 PM 9/1/97
          p4 (list (car p4) (cadr p4) (caddr p3))
           a (/ (distance p3 p4)
                (distance p1 p2)
             )
    );setq else
);if
 
(setq c (trans p3 3 2)
      c (trans c 2 1)
);setq
(if p4
    (setq d (trans p4 3 2)
          d (trans d 2 1)
    );setq
);if
(if (and p2
         p4
         (not (equal (angle p1 p2) (angle c d) 0.0001))
    );and
    (progn
     (acet-ucs-cmd (list "_z" (* (- (angle p1 p2) (angle c d))
                              (/ 180.0 pi)
                           )
                   );list
     );acet-ucs-cmd
     (command "_.plan" "_c")
     (acet-ucs-cmd (list "_p"))
    );progn then
);if
(if (and p2 p4)
    (command "_.zoom" (strcat (rtos a 2 6) "xp"))
);if
(setq b (trans p3 3 2)
      b (trans b 2 1)
);setq
(command "_.-pan" p1 b)
 
;restore the original ucs
(acet-ucs-cmd (list "_p"))
 
(if vplocked
    (acet-viewport-lock-set na T) ;re-lock the viewport
)
 
(if (and p2 p4
         (or (not (equal (caddr p1) (caddr p2) 0.0001))
             (not (equal (caddr c) (caddr d) 0.0001))
         );or
    );and
    (progn
     (princ "\nWarning: Selected Points are not parallel to view")
     (princ "\nCommand results may not be obvious")
    );progn
);if
(princ "\nPaper space = Model space")
(princ (strcat "\n"
               (substr "             " 1
                       (max (- 11 (strlen (rtos 1.0))) 0)
               );substr
               (rtos 1.0)
               " = "
               (rtos (/ 1.0 a))
       );strcat
);princ
(princ (strcat "\nCurrent zoom factor = " (rtos a) "xp"))
);defun alignspace


(princ)

;;;-----BEGIN-SIGNATURE-----
;;; SgcAADCCB0YGCSqGSIb3DQEHAqCCBzcwggczAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
;;; DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
;;; YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
;;; MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
;;; IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
;;; BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
;;; FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
;;; b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
;;; AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
;;; 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
;;; qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
;;; XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
;;; Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
;;; OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
;;; MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
;;; MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
;;; eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
;;; cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
;;; IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
;;; STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
;;; aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
;;; FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
;;; LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
;;; dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
;;; CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
;;; G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
;;; c9v3Xoh1gTIPCte7VPsxggIsMIICKAIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
;;; BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
;;; cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
;;; b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
;;; AQsFADANBgkqhkiG9w0BAQEFAASCAQCYVgNI9R3ud/zggXyw5WNq9VADMksyB7zQ
;;; XiCwxyEF0l3hglpAc58USCiX5W/JaQiteDMug68YHJQ8LMf+88SChx21sEjyNTTh
;;; ovu4zJzUURZMo9mHSaE26j9D98gvZR9OG+ONIqqLCm+3W5cvNT6gbq6mgFvor7Yu
;;; UudloTeXVsn2JCFIfOr8oKkNPE7LMLRVZQPFhJs1LVRGk6iR3mvmR92HGzHtGnUl
;;; pEhcNkAyzT9iYyr3WWKmxknHZZ84zHMUuVgO9WV3IXSUEOuNY/QiS37TphPX33E2
;;; cR/X3lqyg5RbGVkFbn/j0R7eGwDfhDKowW3VQhwotshLMU8lRWH4oWUwYwYDVR0O
;;; MVwEWjQAMQA7ADEALwAzADAALwAyADAAMQA4AC8ANAAvADUAMQAvADMAMQAvAFQA
;;; aQBtAGUAIABmAHIAbwBtACAAdABoAGkAcwAgAGMAbwBtAHAAdQB0AGUAcgAAAA==
;;; -----END-SIGNATURE-----