#ifndef _PC_STYLIZATION_VERTEX_COMMON_REGION_H_
#define _PC_STYLIZATION_VERTEX_COMMON_REGION_H_

#include "VertexCommon.h"

#define MAX_LAYERS                       64     // 64 layers with different color.

// region map

Texture1D gRegionTex;
sampler RegionSamplerPoint= 
sampler_state
{
    Texture = <gRegionTex>;
    MipFilter = POINT;
    MinFilter = POINT;
    MagFilter = POINT;
	AddressU = CLAMP;
}; 

int gRegionCount;
float gRegionScale;
float gRegionFactor;
int   gGlobalRegionIndex;

int RegionIndex(int index)
{
    return (gGlobalRegionIndex == -1)?index:gGlobalRegionIndex;
}

// internal used method
float4 InternelGetRegion(int regionIndex)
{
    float samplePos = (float) (regionIndex+0.5f)/(float)gRegionCount*gRegionScale;
    
    float4 RegionInfo = tex1Dlod(RegionSamplerPoint,float4(samplePos,0.0f,0.0f,0.0f));
    
    return RegionInfo;
}

#endif