// App controller.
(function($, UTILS) {
	$.widget('adsk.appcontroller', {
		options: {
		    config: {},
            defaultPageId: 'topic',
            targetId: 'browser',
            controllers: undefined,
            viewControllers: undefined,
            tocDataConsumers: undefined,
            orientationData: undefined,
            searchRootData: undefined
		},

        /* Private members. */

		_view: undefined,

		_create: function() {
		    console.log('appcontroller: _create');

            // Initialize rooting with hashbang.
            this._addHashchangeHandler();

		    this._createView();

		    // Hide main preloader after all initialization complete.
            this._togglePreloader();
		},

		_processHashAtStartup: function() {
		    console.log('appcontroller: _processHashAtStartup');

            var hash = '',
                search = location.search;

            if (location.hash == '' && search.indexOf('?') == 0) {
                hash = search.replace(/\?/, '#!/');
            } else {
                hash = location.hash;
            }

            this._processHash(hash);
        },

		_createView: function() {
            console.log('appcontroller: createView');

            // Create app view.
            var selector = '#'.concat(this.options.targetId);

            $(selector).appview({
                create:             $.proxy(this._viewCreateHandler, this),
                orientationchange:  $.proxy(this._handleDeviceOrientation, this),
                resize:             $.proxy(this._resize, this)
            });
		},

		_viewCreateHandler: function(event, orientationData) {
		    console.log('appcontroller: _viewCreateHandler, ');

		    this._view = $(event.target).appview("instance");

		    this.options.orientationData = orientationData;

            // Create controllers.
            this._createControllers();

            // TEST
            this._processHashAtStartup();

            // Resize.
            this._resize(event, orientationData);

            // Open default page (topic, navigation, search etc.).
            this._makePageCurrentById(this.options.defaultPageId);
		},

		_createControllers: function() {
		    console.log('appcontroller: _createControllers');

            // Init controllers.
            var viewControllers = this.options.viewControllers = {},
                tocConsumers    = this.options.tocDataConsumers = {},
                controllers     = this.options.controllers = {};

            tocConsumers.favoritesController = viewControllers.favoritesController = $.adsk.favoritescontroller();

            tocConsumers.topicController = viewControllers.topicController = $.adsk.topiccontroller({
                showpage:               $.proxy(this._handleShowPage, this),
                back:                   $.proxy(this._backToPreviousPage, this),
                defaultTopicHref:       this.options.config.defaultPage,
                opentopic:              $.proxy(this._handleOpentopic, this),
                favoritesController:    viewControllers.favoritesController,
                setsuggestiondata:      $.proxy(this._handleSetSuggestionData, this),
                orientationData:        this.options.orientationData
            });

            // TODO: use config to specify default tab.
            tocConsumers.navigationController = viewControllers.navigationController = $.adsk.navigationcontroller({
                defaultTab: 'toc',
                showpage:   $.proxy(this._handleShowPage, this),
                back:       $.proxy(this._backToPreviousPage, this),
                opentopic:  $.proxy(this._handleOpentopic, this),
                closepage:  $.proxy(this._handleCloseSearchResultPage, this),
                setsuggestiondata: $.proxy(this._handleSetSuggestionData, this),
                controllers: {
                    favoritesController: viewControllers.favoritesController
                }
            });

            // Create search controller and observe its events.
            tocConsumers.searchController = viewControllers.searchController = $.adsk.searchcontroller({
                back:                   $.proxy(this._backToPreviousPage, this),
                showsearchresult:       $.proxy(this._showSearchResultPage, this),
                orientationData:        this.options.orientationData
            });

            tocConsumers.searchResultController = viewControllers.searchResultController = $.adsk.searchresultcontroller({
                back:               $.proxy(this._backToPreviousPage, this),
                orientationData:    this.options.orientationData
            });

            controllers.tocController = $.adsk.tocdatacontroller({
                indexed: $.proxy(this._setTocData, this)
            });
		},

		_handleShowPage: function(event, data) {
		    console.log('appcontroller: _handleShowPage');

            this._makePageCurrentById(data.id);
        },

        _makePageCurrentById: function(id) {
             console.log('appcontroller: _makePageCurrentById, ', id);

             this._view.makePageCurrentById(id);

             // Refresh navigation.
             if (id === 'navigation') {
                 this.options.viewControllers.navigationController.refresh();
             }
        },

		_insertHeadMetadata: function() {
		    console.log('appcontroller: _insertHeadMetadata');

            // Get rid of browser URL and button bars.
            UTILS.insertMeta('apple-mobile-web-app-capable', 'yes');

            // Set iOS status bar color to black.
            UTILS.insertMeta('apple-mobile-web-app-status-bar-style', 'black');
		},

		_setTocData: function(event, data) {
		    console.log('appcontroller: _setTocData');

            $.each(this.options.tocDataConsumers, function(index, controller) {
                if (controller.setTocData) {
                    controller.setTocData(data);
                }
            });

            // Let's try to show default topic content.
            this._processHashAtStartup();
        },

        _resize: function(event, orientationData) {
            console.log('appcontroller: _resize');

            // Invoke view controllers resize.
            $.each(this.options.viewControllers, function(index, controller) {
                if (controller.resize) {
                    controller.resize(orientationData);
                }
            });
        },

        _handleDeviceOrientation: function(event, data) {
            console.log('appcontroller: _handleDeviceOrientation');

            // Change layout only if orientation actually changed.
            var orientationData = this.options.orientationData;

            if (data.orientation !== orientationData.orientation) {
                orientationData = data;
            }

            this._resize({}, orientationData);
        },

        _handleOpentopic: function(event, data) {
            console.log('appcontroller: _handleOpentopic, data = ', data);

            // Change location hash to open provided topic.
            if (data === undefined || data.href === undefined || data.href == '') {
                return;
            }

            var hash = (data.href);
            this._setHash('#!/url=' + data.href);

            // Show topic view.
            this._makePageCurrentById('topic');
        },

        _handleSetSuggestionData: function(event, data) {
            console.log('appcontroller: _handleSetSuggestionData');

            this.options.searchRootData = data.type;
            this.options.viewControllers.searchController.setSearchData(data);
        },

        _handleCloseSearchResultPage: function(event, id) {
            console.log('appcontroller: _handleCloseSearchResultPage');
            this.options.viewControllers.searchResultController.closeSearchResultPage();
        },

        _showSearchResultPage: function(event, data) {
            console.log('appcontroller: _handleOpenSearchResult');

            var searchRootData = this.options.searchRootData;
            this.options.viewControllers.searchResultController.processingSearchResults(searchRootData, data.term);
            this._makePageCurrentById(data.id);
        },

        _backToPreviousPage: function() {
            console.log('appcontroller: _backToPreviousPage');

            this._view.backToPreviousPage();
        },

		// Show/hide main preloader.
		_togglePreloader: function() {
		    console.log('appcontroller: _togglePreloader');

            $(document.body).toggleClass('loading');
        },

        _addHashchangeHandler: function() {
            console.log('appcontroller: _addHashchangeHandler');

            // Listen to hash change.
            if ('onhashchange' in window) {
                $(window).on('hashchange', $.proxy(this._handleHashchange, this));
            } else {
                setInterval(this._checkHash, 400);
            }
        },

        _handleHashchange: function(event, data) {
            console.log('appcontroller: _handleHashchange');
            var newHash = location.hash;
            this._processHash(newHash);
        },

        _checkHash: function() {
            console.log('appcontroller: _checkHash');

        },

        _processHash: function(hash) {
            console.log('appcontroller: _processHash, ', hash);

            if (!hash || hash == '') {
                // Load default topic.
                this._handleOpentopic({}, {
                    href: this.options.config.defaultPage
                });
            }

            // If hash starts with hashbang, crop it off.
            var url = this._fetchUrlFromHash(hash);

            if (!url || url == '') {
                // Do nothing.
                return;
            }

            this._processUrl(url);
        },

        _fetchUrlFromHash: function(hash) {
            console.log('appcontroller: _fetchUrlFromHash');

            var url = '';

            if (hash.indexOf('#!') == 0) {
                url = hash.substring(2);
            } else if (hash[0] == '#') {
                url = hash.substring(1);
            } else {
                url = hash;
            }

            return url;
        },

        _processUrl: function(url) {
            console.log('appcontroller: _processUrl: ', url);

            if (url.indexOf('/url=') == 0) {
                // Resolve internal path.
                this._resolveUrl(url);
            }
        },

        _resolveUrl: function(url) {
            console.log('appcontroller: _resolveUrl: ', url);

            var href = url.substring('/url='.length);

            if (!href || href == '') {
                return;
            }

            // Load topic content.
            this.options.viewControllers.topicController.openTopic({
                href: href
            });
        },

        _setHash: function(hash) {
            console.log('appcontroller: _setHash: ', hash);

            if (!hash || hash == '') {
                return;
            }

            if (hash[0] != '#') {
                return;
            }

            location.hash = hash;
        }

        /* Public members. */

    });
})(jQuery, ADSK.UTILS);
// SIG // Begin signature block
// SIG // MIIXrwYJKoZIhvcNAQcCoIIXoDCCF5wCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFCKfFgaKxFG9
// SIG // e0WXe21c2+UqdtHMoIIS3zCCA+4wggNXoAMCAQICEH6T
// SIG // 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
// SIG // CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
// SIG // cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
// SIG // EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
// SIG // Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
// SIG // aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
// SIG // NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
// SIG // bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
// SIG // bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
// SIG // RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
// SIG // AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
// SIG // FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
// SIG // a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
// SIG // AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
// SIG // +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
// SIG // 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
// SIG // 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
// SIG // RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
// SIG // gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
// SIG // gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
// SIG // aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
// SIG // CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
// SIG // Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
// SIG // bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
// SIG // VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
// SIG // VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
// SIG // BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
// SIG // nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
// SIG // sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
// SIG // JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
// SIG // g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
// SIG // UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
// SIG // BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
// SIG // dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
// SIG // MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
// SIG // AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
// SIG // cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
// SIG // sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
// SIG // duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
// SIG // TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
// SIG // YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
// SIG // vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
// SIG // nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
// SIG // 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
// SIG // EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
// SIG // FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
// SIG // BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
// SIG // AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
// SIG // MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
// SIG // bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
// SIG // MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
// SIG // ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
// SIG // MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
// SIG // VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
// SIG // IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
// SIG // SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
// SIG // st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
// SIG // JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
// SIG // dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
// SIG // bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
// SIG // K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
// SIG // SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
// SIG // ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
// SIG // w7wc2AR1MIIE5TCCA82gAwIBAgIQGGKWU9W9DKB4gLDR
// SIG // /Nm99TANBgkqhkiG9w0BAQsFADB/MQswCQYDVQQGEwJV
// SIG // UzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24x
// SIG // HzAdBgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsx
// SIG // MDAuBgNVBAMTJ1N5bWFudGVjIENsYXNzIDMgU0hBMjU2
// SIG // IENvZGUgU2lnbmluZyBDQTAeFw0xNjAxMjgwMDAwMDBa
// SIG // Fw0xODA0MTAyMzU5NTlaMH0xCzAJBgNVBAYTAkNIMRIw
// SIG // EAYDVQQIEwlOZXVjaGF0ZWwxEjAQBgNVBAcTCU5ldWNo
// SIG // YXRlbDEiMCAGA1UEChQZQXV0b2Rlc2sgRGV2ZWxvcG1l
// SIG // bnQgU2FybDEiMCAGA1UEAxQZQXV0b2Rlc2sgRGV2ZWxv
// SIG // cG1lbnQgU2FybDCCASIwDQYJKoZIhvcNAQEBBQADggEP
// SIG // ADCCAQoCggEBALOBje/8PFtBHV0+YQz+EJZzXU+JAy6j
// SIG // OhMiK0n4pWQrgLdfLmoNZUvUL5AVuWoHkzK4f6WLWEjQ
// SIG // eGR4SEZcvDCJjol0n6vdsYAfRurwhekestab635tKUEy
// SIG // JRNKXhC4zuDSgryc+2zUsZa08HSHZaTsFGZzEuQAdxWf
// SIG // iyvD6G5oTu72nj3kDWWn3vqh+zyGkOIhtsIDKZyHpg71
// SIG // 7hPiqEe96bX5LpZgkSOJdAdwpl40NEUFfpNdelT2sOCh
// SIG // MfG63Dg2PR6EjOK5zHgMZm09mPgZBfyNoBV03C1ySSUi
// SIG // UsAHM2ND4wnGfl/GbYEgIVQXWlspRbtpRHTaNavebLJY
// SIG // tWECAwEAAaOCAV0wggFZMAkGA1UdEwQCMAAwDgYDVR0P
// SIG // AQH/BAQDAgeAMCsGA1UdHwQkMCIwIKAeoByGGmh0dHA6
// SIG // Ly9zdi5zeW1jYi5jb20vc3YuY3JsMGEGA1UdIARaMFgw
// SIG // VgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8v
// SIG // ZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0
// SIG // dHBzOi8vZC5zeW1jYi5jb20vcnBhMBMGA1UdJQQMMAoG
// SIG // CCsGAQUFBwMDMFcGCCsGAQUFBwEBBEswSTAfBggrBgEF
// SIG // BQcwAYYTaHR0cDovL3N2LnN5bWNkLmNvbTAmBggrBgEF
// SIG // BQcwAoYaaHR0cDovL3N2LnN5bWNiLmNvbS9zdi5jcnQw
// SIG // HwYDVR0jBBgwFoAUljtT8Hkzl699g+8uK8zKt4YecmYw
// SIG // HQYDVR0OBBYEFHqJl6/oWFvaZKJVCptH8DQRl8JIMA0G
// SIG // CSqGSIb3DQEBCwUAA4IBAQAXhA6ZwymxqqV+k4uKThLd
// SIG // PgPsvZBRcCJJZi3eYMl7HjIDbxSdx03ueVc/Sx3n9OUK
// SIG // U+DupPpLFUnKUJa/X8HPWhcvJftXom9NvGWbYPJM7CBc
// SIG // eTKuXgP5ffKwf1r9pJhok0pEhSA8b6N97pmKQwJDE6XI
// SIG // Z4M5FYw9YELKPRCHhinZCfPHLo+0GxaH+W4AbGd1N2BZ
// SIG // dX2egsgNTGBnC6xGxGMC8ckaj5wyIm4LgklE0pKbxuG9
// SIG // 075426gJ6ASAtCevNViBj9hH3TcNy4aU0ruH6By5gZaR
// SIG // 5lc7ZdaTuBWz0+4wGIK1IiviMSJv19v+h0vpEyn1b8sE
// SIG // 6L7D8JD4szHnMIIFWTCCBEGgAwIBAgIQPXjX+XZJYLJh
// SIG // ffTwHsqGKjANBgkqhkiG9w0BAQsFADCByjELMAkGA1UE
// SIG // BhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8w
// SIG // HQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTow
// SIG // OAYDVQQLEzEoYykgMjAwNiBWZXJpU2lnbiwgSW5jLiAt
// SIG // IEZvciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQD
// SIG // EzxWZXJpU2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5
// SIG // IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzUwHhcN
// SIG // MTMxMjEwMDAwMDAwWhcNMjMxMjA5MjM1OTU5WjB/MQsw
// SIG // CQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29y
// SIG // cG9yYXRpb24xHzAdBgNVBAsTFlN5bWFudGVjIFRydXN0
// SIG // IE5ldHdvcmsxMDAuBgNVBAMTJ1N5bWFudGVjIENsYXNz
// SIG // IDMgU0hBMjU2IENvZGUgU2lnbmluZyBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAJeDHgAWryyx
// SIG // 0gjE12iTUWAecfbiR7TbWE0jYmq0v1obUfejDRh3aLvY
// SIG // NqsvIVDanvPnXydOC8KXyAlwk6naXA1OpA2RoLTsFM6R
// SIG // clQuzqPbROlSGz9BPMpK5KrA6DmrU8wh0MzPf5vmwsxY
// SIG // aoIV7j02zxzFlwckjvF7vjEtPW7ctZlCn0thlV8ccO4X
// SIG // fduL5WGJeMdoG68ReBqYrsRVR1PZszLWoQ5GQMWXkorR
// SIG // U6eZW4U1V9Pqk2JhIArHMHckEU1ig7a6e2iCMe5lyt/5
// SIG // 1Y2yNdyMK29qclxghJzyDJRewFZSAEjM0/ilfd4v1xPk
// SIG // OKiE1Ua4E4bCG53qWjjdm9sCAwEAAaOCAYMwggF/MC8G
// SIG // CCsGAQUFBwEBBCMwITAfBggrBgEFBQcwAYYTaHR0cDov
// SIG // L3MyLnN5bWNiLmNvbTASBgNVHRMBAf8ECDAGAQH/AgEA
// SIG // MGwGA1UdIARlMGMwYQYLYIZIAYb4RQEHFwMwUjAmBggr
// SIG // BgEFBQcCARYaaHR0cDovL3d3dy5zeW1hdXRoLmNvbS9j
// SIG // cHMwKAYIKwYBBQUHAgIwHBoaaHR0cDovL3d3dy5zeW1h
// SIG // dXRoLmNvbS9ycGEwMAYDVR0fBCkwJzAloCOgIYYfaHR0
// SIG // cDovL3MxLnN5bWNiLmNvbS9wY2EzLWc1LmNybDAdBgNV
// SIG // HSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwMwDgYDVR0P
// SIG // AQH/BAQDAgEGMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQD
// SIG // ExFTeW1hbnRlY1BLSS0xLTU2NzAdBgNVHQ4EFgQUljtT
// SIG // 8Hkzl699g+8uK8zKt4YecmYwHwYDVR0jBBgwFoAUf9Nl
// SIG // p8Ld7LvwMAnzQzn6Aq8zMTMwDQYJKoZIhvcNAQELBQAD
// SIG // ggEBABOFGh5pqTf3oL2kr34dYVP+nYxeDKZ1HngXI939
// SIG // 7BoDVTn7cZXHZVqnjjDSRFph23Bv2iEFwi5zuknx0ZP+
// SIG // XcnNXgPgiZ4/dB7X9ziLqdbPuzUvM1ioklbRyE07guZ5
// SIG // hBb8KLCxR/Mdoj7uh9mmf6RWpT+thC4p3ny8qKqjPQQB
// SIG // 6rqTog5QIikXTIfkOhFf1qQliZsFay+0yQFMJ3sLrBkF
// SIG // IqBgFT/ayftNTI/7cmd3/SeUx7o1DohJ/o39KK9KEr0N
// SIG // s5cF3kQMFfo2KwPcwVAB8aERXRTl4r0nS1S+K4ReD6bD
// SIG // dAUK75fDiSKxH3fzvc1D1PFMqT+1i4SvZPLQFCExggQ8
// SIG // MIIEOAIBATCBkzB/MQswCQYDVQQGEwJVUzEdMBsGA1UE
// SIG // ChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAdBgNVBAsT
// SIG // FlN5bWFudGVjIFRydXN0IE5ldHdvcmsxMDAuBgNVBAMT
// SIG // J1N5bWFudGVjIENsYXNzIDMgU0hBMjU2IENvZGUgU2ln
// SIG // bmluZyBDQQIQGGKWU9W9DKB4gLDR/Nm99TAJBgUrDgMC
// SIG // GgUAoHAwEAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcN
// SIG // AQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEO
// SIG // MAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFA/Z
// SIG // o0eqBr9ga9XMJluX4wbu3MMYMA0GCSqGSIb3DQEBAQUA
// SIG // BIIBAEcKVk8YXehK/4av4HChWEKoFrly/6oOrJ2lt4K5
// SIG // cgNx9ev6VV9JDQu16+MCEVAqdP22u0qFueevLBtqTwos
// SIG // a+twYRP4BF4PxW21KCspJlGwMSB2FO2/VT10RMNa74nL
// SIG // RlU4v9U7M75eWXYA1Hp49L4VkRiX3O/73rnesrMUz5+8
// SIG // qVeav3snluemZrbS91rD1kFb13a8x7nIv5CsSX2I+R5g
// SIG // CDuiLi6jTnCSC9TLVfbjytFxHq85muOEj/HbWUQ6zTtc
// SIG // wDxdz2KMxn6j0AQYvbCECtrNzlrD4FoKrdKpO0j+O6am
// SIG // Uez98nq8FLM3DJB28wtuPfO/hvCiMznhh28baQOhggIL
// SIG // MIICBwYJKoZIhvcNAQkGMYIB+DCCAfQCAQEwcjBeMQsw
// SIG // CQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29y
// SIG // cG9yYXRpb24xMDAuBgNVBAMTJ1N5bWFudGVjIFRpbWUg
// SIG // U3RhbXBpbmcgU2VydmljZXMgQ0EgLSBHMgIQDs/0OMj+
// SIG // vzVuBNhqmBsaUDAJBgUrDgMCGgUAoF0wGAYJKoZIhvcN
// SIG // AQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUxDxcN
// SIG // MTYwMjE1MDM1NzEzWjAjBgkqhkiG9w0BCQQxFgQUy+q/
// SIG // Y1za7gtTto2RqqTz08MzI1wwDQYJKoZIhvcNAQEBBQAE
// SIG // ggEAO0ROLewiEfvQF4Bg/+rm34ULgs/yZi5sTwRbDAV/
// SIG // Rxs7c8+nftT3QrHlqYORP5tjVDb3wLWoaKcpGjATJJ+Q
// SIG // KC+nMtV4bXPDZVpsxtCZTzTPJ5K9NxZbGH0ntTbY/h79
// SIG // KeNqfk/1Wb+qbVJMNTcgjwG5REaLrzpDtrS7X1okZFLI
// SIG // PDjDQVDXV0rO/NsRdxXf4YLQkgUAc7Kh98jhK+pilsCb
// SIG // fhPtrQghcqF4PieFmkAwgwIm/rFrjfaAoQNt+i9+Ny2Z
// SIG // CDFuIpyx84bQ/H7Y5VJx7hIdzkk0Qvc3X6OiO2NQh0sN
// SIG // Shu1aUgADUDEoorgPU9H1hnTBp9sXxfD5XqUgg==
// SIG // End signature block
