// Index view (in form of jQuery widget).
(function($, UTILS) {

    $.widget('adsk.indexscrollertabview', {
		options: {
			caption: "Index",
            data:undefined,
            prevItemTopScope:undefined,
            prevItemBottomScope:undefined,
            previousIndexScrollerBigLetter:undefined
		},

        _create: function() {
            console.log('indextabview: _create');
			// Render view.
			this._render();

//            this.testVar = $('#navigation > .toolbar > .center');

            // Handle UI events.
		},
		
		_render: function() {
            console.log('indextabview: _render');
			// Create markup.
            this._initIndexContent();
            this._initIndexScroller();
		},

        _initIndexContent:function () {
            console.log('indextabview: _initIndexContent');
        },

        _initIndexScroller:function () {
            console.log('indextabview: _initIndexScroller');
        },

        initIndexABCScroller:function (indexData) {
            console.log('indextabview: _initIndexScroller');
            this.indexABC = $(document.createElement('div'))
                .attr('id', 'index-abc')
                .addClass('index-abc')
                .appendTo(this.element);
            var index_scroller = $(document.createElement('ul')).addClass('index-abc-list');
            var data = indexData.data;
            for (var l in data) {
                var letter = data[l];
                var letter_item = $(document.createElement('li')).addClass('index-abc-item');
                var small_letter = $(document.createElement('div')).addClass('index-scroller-letter').html(letter.l).appendTo(letter_item);
                letter_item.appendTo(index_scroller);
            }
            this.big_letter = $(document.createElement('div')).addClass('index-scroller-big-letter');
            $([this.big_letter.get(0), index_scroller.get(0)]).appendTo(this.indexABC);
        },

        initEventHandlers:function () {
            var $element = this.indexABC;
            console.log('indextabview: _initEventHandlers');

            var self = this;
            var ABCElem = document.getElementById($element.attr('id'));
            var ABCElemLeftScope = ABCElem.offsetLeft;
            var ABCElemTopScope = ABCElem.offsetTop;
            var ABCElemBottomScope = ABCElemTopScope + ABCElem.offsetHeight - 2;
            var ABCList = ABCElem.getElementsByTagName('ul')[0];
            var ABCListLeftScope = ABCList.offsetLeft;
            var ABCListWidth = ABCList.offsetWidth;
            var ABCListCenter = Math.floor(ABCElemLeftScope + ABCListLeftScope + (ABCListWidth / 2));
//            this.testVar.text(ABCElemLeftScope + '  '+ABCElemTopScope);

            var indexContent = $('#tab-index > .index-content');

            ABCElem.addEventListener('touchstart', function (event) {
                event.preventDefault();
                if(navigator.userAgent.match(/Android/i)){
                    indexContent.css({overflow:'hidden'});
                }
                if (event.targetTouches.length == 1) {
                    var touch = event.targetTouches[0];
                    var xPos = touch.clientX;
                    var yPos = touch.clientY;

                    if (xPos >= ABCElemLeftScope) {
                        var $ABCScroller = $(this.children[1]);
                        self.options.prevItemTopScope = undefined;
                        self.options.prevItemBottomScope = undefined;
                        $ABCScroller.addClass('touched');
                    }
                    if (yPos <= ABCElemBottomScope) {
                        self._scrollIndex(event, ABCListCenter, yPos);
                    }
                }
            }, false);

            ABCElem.addEventListener('touchend', function (event) {
                var $bigLetterElem = $(this.children[0]);
                var $ABCScroller = $(this.children[1]);
                $bigLetterElem.removeClass('displayed');
                $ABCScroller.removeClass('touched');
                if(navigator.userAgent.match(/Android/i)){
                    indexContent.css({overflow:''});
                }
            }, false);

            ABCElem.addEventListener('touchmove', function (event) {
                event.stopPropagation();
                if (event.targetTouches.length == 1) {
                    var touch = event.targetTouches[0];
                    var xPos = touch.clientX;
                    var yPosition = touch.clientY;
                    var currentListItem = document.elementFromPoint(ABCListCenter, yPosition);
                    if (xPos >= ABCElemLeftScope && yPosition <= ABCElemBottomScope) {
                        var currentListItemBottomScope = ABCElemTopScope + currentListItem.offsetTop + currentListItem.offsetHeight;
                        var currentListItemTopScope = ABCElemTopScope + currentListItem.offsetTop;
                        if (currentListItemBottomScope != self.options.prevItemBottomScope && currentListItemTopScope != self.options.prevItemTopScope) {
                            self.options.prevItemTopScope = currentListItemTopScope;
                            self.options.prevItemBottomScope = currentListItemBottomScope;
                            self._scrollIndex(event, ABCListCenter, yPosition);
                        }
                    }
                }
            }, false);

            this.element.on('touchmove', $.proxy(function(event) {
                // Prevent bubbling to enable native scrolling.
                event.stopPropagation();
            }, this));

        },

        _scrollIndex:function (event, xPos, yPos) {
            console.log('indextabview: _scrollIndex');

            var scrollerElement = document.elementFromPoint(xPos, yPos);
//            this.testVar.text(scrollerElement.className);

            if (scrollerElement.className == 'index-scroller-letter') {
                this._createBigLetter(this.big_letter, scrollerElement, xPos, yPos);
            }

            var indexElement = getIndexElement(scrollerElement);
            if (indexElement) {
                indexElement.scrollIntoView();
            }

            function getIndexElement(scrollerElement) {
                var result;
                var indexLetters = document.getElementsByClassName('index-letter-group');
                for (var i = 0; i < indexLetters.length; i++) {
                    if (indexLetters[i].innerHTML === scrollerElement.innerHTML) {
                        result = indexLetters[i];
                    }
                }
                return result
            }
        },

        _createBigLetter:function (bigLetter, elem, xPos, yPos) {
//            console.log('indextabview: _createBigLetter');

            var bigLetterHtml = $(elem).find('.index-scroller-letter').andSelf().filter('.index-scroller-letter').text();
            if (elem && bigLetterHtml !== this.options.previousIndexScrollerBigLetter) {
                bigLetter.html(bigLetterHtml).css({'position':'fixed','top':yPos-20 , 'left':xPos-70});
                this.options.previousIndexScrollerBigLetter = bigLetterHtml;
                bigLetter.addClass('displayed');
            }
        },

        changeScrollerSize:function () {
            console.log('indextabview: changeScrollerSize');

            var $elem = this.indexABC;
            var height = 380;
            var fontSize = 8;
            var elemTopPadding = 40;
            var innerHeight = window.innerHeight;
            var elemHeight = innerHeight - elemTopPadding - 10;
            var multiplier = innerHeight / height;

            var listItems = $elem[0].getElementsByClassName('index-scroller-letter');
            var listItemsLength = listItems.length;
            var listItemHeight = Math.floor(elemHeight/listItemsLength);
            for(var i = 0; i<listItemsLength; i++){
                $(listItems[i]).css({height:listItemHeight+'px', lineHeight:listItemHeight+'px'})
            }
            if (innerHeight >= height) {
                fontSize = Math.floor(fontSize * multiplier);
            }
            $elem.css({height:elemHeight,fontSize:fontSize + 'px', top:elemTopPadding});
        },

        initIndexItemList:function (indexData) {
            console.log('indextabview: initIndexItemList');

            var indexItemDiv = $(document.createElement('div')).addClass('index-item-div').appendTo(this.element);
            var data = indexData.data;
            for (var l in data) {
                var letter = data[l];
                var letter_div = $(document.createElement('div')).addClass('index-letter-group').addClass('index-item').html(letter.l);
                indexItemDiv.append(letter_div);
                this._render_children(indexItemDiv, letter.c);
            }
        },

        _render_children:function (parent, children) {
            console.log('indextabview: _render_children');

            var entriesDiv = $(document.createElement('div')).addClass('entries-div');
            for (var i in children) {
                var child = children[i];
                var grandchildren = child.c;

                var div = $(document.createElement('div')).addClass('index-entry-text').addClass('index-item');
                var link = $(document.createElement('a')).addClass('index-link').attr('href', child.f).html(child.l);
                if (grandchildren) {
                    link = link.addClass('index-caption');
                }
                div.append(link);

                if (grandchildren) {
                    var indent_div = $(document.createElement('div')).addClass('index-entry');
                    this._render_children(indent_div, grandchildren);
                    div.append(indent_div);
                }
                entriesDiv.append(div);
            }
            entriesDiv.appendTo(parent);
        }

	});
})(jQuery);
// SIG // Begin signature block
// SIG // MIIXrwYJKoZIhvcNAQcCoIIXoDCCF5wCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFCIsc4oa0e9K
// SIG // 4zMLczj3cKZja8e4oIIS3zCCA+4wggNXoAMCAQICEH6T
// SIG // 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
// SIG // CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
// SIG // cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
// SIG // EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
// SIG // Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
// SIG // aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
// SIG // NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
// SIG // bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
// SIG // bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
// SIG // RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
// SIG // AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
// SIG // FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
// SIG // a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
// SIG // AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
// SIG // +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
// SIG // 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
// SIG // 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
// SIG // RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
// SIG // gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
// SIG // gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
// SIG // aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
// SIG // CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
// SIG // Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
// SIG // bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
// SIG // VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
// SIG // VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
// SIG // BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
// SIG // nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
// SIG // sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
// SIG // JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
// SIG // g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
// SIG // UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
// SIG // BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
// SIG // dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
// SIG // MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
// SIG // AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
// SIG // cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
// SIG // sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
// SIG // duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
// SIG // TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
// SIG // YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
// SIG // vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
// SIG // nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
// SIG // 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
// SIG // EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
// SIG // FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
// SIG // BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
// SIG // AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
// SIG // MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
// SIG // bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
// SIG // MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
// SIG // ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
// SIG // MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
// SIG // VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
// SIG // IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
// SIG // SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
// SIG // st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
// SIG // JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
// SIG // dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
// SIG // bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
// SIG // K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
// SIG // SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
// SIG // ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
// SIG // w7wc2AR1MIIE5TCCA82gAwIBAgIQGGKWU9W9DKB4gLDR
// SIG // /Nm99TANBgkqhkiG9w0BAQsFADB/MQswCQYDVQQGEwJV
// SIG // UzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24x
// SIG // HzAdBgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsx
// SIG // MDAuBgNVBAMTJ1N5bWFudGVjIENsYXNzIDMgU0hBMjU2
// SIG // IENvZGUgU2lnbmluZyBDQTAeFw0xNjAxMjgwMDAwMDBa
// SIG // Fw0xODA0MTAyMzU5NTlaMH0xCzAJBgNVBAYTAkNIMRIw
// SIG // EAYDVQQIEwlOZXVjaGF0ZWwxEjAQBgNVBAcTCU5ldWNo
// SIG // YXRlbDEiMCAGA1UEChQZQXV0b2Rlc2sgRGV2ZWxvcG1l
// SIG // bnQgU2FybDEiMCAGA1UEAxQZQXV0b2Rlc2sgRGV2ZWxv
// SIG // cG1lbnQgU2FybDCCASIwDQYJKoZIhvcNAQEBBQADggEP
// SIG // ADCCAQoCggEBALOBje/8PFtBHV0+YQz+EJZzXU+JAy6j
// SIG // OhMiK0n4pWQrgLdfLmoNZUvUL5AVuWoHkzK4f6WLWEjQ
// SIG // eGR4SEZcvDCJjol0n6vdsYAfRurwhekestab635tKUEy
// SIG // JRNKXhC4zuDSgryc+2zUsZa08HSHZaTsFGZzEuQAdxWf
// SIG // iyvD6G5oTu72nj3kDWWn3vqh+zyGkOIhtsIDKZyHpg71
// SIG // 7hPiqEe96bX5LpZgkSOJdAdwpl40NEUFfpNdelT2sOCh
// SIG // MfG63Dg2PR6EjOK5zHgMZm09mPgZBfyNoBV03C1ySSUi
// SIG // UsAHM2ND4wnGfl/GbYEgIVQXWlspRbtpRHTaNavebLJY
// SIG // tWECAwEAAaOCAV0wggFZMAkGA1UdEwQCMAAwDgYDVR0P
// SIG // AQH/BAQDAgeAMCsGA1UdHwQkMCIwIKAeoByGGmh0dHA6
// SIG // Ly9zdi5zeW1jYi5jb20vc3YuY3JsMGEGA1UdIARaMFgw
// SIG // VgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8v
// SIG // ZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0
// SIG // dHBzOi8vZC5zeW1jYi5jb20vcnBhMBMGA1UdJQQMMAoG
// SIG // CCsGAQUFBwMDMFcGCCsGAQUFBwEBBEswSTAfBggrBgEF
// SIG // BQcwAYYTaHR0cDovL3N2LnN5bWNkLmNvbTAmBggrBgEF
// SIG // BQcwAoYaaHR0cDovL3N2LnN5bWNiLmNvbS9zdi5jcnQw
// SIG // HwYDVR0jBBgwFoAUljtT8Hkzl699g+8uK8zKt4YecmYw
// SIG // HQYDVR0OBBYEFHqJl6/oWFvaZKJVCptH8DQRl8JIMA0G
// SIG // CSqGSIb3DQEBCwUAA4IBAQAXhA6ZwymxqqV+k4uKThLd
// SIG // PgPsvZBRcCJJZi3eYMl7HjIDbxSdx03ueVc/Sx3n9OUK
// SIG // U+DupPpLFUnKUJa/X8HPWhcvJftXom9NvGWbYPJM7CBc
// SIG // eTKuXgP5ffKwf1r9pJhok0pEhSA8b6N97pmKQwJDE6XI
// SIG // Z4M5FYw9YELKPRCHhinZCfPHLo+0GxaH+W4AbGd1N2BZ
// SIG // dX2egsgNTGBnC6xGxGMC8ckaj5wyIm4LgklE0pKbxuG9
// SIG // 075426gJ6ASAtCevNViBj9hH3TcNy4aU0ruH6By5gZaR
// SIG // 5lc7ZdaTuBWz0+4wGIK1IiviMSJv19v+h0vpEyn1b8sE
// SIG // 6L7D8JD4szHnMIIFWTCCBEGgAwIBAgIQPXjX+XZJYLJh
// SIG // ffTwHsqGKjANBgkqhkiG9w0BAQsFADCByjELMAkGA1UE
// SIG // BhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8w
// SIG // HQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTow
// SIG // OAYDVQQLEzEoYykgMjAwNiBWZXJpU2lnbiwgSW5jLiAt
// SIG // IEZvciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQD
// SIG // EzxWZXJpU2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5
// SIG // IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzUwHhcN
// SIG // MTMxMjEwMDAwMDAwWhcNMjMxMjA5MjM1OTU5WjB/MQsw
// SIG // CQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29y
// SIG // cG9yYXRpb24xHzAdBgNVBAsTFlN5bWFudGVjIFRydXN0
// SIG // IE5ldHdvcmsxMDAuBgNVBAMTJ1N5bWFudGVjIENsYXNz
// SIG // IDMgU0hBMjU2IENvZGUgU2lnbmluZyBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAJeDHgAWryyx
// SIG // 0gjE12iTUWAecfbiR7TbWE0jYmq0v1obUfejDRh3aLvY
// SIG // NqsvIVDanvPnXydOC8KXyAlwk6naXA1OpA2RoLTsFM6R
// SIG // clQuzqPbROlSGz9BPMpK5KrA6DmrU8wh0MzPf5vmwsxY
// SIG // aoIV7j02zxzFlwckjvF7vjEtPW7ctZlCn0thlV8ccO4X
// SIG // fduL5WGJeMdoG68ReBqYrsRVR1PZszLWoQ5GQMWXkorR
// SIG // U6eZW4U1V9Pqk2JhIArHMHckEU1ig7a6e2iCMe5lyt/5
// SIG // 1Y2yNdyMK29qclxghJzyDJRewFZSAEjM0/ilfd4v1xPk
// SIG // OKiE1Ua4E4bCG53qWjjdm9sCAwEAAaOCAYMwggF/MC8G
// SIG // CCsGAQUFBwEBBCMwITAfBggrBgEFBQcwAYYTaHR0cDov
// SIG // L3MyLnN5bWNiLmNvbTASBgNVHRMBAf8ECDAGAQH/AgEA
// SIG // MGwGA1UdIARlMGMwYQYLYIZIAYb4RQEHFwMwUjAmBggr
// SIG // BgEFBQcCARYaaHR0cDovL3d3dy5zeW1hdXRoLmNvbS9j
// SIG // cHMwKAYIKwYBBQUHAgIwHBoaaHR0cDovL3d3dy5zeW1h
// SIG // dXRoLmNvbS9ycGEwMAYDVR0fBCkwJzAloCOgIYYfaHR0
// SIG // cDovL3MxLnN5bWNiLmNvbS9wY2EzLWc1LmNybDAdBgNV
// SIG // HSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwMwDgYDVR0P
// SIG // AQH/BAQDAgEGMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQD
// SIG // ExFTeW1hbnRlY1BLSS0xLTU2NzAdBgNVHQ4EFgQUljtT
// SIG // 8Hkzl699g+8uK8zKt4YecmYwHwYDVR0jBBgwFoAUf9Nl
// SIG // p8Ld7LvwMAnzQzn6Aq8zMTMwDQYJKoZIhvcNAQELBQAD
// SIG // ggEBABOFGh5pqTf3oL2kr34dYVP+nYxeDKZ1HngXI939
// SIG // 7BoDVTn7cZXHZVqnjjDSRFph23Bv2iEFwi5zuknx0ZP+
// SIG // XcnNXgPgiZ4/dB7X9ziLqdbPuzUvM1ioklbRyE07guZ5
// SIG // hBb8KLCxR/Mdoj7uh9mmf6RWpT+thC4p3ny8qKqjPQQB
// SIG // 6rqTog5QIikXTIfkOhFf1qQliZsFay+0yQFMJ3sLrBkF
// SIG // IqBgFT/ayftNTI/7cmd3/SeUx7o1DohJ/o39KK9KEr0N
// SIG // s5cF3kQMFfo2KwPcwVAB8aERXRTl4r0nS1S+K4ReD6bD
// SIG // dAUK75fDiSKxH3fzvc1D1PFMqT+1i4SvZPLQFCExggQ8
// SIG // MIIEOAIBATCBkzB/MQswCQYDVQQGEwJVUzEdMBsGA1UE
// SIG // ChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAdBgNVBAsT
// SIG // FlN5bWFudGVjIFRydXN0IE5ldHdvcmsxMDAuBgNVBAMT
// SIG // J1N5bWFudGVjIENsYXNzIDMgU0hBMjU2IENvZGUgU2ln
// SIG // bmluZyBDQQIQGGKWU9W9DKB4gLDR/Nm99TAJBgUrDgMC
// SIG // GgUAoHAwEAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcN
// SIG // AQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEO
// SIG // MAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFL7I
// SIG // YGo6FtG0We2yNnMbulkufrLzMA0GCSqGSIb3DQEBAQUA
// SIG // BIIBAIhmiSRfpW7A8VEzfwIbTV1K6ontRKfVMDqi2d1g
// SIG // EMhDxaB5SoJarOCDxT1e7o+8KktghhZ07QHXi+b6bRVz
// SIG // j6ajv9DMPmzmF3JT4UCSr6y5oL68ZHkp0I03MwfvMG52
// SIG // aYox4BODmeOIMuX/baqoEj7BAb37IrCJNQj+XbYBztyO
// SIG // W92AcW3/gBEJQYShT5INflMp0yTv1FzoL52MbWfxWZSK
// SIG // t7/71NaA6NY8HzNm+nYTL8qJgfegjyqtD938+MVZ7OvI
// SIG // 7h4E6/hc3Ss9hoZs/YT4MxiZuZ7QDeO6ArjnIlUlPo9u
// SIG // TB9TE8c9jwX6PTgqISRjdz0YT9SRi5Q/sGfkQF2hggIL
// SIG // MIICBwYJKoZIhvcNAQkGMYIB+DCCAfQCAQEwcjBeMQsw
// SIG // CQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29y
// SIG // cG9yYXRpb24xMDAuBgNVBAMTJ1N5bWFudGVjIFRpbWUg
// SIG // U3RhbXBpbmcgU2VydmljZXMgQ0EgLSBHMgIQDs/0OMj+
// SIG // vzVuBNhqmBsaUDAJBgUrDgMCGgUAoF0wGAYJKoZIhvcN
// SIG // AQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUxDxcN
// SIG // MTYwMjE1MDM1NzEzWjAjBgkqhkiG9w0BCQQxFgQU5/1i
// SIG // Ohf3RzjT9Izz78QJDb++GcowDQYJKoZIhvcNAQEBBQAE
// SIG // ggEAh8Aa4D6xTECojmfcTMcBzF6ZgcsNXPAKko5AZZPG
// SIG // sa/qV5f5IZZQZGiQ+2GRMpHszS8LLc9RQpG4PbFqWt9S
// SIG // Y7n4Td0RG2t6jNkDiYc0McurFB+Tbj46l0e6QYQi1SMB
// SIG // QCg8D6u61ADoef9iNvJndNQhkD+0BmrSrP6pdiqXu5+M
// SIG // zZoivEpAi1kZVABd5zAh63HYfZB+cEA4LKI0rNQkRNTQ
// SIG // /8BP9fy1UV29FyFfCnpz6LFr0k0pI5B6A+toMtHhGAMg
// SIG // DKE+UQjx2hPHDavvdOdvFgTyVLVXO4ZfLl0WYXal4zZw
// SIG // 8qaczXUyabnV9XLdWyQHAKc5Sn4l4fbDPC4cMA==
// SIG // End signature block
