// Topic view.
(function($, UTILS) {

	$.widget('adsk.topicview', {
		options: {

		},

		/* Private members. */

		_$preloader: undefined,
		_$content: undefined,

        _create: function() {
            console.log('topicview: _create');

            // Create layout.
            this._render();

            // Show preloader animation.
            this.showPreloader();

            this._addEventHandlers();
        },

        _render: function() {
            console.log('topicview: _render');

            // Create app view markup.
            this.element
            .html('<div class="block-preloader"></div>' +
                  '<div class="content">Topic content</div>');

            this._$preloader = this.element.find('.block-preloader');
            this._$content = this.element.find('.content');
        },

        _addEventHandlers: function() {
            console.log('topicview: _addEventHandlers');

            var self = this,
                href = location.href;
        },

        _isAbsolutePath: function(path) {
            // Check if path is fully qualified.
            if ( /^[A-Za-z]+:\/\//.test(path) ) return true;
            if ( path.indexOf("//") == 0 ) return true;
            return false;
        },

        _flattenRelativeResourcePath: function(src, base) {
            var changedSrc = src;

            if (src && !this._isAbsolutePath(src)) {
                if (!base) {
                    base = './files/';
                }

                if (src.indexOf('../') == 0) {
                    // ../images/image.png.

                    // Strip "move up to one folder" command.
                    changedSrc = src.substr(1);
                } else {
                    // ./image.png or images.png

                    // Remove './'.
                    if (src.indexOf('./') == 0) {
                        src = src.substr(2);
                    }

                    changedSrc = base.concat(src);
                }

                return changedSrc;
            }
        },

        // book with root dir specified: base = './filesBOOK/'
        // root book: base = './files/'
        _changeHyperlinkHref: function(hyperlink, base) {
            var href = hyperlink.getAttribute('href'),
                url = (href) ? href.replace(/^\s+|\s+$/, "") : href, // href.trim()
                changedUrl = url,
                target = hyperlink.getAttribute('target');

            if (url && !this._isAbsolutePath(url)) {
                // Not anchor and not absolute url.

                if (url.indexOf('../') == 0) {
                    // "Move up one folder" relative path (cases 3, 4 and 5).

                    // Strip "move up to one folder" command.
                    changedUrl = url.substr(1);

                    if (target !== '_blank') {
                         // Add hashbang (case 5).
                         changedUrl = '#!/url='.concat(changedUrl);
                    }
                } else if ((url.charAt(0) != '#') &&
                           (url.indexOf('mailto:') != 0) &&
                           (url.indexOf('javascript') != 0)) {
                    // "Current folder" relative path (topic.htm or ./topic.htm).

                    // Remove './'.
                    if (url.indexOf('./') == 0) {
                        url = url.substr(2);
                    }

                    // Add hashbang and base path (e.g. #!url=./files/topic.htm)
                    changedUrl = '#!/url='.concat(base, url);
                } else if (url == '#') {
                    changedUrl = location.hash;
                }

                hyperlink.setAttribute('href', changedUrl);
            }
        },

        _doCommentsHyperlinkHandler: function(topicPath) {
            // Display the comments page.
            var title = document.title;

            // Remove question marks from title.
            title = title.replace(/[\?]/g, '_');

            var href = decodeURIComponent(location.href);
            // Strip hash and all that follows.
            href = href.replace(/#.*$/, '');

            var index = href.lastIndexOf("/");
                helpPath = href.substring(0, index + 1),
                url = helpPath + topicPath + '#' + title + ' [' + location.href + ']',
                specs = "height=450,width=450,resizable=yes,directories=no,location=no,menubar=no,status=no,toolbar=no";

            // Display a fixed height window with none of the browser chrome.
            window.open(url, null, specs);
        },

        _showFallbackWhenNoSourceCouldBeDecoded: function(video) {
            var $video = $(video),
                $lastSource = $video.children('source').last();

            $lastSource.error(function() {
                $video.replaceWith($video.children('.embed-container'));
            });
        },

        ﻿ _replaceObjectWithItsCopy: function(object) {
                    ﻿
            var div = document.createElement('div'),
                params = document.createElement('div'),
                classid = " classid='clsid:D27CDB6E-AE6D-11cf-96B8-444553540000'";

            $(params).append( $(object).children('param') );

            // IE’s proprietary classid attribute and 'movie' param need to be created together,
            // as well as 'flashvars' param (otherwise its value will not be passed to Flash).
            var html = 	"<object" + classid + ">" +
                            params.innerHTML +
                            object.innerHTML +
                        "</object>";

            div.innerHTML = html;

            var obj = div.firstChild;

            obj.setAttribute("type", object.getAttribute('type'));
            obj.setAttribute("data", object.getAttribute('data'));
            obj.setAttribute("id", object.getAttribute('id'));

            // Replace targeted DOM element with our new <object>.
            object.parentNode.replaceChild(obj, object);
        },

        /* Public members. */

        showPreloader: function() {
            console.log('topicview: showPreloader');

            this._$preloader.show();
        },

        hidePreloader: function() {
            console.log('topicview: hidePreloader');

            this._$preloader.fadeOut();
        },

        showTopicContent: function(content, base) {
            console.log('topicview: showTopicContent');

            // Parse a string into an array of DOM nodes.
            // var html = $.parseHTML(content);
            // this._$content.html(html);
            this.showPreloader();

            // Replace src attribute with data-src to prevent jQuery html()
            // from triggering the browser request images.
            content = content.replace(/ src=/g, ' data-src=');

            var topic = $(document.createElement('div'));

            // Set the HTML content.
            topic.html(content);

            var bodyContent = topic.find('#body-content'),
                self = this;

            if (bodyContent.length == 0) {
                bodyContent = topic;
            }

            // Replace <a> elements href attribute value.
            bodyContent.find('a, area').each(function() {
                self._changeHyperlinkHref(this, base);
            });

            // Open comments page by user click.
            bodyContent.find('a.comments-anchor').click(function(event) {
                event.preventDefault();
                self._doCommentsHyperlinkHandler(this.getAttribute('href'));
            });

            // Showing fallback content when no source could be decoded.
            bodyContent.find('video').each(function() {
                self._showFallbackWhenNoSourceCouldBeDecoded(this);
            });

            // Flatten <source> element @src attribute value.
            bodyContent.find('source').each(function() {
                this.setAttribute('src', self._flattenRelativeResourcePath(this.getAttribute('data-src')));
            });

            // Flatten @data attribute value.
            bodyContent.find('object[data]').each(function() {
                this.setAttribute('data', self._flattenRelativeResourcePath(this.getAttribute('data')));
            });

            // Flatten <param name="movie"> @value.
            bodyContent.find('param[name=movie]').each(function() {
                this.setAttribute('value', self._flattenRelativeResourcePath(this.getAttribute('value')));
            });

            // Replace current objects with copies to deal with IE issue when dynamically changed values not honored.
            var isMSIE = /*@cc_on!@*/false;
            if (isMSIE) {
                bodyContent.find('object[data]').each(function() {
                    self._replaceObjectWithItsCopy(this);
                });
            }

            // Add src attributes to <img> elements with slightly changed value of data-src attribute.
            var images = bodyContent.find('img');
            images.each(function() {
                this.setAttribute('src', self._flattenRelativeResourcePath(this.getAttribute('data-src')));
            });

            // Add src attributes to <embed> elements with slightly changed value of data-src attribute.
            var embeds = bodyContent.find('embed');
            embeds.each(function() {
                this.setAttribute('src', self._flattenRelativeResourcePath(this.getAttribute('data-src')));
            });

            // Launch details (collapsible section) polyfill.
            bodyContent.find('details').details();

            // To avoid memory leaks, jQuery removes other constructs such as data and event handlers
            // from the child elements before removing the elements themselves.
            this._$content.empty().append(bodyContent);

            topic = bodyContent = null;

            $(window).trigger('topic-loaded');

            this.hidePreloader();
        },

        highlight: function(searchOptions) {
            // Get topic content except RAWMT banner.
            var $bodyContent = this._$content.children('.body_content');

            $bodyContent.removeHighlight();

            if (searchOptions.highlightEnabled) {
                var query = searchOptions.searchQuery,
                    lenient = searchOptions.caseInsensitiveEnabled;

                if (query && query !== '') {
                    // Highlight whole phrase.
                    $bodyContent.highlight(query, lenient);

                    // Highlight words.
                    if (searchOptions.searchMethod !== 'phrase') {
                        var words = query.split(" ");

                        $(words).each(function(index, word) {
                            if (word && word !== '') {
                                $bodyContent.highlight(word, lenient);
                            }
                        })
                    }
                }
            }
        },

        scrollToFragment: function(href) {
            // Scroll to anchor.
            if (href.lastIndexOf('#') != -1) {
                var fragment = href.substring(href.lastIndexOf('#') + 1);

                if (fragment !== undefined && fragment !== '') {
                    var $anchor = $('a[name=' + fragment + ']');

                    this._$content.scrollTo($anchor, 800);
                } else {
                    // Scroll to top for invalid fragment value.
                    this._$content.scrollTo(0);
                }
            } else {
                // Scroll to top if fragment value not specified.
                this._$content.scrollTo(0);
            }
        }
	});
})(jQuery);
// SIG // Begin signature block
// SIG // MIIXrwYJKoZIhvcNAQcCoIIXoDCCF5wCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFNwWuvkwftqb
// SIG // 5XWHX5NecrdoSgfloIIS3zCCA+4wggNXoAMCAQICEH6T
// SIG // 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
// SIG // CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
// SIG // cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
// SIG // EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
// SIG // Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
// SIG // aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
// SIG // NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
// SIG // bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
// SIG // bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
// SIG // RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
// SIG // AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
// SIG // FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
// SIG // a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
// SIG // AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
// SIG // +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
// SIG // 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
// SIG // 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
// SIG // RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
// SIG // gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
// SIG // gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
// SIG // aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
// SIG // CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
// SIG // Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
// SIG // bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
// SIG // VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
// SIG // VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
// SIG // BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
// SIG // nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
// SIG // sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
// SIG // JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
// SIG // g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
// SIG // UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
// SIG // BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
// SIG // dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
// SIG // MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
// SIG // AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
// SIG // cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
// SIG // sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
// SIG // duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
// SIG // TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
// SIG // YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
// SIG // vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
// SIG // nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
// SIG // 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
// SIG // EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
// SIG // FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
// SIG // BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
// SIG // AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
// SIG // MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
// SIG // bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
// SIG // MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
// SIG // ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
// SIG // MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
// SIG // VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
// SIG // IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
// SIG // SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
// SIG // st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
// SIG // JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
// SIG // dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
// SIG // bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
// SIG // K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
// SIG // SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
// SIG // ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
// SIG // w7wc2AR1MIIE5TCCA82gAwIBAgIQGGKWU9W9DKB4gLDR
// SIG // /Nm99TANBgkqhkiG9w0BAQsFADB/MQswCQYDVQQGEwJV
// SIG // UzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24x
// SIG // HzAdBgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsx
// SIG // MDAuBgNVBAMTJ1N5bWFudGVjIENsYXNzIDMgU0hBMjU2
// SIG // IENvZGUgU2lnbmluZyBDQTAeFw0xNjAxMjgwMDAwMDBa
// SIG // Fw0xODA0MTAyMzU5NTlaMH0xCzAJBgNVBAYTAkNIMRIw
// SIG // EAYDVQQIEwlOZXVjaGF0ZWwxEjAQBgNVBAcTCU5ldWNo
// SIG // YXRlbDEiMCAGA1UEChQZQXV0b2Rlc2sgRGV2ZWxvcG1l
// SIG // bnQgU2FybDEiMCAGA1UEAxQZQXV0b2Rlc2sgRGV2ZWxv
// SIG // cG1lbnQgU2FybDCCASIwDQYJKoZIhvcNAQEBBQADggEP
// SIG // ADCCAQoCggEBALOBje/8PFtBHV0+YQz+EJZzXU+JAy6j
// SIG // OhMiK0n4pWQrgLdfLmoNZUvUL5AVuWoHkzK4f6WLWEjQ
// SIG // eGR4SEZcvDCJjol0n6vdsYAfRurwhekestab635tKUEy
// SIG // JRNKXhC4zuDSgryc+2zUsZa08HSHZaTsFGZzEuQAdxWf
// SIG // iyvD6G5oTu72nj3kDWWn3vqh+zyGkOIhtsIDKZyHpg71
// SIG // 7hPiqEe96bX5LpZgkSOJdAdwpl40NEUFfpNdelT2sOCh
// SIG // MfG63Dg2PR6EjOK5zHgMZm09mPgZBfyNoBV03C1ySSUi
// SIG // UsAHM2ND4wnGfl/GbYEgIVQXWlspRbtpRHTaNavebLJY
// SIG // tWECAwEAAaOCAV0wggFZMAkGA1UdEwQCMAAwDgYDVR0P
// SIG // AQH/BAQDAgeAMCsGA1UdHwQkMCIwIKAeoByGGmh0dHA6
// SIG // Ly9zdi5zeW1jYi5jb20vc3YuY3JsMGEGA1UdIARaMFgw
// SIG // VgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8v
// SIG // ZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0
// SIG // dHBzOi8vZC5zeW1jYi5jb20vcnBhMBMGA1UdJQQMMAoG
// SIG // CCsGAQUFBwMDMFcGCCsGAQUFBwEBBEswSTAfBggrBgEF
// SIG // BQcwAYYTaHR0cDovL3N2LnN5bWNkLmNvbTAmBggrBgEF
// SIG // BQcwAoYaaHR0cDovL3N2LnN5bWNiLmNvbS9zdi5jcnQw
// SIG // HwYDVR0jBBgwFoAUljtT8Hkzl699g+8uK8zKt4YecmYw
// SIG // HQYDVR0OBBYEFHqJl6/oWFvaZKJVCptH8DQRl8JIMA0G
// SIG // CSqGSIb3DQEBCwUAA4IBAQAXhA6ZwymxqqV+k4uKThLd
// SIG // PgPsvZBRcCJJZi3eYMl7HjIDbxSdx03ueVc/Sx3n9OUK
// SIG // U+DupPpLFUnKUJa/X8HPWhcvJftXom9NvGWbYPJM7CBc
// SIG // eTKuXgP5ffKwf1r9pJhok0pEhSA8b6N97pmKQwJDE6XI
// SIG // Z4M5FYw9YELKPRCHhinZCfPHLo+0GxaH+W4AbGd1N2BZ
// SIG // dX2egsgNTGBnC6xGxGMC8ckaj5wyIm4LgklE0pKbxuG9
// SIG // 075426gJ6ASAtCevNViBj9hH3TcNy4aU0ruH6By5gZaR
// SIG // 5lc7ZdaTuBWz0+4wGIK1IiviMSJv19v+h0vpEyn1b8sE
// SIG // 6L7D8JD4szHnMIIFWTCCBEGgAwIBAgIQPXjX+XZJYLJh
// SIG // ffTwHsqGKjANBgkqhkiG9w0BAQsFADCByjELMAkGA1UE
// SIG // BhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8w
// SIG // HQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTow
// SIG // OAYDVQQLEzEoYykgMjAwNiBWZXJpU2lnbiwgSW5jLiAt
// SIG // IEZvciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQD
// SIG // EzxWZXJpU2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5
// SIG // IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzUwHhcN
// SIG // MTMxMjEwMDAwMDAwWhcNMjMxMjA5MjM1OTU5WjB/MQsw
// SIG // CQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29y
// SIG // cG9yYXRpb24xHzAdBgNVBAsTFlN5bWFudGVjIFRydXN0
// SIG // IE5ldHdvcmsxMDAuBgNVBAMTJ1N5bWFudGVjIENsYXNz
// SIG // IDMgU0hBMjU2IENvZGUgU2lnbmluZyBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAJeDHgAWryyx
// SIG // 0gjE12iTUWAecfbiR7TbWE0jYmq0v1obUfejDRh3aLvY
// SIG // NqsvIVDanvPnXydOC8KXyAlwk6naXA1OpA2RoLTsFM6R
// SIG // clQuzqPbROlSGz9BPMpK5KrA6DmrU8wh0MzPf5vmwsxY
// SIG // aoIV7j02zxzFlwckjvF7vjEtPW7ctZlCn0thlV8ccO4X
// SIG // fduL5WGJeMdoG68ReBqYrsRVR1PZszLWoQ5GQMWXkorR
// SIG // U6eZW4U1V9Pqk2JhIArHMHckEU1ig7a6e2iCMe5lyt/5
// SIG // 1Y2yNdyMK29qclxghJzyDJRewFZSAEjM0/ilfd4v1xPk
// SIG // OKiE1Ua4E4bCG53qWjjdm9sCAwEAAaOCAYMwggF/MC8G
// SIG // CCsGAQUFBwEBBCMwITAfBggrBgEFBQcwAYYTaHR0cDov
// SIG // L3MyLnN5bWNiLmNvbTASBgNVHRMBAf8ECDAGAQH/AgEA
// SIG // MGwGA1UdIARlMGMwYQYLYIZIAYb4RQEHFwMwUjAmBggr
// SIG // BgEFBQcCARYaaHR0cDovL3d3dy5zeW1hdXRoLmNvbS9j
// SIG // cHMwKAYIKwYBBQUHAgIwHBoaaHR0cDovL3d3dy5zeW1h
// SIG // dXRoLmNvbS9ycGEwMAYDVR0fBCkwJzAloCOgIYYfaHR0
// SIG // cDovL3MxLnN5bWNiLmNvbS9wY2EzLWc1LmNybDAdBgNV
// SIG // HSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwMwDgYDVR0P
// SIG // AQH/BAQDAgEGMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQD
// SIG // ExFTeW1hbnRlY1BLSS0xLTU2NzAdBgNVHQ4EFgQUljtT
// SIG // 8Hkzl699g+8uK8zKt4YecmYwHwYDVR0jBBgwFoAUf9Nl
// SIG // p8Ld7LvwMAnzQzn6Aq8zMTMwDQYJKoZIhvcNAQELBQAD
// SIG // ggEBABOFGh5pqTf3oL2kr34dYVP+nYxeDKZ1HngXI939
// SIG // 7BoDVTn7cZXHZVqnjjDSRFph23Bv2iEFwi5zuknx0ZP+
// SIG // XcnNXgPgiZ4/dB7X9ziLqdbPuzUvM1ioklbRyE07guZ5
// SIG // hBb8KLCxR/Mdoj7uh9mmf6RWpT+thC4p3ny8qKqjPQQB
// SIG // 6rqTog5QIikXTIfkOhFf1qQliZsFay+0yQFMJ3sLrBkF
// SIG // IqBgFT/ayftNTI/7cmd3/SeUx7o1DohJ/o39KK9KEr0N
// SIG // s5cF3kQMFfo2KwPcwVAB8aERXRTl4r0nS1S+K4ReD6bD
// SIG // dAUK75fDiSKxH3fzvc1D1PFMqT+1i4SvZPLQFCExggQ8
// SIG // MIIEOAIBATCBkzB/MQswCQYDVQQGEwJVUzEdMBsGA1UE
// SIG // ChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAdBgNVBAsT
// SIG // FlN5bWFudGVjIFRydXN0IE5ldHdvcmsxMDAuBgNVBAMT
// SIG // J1N5bWFudGVjIENsYXNzIDMgU0hBMjU2IENvZGUgU2ln
// SIG // bmluZyBDQQIQGGKWU9W9DKB4gLDR/Nm99TAJBgUrDgMC
// SIG // GgUAoHAwEAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcN
// SIG // AQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEO
// SIG // MAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFA7O
// SIG // ytZhYyZsdHONN07Kn+MPHrxCMA0GCSqGSIb3DQEBAQUA
// SIG // BIIBAHgZb1eq+JFldm2PspycEE1FPzGNWGJ42O3Q4yYa
// SIG // dOTr8Q3oHk5NWZY35dchA6DPjqOZldwxY83dMI5NQ9hw
// SIG // HRXGyUxJRUuILnuTXqOg4JRYWizmw7WmfUSrvf0Atk6a
// SIG // kTw8GlgHGh0D9YH2F8VdHax1frSoqWFE0wsJV9b9pmh1
// SIG // KherUHBU5e2WFRtq6wMCNWRHSpBjErQu9Q1pXRXiK7gr
// SIG // M6FgfnGcCis7ceR9ZNrKZ2WhGE83k8xbCVXZnIKXVsYe
// SIG // RQF9KoluU6BBJlC6SVO4+6v4wqJ6LdlINc0cC8uKpe7c
// SIG // 8hht0qSBXHUq5n5Sosoyaq74BFRkbxjCE1PCWgShggIL
// SIG // MIICBwYJKoZIhvcNAQkGMYIB+DCCAfQCAQEwcjBeMQsw
// SIG // CQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29y
// SIG // cG9yYXRpb24xMDAuBgNVBAMTJ1N5bWFudGVjIFRpbWUg
// SIG // U3RhbXBpbmcgU2VydmljZXMgQ0EgLSBHMgIQDs/0OMj+
// SIG // vzVuBNhqmBsaUDAJBgUrDgMCGgUAoF0wGAYJKoZIhvcN
// SIG // AQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUxDxcN
// SIG // MTYwMjE1MDM1NzA5WjAjBgkqhkiG9w0BCQQxFgQUlH2u
// SIG // /QsBWjTtTjVtG9c84KwUlukwDQYJKoZIhvcNAQEBBQAE
// SIG // ggEADBKj6HAW116QYVhJiumFQqaqF/QJTIc26zwaQx29
// SIG // R0YRel2xgN2cWsXWZv6xLZbe5e1zlkN684Ls+AnrBvw+
// SIG // l9W947SA3asEFkESHBlrohMBj/mT0IoICQ1d0eIyn8QK
// SIG // HwmeNohQVBKMgYGGqzZejXspC//zSh9D4SLgSPL3ol8P
// SIG // DVGV2c6sUaGKhX/7Ehw+PGR+E5c2G3skQGycH87HA0Uc
// SIG // B4IQZuj7Pss68Hl2xd/Y3oA/CSx9Aejcx3oFIZ4u5CeP
// SIG // Qw+MCwsHxoAov2ObOtsZ/8QafJNmeJqQ2CZqCVqngoe5
// SIG // 6gm8zkE7gwAyLmsb/vLr6QtfD9DFnx78ka/Daw==
// SIG // End signature block
