// Topic controller.
(function($) {
	$.widget('adsk.topiccontroller', {
		options: {
		    defaultTopicHref: undefined,
		    shareController: undefined,
            favoritesController: undefined,
		    pageIds: ['navigation', 'search', 'page', 'share'],
		    toc: undefined,
		    orientationData: undefined
		},

        /* Private members. */

		_view: undefined,
		_defaultTopicData: undefined,
		_currentTopicData: undefined,
		_parentTopicData: undefined,

		_siblingTopicData: {
		    prn: undefined, // previous
		    nxn: undefined // next
		},

        // This method is the widget's constructor.
		_create: function() {
            console.log('topiccontroller: _create');

            // Create view and attach event handlers.
            $('#topic').topicview({
                create:     $.proxy(this._viewCreateHandler, this),
                buttontap:  $.proxy(this._viewButtontapHandler, this),
                swipeleft:  $.proxy(this._viewSwipeLeftHandler, this),
                swiperight: $.proxy(this._viewSwipeRightHandler, this),
                opentopic:  $.proxy(this._viewOpentopicHandler, this)
            });
		},

		_viewOpentopicHandler: function(event, data) {
		    console.log('topiccontroller: _viewOpentopicHandler');

		    this._trigger('opentopic', {}, data);
		},

        // View widget 'create' event handler.
		_viewCreateHandler: function(event, ui) {
            console.log('topiccontroller: _viewCreateHandler');

            this._view = $(event.target).topicview("instance");
		},

		_openDefaultTopic: function(defaultTopic) {
		    console.log('topiccontroller: _openDefaultTopic');

            this._trigger('opentopic', {}, {
                href: defaultTopic.attr.href
            });
		},

		_getDefaultTopicData: function() {
		    console.log('topiccontroller: _getDefaultTopicData');

		    var href = this.options.defaultTopicHref;

            var topic = this._fetchTopicData({
                href: href
            });

            // If no topic specified in TOC tree data,
            // use config provided HREF to load default topic.
            if (topic === undefined) {
                topic = {
                    /* TODO: add default topic title into publication config. */
                    data: undefined,
                    attr: {
                        href: href
                    }
                };
            }

            return topic;
		},

        // Disable/enable navigation buttons and favorites.
		_setupTopicRelatedFeatures: function(topic) {
		    console.log('topiccontroller: _setupTopicRelatedFeatures');

            var toc = this.options.toc,
            	view = this._view;

		    if (topic !== undefined && topic.attr.id !== undefined) {
                this._setupGoBackFeature(view);

                this._setupGoToParentFeature(toc, topic, view);
                this._setupGoToSiblingFeature('prn', toc, topic, view);
                this._setupGoToSiblingFeature('nxn', toc, topic, view);

                this._setupFavoritesFeature(topic, view);
                // TODO: prev and next features.
		    } else {
		        this._disableTopicRelatedFeatures(view);
		    }

		},

		_disableTopicRelatedFeatures: function(view) {
		    console.log('topiccontroller: _disableTopicRelatedFeatures');

		    view.initGoToParentButton(false);
            view.initFavoritesButton(false);
            view.initGoBackButton(false);

            this._siblingTopicData['prn'] = undefined;
            this._siblingTopicData['nxn'] = undefined;

            view.flag(false);
		},

		_setupGoBackFeature: function(view) {
		     console.log('topiccontroller: _setupGoBackFeature');

             view.initGoBackButton(history.length > 0);
		},


		_setupGoToParentFeature: function(toc, topic, view) {
		    console.log('topiccontroller: _setupGoToParentFeature');

		    // Enable "Go to parent" button if parent topic available.
		    var parentTopic = undefined;

            if (toc !== undefined) {
                var parentTopicNumber = topic.attr.pn,
                    bookName = "";

                if (parentTopicNumber !== undefined) {
                    parentTopic = toc.tocIndexedByTopicNumber[bookName][parentTopicNumber]
                }

                var goToParentButtonEnabled = (parentTopic !== undefined) ? true: false;

                if (goToParentButtonEnabled) {
                    this._parentTopicData = parentTopic;
                } else {
                    this._parentTopicData = undefined;
                }

                view.initGoToParentButton(goToParentButtonEnabled);
            } else {
                view.initGoToParentButton(false);
            }
		},


		// attr = prn || nxn.
		_setupGoToSiblingFeature: function(attr, toc, topic, view) {
		    console.log('topiccontroller: _setupGoToSiblingFeature');

		    // Enable "GoTo" button if 'previous/next' topic available.
		    var targetTopic = undefined;

            if (toc !== undefined) {
                var topicNumber = topic.attr[attr],
                    bookName = '';

                if (topicNumber !== undefined) {
                    targetTopic = toc.tocIndexedByTopicNumber[bookName][topicNumber];
                }
            }

            this._siblingTopicData[attr] = targetTopic;
		},

		_setupFavoritesFeature: function(topic, view) {
		    console.log('topiccontroller: _setupFavoritesFeature');

		    view.initFavoritesButton(true);

		    // Indicate if opened topic page is in favorites.
            var isTopicInFavorites = this.options.favoritesController.isTopicIdInFavorites(topic.attr.id);
            view.flag(isTopicInFavorites);
		},

		_isPageId: function(id) {
            return ($.inArray(id, this.options.pageIds) > -1);
		},

		_makePageCurrentById: function(id) {
		    console.log('topiccontroller: _makePageCurrentById, id = ', id);

		    if (this._isPageId(id)) {
                this._trigger('showpage', {}, { id: id });
            }
		},

		_createShareController: function() {
		    console.log('topiccontroller: _createShareController');

            this.options.shareController = $.adsk.sharecontroller({
                back:               $.proxy(this._backToPreviousPage, this),
                shareButtonOffset:  this.getShareButtonOffset(),
                orientationData:    this.options.orientationData
            });
		},

		_viewButtontapHandler: function(event, id) {
		    console.log('topiccontroller: _viewButtontapHandler');

            id = id.substring('topic-'.length);
            var handlerName = '_' + id + 'ButtontapHandler';
            this[handlerName](event, id);
		},

        _setTopicTitleToShare: function(title){
            console.log('topiccontroller: _setTopicTitleToShare', title);

            if (this.options.shareController !== undefined) {
                this.options.shareController._setCurrentTopicTitle(title);
            }
        },

		_shareButtontapHandler: function(event, id) {
		    // Create share controller lazily.
		    var controller = this.options.shareController;

		    if (controller === undefined) {
                this._createShareController();
                controller = this.options.shareController;
            }

            this._makePageCurrentById(id);
            this._setTopicTitleToShare(this._currentTopicData.data);
            controller.refresh(this.getShareButtonOffset());
		},

		_parentButtontapHandler: function(event, id) {
		    var parentTopic = this._parentTopicData;

            if (parentTopic !== undefined) {
                this._currentTopicData = parentTopic;

                this._trigger('opentopic', {}, {
                    href: parentTopic.attr.href
                });
            }
		},

		_favoritesButtontapHandler: function(event, id) {
		    var attr = this._currentTopicData.attr;
		    if (attr.id !== undefined) {
                var added = this.options.favoritesController.addOrRemoveFavoriteTopicId(attr.id);
                this._view.flag(added);
            }
		},

		_navigationButtontapHandler: function(event, id) {
		    console.log('topiccontroller: _navigationButtontapHandler');

		    this._makePageCurrentById(id);
		},

		_backButtontapHandler: function() {
		    console.log('topiccontroller: _backButtonHandler');

		    history.go(-1);
		},

		_homeButtontapHandler: function(event, id) {
		    console.log('topiccontroller: _homeButtontapHandler');

            this._openDefaultTopic(this._defaultTopicData);
		},

		_searchButtontapHandler: function(event, id) {
            console.log('topiccontroller: _searchButtontapHandler');

            this._makePageCurrentById(id);

            this._trigger('setsuggestiondata', {}, [this._getTopicSearchData()]);
        },

        _viewSwipeRightHandler: function(event) {
            console.log('topiccontroller: _viewSwipeRightHandler');

            var prevTopic = this._siblingTopicData['prn'];

            if (prevTopic !== undefined) {
                this._currentTopicData = prevTopic;

                this._trigger('opentopic', {}, {
                    href: prevTopic.attr.href
                });
            }
        },

        _viewSwipeLeftHandler: function(event) {
            console.log('topiccontroller: _viewSwipeLeftHandler');

            var nextTopic = this._siblingTopicData['nxn'];

            if (nextTopic !== undefined) {
                this._currentTopicData = nextTopic;

                this._trigger('opentopic', {}, {
                    href: nextTopic.attr.href
                });
            }
        },

        _getTopicSearchData: function(){
            console.log('topiccontroller: _getTopicSearchData');

            return {data: document.getElementById('body-content'),
                    type: 'topic'};
        },

        // Tells the view to load topic if it is specified.
		_showTopicContent: function(topic) {
            console.log('topiccontroller: _showTopicContent, ', topic);

            if (topic !== undefined) {
                console.log('topic data: ', topic);

                var href = topic.attr.href,
                    title = topic.data;

                // Get book name to resolve inner links.
                var bookBase = this._getBookBase(href);

                this._setTopicTitleToShare(title);
                this._view.loadPage(href, title, bookBase);
            }
        },

        // Get topic data (title, href, id etc.) from TOC tree by ID, HREF or topic number.
		_fetchTopicData: function(data) {
		    console.log('topiccontroller: _fetchTopicData');

            var toc = this.options.toc,
                bookName = '',
                topic = undefined;

            if (toc !== undefined) {
                // Get topic data by topic ID.
                if (data.id !== undefined && data.id !== '') {
                    if (toc.tocIndexedById !== undefined) {
                        topic = toc.tocIndexedById[bookName][data.id];
                    }
                // Get topic data by href.
                } else if (data.href !== undefined && data.href !== '') {
                    // Crop url fragment.
                    var href = data.href;
                    if (data.href.lastIndexOf('#') != -1) {
                        href = data.href.substr(0, data.href.lastIndexOf('#'));
                    }

                    if (toc.tocIndexedByHref !== undefined) {
                        topic = toc.tocIndexedByHref[bookName][href];
                    }
                // Get topic data by topic number.
                } else if (data.tn !== undefined && data.tn !== '') {
                    if (toc.tocIndexedByTopicNumber !== undefined) {
                        topic = toc.tocIndexedByTopicNumber[bookName][data.tn];
                    }
                }
            }

            if (topic === undefined) {
                topic = {
                    attr: {
                        href: data.href
                    }
                };
            } else {
                topic.attr.href = data.href; // Preserve url fragment.
            }

            return topic;
		},

		_backToPreviousPage: function() {
            console.log('topiccontroller: _backToPreviousPage');

            this._trigger('back');
        },

        // Get book name from path.
        // ./filesTEST1/topichead.htm => TEST1
        _getBookBase: function(path) {
            var pos = path.lastIndexOf('/'),
                base = path.substring(0, pos + 1);

            return base;
        },

        _getBookName: function(bookBase) {
            var files = '/files',
                startIndex = bookBase.lastIndexOf(files) + files.length,
                endIndex = bookBase.lastIndexOf('/');

            return bookBase.substring(startIndex, endIndex);
        },

		/* Public members. */

        resize: function(data) {
            console.log('topiccontroller: resize');

            this.options.orientationData = data;

            this._view.resize();

            var controller = this.options.shareController;
            if (controller !== undefined) {
                controller.resize(data);
                controller.refresh(this.getShareButtonOffset());
            }
        },

        setTocData: function(data) {
            console.log('topiccontroller: setTocData, ');

            this.options.toc = data;

            // Try to fetch default topic data again.
            this._defaultTopicData = this._getDefaultTopicData();
        },

		openTopic: function(data) {
		    console.log('topiccontroller: openTopic: ', data);

            if (data === undefined || $.isEmptyObject(data)) {
                return;
            }

		    var topic = this._currentTopicData = this._fetchTopicData(data);

		    this._showTopicContent(topic);
		    this._setupTopicRelatedFeatures(topic);
		},

		getShareButtonOffset: function() {
            console.log('topiccontroller: getShareButtonOffset');

            return this._view.getShareButtonOffset();
        }
	});
})(jQuery);
// SIG // Begin signature block
// SIG // MIIXrwYJKoZIhvcNAQcCoIIXoDCCF5wCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFIGL7Uu0W8Qt
// SIG // NLfw8Aon2VNLetOfoIIS3zCCA+4wggNXoAMCAQICEH6T
// SIG // 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
// SIG // CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
// SIG // cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
// SIG // EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
// SIG // Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
// SIG // aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
// SIG // NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
// SIG // bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
// SIG // bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
// SIG // RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
// SIG // AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
// SIG // FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
// SIG // a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
// SIG // AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
// SIG // +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
// SIG // 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
// SIG // 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
// SIG // RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
// SIG // gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
// SIG // gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
// SIG // aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
// SIG // CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
// SIG // Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
// SIG // bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
// SIG // VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
// SIG // VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
// SIG // BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
// SIG // nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
// SIG // sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
// SIG // JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
// SIG // g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
// SIG // UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
// SIG // BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
// SIG // dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
// SIG // MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
// SIG // AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
// SIG // cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
// SIG // sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
// SIG // duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
// SIG // TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
// SIG // YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
// SIG // vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
// SIG // nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
// SIG // 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
// SIG // EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
// SIG // FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
// SIG // BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
// SIG // AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
// SIG // MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
// SIG // bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
// SIG // MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
// SIG // ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
// SIG // MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
// SIG // VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
// SIG // IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
// SIG // SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
// SIG // st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
// SIG // JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
// SIG // dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
// SIG // bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
// SIG // K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
// SIG // SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
// SIG // ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
// SIG // w7wc2AR1MIIE5TCCA82gAwIBAgIQGGKWU9W9DKB4gLDR
// SIG // /Nm99TANBgkqhkiG9w0BAQsFADB/MQswCQYDVQQGEwJV
// SIG // UzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24x
// SIG // HzAdBgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsx
// SIG // MDAuBgNVBAMTJ1N5bWFudGVjIENsYXNzIDMgU0hBMjU2
// SIG // IENvZGUgU2lnbmluZyBDQTAeFw0xNjAxMjgwMDAwMDBa
// SIG // Fw0xODA0MTAyMzU5NTlaMH0xCzAJBgNVBAYTAkNIMRIw
// SIG // EAYDVQQIEwlOZXVjaGF0ZWwxEjAQBgNVBAcTCU5ldWNo
// SIG // YXRlbDEiMCAGA1UEChQZQXV0b2Rlc2sgRGV2ZWxvcG1l
// SIG // bnQgU2FybDEiMCAGA1UEAxQZQXV0b2Rlc2sgRGV2ZWxv
// SIG // cG1lbnQgU2FybDCCASIwDQYJKoZIhvcNAQEBBQADggEP
// SIG // ADCCAQoCggEBALOBje/8PFtBHV0+YQz+EJZzXU+JAy6j
// SIG // OhMiK0n4pWQrgLdfLmoNZUvUL5AVuWoHkzK4f6WLWEjQ
// SIG // eGR4SEZcvDCJjol0n6vdsYAfRurwhekestab635tKUEy
// SIG // JRNKXhC4zuDSgryc+2zUsZa08HSHZaTsFGZzEuQAdxWf
// SIG // iyvD6G5oTu72nj3kDWWn3vqh+zyGkOIhtsIDKZyHpg71
// SIG // 7hPiqEe96bX5LpZgkSOJdAdwpl40NEUFfpNdelT2sOCh
// SIG // MfG63Dg2PR6EjOK5zHgMZm09mPgZBfyNoBV03C1ySSUi
// SIG // UsAHM2ND4wnGfl/GbYEgIVQXWlspRbtpRHTaNavebLJY
// SIG // tWECAwEAAaOCAV0wggFZMAkGA1UdEwQCMAAwDgYDVR0P
// SIG // AQH/BAQDAgeAMCsGA1UdHwQkMCIwIKAeoByGGmh0dHA6
// SIG // Ly9zdi5zeW1jYi5jb20vc3YuY3JsMGEGA1UdIARaMFgw
// SIG // VgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8v
// SIG // ZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0
// SIG // dHBzOi8vZC5zeW1jYi5jb20vcnBhMBMGA1UdJQQMMAoG
// SIG // CCsGAQUFBwMDMFcGCCsGAQUFBwEBBEswSTAfBggrBgEF
// SIG // BQcwAYYTaHR0cDovL3N2LnN5bWNkLmNvbTAmBggrBgEF
// SIG // BQcwAoYaaHR0cDovL3N2LnN5bWNiLmNvbS9zdi5jcnQw
// SIG // HwYDVR0jBBgwFoAUljtT8Hkzl699g+8uK8zKt4YecmYw
// SIG // HQYDVR0OBBYEFHqJl6/oWFvaZKJVCptH8DQRl8JIMA0G
// SIG // CSqGSIb3DQEBCwUAA4IBAQAXhA6ZwymxqqV+k4uKThLd
// SIG // PgPsvZBRcCJJZi3eYMl7HjIDbxSdx03ueVc/Sx3n9OUK
// SIG // U+DupPpLFUnKUJa/X8HPWhcvJftXom9NvGWbYPJM7CBc
// SIG // eTKuXgP5ffKwf1r9pJhok0pEhSA8b6N97pmKQwJDE6XI
// SIG // Z4M5FYw9YELKPRCHhinZCfPHLo+0GxaH+W4AbGd1N2BZ
// SIG // dX2egsgNTGBnC6xGxGMC8ckaj5wyIm4LgklE0pKbxuG9
// SIG // 075426gJ6ASAtCevNViBj9hH3TcNy4aU0ruH6By5gZaR
// SIG // 5lc7ZdaTuBWz0+4wGIK1IiviMSJv19v+h0vpEyn1b8sE
// SIG // 6L7D8JD4szHnMIIFWTCCBEGgAwIBAgIQPXjX+XZJYLJh
// SIG // ffTwHsqGKjANBgkqhkiG9w0BAQsFADCByjELMAkGA1UE
// SIG // BhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8w
// SIG // HQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTow
// SIG // OAYDVQQLEzEoYykgMjAwNiBWZXJpU2lnbiwgSW5jLiAt
// SIG // IEZvciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQD
// SIG // EzxWZXJpU2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5
// SIG // IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzUwHhcN
// SIG // MTMxMjEwMDAwMDAwWhcNMjMxMjA5MjM1OTU5WjB/MQsw
// SIG // CQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29y
// SIG // cG9yYXRpb24xHzAdBgNVBAsTFlN5bWFudGVjIFRydXN0
// SIG // IE5ldHdvcmsxMDAuBgNVBAMTJ1N5bWFudGVjIENsYXNz
// SIG // IDMgU0hBMjU2IENvZGUgU2lnbmluZyBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAJeDHgAWryyx
// SIG // 0gjE12iTUWAecfbiR7TbWE0jYmq0v1obUfejDRh3aLvY
// SIG // NqsvIVDanvPnXydOC8KXyAlwk6naXA1OpA2RoLTsFM6R
// SIG // clQuzqPbROlSGz9BPMpK5KrA6DmrU8wh0MzPf5vmwsxY
// SIG // aoIV7j02zxzFlwckjvF7vjEtPW7ctZlCn0thlV8ccO4X
// SIG // fduL5WGJeMdoG68ReBqYrsRVR1PZszLWoQ5GQMWXkorR
// SIG // U6eZW4U1V9Pqk2JhIArHMHckEU1ig7a6e2iCMe5lyt/5
// SIG // 1Y2yNdyMK29qclxghJzyDJRewFZSAEjM0/ilfd4v1xPk
// SIG // OKiE1Ua4E4bCG53qWjjdm9sCAwEAAaOCAYMwggF/MC8G
// SIG // CCsGAQUFBwEBBCMwITAfBggrBgEFBQcwAYYTaHR0cDov
// SIG // L3MyLnN5bWNiLmNvbTASBgNVHRMBAf8ECDAGAQH/AgEA
// SIG // MGwGA1UdIARlMGMwYQYLYIZIAYb4RQEHFwMwUjAmBggr
// SIG // BgEFBQcCARYaaHR0cDovL3d3dy5zeW1hdXRoLmNvbS9j
// SIG // cHMwKAYIKwYBBQUHAgIwHBoaaHR0cDovL3d3dy5zeW1h
// SIG // dXRoLmNvbS9ycGEwMAYDVR0fBCkwJzAloCOgIYYfaHR0
// SIG // cDovL3MxLnN5bWNiLmNvbS9wY2EzLWc1LmNybDAdBgNV
// SIG // HSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwMwDgYDVR0P
// SIG // AQH/BAQDAgEGMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQD
// SIG // ExFTeW1hbnRlY1BLSS0xLTU2NzAdBgNVHQ4EFgQUljtT
// SIG // 8Hkzl699g+8uK8zKt4YecmYwHwYDVR0jBBgwFoAUf9Nl
// SIG // p8Ld7LvwMAnzQzn6Aq8zMTMwDQYJKoZIhvcNAQELBQAD
// SIG // ggEBABOFGh5pqTf3oL2kr34dYVP+nYxeDKZ1HngXI939
// SIG // 7BoDVTn7cZXHZVqnjjDSRFph23Bv2iEFwi5zuknx0ZP+
// SIG // XcnNXgPgiZ4/dB7X9ziLqdbPuzUvM1ioklbRyE07guZ5
// SIG // hBb8KLCxR/Mdoj7uh9mmf6RWpT+thC4p3ny8qKqjPQQB
// SIG // 6rqTog5QIikXTIfkOhFf1qQliZsFay+0yQFMJ3sLrBkF
// SIG // IqBgFT/ayftNTI/7cmd3/SeUx7o1DohJ/o39KK9KEr0N
// SIG // s5cF3kQMFfo2KwPcwVAB8aERXRTl4r0nS1S+K4ReD6bD
// SIG // dAUK75fDiSKxH3fzvc1D1PFMqT+1i4SvZPLQFCExggQ8
// SIG // MIIEOAIBATCBkzB/MQswCQYDVQQGEwJVUzEdMBsGA1UE
// SIG // ChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAdBgNVBAsT
// SIG // FlN5bWFudGVjIFRydXN0IE5ldHdvcmsxMDAuBgNVBAMT
// SIG // J1N5bWFudGVjIENsYXNzIDMgU0hBMjU2IENvZGUgU2ln
// SIG // bmluZyBDQQIQGGKWU9W9DKB4gLDR/Nm99TAJBgUrDgMC
// SIG // GgUAoHAwEAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcN
// SIG // AQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEO
// SIG // MAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFC0J
// SIG // bhrWevDJ7CMgcrh45ca+fubYMA0GCSqGSIb3DQEBAQUA
// SIG // BIIBAJL5hOajUprPZ3qAUtrfh+w2XcOZLtJe2oeNRmdK
// SIG // lXmfe4KdH0Kn9oF/TZ9Mvy4XdB7S6kkwTInr7oXIsNS2
// SIG // bESYTbgK17e1SJKIsUdyoEdT1kVA1CNMHl903alGmmPD
// SIG // vK5lqGPB4yQQgd59o19EWIYeQKwCLRt5g+mjYJgZLyWw
// SIG // moCRB2cYgFqfu8PUnkhSa9pfsYzV/pyFmXX4lBYmB/RE
// SIG // fVObIOD1odfDh4R5mR+SOt/HRJL/fY8GuLvl7D7hVGyZ
// SIG // szyXMbEdsvxcVJVQQn6T/6oPbcsuA7tLDE8HgGbMZX4R
// SIG // sS5A42+Rofd5FiEWLk1aaAMP/cUOIeC5B4dAQXWhggIL
// SIG // MIICBwYJKoZIhvcNAQkGMYIB+DCCAfQCAQEwcjBeMQsw
// SIG // CQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29y
// SIG // cG9yYXRpb24xMDAuBgNVBAMTJ1N5bWFudGVjIFRpbWUg
// SIG // U3RhbXBpbmcgU2VydmljZXMgQ0EgLSBHMgIQDs/0OMj+
// SIG // vzVuBNhqmBsaUDAJBgUrDgMCGgUAoF0wGAYJKoZIhvcN
// SIG // AQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUxDxcN
// SIG // MTYwMjE1MDM1NzIxWjAjBgkqhkiG9w0BCQQxFgQUn0Qy
// SIG // QYF2UzpwA4hvp0I97AtJS+MwDQYJKoZIhvcNAQEBBQAE
// SIG // ggEASRBxcVeBBZPHOcfpsyEdjuiFjv6GaJGtk6j1h0Pb
// SIG // y86nHWZdHYSgfYfAz3NhxhpgKEvv9+t8YAwr1PVAQ0t6
// SIG // lPX435+7gKHEdqnQ3FblipgOK0GmHiqTiZXjQFqtaEJe
// SIG // mlZXoGAPpW2nnRo/SsShx1dUphp7aObZ+O6vNhN7FkjM
// SIG // x71nX2h0chGJZnZ67Vu+Ypo322vwZ7XSqP/fvGQSt8Bz
// SIG // 4I1uPkxkDT0yVIhd0c137urQFGxAOMnXKJcP5/yTN8AY
// SIG // dF5n+ObROQvX4kHyKPWJ75zrOtiWmYzDFzwJuFgla8fL
// SIG // azr/79NjbhyD0Sc3mK+lhasiJEBGReIlyGBIiw==
// SIG // End signature block
