// Search view.
(function($, UTILS) {

    $.widget('adsk.searchview', {
        options: {
            config: undefined
        },

        /* Private members. */

        _create: function() {
            console.log('searchview: _create');

            this._render();
            this._addEventHandlers();
        },

        _render: function() {
            console.log('searchview: _render');

            var caps = this.options.config.labels.search,
				opt = this.options.config.searchOptions;

            // Create markup.
            var html =  '<div class="block-preloader hidden"/>' +
                        '<div class="content">' +
                            this._renderSearchBar() +
                            '<h2 id="search-options-title" class="search-title accordion closed">' +
                                caps.searchOptions +
                            '</h2>' +
                            '<div id="search-options" class="search-options closed">' + /* add\remove collapsed */
                                '<h3 class="search-options-title">' +
                                    caps.searchInFilesFor +
                                '</h3>' +

								this._renderSearchOptionControl(true, caps.anyWord, 'radio', 'search-method', 'or') +
								this._renderSearchOptionControl(true, caps.allWords, 'radio', 'search-method', 'and') +
								this._renderSearchOptionControl(true, caps.phrase, 'radio', 'search-method', 'phrase') +

                                '<h3 class="search-options-title">' +
                                	caps.otherOptions +
                                '</h3>' +

								this._renderSearchOptionControl(opt.caseSensitiveSwitch, caps.ignoreCase, 'checkbox', 'search-case-sensitive') +
								this._renderSearchOptionControl(opt.wholeWordsSwitch, caps.exactWords, 'checkbox', 'search-whole-words') +
								this._renderSearchOptionControl(true, caps.highlightWords, 'checkbox', 'search-highlight') +

                            '</div>' + /* search options */
                            '<ul id="search-results" class="search-resuts"></ul>' +
                       '</div>';

            this.element.html(html);

            this._$results              = this.element.find('#search-results');
            this._$searchOptions        = this.element.find('#search-options');
            this._$searchOptionsTitle   = this.element.find('#search-options-title');
            this._$preloader            = this.element.find('.block-preloader');
            this._$searchbar            = this.element.find('#search-bar');
            this._$searchinput          = this.element.find('#search-input');

            // Apply default options.
            this._applyDefaultSearchOptions();
        },

		_renderSearchOptionControl: function(enabled, label, type, name, value) {
			var input = "";

			if (enabled == true) {
				input = '<label>' +
                        	'<input ' +
								this._getAttributeMarkup('type', type) + ' ' +
								this._getAttributeMarkup('name', name) + ' ' +
								this._getAttributeMarkup('value', value) +
							'/>' + label +
                        '</label>';
			}

			return input;
		},

		_getAttributeMarkup: function(name, value) {
			var attr = "";
			if (value !== "") {
				attr = name + '="' + value + '"';
			}
			return attr;
		},

        _renderSearchBar: function() {
            var html = '';

            if (this.options.config.ui.tabs.searchEnabled) {
                html += '<div id="search-bar" class="search">' +
                           '<div class="wrapper">' +
                               '<a href="#" class="button icon search" id="search-button"></a>' +
                               '<div class="search-field">' +
                                   '<input id="search-input" type="text" name="search-input" class="search-input" placeholder="' +
                                       this.options.config.labels.search.searchInHelpFor +
                                   '">' +
                               '</div>' +
                           '</div>' +
                        '</div>';
            }

            return html;
        },

        /*
            Example:

            caseInsensitiveEnabled: true
            caseSensitiveSwitch: true
            highlightEnabled: true
            searchInThisBook: true
            searchMethod: "or"
            searchStopWords: "stop-words.js"
            wholeWordsEnabled: false
            wholeWordsSwitch: true
        */
        _applyDefaultSearchOptions: function() {
            console.log('searchview: _applyDefaultSearchOptions');

            var o = this.options.config.searchOptions;

            // Search method.
            this._$searchOptions.find('input[value="' + o.searchMethod + '"]').prop('checked', true);

            // Other options.
            this._$searchOptions.find('input[name="search-case-sensitive"]').prop('checked', o.caseInsensitiveEnabled);
            this._$searchOptions.find('input[name="search-whole-words"]').prop('checked', o.wholeWordsEnabled);
            this._$searchOptions.find('input[name="search-highlight"]').prop('checked', o.highlightEnabled);
        },

        _addEventHandlers: function() {
            console.log('searchview: _addEventHandlers');

            var self = this;

            self._on('.search-title.accordion', {
                click: function(event, ui) {
                    event.stopPropagation();

                    var $target = $(event.target);

                    $target.toggleClass('closed').next().toggleClass('closed');
                }
            });

            // Add search field event handlers.

            function doSearch(value) {
                console.log('appview: doSearch, value: [', value, ']');

                if (value !== '') {
                    self._trigger('dosearch', {}, value);
                }
            }

            self._on(self._$searchinput, {
                keyup: function(event) {
                    if (event.keyCode == 13) {
                        doSearch(self._$searchinput.val());
                    }
                }
            });

            self._on('#search-button', {
                click: function(event) {
                    doSearch(self._$searchinput.val());
                }
            });
        },

        _renderResults: function(list) {
            var items_html = '';

            if (list && $.isArray(list) && list.length >= 1) {
                // create layout
                $.each(list, function(count, item) {
                    items_html += '<li class="search-result-li">' +
                                    '<div class="search-result-item">' +
                                        '<a class="search-result-item-link" href="#!/url=' +
                                        item.href +
                                        '" title="' +
                                        item.title +
                                        '">' +
                                            '<h3 class="search-result-item-heading">' +
                                                item.title +
                                            '</h3>' +
                                            '<p class="search-result-item-desc">' +
                                                item.description +
                                            '</p>' +
                                        '</a>' +
                                    '</div>' +
                                  '</li>';
                });
            }

            this._$results.empty();
            this._$results.html(items_html);
        },

        /* Public members. */

        displayProgress: function(progress) {
            console.debug('Progress: ', progress);
        },

        displayResults: function(listOfResults) {
            console.debug('Results: ', listOfResults);
            this._renderResults(listOfResults);
        },

        closeSearchOptions: function() {
            this._$searchOptions.addClass('closed');
            this._$searchOptionsTitle.addClass('closed');
        },

        showPreloader: function() {
            console.log('searchview: showPreloader');

            this._$preloader.removeClass('hidden').show();
        },

        hidePreloader: function() {
            console.log('searchview: hidePreloader');

            this._$preloader.fadeOut();
        },

        getActualSearchOptions: function() {
            console.log('searchview: getActualSearchOptions');

            var so = this.options.config.searchOptions,
                $so = this._$searchOptions;

            so.searchMethod = $so.find('input[name="search-method"]:checked').val();
            so.caseInsensitiveEnabled = $so.find('input[name="search-case-sensitive"]').prop('checked');
            so.highlightEnabled = $so.find('input[name="search-highlight"]').prop('checked');
            so.wholeWordsEnabled = $so.find('input[name="search-whole-words"]').prop('checked');

            return so;
        }
    });

})(jQuery);
// SIG // Begin signature block
// SIG // MIIXrwYJKoZIhvcNAQcCoIIXoDCCF5wCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFGgbrfuZmr+W
// SIG // WCK5b6Y2VB1xJ3KFoIIS3zCCA+4wggNXoAMCAQICEH6T
// SIG // 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
// SIG // CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
// SIG // cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
// SIG // EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
// SIG // Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
// SIG // aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
// SIG // NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
// SIG // bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
// SIG // bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
// SIG // RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
// SIG // AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
// SIG // FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
// SIG // a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
// SIG // AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
// SIG // +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
// SIG // 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
// SIG // 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
// SIG // RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
// SIG // gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
// SIG // gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
// SIG // aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
// SIG // CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
// SIG // Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
// SIG // bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
// SIG // VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
// SIG // VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
// SIG // BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
// SIG // nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
// SIG // sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
// SIG // JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
// SIG // g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
// SIG // UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
// SIG // BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
// SIG // dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
// SIG // MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
// SIG // AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
// SIG // cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
// SIG // sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
// SIG // duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
// SIG // TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
// SIG // YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
// SIG // vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
// SIG // nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
// SIG // 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
// SIG // EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
// SIG // FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
// SIG // BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
// SIG // AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
// SIG // MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
// SIG // bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
// SIG // MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
// SIG // ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
// SIG // MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
// SIG // VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
// SIG // IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
// SIG // SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
// SIG // st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
// SIG // JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
// SIG // dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
// SIG // bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
// SIG // K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
// SIG // SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
// SIG // ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
// SIG // w7wc2AR1MIIE5TCCA82gAwIBAgIQGGKWU9W9DKB4gLDR
// SIG // /Nm99TANBgkqhkiG9w0BAQsFADB/MQswCQYDVQQGEwJV
// SIG // UzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24x
// SIG // HzAdBgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsx
// SIG // MDAuBgNVBAMTJ1N5bWFudGVjIENsYXNzIDMgU0hBMjU2
// SIG // IENvZGUgU2lnbmluZyBDQTAeFw0xNjAxMjgwMDAwMDBa
// SIG // Fw0xODA0MTAyMzU5NTlaMH0xCzAJBgNVBAYTAkNIMRIw
// SIG // EAYDVQQIEwlOZXVjaGF0ZWwxEjAQBgNVBAcTCU5ldWNo
// SIG // YXRlbDEiMCAGA1UEChQZQXV0b2Rlc2sgRGV2ZWxvcG1l
// SIG // bnQgU2FybDEiMCAGA1UEAxQZQXV0b2Rlc2sgRGV2ZWxv
// SIG // cG1lbnQgU2FybDCCASIwDQYJKoZIhvcNAQEBBQADggEP
// SIG // ADCCAQoCggEBALOBje/8PFtBHV0+YQz+EJZzXU+JAy6j
// SIG // OhMiK0n4pWQrgLdfLmoNZUvUL5AVuWoHkzK4f6WLWEjQ
// SIG // eGR4SEZcvDCJjol0n6vdsYAfRurwhekestab635tKUEy
// SIG // JRNKXhC4zuDSgryc+2zUsZa08HSHZaTsFGZzEuQAdxWf
// SIG // iyvD6G5oTu72nj3kDWWn3vqh+zyGkOIhtsIDKZyHpg71
// SIG // 7hPiqEe96bX5LpZgkSOJdAdwpl40NEUFfpNdelT2sOCh
// SIG // MfG63Dg2PR6EjOK5zHgMZm09mPgZBfyNoBV03C1ySSUi
// SIG // UsAHM2ND4wnGfl/GbYEgIVQXWlspRbtpRHTaNavebLJY
// SIG // tWECAwEAAaOCAV0wggFZMAkGA1UdEwQCMAAwDgYDVR0P
// SIG // AQH/BAQDAgeAMCsGA1UdHwQkMCIwIKAeoByGGmh0dHA6
// SIG // Ly9zdi5zeW1jYi5jb20vc3YuY3JsMGEGA1UdIARaMFgw
// SIG // VgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8v
// SIG // ZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0
// SIG // dHBzOi8vZC5zeW1jYi5jb20vcnBhMBMGA1UdJQQMMAoG
// SIG // CCsGAQUFBwMDMFcGCCsGAQUFBwEBBEswSTAfBggrBgEF
// SIG // BQcwAYYTaHR0cDovL3N2LnN5bWNkLmNvbTAmBggrBgEF
// SIG // BQcwAoYaaHR0cDovL3N2LnN5bWNiLmNvbS9zdi5jcnQw
// SIG // HwYDVR0jBBgwFoAUljtT8Hkzl699g+8uK8zKt4YecmYw
// SIG // HQYDVR0OBBYEFHqJl6/oWFvaZKJVCptH8DQRl8JIMA0G
// SIG // CSqGSIb3DQEBCwUAA4IBAQAXhA6ZwymxqqV+k4uKThLd
// SIG // PgPsvZBRcCJJZi3eYMl7HjIDbxSdx03ueVc/Sx3n9OUK
// SIG // U+DupPpLFUnKUJa/X8HPWhcvJftXom9NvGWbYPJM7CBc
// SIG // eTKuXgP5ffKwf1r9pJhok0pEhSA8b6N97pmKQwJDE6XI
// SIG // Z4M5FYw9YELKPRCHhinZCfPHLo+0GxaH+W4AbGd1N2BZ
// SIG // dX2egsgNTGBnC6xGxGMC8ckaj5wyIm4LgklE0pKbxuG9
// SIG // 075426gJ6ASAtCevNViBj9hH3TcNy4aU0ruH6By5gZaR
// SIG // 5lc7ZdaTuBWz0+4wGIK1IiviMSJv19v+h0vpEyn1b8sE
// SIG // 6L7D8JD4szHnMIIFWTCCBEGgAwIBAgIQPXjX+XZJYLJh
// SIG // ffTwHsqGKjANBgkqhkiG9w0BAQsFADCByjELMAkGA1UE
// SIG // BhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8w
// SIG // HQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTow
// SIG // OAYDVQQLEzEoYykgMjAwNiBWZXJpU2lnbiwgSW5jLiAt
// SIG // IEZvciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQD
// SIG // EzxWZXJpU2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5
// SIG // IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzUwHhcN
// SIG // MTMxMjEwMDAwMDAwWhcNMjMxMjA5MjM1OTU5WjB/MQsw
// SIG // CQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29y
// SIG // cG9yYXRpb24xHzAdBgNVBAsTFlN5bWFudGVjIFRydXN0
// SIG // IE5ldHdvcmsxMDAuBgNVBAMTJ1N5bWFudGVjIENsYXNz
// SIG // IDMgU0hBMjU2IENvZGUgU2lnbmluZyBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAJeDHgAWryyx
// SIG // 0gjE12iTUWAecfbiR7TbWE0jYmq0v1obUfejDRh3aLvY
// SIG // NqsvIVDanvPnXydOC8KXyAlwk6naXA1OpA2RoLTsFM6R
// SIG // clQuzqPbROlSGz9BPMpK5KrA6DmrU8wh0MzPf5vmwsxY
// SIG // aoIV7j02zxzFlwckjvF7vjEtPW7ctZlCn0thlV8ccO4X
// SIG // fduL5WGJeMdoG68ReBqYrsRVR1PZszLWoQ5GQMWXkorR
// SIG // U6eZW4U1V9Pqk2JhIArHMHckEU1ig7a6e2iCMe5lyt/5
// SIG // 1Y2yNdyMK29qclxghJzyDJRewFZSAEjM0/ilfd4v1xPk
// SIG // OKiE1Ua4E4bCG53qWjjdm9sCAwEAAaOCAYMwggF/MC8G
// SIG // CCsGAQUFBwEBBCMwITAfBggrBgEFBQcwAYYTaHR0cDov
// SIG // L3MyLnN5bWNiLmNvbTASBgNVHRMBAf8ECDAGAQH/AgEA
// SIG // MGwGA1UdIARlMGMwYQYLYIZIAYb4RQEHFwMwUjAmBggr
// SIG // BgEFBQcCARYaaHR0cDovL3d3dy5zeW1hdXRoLmNvbS9j
// SIG // cHMwKAYIKwYBBQUHAgIwHBoaaHR0cDovL3d3dy5zeW1h
// SIG // dXRoLmNvbS9ycGEwMAYDVR0fBCkwJzAloCOgIYYfaHR0
// SIG // cDovL3MxLnN5bWNiLmNvbS9wY2EzLWc1LmNybDAdBgNV
// SIG // HSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwMwDgYDVR0P
// SIG // AQH/BAQDAgEGMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQD
// SIG // ExFTeW1hbnRlY1BLSS0xLTU2NzAdBgNVHQ4EFgQUljtT
// SIG // 8Hkzl699g+8uK8zKt4YecmYwHwYDVR0jBBgwFoAUf9Nl
// SIG // p8Ld7LvwMAnzQzn6Aq8zMTMwDQYJKoZIhvcNAQELBQAD
// SIG // ggEBABOFGh5pqTf3oL2kr34dYVP+nYxeDKZ1HngXI939
// SIG // 7BoDVTn7cZXHZVqnjjDSRFph23Bv2iEFwi5zuknx0ZP+
// SIG // XcnNXgPgiZ4/dB7X9ziLqdbPuzUvM1ioklbRyE07guZ5
// SIG // hBb8KLCxR/Mdoj7uh9mmf6RWpT+thC4p3ny8qKqjPQQB
// SIG // 6rqTog5QIikXTIfkOhFf1qQliZsFay+0yQFMJ3sLrBkF
// SIG // IqBgFT/ayftNTI/7cmd3/SeUx7o1DohJ/o39KK9KEr0N
// SIG // s5cF3kQMFfo2KwPcwVAB8aERXRTl4r0nS1S+K4ReD6bD
// SIG // dAUK75fDiSKxH3fzvc1D1PFMqT+1i4SvZPLQFCExggQ8
// SIG // MIIEOAIBATCBkzB/MQswCQYDVQQGEwJVUzEdMBsGA1UE
// SIG // ChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAdBgNVBAsT
// SIG // FlN5bWFudGVjIFRydXN0IE5ldHdvcmsxMDAuBgNVBAMT
// SIG // J1N5bWFudGVjIENsYXNzIDMgU0hBMjU2IENvZGUgU2ln
// SIG // bmluZyBDQQIQGGKWU9W9DKB4gLDR/Nm99TAJBgUrDgMC
// SIG // GgUAoHAwEAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcN
// SIG // AQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEO
// SIG // MAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFGYp
// SIG // gK61cARiwOWqReCVmtmgedteMA0GCSqGSIb3DQEBAQUA
// SIG // BIIBAHC0XBvD+0u7NJBESjsVgM2ou7PWJmT4uVtk7IHv
// SIG // 0XGvZRFdJ6ssw49SxZ88R4KkDcE8UQPMs2LcEFJcj7q1
// SIG // BdK3pAuqUPfbXtSnm1c7EirP2kOYBFBoXA0MqLfLa6q7
// SIG // v/pbHemCAS53Ra6KTP6oxulpG27jfg3I1cge4U9DORuK
// SIG // bCrbrw4oA571DT6NZMribNV2s6/5e/gWXybUbPCS17Rv
// SIG // p1TuqRKwFZyWpkV1liydgR1ps70ORnhxj2s4R05njJL3
// SIG // EEhOxcCykhBxP71TqU2WS2GsLEH1U12ZfsODlDDqkxed
// SIG // muP3H0mtljr/eR4TWKt3/COX6r884eeIP5ImoUWhggIL
// SIG // MIICBwYJKoZIhvcNAQkGMYIB+DCCAfQCAQEwcjBeMQsw
// SIG // CQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29y
// SIG // cG9yYXRpb24xMDAuBgNVBAMTJ1N5bWFudGVjIFRpbWUg
// SIG // U3RhbXBpbmcgU2VydmljZXMgQ0EgLSBHMgIQDs/0OMj+
// SIG // vzVuBNhqmBsaUDAJBgUrDgMCGgUAoF0wGAYJKoZIhvcN
// SIG // AQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUxDxcN
// SIG // MTYwMjE1MDM1NzA3WjAjBgkqhkiG9w0BCQQxFgQU2Frr
// SIG // nEfM2XC/UATANJJPaSJI7mAwDQYJKoZIhvcNAQEBBQAE
// SIG // ggEAglpWpOceIKJeoJm1ZL1OxBJPGfF2Kvf+6SSZctFd
// SIG // kvbGwIhWUbc11lxb0NMIqZl8fEZPmYaw3YgwlMW67H8Y
// SIG // B9bBeOZcGk6t7jcCL+KpLEKUtSFuIaCJ5oyCWp5irwPI
// SIG // /SYIcIgUZt5VIY6NDxEhCuknc10CWU+R6C3JSzztDbBn
// SIG // 8h54My9HVuYYNdNsdliDgqknu4KsZb+/YBdn5003DIZv
// SIG // fMVE28LAITQ/UhDKsmoLu6WZ3zaLNGBmaepyNOtl6qNi
// SIG // l+90zcLdTJ15hWkwxM0mIWlUb3Xi4zoTF6FxnOgL44BX
// SIG // 913D3NEz+NNd3yRKBKDIeWnu0BoYLMUpts69pg==
// SIG // End signature block
