// Topic view (jQuery UI widget).
(function ($) {
    $.widget('adsk.topicview', {
        options: {
            caption: "Topic"
        },

        $content: undefined,
        $header: undefined,
        $favorites: undefined,

        goToParentButtonEnabled: false,
        favoritesButtonEnabled: false,
        goBackButtonEnabled: false,

        _create: function() {
            console.log('topicview: _create');

            // Render view.
            this._render();

            // Handle UI events.
            this._addEventHandlers();
        },

        _render: function() {
            console.log('topicview: _render');

            // Create topic view markup.
            this.element.html(
              '<header class="toolbar drop-shadow">' +
                '<div class="column left">' +
                    '<a href="#" id="topic-navigation" class="navigation button icon"/>' +
                    '<a href="#" id="topic-back" class="back button icon disabled"/>' +
                    '<a href="#" id="topic-parent" class="parent button icon disabled"/>' +
                    '<a href="#" id="topic-home" class="home button icon"/>' +
                '</div>' +
                '<div class="column center"></div>' +
                '<div class="column right">' +
                    '<a href="#" id="topic-share" class="share button icon"/>' +
                    '<a href="#" id="topic-favorites" class="favorites button icon disabled"/>' +
                    '<a href="#" id="topic-search" class="search button icon"/>' +
                '</div>' +
              '</header>' +
              '<div class="content"></div>' +
              '<footer class="toolbar">' +
                '<a href="#" class="preceding-topic">' +
                  '<div class="label">Previous topic</div>' +
                  '<div class="name"></div>' +
                  '<div class="path"></div>' +
                '</a>' +
                '<a href="#" class="following-topic">' +
                  '<div class="label">Next topic</div>' +
                  '<div class="name"></div>' +
                  '<div class="path"></div>' +
                '</a>' +
              '</footer>'
            );

            // Store jQuery objects for later use.
            this.$header = this.element.find('header');
            this.$footer = this.element.find('footer');
            this.$content = this.element.find('.content');
            this.$favorites = this.element.find('#topic-favorites');
        },

        _addEventHandlers: function() {
            console.log('topicview: _addEventHandlers');

            // Add look to all tapped buttons.
            this.$header.find('.button')
            .on('touchstart', $.proxy(this._handleToolbarButtonTouchstart, this))
            .on('touchend', $.proxy(this._handleToolbarButtonTouchend, this));

            this.element
            .on('touchmove', function(event) {
                event.preventDefault();
            });

            this.$content
            .on('touchmove', function(event) {
                // Prevent bubbling to enable native scrolling.
                event.stopPropagation();
            });
        },

        _handleToolbarButtonTouchstart: function(event) {
            console.log('topicview: _handleToolbarButtonTouchstart');

            event.preventDefault();
            event.stopPropagation();

            var $target = $(event.target);

            if (!$target.hasClass('disabled')) {
                $target.addClass("tapped");
            }
        },

        _handleToolbarButtonTouchend: function(event) {
            event.preventDefault();
            event.stopPropagation();

            var $target = $(event.target);

            if (!$target.hasClass('disabled')) {
                // Style tapped button.
                $target.removeClass('tapped');

                // Trigger 'buttontap' custom event.
                this._trigger('buttontap', event, $target.attr('id'));
            }
        },

        _setContentHeight: function() {
            console.log('topicview: _setContentHeight');

            var height = $(document).height() - this.$header.height() - this.$footer.height();

            this.$content.css('height', height + 'px');
        },

        _isAbsolutePath: function(url) {
             if ((url.indexOf('http:') == 0) || (url.indexOf('https:') == 0)) {
                 return true;
             }
             return false;
        },

        _changeImageSrc: function(src, base) {
            var changedSrc = src;

            if (src && !this._isAbsolutePath(src)) {
                if (!base) {
                    base = './files/';
                }

                if (src.indexOf('../') == 0) {
                    // ../images/image.png.

                    // Strip "move up to one folder" command.
                    changedSrc = src.substr(1);
                } else {
                    // ./image.png or images.png

                    // Remove './'.
                    if (src.indexOf('./') == 0) {
                        src = src.substr(2);
                    }

                    changedSrc = base.concat(src);
                }

                return changedSrc;
            }
        },

        _changeHyperlinkHref: function(hyperlink, base) {
            var url = hyperlink.getAttribute('href'),
                changedUrl = url,
                target = hyperlink.getAttribute('target');

            if (url && !this._isAbsolutePath(url)) {
                // Not an anchor and not an absolute url.

                if (url.indexOf('../') == 0) {
                    // "Move up one folder" relative path (cases 3, 4 and 5).

                    // Strip "move up to one folder" command.
                    changedUrl = url.substr(1);

                    if (target !== '_blank') {
                         // Add hashbang (case 5).
                         changedUrl = '#!/url='.concat(changedUrl);
                    }
                } else if ((url.charAt(0) != '#') &&
                           (url.indexOf('mailto:') != 0) &&
                           (url.indexOf('javascript') != 0)) {
                    // "Current folder" relative path (topic.htm or ./topic.htm).

                    // Remove './'.
                    if (url.indexOf('./') == 0) {
                        url = url.substr(2);
                    }

                    // Add hashbang and base path (e.g. #!url=./files/topic.htm)
                    changedUrl = '#!/url='.concat(base, url);
                } else if (url == '#') {
                    changedUrl = location.hash;
                }

                hyperlink.setAttribute('href', changedUrl);
            }
        },

        /* Public members. */

        getShareButtonOffset: function() {
            console.log('topicview: getShareButtonOffset');

            var $page = this.element,
                offset = $page.find('#topic-share').offset();

            return offset;
        },

        loadPage: function(href, title, base) {
            console.log('topicview: loadPage, href = ' + href);

            var self = this;

            $container = this.element.find('.content');

            // TODO: find robust way.
            $container.html('');

            var xhr = $
            .get(href)
            .done(function(response) {
                // Replace src attribute with data-src to prevent jQuery html()
                // from triggering the browser request images.
                response = response.replace(/ src=/g, ' data-src=');

                var $bodyContent = $(response).filter('#body-content');

                if (!$bodyContent.length) {
                    $bodyContent = $(response.substring(response.indexOf("<body>"), response.indexOf("</body>") + 7));
                }

                if ($bodyContent.length) {
                    // Replace <a> elements href attribute value.
                    $bodyContent.find('a, area').each(function() {
                        self._changeHyperlinkHref(this, base);
                    });

                    // Add src attributes to <img> elements with slightly changed value of data-src attribute.
                    var images = $bodyContent.find('img');
                    images.each(function() {
                        this.setAttribute('src', self._changeImageSrc(this.getAttribute('data-src')));
                    });

                    // Add collapsible section click listener.
                    images.filter('.collapsible').click(function(event) {
                        var img = $(this);

                        img.toggleClass('opened');

                        // Show/hide collapsible section.
                        img.parents('.collapsible').find('.collapsible-section').toggleClass('hidden');
                    });

                    // Place topic content into container.
                    $container.html($bodyContent);

                    // Scroll to anchor.
                    var fragment = '';
                    if (href.lastIndexOf('#') != -1) {
                        fragment = href.substring(href.lastIndexOf('#') + 1);

                        if (fragment !== undefined && fragment !== '') {
                            var $anchor = $('a[name=' + fragment + ']');

                            console.log('scroll to fragment: ', fragment);
                            $container.scrollTo($anchor, 800);
                        }
                    }

                } else {
                    $container.html(response);
                }

                // Get topic base url.
                var splittedHref = href.split('/'),
                    baseUrl = splittedHref.slice(0, splittedHref.length - 1).join('/');

                    // Override content links and add swipe handlers.
                    self.addBodyContentHandlers(baseUrl);
                })
            .fail(function(response) {
                $container.html(response);
            })
            .always(function() {

            });
        },

        initGoToParentButton: function(enabled) {
            this.goToParentButtonEnabled = enabled;

            if (enabled) {
                this.$header.find('#topic-parent').removeClass('disabled');
            } else {
                this.$header.find('#topic-parent').addClass('disabled');
            }
        },

        initFavoritesButton: function(enabled) {
            this.favoritesButtonEnabled = enabled;

            if (enabled) {
                this.$header.find('#topic-favorites').removeClass('disabled');
            } else {
                this.$header.find('#topic-favorites').addClass('disabled');
            }
        },

        initGoBackButton: function(enabled) {
            this.goBackButtonEnabled = enabled;

            if (enabled) {
                this.$header.find('#topic-back').removeClass('disabled');
            } else {
                this.$header.find('#topic-back').addClass('disabled');
            }
        },

        resize: function() {
            console.log('topicview: resize');

            // Set content container height.
            this._setContentHeight();
        },

        // Flag if topic is in Favorites or not.
        flag: function(addedToFavorites) {
            console.log('topicview: flag');

            if (addedToFavorites) {
                this.$favorites.addClass('flagged');
            } else {
                this.$favorites.removeClass('flagged');
            }
        },

        addBodyContentHandlers: function(baseUrl) {
            console.log('topicview: addBodyContentHandlers');

            // Listen for ALL links at the top level of topic content.
            /*
            $bodyContent
            .on("click", "a", $.proxy(function(event) {
                var $target = $(event.target),
                    targetAttr = $target.attr('target');

                // For some browsers, target is undefined; for others,
                // target is false. Check for both.
                if (typeof targetAttr !== 'undefined' && targetAttr !== false) {
                    // Use default browser action.
                } else {
                    var parser = document.createElement('a');
                    parser.href = $target.attr('href');

                    var href = $target.attr('href');

                    if (location.host == parser.host) {
                        // Stop the default behavior of the browser, which
                        // is to change the URL of the page.
                        event.preventDefault();

                        // Fire event to change location hash.
                        this._trigger('opentopic', {}, {
                            href: baseUrl + '/' + href // resolve
                        });
                    } else {
                        // Use default browser action.
                    }
                }
            }, this));
            */

            this._runRetinaJS();
        },

        _runRetinaJS: function() {
            $('#body-content').find('img').retina('--2x');
        }
    });
})(jQuery);

// SIG // Begin signature block
// SIG // MIIXrwYJKoZIhvcNAQcCoIIXoDCCF5wCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFK+ARCkB/5gY
// SIG // CI0b2OM9SasrMgRToIIS3zCCA+4wggNXoAMCAQICEH6T
// SIG // 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
// SIG // CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
// SIG // cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
// SIG // EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
// SIG // Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
// SIG // aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
// SIG // NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
// SIG // bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
// SIG // bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
// SIG // RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
// SIG // AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
// SIG // FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
// SIG // a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
// SIG // AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
// SIG // +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
// SIG // 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
// SIG // 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
// SIG // RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
// SIG // gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
// SIG // gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
// SIG // aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
// SIG // CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
// SIG // Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
// SIG // bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
// SIG // VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
// SIG // VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
// SIG // BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
// SIG // nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
// SIG // sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
// SIG // JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
// SIG // g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
// SIG // UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
// SIG // BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
// SIG // dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
// SIG // MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
// SIG // AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
// SIG // cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
// SIG // sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
// SIG // duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
// SIG // TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
// SIG // YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
// SIG // vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
// SIG // nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
// SIG // 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
// SIG // EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
// SIG // FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
// SIG // BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
// SIG // AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
// SIG // MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
// SIG // bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
// SIG // MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
// SIG // ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
// SIG // MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
// SIG // VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
// SIG // IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
// SIG // SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
// SIG // st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
// SIG // JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
// SIG // dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
// SIG // bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
// SIG // K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
// SIG // SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
// SIG // ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
// SIG // w7wc2AR1MIIE5TCCA82gAwIBAgIQGGKWU9W9DKB4gLDR
// SIG // /Nm99TANBgkqhkiG9w0BAQsFADB/MQswCQYDVQQGEwJV
// SIG // UzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24x
// SIG // HzAdBgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsx
// SIG // MDAuBgNVBAMTJ1N5bWFudGVjIENsYXNzIDMgU0hBMjU2
// SIG // IENvZGUgU2lnbmluZyBDQTAeFw0xNjAxMjgwMDAwMDBa
// SIG // Fw0xODA0MTAyMzU5NTlaMH0xCzAJBgNVBAYTAkNIMRIw
// SIG // EAYDVQQIEwlOZXVjaGF0ZWwxEjAQBgNVBAcTCU5ldWNo
// SIG // YXRlbDEiMCAGA1UEChQZQXV0b2Rlc2sgRGV2ZWxvcG1l
// SIG // bnQgU2FybDEiMCAGA1UEAxQZQXV0b2Rlc2sgRGV2ZWxv
// SIG // cG1lbnQgU2FybDCCASIwDQYJKoZIhvcNAQEBBQADggEP
// SIG // ADCCAQoCggEBALOBje/8PFtBHV0+YQz+EJZzXU+JAy6j
// SIG // OhMiK0n4pWQrgLdfLmoNZUvUL5AVuWoHkzK4f6WLWEjQ
// SIG // eGR4SEZcvDCJjol0n6vdsYAfRurwhekestab635tKUEy
// SIG // JRNKXhC4zuDSgryc+2zUsZa08HSHZaTsFGZzEuQAdxWf
// SIG // iyvD6G5oTu72nj3kDWWn3vqh+zyGkOIhtsIDKZyHpg71
// SIG // 7hPiqEe96bX5LpZgkSOJdAdwpl40NEUFfpNdelT2sOCh
// SIG // MfG63Dg2PR6EjOK5zHgMZm09mPgZBfyNoBV03C1ySSUi
// SIG // UsAHM2ND4wnGfl/GbYEgIVQXWlspRbtpRHTaNavebLJY
// SIG // tWECAwEAAaOCAV0wggFZMAkGA1UdEwQCMAAwDgYDVR0P
// SIG // AQH/BAQDAgeAMCsGA1UdHwQkMCIwIKAeoByGGmh0dHA6
// SIG // Ly9zdi5zeW1jYi5jb20vc3YuY3JsMGEGA1UdIARaMFgw
// SIG // VgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8v
// SIG // ZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0
// SIG // dHBzOi8vZC5zeW1jYi5jb20vcnBhMBMGA1UdJQQMMAoG
// SIG // CCsGAQUFBwMDMFcGCCsGAQUFBwEBBEswSTAfBggrBgEF
// SIG // BQcwAYYTaHR0cDovL3N2LnN5bWNkLmNvbTAmBggrBgEF
// SIG // BQcwAoYaaHR0cDovL3N2LnN5bWNiLmNvbS9zdi5jcnQw
// SIG // HwYDVR0jBBgwFoAUljtT8Hkzl699g+8uK8zKt4YecmYw
// SIG // HQYDVR0OBBYEFHqJl6/oWFvaZKJVCptH8DQRl8JIMA0G
// SIG // CSqGSIb3DQEBCwUAA4IBAQAXhA6ZwymxqqV+k4uKThLd
// SIG // PgPsvZBRcCJJZi3eYMl7HjIDbxSdx03ueVc/Sx3n9OUK
// SIG // U+DupPpLFUnKUJa/X8HPWhcvJftXom9NvGWbYPJM7CBc
// SIG // eTKuXgP5ffKwf1r9pJhok0pEhSA8b6N97pmKQwJDE6XI
// SIG // Z4M5FYw9YELKPRCHhinZCfPHLo+0GxaH+W4AbGd1N2BZ
// SIG // dX2egsgNTGBnC6xGxGMC8ckaj5wyIm4LgklE0pKbxuG9
// SIG // 075426gJ6ASAtCevNViBj9hH3TcNy4aU0ruH6By5gZaR
// SIG // 5lc7ZdaTuBWz0+4wGIK1IiviMSJv19v+h0vpEyn1b8sE
// SIG // 6L7D8JD4szHnMIIFWTCCBEGgAwIBAgIQPXjX+XZJYLJh
// SIG // ffTwHsqGKjANBgkqhkiG9w0BAQsFADCByjELMAkGA1UE
// SIG // BhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8w
// SIG // HQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTow
// SIG // OAYDVQQLEzEoYykgMjAwNiBWZXJpU2lnbiwgSW5jLiAt
// SIG // IEZvciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQD
// SIG // EzxWZXJpU2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5
// SIG // IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzUwHhcN
// SIG // MTMxMjEwMDAwMDAwWhcNMjMxMjA5MjM1OTU5WjB/MQsw
// SIG // CQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29y
// SIG // cG9yYXRpb24xHzAdBgNVBAsTFlN5bWFudGVjIFRydXN0
// SIG // IE5ldHdvcmsxMDAuBgNVBAMTJ1N5bWFudGVjIENsYXNz
// SIG // IDMgU0hBMjU2IENvZGUgU2lnbmluZyBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAJeDHgAWryyx
// SIG // 0gjE12iTUWAecfbiR7TbWE0jYmq0v1obUfejDRh3aLvY
// SIG // NqsvIVDanvPnXydOC8KXyAlwk6naXA1OpA2RoLTsFM6R
// SIG // clQuzqPbROlSGz9BPMpK5KrA6DmrU8wh0MzPf5vmwsxY
// SIG // aoIV7j02zxzFlwckjvF7vjEtPW7ctZlCn0thlV8ccO4X
// SIG // fduL5WGJeMdoG68ReBqYrsRVR1PZszLWoQ5GQMWXkorR
// SIG // U6eZW4U1V9Pqk2JhIArHMHckEU1ig7a6e2iCMe5lyt/5
// SIG // 1Y2yNdyMK29qclxghJzyDJRewFZSAEjM0/ilfd4v1xPk
// SIG // OKiE1Ua4E4bCG53qWjjdm9sCAwEAAaOCAYMwggF/MC8G
// SIG // CCsGAQUFBwEBBCMwITAfBggrBgEFBQcwAYYTaHR0cDov
// SIG // L3MyLnN5bWNiLmNvbTASBgNVHRMBAf8ECDAGAQH/AgEA
// SIG // MGwGA1UdIARlMGMwYQYLYIZIAYb4RQEHFwMwUjAmBggr
// SIG // BgEFBQcCARYaaHR0cDovL3d3dy5zeW1hdXRoLmNvbS9j
// SIG // cHMwKAYIKwYBBQUHAgIwHBoaaHR0cDovL3d3dy5zeW1h
// SIG // dXRoLmNvbS9ycGEwMAYDVR0fBCkwJzAloCOgIYYfaHR0
// SIG // cDovL3MxLnN5bWNiLmNvbS9wY2EzLWc1LmNybDAdBgNV
// SIG // HSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwMwDgYDVR0P
// SIG // AQH/BAQDAgEGMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQD
// SIG // ExFTeW1hbnRlY1BLSS0xLTU2NzAdBgNVHQ4EFgQUljtT
// SIG // 8Hkzl699g+8uK8zKt4YecmYwHwYDVR0jBBgwFoAUf9Nl
// SIG // p8Ld7LvwMAnzQzn6Aq8zMTMwDQYJKoZIhvcNAQELBQAD
// SIG // ggEBABOFGh5pqTf3oL2kr34dYVP+nYxeDKZ1HngXI939
// SIG // 7BoDVTn7cZXHZVqnjjDSRFph23Bv2iEFwi5zuknx0ZP+
// SIG // XcnNXgPgiZ4/dB7X9ziLqdbPuzUvM1ioklbRyE07guZ5
// SIG // hBb8KLCxR/Mdoj7uh9mmf6RWpT+thC4p3ny8qKqjPQQB
// SIG // 6rqTog5QIikXTIfkOhFf1qQliZsFay+0yQFMJ3sLrBkF
// SIG // IqBgFT/ayftNTI/7cmd3/SeUx7o1DohJ/o39KK9KEr0N
// SIG // s5cF3kQMFfo2KwPcwVAB8aERXRTl4r0nS1S+K4ReD6bD
// SIG // dAUK75fDiSKxH3fzvc1D1PFMqT+1i4SvZPLQFCExggQ8
// SIG // MIIEOAIBATCBkzB/MQswCQYDVQQGEwJVUzEdMBsGA1UE
// SIG // ChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAdBgNVBAsT
// SIG // FlN5bWFudGVjIFRydXN0IE5ldHdvcmsxMDAuBgNVBAMT
// SIG // J1N5bWFudGVjIENsYXNzIDMgU0hBMjU2IENvZGUgU2ln
// SIG // bmluZyBDQQIQGGKWU9W9DKB4gLDR/Nm99TAJBgUrDgMC
// SIG // GgUAoHAwEAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcN
// SIG // AQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEO
// SIG // MAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFDhE
// SIG // 8LClXa/dcH5fdzzVYuNTIOC7MA0GCSqGSIb3DQEBAQUA
// SIG // BIIBAJabHksGGSIopt+BsUpUAKxTmufCKBnwMBZC9CFH
// SIG // QNGYavOxLn87xqOUwXqli4bGTgx+zAM1vXQpIjPPL9eJ
// SIG // iaoI9wEhFKXlv631L1rG2TbKfX2nI6CXy3jQJ/EnocMG
// SIG // NUpTnt2VFNZFzpFlouG0SS0ThYwsYwSeA3HhVD+hPYfJ
// SIG // d2EHYWoUZ8N2h0y+7RDcJ3bi+yqdnBLYxdNCXZf7ODYd
// SIG // 1G7ujyPEmfVaReIi8Zn9s+VbPVwDcoIrJeLpoAisHpeb
// SIG // wiVNcJlk4ZR5oITMoEGdsIKJCb19RVYo9HwMzhbGrdPK
// SIG // MCjC9izOU0uU+IixVPHoZS644szZsqh1eZySPMWhggIL
// SIG // MIICBwYJKoZIhvcNAQkGMYIB+DCCAfQCAQEwcjBeMQsw
// SIG // CQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29y
// SIG // cG9yYXRpb24xMDAuBgNVBAMTJ1N5bWFudGVjIFRpbWUg
// SIG // U3RhbXBpbmcgU2VydmljZXMgQ0EgLSBHMgIQDs/0OMj+
// SIG // vzVuBNhqmBsaUDAJBgUrDgMCGgUAoF0wGAYJKoZIhvcN
// SIG // AQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUxDxcN
// SIG // MTYwMjE1MDM1NjA5WjAjBgkqhkiG9w0BCQQxFgQUE/ux
// SIG // lImbzs9TZoSejiU79Eh62n0wDQYJKoZIhvcNAQEBBQAE
// SIG // ggEANzIS+rnfchSNdjzIykXkoRIqdWp8ogq06ygVvD1h
// SIG // H80caAQct5Z1RnhlBBNKRStuuUOJ/CtWNT+504qhaBzM
// SIG // /y5gGjJjMXBsPv3+Ej9Zof1HEq/Afgsg+P+F/ZzQZFks
// SIG // ioruDLun4X3ILnk8N17tm3/gWLoul6ICFLj2rUr62yCO
// SIG // q2NtUjIY1DMDQVyV0iwy+rnfV3uC7y2UNGVMYmyQyf7b
// SIG // 2X20m67lwe1vQOTVC0mKXdMDccAYX3jrt9w1VWNJlLFd
// SIG // jsEKcgkOs/47M6/HbIqi7TSK+iiALyYSJg1w9bkaWUov
// SIG // adjs4sXeaABYdkQLghZIu88Qem6eTBZEe14cVQ==
// SIG // End signature block
