// Main app menu view (jQuery UI widget).
(function($, UTILS) {
	$.widget('adsk.navigationview', {
		options: {
            activeTabId: 'toc'
		},

        // Content tabs ('toc-tab', 'tree-tab', 'index-tab', 'favorites-tab').
        $tabs: undefined,
        $content: undefined,
        $toolbar: undefined,

		_create: function() {
		    console.log('navigationview: _create');

			// Render view.
			this._render();

			// TODO: Add event responders.
			this._addEventHandlers();
		},

		_render: function() {
		    console.log('navigationview: _render');

            var $e = this.element;

		    // Create topic view markup.
            $e.html(['<header class="toolbar drop-shadow">',
                        '<div class="column left">',
                            '<a href="#" id="nav-resume" class="button command">',
                                '<div class="frame">Resume</div>',
                            '</a>',
                            '<a href="#" id="nav-search" class="search button icon"/>',
                        '</div>',

                        '<div class="column center"></div>',

                        '<div class="column right">',
                            '<a href="#" id="nav-toc" class="button tab left">',
                                '<div class="frame">',
                                    '<div class="toc icon"/>',
                                '</div>',
                            '</a>',
                            '<a href="#" id="nav-tree" class="button tab middle">',
                                '<div class="frame">',
                                    '<div class="tree icon"/>',
                                '</div>',
                            '</a>',
                            '<a href="#" id="nav-index" class="button tab middle">',
                                '<div class="frame">' +
                                    '<div class="index icon"/>',
                                '</div>',
                            '</a>',
                            '<a href="#" id="nav-favorites" class="button tab right">',
                                '<div class="frame">',
                                    '<div class="favorites icon"/>',
                                '</div>',
                            '</a>',
                        '</div>',
                    '</header>',

                    '<div class="content">',
                        '<div id="tab-toc" class="content-tab opened">',
                        '</div>',
                        '<div id="tab-tree" class="content-tab">',
                        '</div>',
                        '<div id="tab-index" class="content-tab">',
                        '</div>',
                        '<div id="tab-favorites" class="content-tab">',
                        '</div>',
                    '</div>'].join(''));

            // Store jQuery objects for later use.
            this.$toolbar = $e.find('.toolbar');
            var $c = this.$content = $e.find('.content');
            this.$tabs = [
                $c.children('#tab-toc'),
                $c.children('#tab-tree'),
                $c.children('#tab-index'),
                $c.children('#tab-favorites'),
            ];

            // Set content container height.
            this._setContentHeight();

            // Set default active tab button.
            this.openTabById(this.options.activeTabId);
		},

		_setContentHeight: function() {
		    console.log('navigationview: _setContentHeight');

            var height = $(document).height() - this.$toolbar.height();
		    this.$content.css('height', height + 'px');
		},

		_handleToolbarButtonTouchStart: function(event) {
		    event.preventDefault();
            event.stopPropagation();

            $(this).addClass("tapped");
		},

		_handleToolbarButtonTouchEnd: function(event) {
		    console.log('navigationview: _handleToolbarButtonTouchEnd');

		    event.preventDefault();
            event.stopPropagation();

            var $button = $(event.currentTarget);

            // Get rid of tap highlighting.
            $button.removeClass('tapped');

            // Process tap on tab button.
            if ($button.hasClass('tab') && !($button.hasClass('active'))) {
                var tabId = $button.attr('id').substring('nav-'.length);
                this.openTabById(tabId);
            }

            // Trigger 'buttontap' custom event.
            this._trigger('buttontap', event, $button.attr('id'));
		},

		_addEventHandlers: function() {
		    console.log('navigationview: _addEventHandlers');

            var $toolbar = this.$toolbar;

            // Add look to all tapped buttons.
            $toolbar.find('.button')
            .on('touchstart', $.proxy(this._handleToolbarButtonTouchStart, this))
            .on('touchend', $.proxy(this._handleToolbarButtonTouchEnd, this));
        },

        openTabById: function(tabId) {
            console.log('navigationview: openTabById: ' + tabId);

            // Deactivate previous selected tab button.
            $(this.element).find('.active').removeClass('active');

            // Activate selected tab button.
            var $tabButton = $(this.element).find('#nav-' + tabId);
            $tabButton.addClass('active');

            // Hide previous tab.
             $(this.element).find('.opened').removeClass('opened');

            // Show current tab.
            var $tabContent = $(this.element).find('#tab-' + tabId);
            $tabContent.addClass('opened');
        },

        resize: function() {
            // Set content container height.
            this._setContentHeight();
        }
	});
})(jQuery);
// SIG // Begin signature block
// SIG // MIIXrwYJKoZIhvcNAQcCoIIXoDCCF5wCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFH4tQxcNuHkk
// SIG // 5vj7tQKekbjMxNezoIIS3zCCA+4wggNXoAMCAQICEH6T
// SIG // 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
// SIG // CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
// SIG // cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
// SIG // EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
// SIG // Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
// SIG // aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
// SIG // NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
// SIG // bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
// SIG // bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
// SIG // RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
// SIG // AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
// SIG // FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
// SIG // a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
// SIG // AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
// SIG // +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
// SIG // 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
// SIG // 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
// SIG // RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
// SIG // gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
// SIG // gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
// SIG // aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
// SIG // CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
// SIG // Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
// SIG // bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
// SIG // VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
// SIG // VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
// SIG // BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
// SIG // nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
// SIG // sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
// SIG // JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
// SIG // g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
// SIG // UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
// SIG // BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
// SIG // dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
// SIG // MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
// SIG // AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
// SIG // cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
// SIG // sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
// SIG // duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
// SIG // TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
// SIG // YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
// SIG // vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
// SIG // nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
// SIG // 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
// SIG // EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
// SIG // FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
// SIG // BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
// SIG // AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
// SIG // MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
// SIG // bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
// SIG // MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
// SIG // ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
// SIG // MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
// SIG // VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
// SIG // IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
// SIG // SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
// SIG // st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
// SIG // JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
// SIG // dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
// SIG // bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
// SIG // K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
// SIG // SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
// SIG // ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
// SIG // w7wc2AR1MIIE5TCCA82gAwIBAgIQGGKWU9W9DKB4gLDR
// SIG // /Nm99TANBgkqhkiG9w0BAQsFADB/MQswCQYDVQQGEwJV
// SIG // UzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24x
// SIG // HzAdBgNVBAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsx
// SIG // MDAuBgNVBAMTJ1N5bWFudGVjIENsYXNzIDMgU0hBMjU2
// SIG // IENvZGUgU2lnbmluZyBDQTAeFw0xNjAxMjgwMDAwMDBa
// SIG // Fw0xODA0MTAyMzU5NTlaMH0xCzAJBgNVBAYTAkNIMRIw
// SIG // EAYDVQQIEwlOZXVjaGF0ZWwxEjAQBgNVBAcTCU5ldWNo
// SIG // YXRlbDEiMCAGA1UEChQZQXV0b2Rlc2sgRGV2ZWxvcG1l
// SIG // bnQgU2FybDEiMCAGA1UEAxQZQXV0b2Rlc2sgRGV2ZWxv
// SIG // cG1lbnQgU2FybDCCASIwDQYJKoZIhvcNAQEBBQADggEP
// SIG // ADCCAQoCggEBALOBje/8PFtBHV0+YQz+EJZzXU+JAy6j
// SIG // OhMiK0n4pWQrgLdfLmoNZUvUL5AVuWoHkzK4f6WLWEjQ
// SIG // eGR4SEZcvDCJjol0n6vdsYAfRurwhekestab635tKUEy
// SIG // JRNKXhC4zuDSgryc+2zUsZa08HSHZaTsFGZzEuQAdxWf
// SIG // iyvD6G5oTu72nj3kDWWn3vqh+zyGkOIhtsIDKZyHpg71
// SIG // 7hPiqEe96bX5LpZgkSOJdAdwpl40NEUFfpNdelT2sOCh
// SIG // MfG63Dg2PR6EjOK5zHgMZm09mPgZBfyNoBV03C1ySSUi
// SIG // UsAHM2ND4wnGfl/GbYEgIVQXWlspRbtpRHTaNavebLJY
// SIG // tWECAwEAAaOCAV0wggFZMAkGA1UdEwQCMAAwDgYDVR0P
// SIG // AQH/BAQDAgeAMCsGA1UdHwQkMCIwIKAeoByGGmh0dHA6
// SIG // Ly9zdi5zeW1jYi5jb20vc3YuY3JsMGEGA1UdIARaMFgw
// SIG // VgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8v
// SIG // ZC5zeW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0
// SIG // dHBzOi8vZC5zeW1jYi5jb20vcnBhMBMGA1UdJQQMMAoG
// SIG // CCsGAQUFBwMDMFcGCCsGAQUFBwEBBEswSTAfBggrBgEF
// SIG // BQcwAYYTaHR0cDovL3N2LnN5bWNkLmNvbTAmBggrBgEF
// SIG // BQcwAoYaaHR0cDovL3N2LnN5bWNiLmNvbS9zdi5jcnQw
// SIG // HwYDVR0jBBgwFoAUljtT8Hkzl699g+8uK8zKt4YecmYw
// SIG // HQYDVR0OBBYEFHqJl6/oWFvaZKJVCptH8DQRl8JIMA0G
// SIG // CSqGSIb3DQEBCwUAA4IBAQAXhA6ZwymxqqV+k4uKThLd
// SIG // PgPsvZBRcCJJZi3eYMl7HjIDbxSdx03ueVc/Sx3n9OUK
// SIG // U+DupPpLFUnKUJa/X8HPWhcvJftXom9NvGWbYPJM7CBc
// SIG // eTKuXgP5ffKwf1r9pJhok0pEhSA8b6N97pmKQwJDE6XI
// SIG // Z4M5FYw9YELKPRCHhinZCfPHLo+0GxaH+W4AbGd1N2BZ
// SIG // dX2egsgNTGBnC6xGxGMC8ckaj5wyIm4LgklE0pKbxuG9
// SIG // 075426gJ6ASAtCevNViBj9hH3TcNy4aU0ruH6By5gZaR
// SIG // 5lc7ZdaTuBWz0+4wGIK1IiviMSJv19v+h0vpEyn1b8sE
// SIG // 6L7D8JD4szHnMIIFWTCCBEGgAwIBAgIQPXjX+XZJYLJh
// SIG // ffTwHsqGKjANBgkqhkiG9w0BAQsFADCByjELMAkGA1UE
// SIG // BhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8w
// SIG // HQYDVQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTow
// SIG // OAYDVQQLEzEoYykgMjAwNiBWZXJpU2lnbiwgSW5jLiAt
// SIG // IEZvciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQD
// SIG // EzxWZXJpU2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5
// SIG // IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzUwHhcN
// SIG // MTMxMjEwMDAwMDAwWhcNMjMxMjA5MjM1OTU5WjB/MQsw
// SIG // CQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29y
// SIG // cG9yYXRpb24xHzAdBgNVBAsTFlN5bWFudGVjIFRydXN0
// SIG // IE5ldHdvcmsxMDAuBgNVBAMTJ1N5bWFudGVjIENsYXNz
// SIG // IDMgU0hBMjU2IENvZGUgU2lnbmluZyBDQTCCASIwDQYJ
// SIG // KoZIhvcNAQEBBQADggEPADCCAQoCggEBAJeDHgAWryyx
// SIG // 0gjE12iTUWAecfbiR7TbWE0jYmq0v1obUfejDRh3aLvY
// SIG // NqsvIVDanvPnXydOC8KXyAlwk6naXA1OpA2RoLTsFM6R
// SIG // clQuzqPbROlSGz9BPMpK5KrA6DmrU8wh0MzPf5vmwsxY
// SIG // aoIV7j02zxzFlwckjvF7vjEtPW7ctZlCn0thlV8ccO4X
// SIG // fduL5WGJeMdoG68ReBqYrsRVR1PZszLWoQ5GQMWXkorR
// SIG // U6eZW4U1V9Pqk2JhIArHMHckEU1ig7a6e2iCMe5lyt/5
// SIG // 1Y2yNdyMK29qclxghJzyDJRewFZSAEjM0/ilfd4v1xPk
// SIG // OKiE1Ua4E4bCG53qWjjdm9sCAwEAAaOCAYMwggF/MC8G
// SIG // CCsGAQUFBwEBBCMwITAfBggrBgEFBQcwAYYTaHR0cDov
// SIG // L3MyLnN5bWNiLmNvbTASBgNVHRMBAf8ECDAGAQH/AgEA
// SIG // MGwGA1UdIARlMGMwYQYLYIZIAYb4RQEHFwMwUjAmBggr
// SIG // BgEFBQcCARYaaHR0cDovL3d3dy5zeW1hdXRoLmNvbS9j
// SIG // cHMwKAYIKwYBBQUHAgIwHBoaaHR0cDovL3d3dy5zeW1h
// SIG // dXRoLmNvbS9ycGEwMAYDVR0fBCkwJzAloCOgIYYfaHR0
// SIG // cDovL3MxLnN5bWNiLmNvbS9wY2EzLWc1LmNybDAdBgNV
// SIG // HSUEFjAUBggrBgEFBQcDAgYIKwYBBQUHAwMwDgYDVR0P
// SIG // AQH/BAQDAgEGMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQD
// SIG // ExFTeW1hbnRlY1BLSS0xLTU2NzAdBgNVHQ4EFgQUljtT
// SIG // 8Hkzl699g+8uK8zKt4YecmYwHwYDVR0jBBgwFoAUf9Nl
// SIG // p8Ld7LvwMAnzQzn6Aq8zMTMwDQYJKoZIhvcNAQELBQAD
// SIG // ggEBABOFGh5pqTf3oL2kr34dYVP+nYxeDKZ1HngXI939
// SIG // 7BoDVTn7cZXHZVqnjjDSRFph23Bv2iEFwi5zuknx0ZP+
// SIG // XcnNXgPgiZ4/dB7X9ziLqdbPuzUvM1ioklbRyE07guZ5
// SIG // hBb8KLCxR/Mdoj7uh9mmf6RWpT+thC4p3ny8qKqjPQQB
// SIG // 6rqTog5QIikXTIfkOhFf1qQliZsFay+0yQFMJ3sLrBkF
// SIG // IqBgFT/ayftNTI/7cmd3/SeUx7o1DohJ/o39KK9KEr0N
// SIG // s5cF3kQMFfo2KwPcwVAB8aERXRTl4r0nS1S+K4ReD6bD
// SIG // dAUK75fDiSKxH3fzvc1D1PFMqT+1i4SvZPLQFCExggQ8
// SIG // MIIEOAIBATCBkzB/MQswCQYDVQQGEwJVUzEdMBsGA1UE
// SIG // ChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAdBgNVBAsT
// SIG // FlN5bWFudGVjIFRydXN0IE5ldHdvcmsxMDAuBgNVBAMT
// SIG // J1N5bWFudGVjIENsYXNzIDMgU0hBMjU2IENvZGUgU2ln
// SIG // bmluZyBDQQIQGGKWU9W9DKB4gLDR/Nm99TAJBgUrDgMC
// SIG // GgUAoHAwEAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcN
// SIG // AQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEO
// SIG // MAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFDz8
// SIG // okCtvor/3q4Iatqi8HebKypSMA0GCSqGSIb3DQEBAQUA
// SIG // BIIBAARUfhm0Np+OVCo7HMN3dvml0GXOlRfnx6zXKEIe
// SIG // XjsCDFR+UDvwwOMB0dizq1tFGTMNkkyiAHvIKdHGJ9Fx
// SIG // AU3951zSRzVxgTUdZ+upPw1TfgeW/Mw7GVxe2/WX285s
// SIG // yZy8+GRxqt38fORiN55y32A2BAyUb8MhkONO4PIOca4Z
// SIG // HsOav3rUz8Ym5Dl7TQ+O/s7HAJ3KgE3GFmPxAgAN4KRq
// SIG // qIhQh09/xucW6ZNKJUmTAbpd1xWt2jfqvbu4OtiHFNT1
// SIG // vbTA6l0sNwbcJm7nfBMv10PaOAOyZO+nd/U8dpiU1Ush
// SIG // IXWOwoLMour2SY86lhUKo/RuY+kwEve5NTqZGRqhggIL
// SIG // MIICBwYJKoZIhvcNAQkGMYIB+DCCAfQCAQEwcjBeMQsw
// SIG // CQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29y
// SIG // cG9yYXRpb24xMDAuBgNVBAMTJ1N5bWFudGVjIFRpbWUg
// SIG // U3RhbXBpbmcgU2VydmljZXMgQ0EgLSBHMgIQDs/0OMj+
// SIG // vzVuBNhqmBsaUDAJBgUrDgMCGgUAoF0wGAYJKoZIhvcN
// SIG // AQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUxDxcN
// SIG // MTYwMjE1MDM1NjAzWjAjBgkqhkiG9w0BCQQxFgQUh8/3
// SIG // RjpGoV02Kx1rLYeim45kkGUwDQYJKoZIhvcNAQEBBQAE
// SIG // ggEAKiy8zx4+hNLRWEji8GXfVctAv4ytyYesYyEXo959
// SIG // WnDQDJNavVIV0VAUKfKwK4gHzUxHi3O3DXTRZ+bVskeh
// SIG // knpYyAJrcaYSk+K1Twn/m2OqZE6hnbuSFIt/sTdSkcF8
// SIG // Y9Y0WKE2Y/TxZBrTRs44jpADE+A26K04/OLTzkGiajzM
// SIG // uVPmeOr/L+bISg58WtJpn/ga9UNnR0HZQW+257YqE4hw
// SIG // 8SQsevxQbmUJuN91Nof9I+w/rBEn9iluIREl4qSdj15V
// SIG // sZnPbo84jHVKP1OjEPisWg7GFHB6ypij1vvjKCDvh12f
// SIG // S/fM7OxZPt0hKhtY7Ooo7Etn1vBmNAVMK2NDFg==
// SIG // End signature block
