"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _token = require("./token");

function parseChallenge(buffer) {
  const challenge = {};
  challenge.magic = buffer.slice(0, 8).toString('utf8');
  challenge.type = buffer.readInt32LE(8);
  challenge.domainLen = buffer.readInt16LE(12);
  challenge.domainMax = buffer.readInt16LE(14);
  challenge.domainOffset = buffer.readInt32LE(16);
  challenge.flags = buffer.readInt32LE(20);
  challenge.nonce = buffer.slice(24, 32);
  challenge.zeroes = buffer.slice(32, 40);
  challenge.targetLen = buffer.readInt16LE(40);
  challenge.targetMax = buffer.readInt16LE(42);
  challenge.targetOffset = buffer.readInt32LE(44);
  challenge.oddData = buffer.slice(48, 56);
  challenge.domain = buffer.slice(56, 56 + challenge.domainLen).toString('ucs2');
  challenge.target = buffer.slice(56 + challenge.domainLen, 56 + challenge.domainLen + challenge.targetLen);
  return challenge;
}

function sspiParser(parser, _options, callback) {
  parser.readUsVarByte(buffer => {
    callback(new _token.SSPIToken(parseChallenge(buffer), buffer));
  });
}

var _default = sspiParser;
exports.default = _default;
module.exports = sspiParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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